/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.standard.Complex;
import java.text.MessageFormat;
import java.util.Vector;

public class Subtract
extends BinaryFunction
implements RealBinaryFunction {
    private static final long serialVersionUID = 300L;

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        return this.sub(object, object2);
    }

    public Object sub(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return Subtract.sub((Number)object, (Number)object2);
            }
            if (object2 instanceof Complex) {
                return Subtract.sub((Number)object, (Complex)object2);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Number) {
                return Subtract.sub((Complex)object, (Number)object2);
            }
            if (object2 instanceof Complex) {
                return Subtract.sub((Complex)object, (Complex)object2);
            }
        } else {
            if (object instanceof Vector && object2 instanceof Vector) {
                return this.sub((Vector)object, (Vector)object2);
            }
            throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 1, object2);
    }

    public Vector<Object> sub(Vector<?> vector, Vector<?> vector2) throws EvaluationException {
        if (vector.size() != vector2.size()) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.DimensionsOfVectorsDoNotMatch"), this.getName(), vector.size(), vector2.size()));
        }
        Vector<Object> vector3 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector3.add(i, this.sub(vector.get(i), vector2.get(i)));
        }
        return vector3;
    }

    public static Double sub(Number number, Number number2) {
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    public static Complex sub(Complex complex, Complex complex2) {
        return new Complex(complex.re() - complex2.re(), complex.im() - complex2.im());
    }

    public static Complex sub(Complex complex, Number number) {
        return new Complex(complex.re() - number.doubleValue(), complex.im());
    }

    public static Complex sub(Number number, Complex complex) {
        return new Complex(number.doubleValue() - complex.re(), -complex.im());
    }

    @Override
    public double evaluate(double d, double d2) {
        return d - d2;
    }
}

