/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions.strings;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.NaryFunction;
import java.text.MessageFormat;

public class Substring
extends NaryFunction {
    private static final long serialVersionUID = 330L;

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n == 2 || n == 3;
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        String string = this.asString(0, objectArray[0]);
        int n = string.length();
        int n2 = this.asStrictInt(1, objectArray[1]);
        if (n2 > n || n2 < 0) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IndexOutOfRange"), this.toString(objectArray), n2));
        }
        if (objectArray.length == 2) {
            return string.substring(n2);
        }
        int n3 = this.asStrictInt(2, objectArray[2]);
        if (n3 < n2 || n3 > n) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IndexOutOfRange"), this.toString(objectArray), n3));
        }
        return string.substring(n2, n3);
    }
}

