/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.standard.Complex;
import java.text.MessageFormat;

public class LogTwoArg
extends BinaryFunction
implements RealBinaryFunction {
    private static final long serialVersionUID = 330L;
    private final boolean strict;

    public LogTwoArg(boolean bl) {
        this.strict = bl;
    }

    public LogTwoArg() {
        this.strict = false;
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        return this.log(object, object2);
    }

    public Object log(Object object, Object object2) throws EvaluationException {
        double d = this.asDouble(1, object2);
        if (d < 0.0) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("misc.functions,LogTwoArg.SecondArgumentMustBePositive"), this.getName(), d));
        }
        double d2 = Math.log(d);
        if (object instanceof Number) {
            double d3 = ((Number)object).doubleValue();
            if (d3 >= 0.0) {
                return Math.log(d3) / d2;
            }
            if (Double.isNaN(d3)) {
                return NaN;
            }
            if (this.strict) {
                return NaN;
            }
            Complex complex = new Complex(d3);
            return complex.log().div(new Complex(d2));
        }
        if (object instanceof Complex) {
            return ((Complex)object).log().div(new Complex(d2));
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d, double d2) {
        return Math.log(d) / Math.log(d2);
    }
}

