/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class Switch
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 330L;
    NullBehaviour nullBehaviour = NullBehaviour.ERROR;

    public Switch() {
        super(-1);
    }

    public Switch(NullBehaviour nullBehaviour) {
        super(-1);
        this.nullBehaviour = nullBehaviour;
    }

    public NullBehaviour getNullBehaviour() {
        return this.nullBehaviour;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n >= 2;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        Object object = evaluator.eval(node.jjtGetChild(0));
        if (object == null && this.nullBehaviour == NullBehaviour.RETURN_NULL) {
            return null;
        }
        int n = this.asStrictInt(0, object);
        if (n >= node.jjtGetNumChildren() || n <= 0) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IndexOutOfRangeMax"), this.getName(), n, node.jjtGetNumChildren() - 1));
        }
        Object object2 = evaluator.eval(node.jjtGetChild(n));
        return object2;
    }

    public static enum NullBehaviour {
        ERROR,
        RETURN_NULL;

    }
}

