/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.lineNumbering;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;

public class LineNumberingNodeFactory
extends NodeFactory {
    private static final long serialVersionUID = 340L;
    int currentLine = -1;
    int currentColumn = -1;
    NodeFactory root;

    public LineNumberingNodeFactory(NodeFactory nodeFactory) {
        this.root = nodeFactory;
    }

    public LineNumberingNodeFactory() {
        this.root = new NodeFactory();
    }

    public static int getLineNumber(Node node) {
        return (Integer)node.getHook(Numbering.LINENUMBER);
    }

    public static int getColumn(Node node) {
        return (Integer)node.getHook(Numbering.COLUMNNUMBER);
    }

    public static void setPosition(Node node, int n, int n2) {
        node.setHook(Numbering.LINENUMBER, n);
        node.setHook(Numbering.COLUMNNUMBER, n2);
    }

    public void setCurrentPosition(int n, int n2) {
        this.currentLine = n;
        this.currentColumn = n2;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    @Override
    public ASTConstant buildConstantNode(ASTConstant aSTConstant) throws ParseException {
        ASTConstant aSTConstant2 = this.root.buildConstantNode(aSTConstant);
        aSTConstant2.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTConstant2.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTConstant2;
    }

    @Override
    public ASTConstant buildConstantNode(Object object) throws ParseException {
        ASTConstant aSTConstant = this.root.buildConstantNode(object);
        aSTConstant.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTConstant.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTConstant;
    }

    @Override
    public ASTConstant buildConstantNode(Operator operator, Node ... nodeArray) throws ParseException {
        ASTConstant aSTConstant = this.root.buildConstantNode(operator, nodeArray);
        aSTConstant.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTConstant.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTConstant;
    }

    @Override
    public ASTConstant buildConstantNode(PostfixMathCommandI postfixMathCommandI, Node ... nodeArray) throws ParseException {
        ASTConstant aSTConstant = this.root.buildConstantNode(postfixMathCommandI, nodeArray);
        aSTConstant.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTConstant.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTConstant;
    }

    @Override
    public ASTFunNode buildFunctionNode(ASTFunNode aSTFunNode, Node ... nodeArray) throws ParseException {
        ASTFunNode aSTFunNode2 = this.root.buildFunctionNode(aSTFunNode, nodeArray);
        aSTFunNode2.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTFunNode2.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTFunNode2;
    }

    @Override
    public ASTFunNode buildFunctionNode(String string, PostfixMathCommandI postfixMathCommandI, Node ... nodeArray) throws ParseException {
        ASTFunNode aSTFunNode = this.root.buildFunctionNode(string, postfixMathCommandI, nodeArray);
        aSTFunNode.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTFunNode.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTFunNode;
    }

    @Override
    public ASTOpNode buildOperatorNode(Operator operator, Node ... nodeArray) throws ParseException {
        ASTOpNode aSTOpNode = this.root.buildOperatorNode(operator, nodeArray);
        aSTOpNode.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTOpNode.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTOpNode;
    }

    @Override
    public ASTOpNode buildUnfinishedOperatorNode(Operator operator) {
        ASTOpNode aSTOpNode = this.root.buildUnfinishedOperatorNode(operator);
        aSTOpNode.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTOpNode.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTOpNode;
    }

    @Override
    public ASTVarNode buildVariableNode(ASTVarNode aSTVarNode) throws ParseException {
        ASTVarNode aSTVarNode2 = this.root.buildVariableNode(aSTVarNode);
        aSTVarNode2.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTVarNode2.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTVarNode2;
    }

    @Override
    public ASTVarNode buildVariableNode(String string) throws ParseException {
        ASTVarNode aSTVarNode = this.root.buildVariableNode(string);
        aSTVarNode.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTVarNode.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTVarNode;
    }

    @Override
    public ASTVarNode buildVariableNode(Variable variable) throws ParseException {
        ASTVarNode aSTVarNode = this.root.buildVariableNode(variable);
        aSTVarNode.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTVarNode.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTVarNode;
    }

    @Override
    public ASTVarNode buildVariableNodeCheckUndeclared(String string) throws ParseException {
        ASTVarNode aSTVarNode = this.root.buildVariableNodeCheckUndeclared(string);
        aSTVarNode.setHook(Numbering.LINENUMBER, this.currentLine);
        aSTVarNode.setHook(Numbering.COLUMNNUMBER, this.currentColumn);
        return aSTVarNode;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new LineNumberingNodeFactory((NodeFactory)this.root.getLightWeightInstance());
    }

    @Override
    public void init(Jep jep) {
        super.init(jep);
        this.root.init(jep);
    }

    public NodeFactory getRoot() {
        return this.root;
    }

    public static enum Numbering implements Node.HookKey
    {
        LINENUMBER,
        COLUMNNUMBER;

    }
}

