/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.nullwrapper.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.If;
import com.singularsys.jep.misc.nullwrapper.functions.NullWrappedFunctionI;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import java.text.MessageFormat;

public class NullWrappedIf
extends If
implements NullWrappedFunctionI {
    private static final long serialVersionUID = 340L;

    public NullWrappedIf() {
    }

    public NullWrappedIf(Object object) {
        super(object);
    }

    @Override
    public PostfixMathCommandI getRoot() {
        return this;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        double d;
        int n = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(n)) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IncorrectNumberOfArguments"), this.getName(), n));
        }
        Object object = evaluator.eval(node.jjtGetChild(0));
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return evaluator.eval(node.jjtGetChild(1));
            }
            return evaluator.eval(node.jjtGetChild(2));
        }
        if (object instanceof Complex) {
            d = ((Complex)object).re();
        } else if (object instanceof Number) {
            d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                return d;
            }
        } else {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.If.ConditionMustBeBooleanOrNumber"), this.getName(), object.toString()));
        }
        if (d > 0.0) {
            return evaluator.eval(node.jjtGetChild(1));
        }
        if (n == 2) {
            return this.falseValue;
        }
        if (n == 3 || d < 0.0) {
            return evaluator.eval(node.jjtGetChild(2));
        }
        return evaluator.eval(node.jjtGetChild(3));
    }
}

