/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.threadsafeeval;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.FastEvaluator;
import java.text.MessageFormat;

public class ThreadSafeEvaluator
extends FastEvaluator {
    private static final long serialVersionUID = 350L;
    protected Jep jep;
    protected VariableTable vt;

    @Override
    public void init(Jep jep) {
        this.jep = jep;
        this.vt = jep.getVariableTable();
        super.init(jep);
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new ThreadSafeEvaluator();
    }

    public Variable getVariable(String string) {
        Variable variable = this.vt.getVariable(string);
        if (variable == null) {
            variable = this.vt.addVariable(string);
        }
        return variable;
    }

    @Override
    public Object visitVar(Node node) throws EvaluationException {
        String string = node.getName();
        Variable variable = this.vt.getVariable(string);
        if (!variable.hasValidValue()) {
            String string2 = MessageFormat.format(JepMessages.getString("standard.FastEvaluator.CouldNotEvaluateVariableNoValueSet"), variable.getName());
            throw new EvaluationException(string2);
        }
        Object object = variable.getValue();
        if (this.trapNullValues && object == null) {
            String string3 = MessageFormat.format(JepMessages.getString("standard.FastEvaluator.CouldNotEvaluateVariableNullValue"), variable.getName());
            throw new EvaluationException(string3);
        }
        if (this.trapNaN && (object instanceof Double && ((Double)object).isNaN() || object instanceof Float && ((Float)object).isNaN())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.NaNValueForVariable"), variable.getName()));
        }
        if (this.trapInfinity && (object instanceof Double && ((Double)object).isInfinite() || object instanceof Float && ((Float)object).isInfinite())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.InfiniteValueForVariable"), object.toString(), variable.getName()));
        }
        return object;
    }
}

