/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.standard;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.standard.Complex;

public class DoubleNumberFactory
implements NumberFactory {
    private static final long serialVersionUID = 300L;
    public static final Double ZERO = new Double(0.0);
    public static final Double ONE = new Double(1.0);
    public static final Double TWO = new Double(2.0);
    public static final Double MINUSONE = new Double(-1.0);

    @Override
    public Object createNumber(String string) {
        return new Double(string);
    }

    @Override
    public Object createNumber(double d) {
        return new Double(d);
    }

    @Override
    public Object createNumber(Number number) {
        return number;
    }

    @Override
    public Object createNumber(boolean bl) {
        return bl ? ONE : ZERO;
    }

    @Override
    public Object createNumber(float f) {
        return new Double(f);
    }

    @Override
    public Object createNumber(int n) {
        return new Double(n);
    }

    @Override
    public Object createNumber(short s) {
        return new Double(s);
    }

    @Override
    public Object createNumber(long l) {
        return new Double(l);
    }

    @Override
    public Object createNumber(Complex complex) throws ParseException {
        throw new ParseException(JepMessages.getString("standard.DoubleNumberFactory.CannotCreateANumberFromAComplexValue"));
    }

    @Override
    public Object getMinusOne() {
        return MINUSONE;
    }

    @Override
    public Object getOne() {
        return ONE;
    }

    @Override
    public Object getTwo() {
        return TWO;
    }

    @Override
    public Object getZero() {
        return ZERO;
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }
}

