/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.DeepCopyVisitor;
import java.util.ArrayList;
import java.util.List;

public class ExpressionConsolidator
extends DeepCopyVisitor {
    private static final long serialVersionUID = 340L;
    protected List<Operator> ops = new ArrayList<Operator>();

    public ExpressionConsolidator(Jep jep) {
        super(jep);
        this.ops.add(this.ot.getAdd());
        this.ops.add(this.ot.getMultiply());
    }

    public Node consolidate(Node node) throws JepException {
        return this.visit(node);
    }

    protected Node[] consolidateChildren(Operator operator, Node[] nodeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : nodeArray) {
            if (operator.equals(node.getOperator())) {
                for (Node node2 : node.children()) {
                    arrayList.add(node2);
                }
                continue;
            }
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        Operator operator = aSTOpNode.getOperator();
        if (this.ops.contains(operator)) {
            Node[] nodeArray = this.visitChildren(aSTOpNode, object);
            Node[] nodeArray2 = this.consolidateChildren(operator, nodeArray);
            return this.copyChildrenIfNeeded(aSTOpNode, nodeArray2);
        }
        return super.visit(aSTOpNode, object);
    }

    public boolean add(Operator operator) {
        return this.ops.add(operator);
    }

    public List<Operator> getOps() {
        return this.ops;
    }
}

