/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.PostfixTreeWalker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Stack;

public class PostfixEvaluator
extends PostfixTreeWalker
implements Evaluator {
    private static final long serialVersionUID = 300L;
    protected transient Stack<Object> stack = new Stack();

    @Override
    public Object evaluate(Node node) throws EvaluationException {
        this.stack.clear();
        try {
            this.walk(node);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (JepException jepException) {
            throw new EvaluationException(jepException);
        }
        Object object = this.stack.pop();
        return object;
    }

    @Override
    protected void visit(ASTFunNode aSTFunNode, int n, int n2) throws EvaluationException {
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        postfixMathCommandI.setCurNumberOfParameters(n);
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            Object object = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, this);
            this.stack.push(object);
        } else {
            postfixMathCommandI.run(this.stack);
        }
    }

    @Override
    protected void visit(ASTOpNode aSTOpNode, int n, int n2) throws EvaluationException {
        this.visit((ASTFunNode)aSTOpNode, n, n2);
    }

    @Override
    protected void visit(ASTVarNode aSTVarNode, int n, int n2) {
        this.stack.push(aSTVarNode.getVar().getValue());
    }

    @Override
    protected void visit(ASTConstant aSTConstant, int n, int n2) throws EvaluationException {
        this.stack.push(aSTConstant.getValue());
    }

    @Override
    protected boolean supressExaminingChildren(Node node) {
        if (node instanceof ASTFunNode) {
            return node.getPFMC() instanceof CallbackEvaluationI;
        }
        return false;
    }

    @Override
    public Object eval(Node node) throws EvaluationException {
        try {
            this.walkSubEquations(node);
        }
        catch (JepException jepException) {
            throw new EvaluationException(jepException.getMessage());
        }
        Object object = this.stack.pop();
        return object;
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new PostfixEvaluator();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stack = new Stack();
    }
}

