/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;
import java.util.Stack;

public abstract class PostfixTreeWalker {
    private final Stack<NodeIndex> s = new Stack();
    private int depth;

    protected final void walk(Node node) throws JepException {
        this.s.clear();
        this.walk2(node);
    }

    private void walk2(Node node) throws JepException {
        NodeIndex nodeIndex;
        this.s.push(new NodeIndex(node));
        this.depth = 1;
        while (!this.s.isEmpty() && (nodeIndex = this.s.peek()) != NodeIndex.sentinel) {
            if (this.supressExaminingChildren(nodeIndex.n)) {
                this.visit(nodeIndex.n, 0, this.depth + 1);
                this.s.pop();
                continue;
            }
            Node node2 = nodeIndex.getNext();
            if (node2 == null) {
                this.visit(nodeIndex.n, nodeIndex.max, this.depth);
                --this.depth;
                this.s.pop();
                continue;
            }
            int n = node2.jjtGetNumChildren();
            if (n == 0 || this.supressExaminingChildren(node2)) {
                this.visit(node2, 0, this.depth + 1);
                continue;
            }
            ++this.depth;
            this.s.push(new NodeIndex(node2));
        }
    }

    protected boolean supressExaminingChildren(Node node) {
        return false;
    }

    protected final void walkSubEquations(Node node) throws JepException {
        this.s.push(NodeIndex.sentinel);
        this.walk2(node);
        NodeIndex nodeIndex = this.s.pop();
        if (nodeIndex != NodeIndex.sentinel) {
            throw new EvaluationException(JepMessages.getString("walkers.PostfixTreeWalker.ExpectedSentinalOnStack"));
        }
    }

    private final void visit(Node node, int n, int n2) throws JepException {
        if (node instanceof ASTConstant) {
            this.visit((ASTConstant)node, n, n2);
        } else if (node instanceof ASTVarNode) {
            this.visit((ASTVarNode)node, n, n2);
        } else if (node instanceof ASTOpNode) {
            this.visit((ASTOpNode)node, n, n2);
        } else if (node instanceof ASTFunNode) {
            this.visit((ASTFunNode)node, n, n2);
        } else {
            throw new JepException(MessageFormat.format(JepMessages.getString("IllegalNodeTypeEncountered"), node.getClass().getSimpleName()));
        }
    }

    protected abstract void visit(ASTFunNode var1, int var2, int var3) throws JepException;

    protected abstract void visit(ASTOpNode var1, int var2, int var3) throws JepException;

    protected abstract void visit(ASTVarNode var1, int var2, int var3) throws JepException;

    protected abstract void visit(ASTConstant var1, int var2, int var3) throws JepException;

    static class NodeIndex {
        static NodeIndex sentinel = new NodeIndex();
        Node n;
        int pos;
        int max;

        private NodeIndex() {
        }

        public NodeIndex(Node node) {
            this.n = node;
            this.pos = -1;
            this.max = node.jjtGetNumChildren();
        }

        public Node getNext() {
            ++this.pos;
            if (this.pos >= this.max) {
                return null;
            }
            return this.n.jjtGetChild(this.pos);
        }

        public String toString() {
            return this.n.toString() + "\t" + this.max + "\t" + this.pos;
        }
    }
}

