/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Document;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Koordinatensystem3D;
import de.didappslib.base.Statics;
import de.didappslib.guitools.SlomoThread;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class Diagram
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final Color[] colorArray = Diagram.erzeugeFarbArray();
    private final Document document;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Diagramm", Statics.locale);
    private final BasicSplitPaneUI splitPaneHDivUI;
    private final BasicSplitPaneUI splitPaneVDivUI;
    private final BasicSplitPaneUI splitPaneHDivUI2;
    private final BasicSplitPaneUI splitPaneVDivUI2;
    private final JPanel overlay = new JPanel(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (Diagram.this.overlayState != 0) {
                Diagram.this.paintOverlay(g);
            }
        }
    };
    protected static final int OL_NO = 0;
    protected static final int OL_PGRMODEL = 1;
    protected static final int OL_LINEMODEL = 2;
    protected static final int OL_COLORMODEL = 3;
    protected static final int OL_SELCOLORMODEL = 4;
    protected static final int OL_LINEFKT = 5;
    protected static final int OL_STRICHFKT = 6;
    protected static final int OL_COLORFKT = 7;
    protected static final int OL_PKTGRCVAL = 8;
    protected static final int OL_COLORCVAL = 9;
    protected int overlayState;
    protected int overlayValue;
    private int modelPunktGroesse_save;
    private int modelLinienStaerke_save;
    private int modelZeichFarbIndex;
    private int modelAusFarbIndex;
    private int fktBreite_save;
    private int fktStrichelung_save;
    private int fktFarbIndex_save;
    private int wertePktGr_save;
    private int werteFarbIndex_save;
    public ArrayList<Koordinatensystem> koordinatensysteme = new ArrayList();
    protected Koordinatensystem aktKS;
    protected boolean nebeneinander = false;
    public boolean plotAll = true;
    protected Color zeichenFarbe;
    protected Color auswahlFarbe;
    SlomoThread slomoThread;
    int x1 = -1;
    int x2 = -1;
    int y1;
    int y2;
    long whenClicked;
    private int overlaydelta = 1;

    public Diagram(Document doc) {
        this.document = doc;
        this.init();
        this.splitPaneHDivUI = new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border b) {
                    }

                    @Override
                    public void paint(Graphics g) {
                        g.setColor(Statics.sidebarBackButtColor_ro);
                        g.fillRect(0, 1, this.getSize().width, this.getSize().height - 2);
                        super.paint(g);
                    }
                };
            }
        };
        this.splitPaneVDivUI = new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border b) {
                    }

                    @Override
                    public void paint(Graphics g) {
                        g.setColor(Statics.sidebarBackButtColor_ro);
                        g.fillRect(1, 0, this.getSize().width - 2, this.getSize().height);
                        super.paint(g);
                    }
                };
            }
        };
        this.splitPaneHDivUI2 = new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border b) {
                    }

                    @Override
                    public void paint(Graphics g) {
                        g.setColor(Statics.sidebarBackButtColor_ro);
                        g.fillRect(0, 1, this.getSize().width, this.getSize().height - 2);
                        super.paint(g);
                    }
                };
            }
        };
        this.splitPaneVDivUI2 = new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border b) {
                    }

                    @Override
                    public void paint(Graphics g) {
                        g.setColor(Statics.sidebarBackButtColor_ro);
                        g.fillRect(1, 0, this.getSize().width - 2, this.getSize().height);
                        super.paint(g);
                    }
                };
            }
        };
    }

    public final void init() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Diagram.this.hasBeenResized();
            }
        });
        this.setLayout(null);
        this.setBackground(Color.white);
        this.overlay.setBackground(new Color(0, 0, 0, 0));
        this.overlay.addMouseListener(this);
        this.overlay.addMouseMotionListener(this);
        this.overlay.addKeyListener(this);
        this.createKSysteme(1, true, false);
    }

    private void layoutKSysteme() {
        this.getComponent(0).setBounds(0, 0, this.getWidth(), this.getHeight());
        for (Koordinatensystem koordinatensystem : this.koordinatensysteme) {
            if (this.koordinatensysteme.size() > 3) {
                koordinatensystem.getParent().getParent().doLayout();
            } else {
                koordinatensystem.getParent().doLayout();
            }
            koordinatensystem.adjustLegend();
        }
    }

    public void clearKSListe() {
        this.koordinatensysteme.clear();
    }

    public void hasBeenResized() {
        this.layoutKSysteme();
        this.overlay.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    public final void createKSysteme(int anzahl, boolean neben, boolean update) {
        Statics.print("CreateKS...");
        Koordinatensystem k1 = null;
        this.nebeneinander = neben;
        this.removeAll();
        this.overlayState = 0;
        this.koordinatensysteme.clear();
        switch (anzahl) {
            case 1: {
                k1 = new Koordinatensystem(this, 1);
                k1.checkAuftragungsStrings();
                this.koordinatensysteme.add(k1);
                this.add(k1);
                this.validate();
                break;
            }
            case 2: {
                JSplitPane sp = new JSplitPane();
                sp.setDividerSize(5);
                sp.setResizeWeight(0.5);
                this.add(sp);
                k1 = new Koordinatensystem(this, 1);
                k1.checkAuftragungsStrings();
                this.koordinatensysteme.add(k1);
                Koordinatensystem k2 = new Koordinatensystem(this, 2);
                k2.checkAuftragungsStrings();
                this.koordinatensysteme.add(k2);
                if (this.nebeneinander) {
                    sp.setOrientation(1);
                    sp.setLeftComponent(k1);
                    sp.setRightComponent(k2);
                    sp.setUI(this.splitPaneVDivUI);
                } else {
                    sp.setOrientation(0);
                    sp.setTopComponent(k1);
                    sp.setBottomComponent(k2);
                    sp.setUI(this.splitPaneHDivUI);
                }
                sp.setDividerLocation(0.5);
                sp.setBorder(null);
                break;
            }
            case 3: {
                JSplitPane sp1 = new JSplitPane();
                sp1.setDividerSize(5);
                sp1.setResizeWeight(0.33);
                JSplitPane sp2 = new JSplitPane();
                sp2.setDividerSize(5);
                sp2.setResizeWeight(0.5);
                this.add(sp1);
                k1 = new Koordinatensystem(this, 1);
                k1.checkAuftragungsStrings();
                this.koordinatensysteme.add(k1);
                Koordinatensystem k2 = new Koordinatensystem(this, 2);
                k2.checkAuftragungsStrings();
                this.koordinatensysteme.add(k2);
                Koordinatensystem k3 = new Koordinatensystem(this, 3);
                k3.checkAuftragungsStrings();
                this.koordinatensysteme.add(k3);
                if (this.nebeneinander) {
                    sp1.setOrientation(1);
                    sp2.setOrientation(1);
                    sp1.setLeftComponent(k1);
                    sp1.setRightComponent(sp2);
                    sp1.setUI(this.splitPaneVDivUI);
                    sp2.setLeftComponent(k2);
                    sp2.setRightComponent(k3);
                    sp2.setUI(this.splitPaneVDivUI2);
                } else {
                    sp1.setOrientation(0);
                    sp2.setOrientation(0);
                    sp1.setTopComponent(k1);
                    sp1.setBottomComponent(sp2);
                    sp1.setUI(this.splitPaneHDivUI);
                    sp2.setTopComponent(k2);
                    sp2.setBottomComponent(k3);
                    sp2.setUI(this.splitPaneHDivUI2);
                }
                sp1.setBorder(null);
                sp2.setBorder(null);
                sp1.setDividerLocation(0.33);
                sp2.setDividerLocation(0.5);
                break;
            }
            case 4: {
                JSplitPane sp1 = new JSplitPane();
                sp1.setDividerSize(5);
                sp1.setResizeWeight(0.5);
                JSplitPane sp2 = new JSplitPane();
                sp2.setDividerSize(5);
                sp2.setResizeWeight(0.5);
                sp2.setBorder(null);
                JSplitPane sp3 = new JSplitPane();
                sp3.setDividerSize(5);
                sp3.setResizeWeight(0.5);
                sp3.setBorder(null);
                this.add(sp1);
                k1 = new Koordinatensystem(this, 1);
                k1.checkAuftragungsStrings();
                this.koordinatensysteme.add(k1);
                Koordinatensystem k2 = new Koordinatensystem(this, 2);
                k2.checkAuftragungsStrings();
                this.koordinatensysteme.add(k2);
                Koordinatensystem k3 = new Koordinatensystem(this, 3);
                k3.checkAuftragungsStrings();
                this.koordinatensysteme.add(k3);
                Koordinatensystem k4 = new Koordinatensystem(this, 4);
                k4.checkAuftragungsStrings();
                this.koordinatensysteme.add(k4);
                sp1.setOrientation(0);
                sp2.setOrientation(1);
                sp3.setOrientation(1);
                sp1.setLeftComponent(sp2);
                sp1.setRightComponent(sp3);
                sp1.setUI(this.splitPaneHDivUI);
                sp2.setLeftComponent(k1);
                sp2.setRightComponent(k2);
                sp3.setUI(this.splitPaneVDivUI);
                sp3.setLeftComponent(k3);
                sp3.setRightComponent(k4);
                sp3.setUI(this.splitPaneVDivUI);
                sp1.setBorder(null);
                sp2.setBorder(null);
                sp3.setBorder(null);
                sp1.setDividerLocation(0.5);
                sp2.setDividerLocation(0.5);
                sp3.setDividerLocation(0.5);
            }
        }
        this.layoutKSysteme();
        if (k1 == null) {
            this.document.errorMsg("Error!", "Could not create coordinate systems.", null, true);
            return;
        }
        k1.activate();
        if (update) {
            this.updateDiagramPlus();
        }
        this.document.setChanged(true);
        Statics.println("fertig mit CreateKS");
    }

    public void createKSystem3D() {
        Statics.println("Anfang mit CreateKS3D");
        this.removeAll();
        this.overlayState = 0;
        this.koordinatensysteme.clear();
        Koordinatensystem3D k = new Koordinatensystem3D(this);
        this.koordinatensysteme.add(k);
        this.add(k);
        k.activate();
        ((Koordinatensystem)k).checkAuftragungsStrings();
        this.layoutKSysteme();
        Statics.println("fertig mit CreateKS3D");
    }

    public void readKSDataV12(String kennung, ObjectInputStream ostr) throws Exception {
        Statics.println("*now reading Diagram (" + kennung + ") ...");
        int ksanzahl = 1;
        boolean neben = true;
        if (kennung.contains("KSData4")) {
            ksanzahl = 4;
        } else if (kennung.contains("KSData3n")) {
            ksanzahl = 3;
        } else if (kennung.contains("KSData3u")) {
            ksanzahl = 3;
            neben = false;
        } else if (kennung.contains("KSData2n")) {
            ksanzahl = 2;
        } else if (kennung.contains("KSData2u")) {
            ksanzahl = 2;
            neben = false;
        }
        if (kennung.contains("KSData3D")) {
            this.createKSystem3D();
            this.aktKS.readDataV12(ostr);
        } else {
            this.createKSysteme(ksanzahl, neben, false);
            for (int i = 0; i < this.koordinatensysteme.size(); ++i) {
                Koordinatensystem ks = this.koordinatensysteme.get(i);
                Statics.print("read KS" + i + "...");
                ks.readDataV12(ostr);
            }
        }
        this.document.getViewer().getMenus().adjustDarstSubMenu(ksanzahl, neben);
        this.aktKS.generateAllPlotArrays();
        this.aktKS.zeichneAlles();
        Statics.println("\n*Diagram data read");
    }

    public void readDiagramm(ObjectInputStream ostr, float datversion, String kennung) throws Exception {
        if (kennung.contains("KSData")) {
            this.readKSDataV12(kennung, ostr);
            return;
        }
        if ((double)datversion < 2.2) {
            this.document.fontNumber = ostr.readInt();
            this.document.fontSize = ostr.readInt();
            this.document.showSmallGrid = ostr.readBoolean();
            this.document.achsenFaerben = ostr.readBoolean();
            this.document.scrollRad = ostr.readBoolean();
            this.document.achsenDehnen = ostr.readBoolean();
            this.document.showLegend = ostr.readBoolean();
        }
        int ksanzahl = 1;
        boolean neben = true;
        kennung = ostr.readUTF();
        if (kennung.contains("KSData4")) {
            ksanzahl = 4;
        } else if (kennung.contains("KSData3n")) {
            ksanzahl = 3;
        } else if (kennung.contains("KSData3u")) {
            ksanzahl = 3;
            neben = false;
        } else if (kennung.contains("KSData2n")) {
            ksanzahl = 2;
        } else if (kennung.contains("KSData2u")) {
            ksanzahl = 2;
            neben = false;
        }
        if (kennung.contains("KSData3D")) {
            this.createKSystem3D();
            this.aktKS.readData(ostr, datversion, kennung);
        } else {
            this.createKSysteme(ksanzahl, neben, false);
            for (Koordinatensystem koordinatensystem : this.koordinatensysteme) {
                koordinatensystem.readData(ostr, datversion, kennung);
                koordinatensystem.generateAllPlotArrays();
            }
        }
    }

    public void writeDiagramm(ObjectOutputStream objstr) throws Exception {
        objstr.writeUTF("DiagrammData");
        if (this.aktKS instanceof Koordinatensystem3D) {
            objstr.writeUTF("\nKSData3D\n");
            this.aktKS.writeData(objstr);
            return;
        }
        switch (this.koordinatensysteme.size()) {
            case 1: {
                objstr.writeUTF("\nKSData\n");
                break;
            }
            case 2: {
                if (this.nebeneinander) {
                    objstr.writeUTF("\nKSData2n\n");
                    break;
                }
                objstr.writeUTF("\nKSData2u\n");
                break;
            }
            case 3: {
                if (this.nebeneinander) {
                    objstr.writeUTF("\nKSData3n\n");
                    break;
                }
                objstr.writeUTF("\nKSData3u\n");
                break;
            }
            case 4: {
                objstr.writeUTF("\nKSData4\n");
            }
        }
        for (Koordinatensystem koordinatensystem : this.koordinatensysteme) {
            koordinatensystem.writeData(objstr);
        }
    }

    public void setSliderStatus(int status, int value) {
        this.overlayState = status;
        this.overlayValue = value;
    }

    public void updateDiagramOhnePaint() {
        Statics.println("UpdateDiagrammOhnePaint...");
        this.koordinatensysteme.forEach(k -> k.generateAllPlotArrays());
    }

    public void updateDiagramPlus() {
        if (this.document.getViewer() == null) {
            return;
        }
        Statics.println("UpdateDiagrammMitRedraw...");
        this.koordinatensysteme.forEach(k -> k.generateAllPlotArrays());
        this.redrawDiagram();
    }

    public void updateWertePlots() {
        if (this.document.getViewer() == null) {
            return;
        }
        Statics.println("UpdateWerteMitRedraw...");
        this.koordinatensysteme.forEach(k -> k.generateWertePlotArrays());
        this.redrawDiagram();
    }

    public void startSlomoAnimation() {
        this.stopSlomoAnimation();
        this.slomoThread = new SlomoThread(this.document.getModel(), this.document.getViewer().getAnimationSpeed());
        this.slomoThread.execute();
    }

    public void stopSlomoAnimation() {
        if (this.slomoThread != null) {
            while (!this.slomoThread.isDone()) {
                this.slomoThread.cancel(true);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.document.getViewer().slomoButt.setName("nothing");
    }

    public void pauseSlomoAnimation() {
        if (this.slomoThread == null) {
            return;
        }
        while (!this.slomoThread.isDone()) {
            this.slomoThread.cancel(true);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.document.getViewer().slomoButt.setName("slomopaused");
    }

    public void resumeSlomoAnimation() {
        this.slomoThread = new SlomoThread(this.document.getModel(), this.document.getViewer().getAnimationSpeed());
        this.slomoThread.setStartValue(this.document.getViewer().getCalcLengthSliderValue());
        this.slomoThread.execute();
    }

    public void redrawDiagram() {
        this.document.getViewer().setCalcLengthSlider(100, false);
        this.koordinatensysteme.forEach(k -> k.zeichneAlles());
    }

    public void redrawDiagramBis(int to) {
        this.document.getViewer().setCalcLengthSlider(to, false);
        this.koordinatensysteme.forEach(k -> k.zeichneTeils(0, to, false));
    }

    public void redrawDiagramBisSlider(int to) {
        this.document.getViewer().setCalcLengthSlider(to, false);
        this.koordinatensysteme.forEach(k -> k.zeichneTeils(0, to, true));
    }

    @Override
    public void paint(Graphics g) {
        if (this.overlayState != 0) {
            if (!this.overlay.isShowing()) {
                this.add((Component)this.overlay, 0);
            }
            this.overlay.requestFocus();
        }
        super.paint(g);
    }

    private void paintOverlay(Graphics g) {
        if (this.overlayState == 0 || g == null) {
            return;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.overlayState <= 9) {
            String s;
            g.setColor(Statics.transpBGColor);
            int left = this.getWidth() / 2 - 225;
            int top = this.getHeight() / 2 - 70;
            int hwidth = 225;
            g.fillRoundRect(left, top, 2 * hwidth, 140, 40, 40);
            g.setFont(new Font("Dialog", 1, 26));
            if (this.overlayState == 1) {
                s = this.rbundle.getString("Punktgr\u00f6\u00dfe_DGL");
                this.drawSpecial(g, "  " + s + " \u2192", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 30, top + 50);
            }
            if (this.overlayState == 2) {
                s = this.rbundle.getString("Linienst\u00e4rke_DGL");
                this.drawSpecial(g, "\u2190 " + s + " \u2192", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 40, top + 50);
            }
            if (this.overlayState == 3) {
                s = this.rbundle.getString("Zeichenfarbe_DGL");
                this.drawSpecial(g, "\u2190 " + s + " \u2192", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 40, top + 50);
            }
            if (this.overlayState == 4) {
                s = this.rbundle.getString("Auswahlfarbe_DGL");
                this.drawSpecial(g, "\u2190 " + s + "  ", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 40, top + 50);
            }
            if (this.overlayState == 5) {
                s = this.rbundle.getString("Linienst\u00e4rke_Funktion");
                this.drawSpecial(g, "   " + s + " \u2192", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 30, top + 50);
            }
            if (this.overlayState == 6) {
                s = this.rbundle.getString("Strichelung_Funktion");
                this.drawSpecial(g, "\u2190 " + s + " \u2192", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 40, top + 50);
            }
            if (this.overlayState == 7) {
                s = this.rbundle.getString("Farbe_der_Funktion");
                this.drawSpecial(g, "\u2190 " + s + "  ", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 40, top + 50);
            }
            if (this.overlayState == 8) {
                s = this.rbundle.getString("Punktgr\u00f6\u00dfe_Vergl.-Werte");
                this.drawSpecial(g, "   " + s + " \u2192", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 30, top + 50);
            }
            if (this.overlayState == 9) {
                s = this.rbundle.getString("Farbe_der_Vergl.-Werte");
                this.drawSpecial(g, "\u2190 " + s + "  ", left + hwidth - g.getFontMetrics().stringWidth(s) / 2 - 40, top + 50);
            }
            if (this.overlayState == 1 || this.overlayState == 2 || this.overlayState == 5 || this.overlayState == 6 || this.overlayState == 8) {
                int i;
                g.setColor(Statics.transpBGColorDark);
                for (i = 0; i < 16; ++i) {
                    g.fillRect(left + 120 + 14 * i, top + 90, 10, 12);
                }
                for (i = 0; i < this.overlayValue; ++i) {
                    g.setColor(Statics.transpBGColorDark);
                    g.fillRoundRect(left + 119 + 14 * i, top + 90, 12, 13, 3, 3);
                    g.setColor(new Color(250, 250, 250));
                    g.fillRect(left + 120 + 14 * i, top + 90, 10, 12);
                }
            } else {
                g.setColor(Statics.transpBGColorDark);
                g.fillRoundRect(left + (2 * hwidth - colorArray.length) / 2 - 2, top + 90 - 2, colorArray.length + 3, 16, 3, 3);
                g.fillRoundRect(left + (2 * hwidth - colorArray.length) / 2 - 1, top + 90 - 1, colorArray.length + 3, 16, 3, 3);
                for (int i = 0; i < colorArray.length; ++i) {
                    g.setColor(colorArray[i]);
                    g.drawLine(i + left + (2 * hwidth - colorArray.length) / 2, top + 90, i + left + (2 * hwidth - colorArray.length) / 2, top + 102);
                }
                g.setColor(Color.BLACK);
                ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
                g.drawRoundRect(this.overlayValue + left + (2 * hwidth - colorArray.length) / 2 - 4, top + 90 - 5, 5, 22, 3, 3);
            }
        }
    }

    private void drawSpecial(Graphics g, String s, int x, int y) {
        g.setColor(Statics.transpBGColorDark);
        g.drawString(s, x - 1, y - 1);
        g.drawString(s, x + 1, y + 1);
        g.drawString(s, x + 2, y + 2);
        g.setColor(new Color(250, 250, 250));
        g.drawString(s, x, y);
    }

    public void showOverlay(int state) {
        this.overlayState = state;
        this.savePlotParameter();
        this.setOverlayValues(state);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int i;
        int top;
        int left;
        if (this.overlayState == 1 || this.overlayState == 2 || this.overlayState == 5 || this.overlayState == 6 || this.overlayState == 8) {
            left = this.getWidth() / 2 - 200;
            top = this.getHeight() / 2 - 70;
            if (Math.abs(e.getY() - (top + 95)) < 25 && (i = (e.getX() - left - 100 + 14) / 14) >= 0 && i <= 16) {
                this.overlayValue = i;
                if (this.overlayState == 1) {
                    if (this.document.linienStaerke == 0 && this.overlayValue == 0) {
                        this.overlayValue = 1;
                    }
                    this.document.punktGroesse = this.overlayValue;
                }
                if (this.overlayState == 2) {
                    if (this.document.punktGroesse == 0 && this.overlayValue == 0) {
                        this.overlayValue = 1;
                    }
                    this.document.linienStaerke = this.overlayValue;
                }
                if (this.overlayState == 5) {
                    if (this.overlayValue < 1) {
                        this.overlayValue = 1;
                    }
                    this.document.fktBreite = this.overlayValue;
                }
                if (this.overlayState == 6) {
                    this.document.fktStrichelung = this.overlayValue;
                }
                if (this.overlayState == 8) {
                    this.document.wertePktGr = this.overlayValue;
                }
                this.redrawDiagram();
                this.repaint();
                return;
            }
        }
        if (this.overlayState == 3 || this.overlayState == 4 || this.overlayState == 7 || this.overlayState == 9) {
            left = this.getWidth() / 2 - 200;
            top = this.getHeight() / 2 - 70;
            if (Math.abs(e.getY() - (top + 95)) < 25 && (i = e.getX() - left - (400 - colorArray.length) / 2) >= 0 && i <= colorArray.length - 1) {
                this.overlayValue = i;
                if (this.overlayState == 3) {
                    this.document.zeichFarbIndex = this.overlayValue;
                    this.zeichenFarbe = colorArray[this.overlayValue];
                    this.document.getModel().repaint();
                }
                if (this.overlayState == 4) {
                    this.document.auswFarbIndex = this.overlayValue;
                    this.zeichenFarbe = colorArray[this.overlayValue];
                    this.document.getModel().repaint();
                }
                if (this.overlayState == 7) {
                    this.document.fktFarbIndex = this.overlayValue;
                }
                if (this.overlayState == 9) {
                    this.document.werteFarbIndex = this.overlayValue;
                }
                this.redrawDiagram();
                this.repaint();
                return;
            }
            return;
        }
    }

    private void savePlotParameter() {
        this.modelPunktGroesse_save = this.document.punktGroesse;
        this.modelLinienStaerke_save = this.document.linienStaerke;
        this.modelZeichFarbIndex = this.document.zeichFarbIndex;
        this.modelAusFarbIndex = this.document.auswFarbIndex;
        this.fktBreite_save = this.document.fktBreite;
        this.fktStrichelung_save = this.document.fktStrichelung;
        this.fktFarbIndex_save = this.document.fktFarbIndex;
        this.wertePktGr_save = this.document.wertePktGr;
        this.werteFarbIndex_save = this.document.werteFarbIndex;
    }

    private void restorePlotParameter() {
        this.document.punktGroesse = this.modelPunktGroesse_save;
        this.document.linienStaerke = this.modelLinienStaerke_save;
        this.document.zeichFarbIndex = this.modelZeichFarbIndex;
        this.document.auswFarbIndex = this.modelAusFarbIndex;
        this.document.fktBreite = this.fktBreite_save;
        this.document.fktStrichelung = this.fktStrichelung_save;
        this.document.fktFarbIndex = this.fktFarbIndex_save;
        this.document.wertePktGr = this.wertePktGr_save;
        this.document.werteFarbIndex = this.werteFarbIndex_save;
    }

    protected void setOverlayValues(int state) {
        switch (state) {
            case 1: {
                this.overlayValue = this.document.punktGroesse;
                break;
            }
            case 2: {
                this.overlayValue = this.document.linienStaerke;
                break;
            }
            case 3: {
                this.overlayValue = this.document.zeichFarbIndex;
                break;
            }
            case 4: {
                this.overlayValue = this.document.auswFarbIndex;
                break;
            }
            case 5: {
                this.overlayValue = this.document.fktBreite;
                break;
            }
            case 6: {
                this.overlayValue = this.document.fktStrichelung;
                break;
            }
            case 7: {
                this.overlayValue = this.document.fktFarbIndex;
                break;
            }
            case 8: {
                this.overlayValue = this.document.wertePktGr;
                break;
            }
            case 9: {
                this.overlayValue = this.document.werteFarbIndex;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.whenClicked == e.getWhen()) {
            return;
        }
        this.whenClicked = e.getWhen();
        int left = this.getWidth() / 2 - 250;
        int top = this.getHeight() / 2 - 85;
        if (this.overlayState > 0 && (x < left || y < top || x > left + 500 || y > top + 170)) {
            this.overlayState = 0;
            this.document.setChanged(true);
            this.remove(this.overlay);
            this.redrawDiagram();
            this.repaint();
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int i;
        int top;
        int left;
        if (this.whenClicked == e.getWhen()) {
            return;
        }
        this.whenClicked = e.getWhen();
        this.x1 = e.getX();
        this.y1 = e.getY();
        this.x2 = -1;
        this.y2 = -1;
        if (this.overlayState > 0) {
            int top2 = this.getHeight() / 2 - 70;
            if (Math.abs(this.y1 - (top2 + 40)) < 20) {
                if (this.x1 > this.getWidth() / 2) {
                    ++this.overlayState;
                    if (this.overlayState == 5) {
                        this.overlayState = 4;
                    }
                    if (this.overlayState == 8) {
                        this.overlayState = 7;
                    }
                    if (this.overlayState > 9) {
                        this.overlayState = 9;
                    }
                } else {
                    --this.overlayState;
                    if (this.overlayState < 1) {
                        this.overlayState = 1;
                    }
                    if (this.overlayState == 4) {
                        this.overlayState = 5;
                    }
                    if (this.overlayState == 7) {
                        this.overlayState = 8;
                    }
                }
                this.setOverlayValues(this.overlayState);
            }
            this.redrawDiagram();
            this.repaint();
        }
        if (this.overlayState == 1 || this.overlayState == 2 || this.overlayState == 5 || this.overlayState == 6 || this.overlayState == 8) {
            left = this.getWidth() / 2 - 200;
            top = this.getHeight() / 2 - 70;
            if (Math.abs(e.getY() - (top + 95)) < 25 && (i = (e.getX() - left - 100 + 14) / 14) >= 0 && i <= 16) {
                this.overlayValue = i;
                if (this.overlayState == 1) {
                    this.document.punktGroesse = this.overlayValue;
                }
                if (this.overlayState == 2) {
                    this.document.linienStaerke = this.overlayValue;
                }
                if (this.overlayState == 5) {
                    if (this.overlayValue < 1) {
                        this.overlayValue = 1;
                    }
                    this.document.fktBreite = this.overlayValue;
                }
                if (this.overlayState == 6) {
                    this.document.fktStrichelung = this.overlayValue;
                }
                if (this.overlayState == 8) {
                    this.document.wertePktGr = this.overlayValue;
                }
                this.redrawDiagram();
                this.repaint();
                return;
            }
        }
        if (this.overlayState == 3 || this.overlayState == 4 || this.overlayState == 7 || this.overlayState == 9) {
            left = this.getWidth() / 2 - 200;
            top = this.getHeight() / 2 - 70;
            if (Math.abs(e.getY() - (top + 95)) < 25 && (i = e.getX() - left - (400 - colorArray.length) / 2) >= 0 && i <= colorArray.length - 1) {
                this.overlayValue = i;
                if (this.overlayState == 3) {
                    this.document.zeichFarbIndex = this.overlayValue;
                    this.zeichenFarbe = colorArray[this.overlayValue];
                    this.document.getModel().repaint();
                }
                if (this.overlayState == 4) {
                    this.document.auswFarbIndex = this.overlayValue;
                    this.zeichenFarbe = colorArray[this.overlayValue];
                    this.document.getModel().repaint();
                }
                if (this.overlayState == 7) {
                    this.document.fktFarbIndex = this.overlayValue;
                }
                if (this.overlayState == 9) {
                    this.document.werteFarbIndex = this.overlayValue;
                }
                this.redrawDiagram();
                return;
            }
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.whenClicked == e.getWhen()) {
            return;
        }
        this.whenClicked = e.getWhen();
        int overlaymax = 16;
        if (this.overlayState == 3 || this.overlayState == 4 || this.overlayState == 7 || this.overlayState == 9) {
            overlaymax = colorArray.length - 1;
        }
        if (e.getKeyCode() == 39 && this.overlayState != 0) {
            this.overlayValue += this.overlaydelta;
            if (this.overlayState == 3 || this.overlayState == 4 || this.overlayState == 7 || this.overlayState == 9) {
                ++this.overlaydelta;
            }
            if (this.overlaydelta > 30) {
                this.overlaydelta = 30;
            }
            if (this.overlayValue > overlaymax) {
                this.overlayValue = overlaymax;
            }
            if (this.overlayState == 1) {
                this.document.punktGroesse = this.overlayValue;
            }
            if (this.overlayState == 2) {
                this.document.linienStaerke = this.overlayValue;
            }
            if (this.overlayState == 3) {
                this.document.zeichFarbIndex = this.overlayValue;
            }
            if (this.overlayState == 4) {
                this.document.auswFarbIndex = this.overlayValue;
            }
            if (this.overlayState == 5) {
                this.document.fktBreite = this.overlayValue;
            }
            if (this.overlayState == 6) {
                this.document.fktStrichelung = this.overlayValue;
            }
            if (this.overlayState == 7) {
                this.document.fktFarbIndex = this.overlayValue;
            }
            if (this.overlayState == 8) {
                this.document.wertePktGr = this.overlayValue;
            }
            if (this.overlayState == 9) {
                this.document.werteFarbIndex = this.overlayValue;
            }
            this.redrawDiagram();
            this.repaint();
        }
        if (e.getKeyCode() == 37 && this.overlayState != 0) {
            this.overlayValue -= this.overlaydelta;
            if (this.overlayState == 3 || this.overlayState == 4 || this.overlayState == 7 || this.overlayState == 9) {
                ++this.overlaydelta;
            }
            if (this.overlaydelta > 30) {
                this.overlaydelta = 30;
            }
            if (this.overlayValue < 0) {
                this.overlayValue = 0;
            }
            if (this.overlayState == 1) {
                this.document.punktGroesse = this.overlayValue;
            }
            if (this.overlayState == 2) {
                this.document.linienStaerke = this.overlayValue;
            }
            if (this.overlayState == 3) {
                this.document.zeichFarbIndex = this.overlayValue;
            }
            if (this.overlayState == 4) {
                this.document.auswFarbIndex = this.overlayValue;
            }
            if (this.overlayState == 5) {
                if (this.overlayValue < 1) {
                    this.overlayValue = 1;
                }
                this.document.fktBreite = this.overlayValue;
            }
            if (this.overlayState == 6) {
                this.document.fktStrichelung = this.overlayValue;
            }
            if (this.overlayState == 7) {
                this.document.fktFarbIndex = this.overlayValue;
            }
            if (this.overlayState == 8) {
                this.document.wertePktGr = this.overlayValue;
            }
            if (this.overlayState == 9) {
                this.document.werteFarbIndex = this.overlayValue;
            }
            this.redrawDiagram();
            this.repaint();
        }
        if (e.getKeyCode() == 27 && this.overlayState != 0) {
            this.restorePlotParameter();
            this.overlayState = 0;
            this.remove(this.overlay);
            this.redrawDiagram();
            this.repaint();
        }
        if (e.getKeyCode() == 10 && this.overlayState != 0) {
            this.overlayState = 0;
            this.remove(this.overlay);
            this.document.setChanged(true);
            this.redrawDiagram();
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.overlayState != 0) {
            this.overlaydelta = 1;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private static Color[] erzeugeFarbArray() {
        int gg;
        int maxwert = 255;
        int wo = 0;
        int r = 255;
        int b = 0;
        int step = 5;
        double fak = 0.83;
        Color[] colArr = new Color[6 * maxwert / step];
        for (gg = 0; gg < maxwert; gg += step) {
            colArr[wo] = new Color((int)((double)r * fak), (int)((double)gg * fak), (int)((double)b * fak));
            ++wo;
        }
        gg = maxwert;
        fak = 0.55;
        for (r = maxwert; r > 0; r -= step) {
            colArr[wo] = new Color((int)((double)r * fak), (int)((double)gg * fak), (int)((double)b * fak));
            ++wo;
        }
        r = 0;
        fak = 0.72;
        for (b = 0; b < maxwert; b += step) {
            colArr[wo] = new Color((int)((double)r * fak), (int)((double)gg * fak), (int)((double)b * fak));
            ++wo;
        }
        b = maxwert;
        fak = 0.88;
        for (gg = maxwert; gg > 0; gg -= step) {
            colArr[wo] = new Color((int)((double)r * fak), (int)((double)gg * fak), (int)((double)b * fak));
            ++wo;
        }
        gg = 0;
        fak = 0.7;
        for (r = 0; r < maxwert; r += step) {
            colArr[wo] = new Color((int)((double)r * fak), (int)((double)gg * fak), (int)((double)b * fak));
            ++wo;
        }
        r = maxwert;
        fak = 0.6;
        for (b = maxwert; b > 0; b -= step) {
            if (b < 3 * step) {
                fak = 0.0;
            }
            colArr[wo] = new Color((int)((double)r * fak), (int)((double)gg * fak), (int)((double)b * fak));
            ++wo;
        }
        return colArr;
    }

    public Document getProjekt() {
        return this.document;
    }

    public int getKSAnzahl() {
        return this.koordinatensysteme.size();
    }
}

