/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Document;
import de.didappslib.base.Menus;
import de.didappslib.base.PrefsDialog;
import de.didappslib.base.Statics;
import de.didappslib.base.Tabelle;
import de.didappslib.base.VergleichsTabelle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public final class DocumentPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Projekt", Statics.locale);
    public DocumentPanel me = this;
    private Document document;
    private final Menus window;
    private Tabelle aktTable = null;
    private final Icon[] busyIcons = new Icon[15];
    private final Icon idleIcon = new ImageIcon(this.getClass().getResource("/de/didappslib/images/busyicons/idle-icon.png"));
    public int busyIconIndex = 0;
    public Timer busyTimer;
    protected UndoManager undoManager = new UndoManager();
    private int animationSpeed = 5;
    private boolean isUpdating;
    private boolean enterpressed;
    private boolean noRedraw;
    public boolean scaleSliderMoved = false;
    private JDialog animSpeedDialog;
    private JPanel animSpeedPanel;
    private JSlider animSpeedSlider;
    public JSplitPane anzeigePane;
    private JLabel calcLengthLabel;
    private JSlider calcLengthSlider;
    private JButton clearButt;
    private JPanel distance;
    private JPanel errorPanel;
    private JPanel extrasPanel;
    private JLabel fastLabel;
    public JSplitPane generalPane;
    private JButton goButton;
    private JButton hideButton;
    private JButton infoButt;
    private JPanel modelPanel;
    private JLabel msgLabel;
    private JButton playButt;
    protected JTextField prjNameField;
    public JPanel sidebar;
    private JPanel sidebarPanel;
    private JScrollPane sidebarScrollPane;
    private JPanel sliderPanel;
    public JButton slomoButt;
    private JLabel slowLabel;
    private JLabel statusLab;
    private JPanel steuerPanel;
    private JButton tabClrButt;
    private JButton tabImportButt;
    private JComboBox<String> tabellenwahlCB;
    private JPanel tableButPane;
    private JPanel tableContainer;
    private JPanel tableControlPane;
    protected JPanel tablePane;
    private JPanel viewPane;

    public DocumentPanel(Document doc) {
        this.document = doc;
        this.document.setViewer(this);
        this.window = new Menus(this.document);
        PrefsDialog pd = Statics.prefsDialog;
        this.initComponents();
        this.clearButt.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/ClearIcon", 1.0f));
        this.clearButt.setPressedIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/ClearIconPressed", 1.0f));
        this.clearButt.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/ClearIconRollover", 1.0f));
        this.playButt.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/PlayIcon", 1.0f));
        this.playButt.setPressedIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/PlayIconPressed", 1.0f));
        this.playButt.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/PlayIconRollover", 1.0f));
        this.slomoButt.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/SlomoIcon", 1.0f));
        this.slomoButt.setPressedIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/SlomoIconPressed", 1.0f));
        this.slomoButt.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/SlomoIconRollover", 1.0f));
        this.infoButt.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/InfoButton", 1.0f));
        this.infoButt.setPressedIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/InfoButtonPressed", 1.0f));
        this.infoButt.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/InfoButtonRollover", 1.0f));
        this.slowLabel.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/langsam", 1.0f));
        this.fastLabel.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/schnell", 1.0f));
        this.tablePane.remove(this.tableButPane);
        String[] ss = new String[]{this.rbundle.getString("Modell-Ergebnis"), this.rbundle.getString("Definierbare_Tabelle"), this.rbundle.getString("Vergleichswerte")};
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(ss);
        this.tabellenwahlCB.setModel(cbm);
        this.prjNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                DocumentPanel.this.document.setPrjName(DocumentPanel.this.prjNameField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                DocumentPanel.this.document.setPrjName(DocumentPanel.this.prjNameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                DocumentPanel.this.document.setPrjName(DocumentPanel.this.prjNameField.getText());
            }
        });
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = new ImageIcon(this.getClass().getResource("/de/didappslib/images/busyicons/busy-icon" + i + ".png"));
        }
        this.busyTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DocumentPanel.this.busyIconIndex == 0) {
                    DocumentPanel.this.playButt.setName("stopcalc");
                    DocumentPanel.this.playButt.setToolTipText(DocumentPanel.this.rbundle.getString("Simulation_stoppen"));
                    DocumentPanel.this.playButt.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/StopIcon", 1.0f));
                    DocumentPanel.this.playButt.setPressedIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/StopIconPressed", 1.0f));
                    DocumentPanel.this.playButt.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/StopIconRollover", 1.0f));
                    DocumentPanel.this.slomoButt.setEnabled(false);
                    DocumentPanel.this.clearButt.setEnabled(false);
                }
                ++DocumentPanel.this.busyIconIndex;
                DocumentPanel.this.statusLab.setIcon(DocumentPanel.this.busyIcons[DocumentPanel.this.busyIconIndex % DocumentPanel.this.busyIcons.length]);
                if (DocumentPanel.this.document.getModel().berechnung != null) {
                    DocumentPanel.this.setStatusLabel(DocumentPanel.this.document.getModel().berechnung.getProgress());
                }
                if (DocumentPanel.this.busyIconIndex > 3000) {
                    DocumentPanel.this.busyIconIndex = 1;
                }
            }
        });
        this.statusLab.setIcon(this.idleIcon);
        if (Statics.os.contains("Mac")) {
            this.animSpeedPanel.setBorder(null);
            this.animSpeedPanel.remove(this.distance);
        }
        this.window.setContentPane(this.me);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Statics.projektSchliessen(DocumentPanel.this.document);
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                Statics.aktProjekt = DocumentPanel.this.document;
            }
        });
        this.window.setJMenuBar(this.window.menuBar);
        this.updateWindowTitle();
        this.showHideProgBar(Statics.prefsDialog.showProgBar);
        this.anzeigePane.setRightComponent(null);
        this.window.pack();
    }

    private void initComponents() {
        this.animSpeedDialog = new JDialog();
        this.animSpeedPanel = new JPanel();
        this.slowLabel = new JLabel();
        this.animSpeedSlider = new JSlider();
        this.fastLabel = new JLabel();
        this.distance = new JPanel();
        this.goButton = new JButton();
        this.generalPane = new JSplitPane();
        this.sidebar = new JPanel();
        this.prjNameField = new JTextField();
        this.infoButt = new JButton();
        this.sidebarScrollPane = new JScrollPane();
        this.sidebarPanel = new JPanel();
        this.modelPanel = new JPanel();
        this.steuerPanel = new JPanel();
        this.playButt = new JButton();
        this.slomoButt = new JButton();
        this.statusLab = new JLabel();
        this.clearButt = new JButton();
        this.sliderPanel = new JPanel();
        this.calcLengthLabel = new JLabel();
        this.calcLengthSlider = new JSlider();
        this.extrasPanel = new JPanel();
        this.errorPanel = new JPanel();
        this.msgLabel = new JLabel();
        this.anzeigePane = new JSplitPane();
        this.viewPane = new JPanel();
        this.tablePane = new JPanel();
        this.tableControlPane = new JPanel();
        this.hideButton = new JButton();
        this.tabellenwahlCB = new JComboBox();
        this.tableContainer = new JPanel();
        this.tableButPane = new JPanel();
        this.tabClrButt = new JButton();
        this.tabImportButt = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("de/didappslib/base/resources/Projekt");
        this.animSpeedDialog.setTitle(bundle.getString("Animationsgeschwindigkeit"));
        this.animSpeedDialog.setAlwaysOnTop(true);
        this.animSpeedDialog.setModal(true);
        this.animSpeedDialog.setUndecorated(true);
        this.animSpeedDialog.setResizable(false);
        this.animSpeedDialog.setSize(new Dimension(300, 40));
        this.animSpeedDialog.setType(Window.Type.UTILITY);
        this.animSpeedDialog.getContentPane().setLayout(new GridBagLayout());
        this.animSpeedPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 102, 204)));
        this.animSpeedPanel.setPreferredSize(new Dimension(330, 50));
        this.animSpeedPanel.setLayout(new GridBagLayout());
        this.slowLabel.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/langsam.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.animSpeedPanel.add((Component)this.slowLabel, gridBagConstraints);
        this.animSpeedSlider.setPaintLabels(true);
        this.animSpeedSlider.setToolTipText(bundle.getString("AnimationSlider_TIP"));
        this.animSpeedSlider.setValue(4);
        this.animSpeedSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DocumentPanel.this.animSpeedSliderMouseClicked(evt);
            }
        });
        this.animSpeedSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPanel.this.animSpeedSliderKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        this.animSpeedPanel.add((Component)this.animSpeedSlider, gridBagConstraints);
        this.fastLabel.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/schnell.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.animSpeedPanel.add((Component)this.fastLabel, gridBagConstraints);
        this.distance.setMinimumSize(new Dimension(5, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.animSpeedPanel.add((Component)this.distance, gridBagConstraints);
        this.goButton.setText(this.rbundle.getString("go!"));
        this.goButton.setIconTextGap(0);
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.goButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.animSpeedPanel.add((Component)this.goButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.animSpeedDialog.getContentPane().add((Component)this.animSpeedPanel, gridBagConstraints);
        this.setBackground(new Color(214, 220, 224));
        this.setMinimumSize(new Dimension(750, 550));
        this.setPreferredSize(new Dimension(1000, 800));
        this.setLayout(new BorderLayout());
        this.generalPane.setBorder(null);
        this.generalPane.setDividerLocation(315);
        this.generalPane.setDividerSize(4);
        this.sidebar.setBackground(Statics.sidebarBackColor);
        this.sidebar.setMinimumSize(new Dimension(315, 602));
        this.sidebar.setPreferredSize(new Dimension(315, 602));
        this.sidebar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DocumentPanel.this.sidebarComponentResized(evt);
            }
        });
        this.sidebar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPanel.this.sidebarKeyPressed(evt);
            }
        });
        this.sidebar.setLayout(new GridBagLayout());
        this.prjNameField.setBackground(Statics.sidebarBackColor);
        this.prjNameField.setFont(this.prjNameField.getFont().deriveFont(this.prjNameField.getFont().getStyle() | 1, this.prjNameField.getFont().getSize() + 1));
        this.prjNameField.setHorizontalAlignment(0);
        this.prjNameField.setText("Dummy Projektname");
        this.prjNameField.setToolTipText(this.rbundle.getString("Hier_kann_der_Projektname_geaendert_werden."));
        this.prjNameField.setBorder(null);
        this.prjNameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 19));
        this.prjNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DocumentPanel.this.prjNameFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 3);
        this.sidebar.add((Component)this.prjNameField, gridBagConstraints);
        this.infoButt.setBackground(Statics.sidebarBackColor);
        this.infoButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/InfoButton.png")));
        this.infoButt.setToolTipText(this.rbundle.getString("Informationen_zum_Projekt"));
        this.infoButt.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.infoButt.setBorderPainted(false);
        this.infoButt.setMaximumSize(new Dimension(22, 22));
        this.infoButt.setPreferredSize(new Dimension(22, 22));
        this.infoButt.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/InfoButtonPressed.png")));
        this.infoButt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/InfoButtonRollover.png")));
        this.infoButt.setVerticalAlignment(1);
        this.infoButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.infoButtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.sidebar.add((Component)this.infoButt, gridBagConstraints);
        this.sidebarScrollPane.setBorder(null);
        this.sidebarScrollPane.setHorizontalScrollBarPolicy(31);
        this.sidebarScrollPane.setPreferredSize(new Dimension(270, 600));
        this.sidebarPanel.setBackground(Statics.sidebarBackColor);
        this.sidebarPanel.setLayout(new GridBagLayout());
        this.modelPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.sidebarPanel.add((Component)this.modelPanel, gridBagConstraints);
        this.steuerPanel.setOpaque(false);
        this.steuerPanel.setPreferredSize(new Dimension(50, 40));
        this.steuerPanel.setLayout(new GridBagLayout());
        this.playButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/PlayIcon.png")));
        this.playButt.setToolTipText(this.rbundle.getString("Simulation_einmal_ausf\u00fchren"));
        this.playButt.setBorder(null);
        this.playButt.setBorderPainted(false);
        this.playButt.setContentAreaFilled(false);
        this.playButt.setFocusable(false);
        this.playButt.setIconTextGap(5);
        this.playButt.setMargin(new Insets(0, 0, 0, 2));
        this.playButt.setMinimumSize(new Dimension(110, 26));
        this.playButt.setName("startcalc");
        this.playButt.setPreferredSize(new Dimension(45, 34));
        this.playButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.playButtPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.steuerPanel.add((Component)this.playButt, gridBagConstraints);
        this.slomoButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/SlomoIcon.png")));
        this.slomoButt.setToolTipText(this.rbundle.getString("Simulation_langsam_ausf\u00fchren"));
        this.slomoButt.setBorder(null);
        this.slomoButt.setBorderPainted(false);
        this.slomoButt.setContentAreaFilled(false);
        this.slomoButt.setFocusable(false);
        this.slomoButt.setIconTextGap(5);
        this.slomoButt.setMargin(new Insets(0, 0, 0, 2));
        this.slomoButt.setName("nothing");
        this.slomoButt.setPreferredSize(new Dimension(45, 34));
        this.slomoButt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DocumentPanel.this.slomoButtMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.steuerPanel.add((Component)this.slomoButt, gridBagConstraints);
        this.statusLab.setHorizontalAlignment(0);
        this.statusLab.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/busyicons/idle-icon.png")));
        this.statusLab.setName("startcalc");
        this.statusLab.setPreferredSize(new Dimension(55, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.steuerPanel.add((Component)this.statusLab, gridBagConstraints);
        this.clearButt.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/ClearIcon.png")));
        this.clearButt.setToolTipText(this.rbundle.getString("clearButt_TIP"));
        this.clearButt.setBorder(null);
        this.clearButt.setBorderPainted(false);
        this.clearButt.setContentAreaFilled(false);
        this.clearButt.setFocusable(false);
        this.clearButt.setIconTextGap(5);
        this.clearButt.setMargin(new Insets(0, 0, 0, 2));
        this.clearButt.setPreferredSize(new Dimension(45, 34));
        this.clearButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.clearButtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.steuerPanel.add((Component)this.clearButt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.sidebarPanel.add((Component)this.steuerPanel, gridBagConstraints);
        this.sliderPanel.setBackground(Statics.sidebarBackColor);
        this.sliderPanel.setLayout(new GridBagLayout());
        this.calcLengthLabel.setFont(new Font("Lucida Grande", 0, 14));
        this.calcLengthLabel.setHorizontalAlignment(2);
        this.calcLengthLabel.setText(bundle.getString("part_drawn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.sliderPanel.add((Component)this.calcLengthLabel, gridBagConstraints);
        this.calcLengthSlider.setBackground(Statics.sidebarBackColor);
        this.calcLengthSlider.setPaintLabels(true);
        this.calcLengthSlider.setValue(100);
        this.calcLengthSlider.setMaximumSize(new Dimension(500, 29));
        this.calcLengthSlider.setMinimumSize(new Dimension(200, 29));
        this.calcLengthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DocumentPanel.this.calcLengthSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.sliderPanel.add((Component)this.calcLengthSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.sidebarPanel.add((Component)this.sliderPanel, gridBagConstraints);
        this.extrasPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.sidebarPanel.add((Component)this.extrasPanel, gridBagConstraints);
        this.errorPanel.setBackground(Statics.sidebarBackColor);
        this.errorPanel.setMinimumSize(new Dimension(255, 62));
        this.errorPanel.setPreferredSize(new Dimension(255, 62));
        this.errorPanel.setLayout(new GridBagLayout());
        this.msgLabel.setFont(new Font("SansSerif", 0, 12));
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.errorPanel.add((Component)this.msgLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.sidebarPanel.add((Component)this.errorPanel, gridBagConstraints);
        this.sidebarScrollPane.setViewportView(this.sidebarPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 2);
        this.sidebar.add((Component)this.sidebarScrollPane, gridBagConstraints);
        this.generalPane.setLeftComponent(this.sidebar);
        this.anzeigePane.setBorder(null);
        this.anzeigePane.setDividerLocation(30000);
        this.anzeigePane.setDividerSize(4);
        this.anzeigePane.setResizeWeight(1.0);
        this.anzeigePane.setPreferredSize(new Dimension(900, 1400));
        this.viewPane.setBackground(new Color(255, 255, 255));
        this.viewPane.setDoubleBuffered(false);
        this.viewPane.setFocusCycleRoot(true);
        this.viewPane.setVerifyInputWhenFocusTarget(false);
        this.viewPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DocumentPanel.this.viewPaneComponentResized(evt);
            }
        });
        this.viewPane.setLayout(new BorderLayout());
        this.anzeigePane.setLeftComponent(this.viewPane);
        this.tablePane.setBackground(Statics.sidebarBackColor);
        this.tablePane.setLayout(new BorderLayout());
        this.tableControlPane.setBackground(Statics.sidebarBackColor);
        this.tableControlPane.setLayout(new GridBagLayout());
        this.hideButton.setFont(new Font("Lucida Grande", 1, 18));
        this.hideButton.setForeground(new Color(51, 51, 51));
        this.hideButton.setText("\u2794");
        this.hideButton.setToolTipText(this.rbundle.getString("Tabelle_ausblenden."));
        this.hideButton.setPreferredSize(new Dimension(60, 20));
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.hideButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.tableControlPane.add((Component)this.hideButton, gridBagConstraints);
        this.tabellenwahlCB.setFont(new Font("Lucida Grande", 0, 12));
        this.tabellenwahlCB.setToolTipText(this.rbundle.getString("Art_der_Tabellenansicht_festlegen."));
        this.tabellenwahlCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DocumentPanel.this.tabellenwahlCBItemStateChanged(evt);
            }
        });
        this.tabellenwahlCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.tabellenwahlCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tableControlPane.add(this.tabellenwahlCB, gridBagConstraints);
        this.tablePane.add((Component)this.tableControlPane, "North");
        this.tableContainer.setBackground(Statics.sidebarBackColor);
        this.tableContainer.setLayout(new BorderLayout());
        this.tablePane.add((Component)this.tableContainer, "Center");
        this.tableButPane.setBackground(Statics.sidebarBackColor);
        this.tableButPane.setLayout(new GridBagLayout());
        this.tabClrButt.setFont(new Font("Lucida Grande", 0, 12));
        this.tabClrButt.setText(this.rbundle.getString("l\u00f6schen..."));
        this.tabClrButt.setToolTipText(this.rbundle.getString("Alle_Werte_l\u00f6schen."));
        this.tabClrButt.setPreferredSize(new Dimension(120, 29));
        this.tabClrButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.tabClrButtActionPerformed(evt);
            }
        });
        this.tableButPane.add((Component)this.tabClrButt, new GridBagConstraints());
        this.tabImportButt.setFont(new Font("Lucida Grande", 0, 12));
        this.tabImportButt.setText(this.rbundle.getString("importieren..."));
        this.tabImportButt.setToolTipText(this.rbundle.getString("Vergleichswerte_importieren_(TAB-Text)."));
        this.tabImportButt.setPreferredSize(new Dimension(120, 29));
        this.tabImportButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.tabImportButtActionPerformed(evt);
            }
        });
        this.tableButPane.add((Component)this.tabImportButt, new GridBagConstraints());
        this.tablePane.add((Component)this.tableButPane, "Last");
        this.anzeigePane.setRightComponent(this.tablePane);
        this.generalPane.setRightComponent(this.anzeigePane);
        this.add((Component)this.generalPane, "Center");
    }

    private void infoButtActionPerformed(ActionEvent evt) {
        this.showInfoPDF();
    }

    private void viewPaneComponentResized(ComponentEvent evt) {
        int w = this.viewPane.getWidth();
        int h = this.viewPane.getHeight();
        if (this.document.getDiagramm() != null) {
            this.document.getDiagramm().setSize(w, h);
        }
    }

    private void playButtPressed(ActionEvent evt) {
        if (this.playButt.getName().equals("stopcalc")) {
            this.document.getModel().stopCalculation(true);
            this.document.getDiagramm().updateDiagramPlus();
        } else {
            this.document.getModel().startCalculation();
        }
    }

    private void clearButtActionPerformed(ActionEvent evt) {
        this.document.getModel().clearData(0);
    }

    private void tabellenwahlCBItemStateChanged(ItemEvent evt) {
        this.tableContainer.removeAll();
        try {
            if (this.aktTable == this.document.getModelTable()) {
                this.document.getCustomTable().tab.setRowSelectionInterval(this.aktTable.tab.getSelectedRow(), this.aktTable.tab.getSelectedRow() + this.aktTable.tab.getSelectedRowCount() - 1);
            }
            if (this.aktTable == this.document.getCustomTable()) {
                this.document.getModelTable().tab.setRowSelectionInterval(this.aktTable.tab.getSelectedRow(), this.aktTable.tab.getSelectedRow() + this.aktTable.tab.getSelectedRowCount() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (evt.getItem().toString().contains(this.rbundle.getString("Modell-Ergebnis"))) {
            this.tablePane.remove(this.tableButPane);
            this.aktTable = this.document.getModelTable();
        }
        if (evt.getItem().toString().contains(this.rbundle.getString("Definierbare_Tabelle"))) {
            this.tablePane.remove(this.tableButPane);
            this.aktTable = this.document.getCustomTable();
        }
        if (evt.getItem().toString().contains(this.rbundle.getString("Vergleichswerte"))) {
            this.tablePane.add((Component)this.tableButPane, "South");
            this.aktTable = this.document.getCompValTable();
        }
        this.tableContainer.add((Component)this.aktTable, "Center");
        this.tablePane.doLayout();
        this.tableContainer.doLayout();
        this.tableButPane.doLayout();
    }

    private void tabClrButtActionPerformed(ActionEvent evt) {
        this.document.getCompValTable().clearAll();
    }

    private void tabImportButtActionPerformed(ActionEvent evt) {
        this.document.getCompValTable().importTable();
    }

    private void hideButtonActionPerformed(ActionEvent evt) {
        this.document.getViewer().showHideTable(0.0);
    }

    private void slomoButtMousePressed(MouseEvent evt) {
        if ((evt.getModifiersEx() & 0x40) != 0 || evt.isPopupTrigger() || evt.getButton() > 1) {
            this.openAnimationSliderDialog();
        } else {
            this.sidebar.requestFocus();
            if (this.slomoButt.getName().equals("slomorunning")) {
                this.document.getDiagramm().pauseSlomoAnimation();
                return;
            }
            if (this.slomoButt.getName().equals("slomopaused")) {
                this.document.getDiagramm().resumeSlomoAnimation();
                return;
            }
            if (this.slomoButt.getName().equals("nothing")) {
                this.document.getModel().startCalculationSlomo();
                return;
            }
        }
    }

    private void animSpeedSliderKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.enterpressed = true;
            this.animSpeedDialog.setVisible(false);
        }
        if (evt.getKeyCode() == 27) {
            this.animSpeedDialog.setVisible(false);
        }
    }

    private void animSpeedSliderMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.enterpressed = true;
            this.animSpeedDialog.setVisible(false);
        }
    }

    private void sidebarComponentResized(ComponentEvent evt) {
        this.sidebar.validate();
        float f = (float)this.generalPane.getDividerLocation() / Statics.prefsDialog.guiScale;
        Objects.requireNonNull(this.document);
        this.document.sidebarDivLocFactor = f / 315.0f;
    }

    private void prjNameFieldKeyTyped(KeyEvent evt) {
        if (evt.getExtendedKeyCode() == 10) {
            this.prjNameField.transferFocus();
            return;
        }
        this.document.setChanged(true);
    }

    private void sidebarKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() != 32) {
            return;
        }
        if (this.slomoButt.getName().equals("slomorunning")) {
            this.document.getDiagramm().pauseSlomoAnimation();
            return;
        }
        if (this.slomoButt.getName().equals("slomopaused")) {
            this.document.getDiagramm().resumeSlomoAnimation();
            return;
        }
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        this.enterpressed = true;
        this.animSpeedDialog.setVisible(false);
    }

    private void calcLengthSliderStateChanged(ChangeEvent evt) {
        if (!this.noRedraw) {
            this.document.getDiagramm().redrawDiagramBisSlider(this.calcLengthSlider.getValue());
        }
    }

    private void tabellenwahlCBActionPerformed(ActionEvent evt) {
        this.showHideTable(1.0);
    }

    public void calcLengthSliderSetEndabled(boolean bool) {
        this.calcLengthSlider.setEnabled(bool);
    }

    public void setCalcLengthSlider(int val, boolean redraw) {
        this.noRedraw = !redraw;
        this.calcLengthSlider.setValue(val);
        this.noRedraw = false;
    }

    public int getCalcLengthSliderValue() {
        return this.calcLengthSlider.getValue();
    }

    private void openAnimationSliderDialog() {
        this.animSpeedSlider.setValue(this.animationSpeed * 10);
        Point p = this.slomoButt.getLocationOnScreen();
        p.setLocation(p.x - 51, p.y);
        this.animSpeedDialog.setLocation(p);
        this.enterpressed = false;
        this.animSpeedDialog.setVisible(true);
        this.animationSpeed = this.animSpeedSlider.getValue() / 10;
        if (this.enterpressed) {
            this.document.getModel().startCalculationSlomo();
        }
    }

    public void showHideTable(double size) {
        if (size < 0.0) {
            size = (double)this.anzeigePane.getDividerLocation() > 0.99 * (double)this.anzeigePane.getWidth() ? 1.0 : 0.0;
        }
        if (size == 1.0) {
            switch (this.tabellenwahlCB.getSelectedIndex()) {
                case 0: {
                    this.aktTable = this.document.getModelTable();
                    break;
                }
                case 1: {
                    this.aktTable = this.document.getCustomTable();
                    break;
                }
                case 2: {
                    this.aktTable = this.document.getCompValTable();
                }
            }
            double tbreite = this.aktTable.evalTabWidth();
            double d = 1.0 - tbreite / (double)this.anzeigePane.getWidth();
            if (d < 0.25) {
                d = 0.25;
            }
            this.anzeigePane.setRightComponent(this.tablePane);
            this.anzeigePane.setDividerLocation(d);
            this.tablePane.getComponent(0).requestFocus();
        } else {
            this.anzeigePane.setDividerLocation(1.0);
            this.anzeigePane.setRightComponent(null);
            this.document.getDiagramm().requestFocus();
            this.aktTable = null;
        }
        this.anzeigePane.doLayout();
    }

    public boolean isTableShown() {
        return this.anzeigePane.getWidth() - this.viewPane.getWidth() > 50;
    }

    public void showVWerteTab() {
        this.tabellenwahlCB.setSelectedIndex(2);
        this.showHideTable(1.0);
    }

    public void setVWerteTab(VergleichsTabelle vtab) {
        this.tableContainer.removeAll();
        this.tableContainer.add((Component)vtab, "Center");
        this.tablePane.add((Component)this.tableButPane, "South");
        this.tablePane.doLayout();
        this.tableContainer.doLayout();
        this.tableButPane.doLayout();
    }

    public boolean vTabelleIsSelected() {
        return this.tabellenwahlCB.getSelectedIndex() == 1;
    }

    public void redrawTable() {
        this.tablePane.getComponent(1).repaint();
    }

    public void setTabellenWahlCB(int value) {
        this.tabellenwahlCB.setSelectedIndex(value);
    }

    public void addEdit(UndoableEdit ue) {
        this.undoManager.addEdit(ue);
        if (this.document.getViewer() != null) {
            this.document.getViewer().getMenus().updateUndoRedoItems();
        }
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
        if (this.document.getViewer() != null) {
            this.document.getViewer().getMenus().updateUndoRedoItems();
        }
    }

    void setErrorLabel(String str, int type) {
        switch (type) {
            case 1: {
                this.msgLabel.setForeground(Statics.sidebarErrorColor);
                break;
            }
            case 2: {
                this.msgLabel.setForeground(Statics.sidebarWarningColor);
                break;
            }
            default: {
                this.msgLabel.setForeground(Statics.sidebarTextColor);
            }
        }
        this.msgLabel.setText("<HTML>" + str.replace("\n", "<p>") + "</HTML>");
    }

    public void setWarningLabel(String s) {
        this.setErrorLabel(s, 2);
    }

    public String getPrjName() {
        return this.prjNameField.getText();
    }

    public Document getProjekt() {
        return this.document;
    }

    public void startBusyTimer(boolean immediateButtonFeedback) {
        if (immediateButtonFeedback) {
            this.playButt.setName("stopcalc");
            this.playButt.setToolTipText(this.rbundle.getString("Simulation_stoppen"));
            this.playButt.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/StopIcon", 1.0f));
            this.playButt.setPressedIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/StopIconPressed", 1.0f));
            this.playButt.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/StopIconRollover", 1.0f));
            this.playButt.setBorder(null);
            this.slomoButt.setEnabled(false);
            this.clearButt.setEnabled(false);
        }
        this.busyIconIndex = 0;
        this.busyTimer.start();
    }

    public void stopBusyTimer() {
        this.statusLab.setIcon(this.idleIcon);
        this.statusLab.setText(null);
        this.playButt.setName("startcalc");
        this.playButt.setToolTipText(this.rbundle.getString("Simulation_einmal_ausf\u00fchren"));
        this.playButt.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/PlayIcon", 1.0f));
        this.playButt.setPressedIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/PlayIconPressed", 1.0f));
        this.playButt.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/PlayIconRollover", 1.0f));
        this.playButt.setBorder(null);
        this.slomoButt.setEnabled(true);
        this.clearButt.setEnabled(true);
        this.busyTimer.stop();
    }

    public void setStatusLabel(int val) {
        this.statusLab.setText(val + " %");
    }

    public void setModelPanel(JPanel mp) {
        this.modelPanel.removeAll();
        this.modelPanel.add(mp);
    }

    public void setExtrasPanel(JPanel ep) {
        this.extrasPanel.add(ep);
    }

    public void showHideProgBar(boolean showProgBar) {
        if (!showProgBar) {
            this.sidebar.remove(this.window.getMenuPanel());
        } else {
            this.sidebar.remove(this.window.getMenuPanel());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            this.sidebar.add((Component)this.window.getMenuPanel(), gridBagConstraints);
            this.window.getMenuPanel().validate();
        }
        this.validateSidebar();
    }

    public void validateSidebar() {
        this.sidebar.validate();
    }

    public void scaleSidebar(float scale) {
        float newFieldFontSize = 15.0f * scale * (scale == 1.0f ? 1.0f : 1.05f);
        float newLabFontSize = 13.0f * scale * (scale == 1.0f ? 1.0f : 0.98f);
        this.prjNameField.setFont(this.prjNameField.getFont().deriveFont(newFieldFontSize));
        this.calcLengthLabel.setFont(this.calcLengthLabel.getFont().deriveFont(newLabFontSize));
        this.document.getModel().panelResized();
        this.document.getExtras().panelResized();
        Objects.requireNonNull(this.document);
        this.sidebar.setMinimumSize(new Dimension((int)(315.0f * scale), 480));
        this.setDividerLocation(this.document.sidebarDivLocFactor);
    }

    public void setSidebarMaxDivPos() {
        if (this.window != null) {
            this.anzeigePane.setMinimumSize(new Dimension(this.window.getWidth() / 2, 480));
        }
    }

    public void updateView() {
        this.isUpdating = true;
        if (this.document.getViewer().getAktTable() != null) {
            this.document.getViewer().getAktTable().updateTab();
        }
        if (this.document.getDiagramm() != null) {
            this.document.getDiagramm().updateDiagramPlus();
        }
        this.repaint();
        this.isUpdating = false;
    }

    public void updateViewOhnePaint() {
        this.isUpdating = true;
        if (this.document.getViewer().getAktTable() != null) {
            this.document.getViewer().getAktTable().updateTab();
        }
        if (this.document.getDiagramm() != null) {
            this.document.getDiagramm().updateDiagramOhnePaint();
        }
        this.isUpdating = false;
    }

    public void updateAll() {
        this.validateSidebar();
        this.updateView();
    }

    private void setDividerLocation(float divLocFac) {
        Objects.requireNonNull(this.document);
        int divLoc = (int)(315.0f * Statics.prefsDialog.guiScale * divLocFac);
        this.generalPane.setDividerLocation(divLoc);
    }

    public void setWindowBoundsAndDividerLocation(Rectangle bounds, float divLocFac) {
        this.window.setBounds(bounds);
        this.setDividerLocation(divLocFac);
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void initDiagramm() {
        if (this.document.getDiagramm() != null) {
            this.document.getDiagramm().init();
        }
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public Tabelle getAktTable() {
        return this.aktTable;
    }

    public void setAktTable(Tabelle tabelle) {
        this.aktTable = tabelle;
        this.tabellenwahlCB.setSelectedIndex(tabelle.getType() - 1);
    }

    public void setAktTableByType(int type) {
        switch (type) {
            case 0: {
                this.showHideTable(0.0);
                break;
            }
            case 1: {
                this.setAktTable(this.document.getModelTable());
                break;
            }
            case 2: {
                this.setAktTable(this.document.getCustomTable());
                break;
            }
            case 3: {
                this.setAktTable(this.document.getCompValTable());
                break;
            }
        }
    }

    public void setPrjNameFieldText(String txt) {
        try {
            this.prjNameField.setText(txt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSplitPane getAnzeigePane() {
        return this.anzeigePane;
    }

    public boolean checkInfoFile() {
        boolean bool = new File(this.document.getPath() + this.document.adjustSuffix(this.document.getFileName(), "pdf")).exists();
        if (!bool) {
            bool = new File(this.document.getPath() + this.document.adjustSuffix(this.document.getFileName(), "PDF")).exists();
        }
        this.infoButt.setVisible(bool);
        return bool;
    }

    public void showInfoPDF() {
        try {
            if (new File(this.document.getPath() + this.document.adjustSuffix(this.document.getFileName(), "pdf")).exists()) {
                Desktop.getDesktop().open(new File(this.document.getPath() + this.document.adjustSuffix(this.document.getFileName(), "pdf")));
            } else {
                Desktop.getDesktop().open(new File(this.document.getPath() + this.document.adjustSuffix(this.document.getFileName(), "PDF")));
            }
        }
        catch (Exception ex) {
            this.document.errorMsg(this.rbundle.getString("File_error"), this.rbundle.getString("Could_not_open_info_file").replace("#", this.document.getFileName()), null, true);
            this.infoButt.setVisible(false);
        }
    }

    public JFrame getWindow() {
        return this.window;
    }

    public Menus getMenus() {
        return this.window;
    }

    public Rectangle getWindowBounds() {
        return this.window.getBounds();
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public final void updateWindowTitle() {
        String s = "";
        if (this.document.hasChanged()) {
            s = "\u2022 ";
        }
        this.window.setTitle(s + this.document.getPrjName() + " (" + this.document.getFileName() + ") - " + Statics.prgName + "  V" + Statics.prgVersion);
    }

    public final void init() {
        ImageIcon icon = new ImageIcon(this.document.getModel().getClass().getResource("/images/ProgramIcon_220.png"));
        this.window.setIconImage(icon.getImage());
        this.setModelPanel(this.document.getModel());
        this.setExtrasPanel(this.document.getExtras());
        this.initDiagramm();
        this.viewPane.add(this.document.getDiagramm());
        this.validateSidebar();
        this.document.getExtras().neu();
        this.extrasPanel.add(this.document.getExtras());
        this.document.getExtras().validate();
        this.document.getExtras().doLayout();
        this.tableContainer.add((Component)this.document.getModelTable(), "Center");
        this.setPrjNameFieldText(this.rbundle.getString("Neues_Projekt"));
        this.undoManager.setLimit(100);
    }
}

