/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DocumentPrefs
extends JDialog {
    private final Font[] fonts = new Font[12];
    private final ComboBoxModel fontCBoxModel;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/DocumentPrefs", Statics.locale);
    private boolean init;
    private final Document document;
    private JLabel BasicLab;
    private JCheckBox achsDehnCB;
    private JCheckBox achsFaerbCB;
    private JLabel aktLab;
    private JPanel basicPanel;
    private JLabel calcLabel;
    private JButton defaultButt;
    private JCheckBox edbarCB;
    private JTextField epsilonField;
    private JLabel epsilonLabel;
    private JSlider epsilonSlider;
    private JCheckBox feinGitterCB;
    private JComboBox<String> fontCBox;
    private JLabel fontLabel;
    private JComboBox<String> fontsizeCBox;
    private JCheckBox gitterCB;
    private JLabel graphLabel;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel6;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JTextField prjNamField;
    private JCheckBox scrollradCB;
    private JButton templateButt;
    private JButton toLoadButt;
    private JComboBox<String> verfahrenComBox;

    public DocumentPrefs(Document doc) {
        super((Frame)doc.getViewer().getWindow(), true);
        this.document = doc;
        this.fontCBoxModel = new DefaultComboBoxModel<String>(new String[]{this.rbundle.getString("Serif_-_normal"), this.rbundle.getString("Serif_-_fett"), this.rbundle.getString("Serif_-_kursiv"), this.rbundle.getString("Serif_-_fett_&_kursiv"), this.rbundle.getString("Sans_Serif_-_normal"), this.rbundle.getString("Sans_Serif_-_fett"), this.rbundle.getString("Sans_Serif_-_kursiv"), this.rbundle.getString("Sans_Serif_-_fett_&_kursiv"), this.rbundle.getString("Monospaced_-_normal"), this.rbundle.getString("Monospaced_-_fett"), this.rbundle.getString("Monospaced_-_kursiv"), this.rbundle.getString("Monospaced_-_fett_&_kursiv")});
        this.fonts[0] = new Font("Serif", 0, 13);
        this.fonts[1] = new Font("Serif", 1, 13);
        this.fonts[2] = new Font("Serif", 2, 13);
        this.fonts[3] = new Font("Serif", 3, 13);
        this.fonts[4] = new Font("SansSerif", 0, 12);
        this.fonts[5] = new Font("SansSerif", 1, 12);
        this.fonts[6] = new Font("SansSerif", 2, 12);
        this.fonts[7] = new Font("SansSerif", 3, 12);
        this.fonts[8] = new Font("Monospaced", 0, 12);
        this.fonts[9] = new Font("Monospaced", 1, 12);
        this.fonts[10] = new Font("Monospaced", 2, 12);
        this.fonts[11] = new Font("Monospaced", 3, 12);
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.BasicLab = new JLabel();
        this.basicPanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.prjNamField = new JTextField();
        this.calcLabel = new JLabel();
        this.verfahrenComBox = new JComboBox();
        this.epsilonLabel = new JLabel();
        this.epsilonField = new JTextField();
        this.epsilonSlider = new JSlider();
        this.edbarCB = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.graphLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.fontLabel = new JLabel();
        this.fontCBox = new JComboBox();
        this.fontsizeCBox = new JComboBox();
        this.gitterCB = new JCheckBox();
        this.feinGitterCB = new JCheckBox();
        this.achsFaerbCB = new JCheckBox();
        this.scrollradCB = new JCheckBox();
        this.achsDehnCB = new JCheckBox();
        this.jSeparator4 = new JSeparator();
        this.aktLab = new JLabel();
        this.jPanel2 = new JPanel();
        this.defaultButt = new JButton();
        this.templateButt = new JButton();
        this.toLoadButt = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.rbundle.getString("Einstellungen_fuer_das_aktuelle_Projekt"));
        this.setBackground(Statics.sidebarBackColor);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DocumentPrefs.this.prefsDialogWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.BasicLab.setFont(new Font("Lucida Grande", 1, 13));
        this.BasicLab.setText(this.rbundle.getString("Grundeinstellungen"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(17, 30, 0, 0);
        this.getContentPane().add((Component)this.BasicLab, gridBagConstraints);
        this.basicPanel.setLayout(new GridBagLayout());
        this.jLabel9.setText(this.rbundle.getString("Name_des_Projekts:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.basicPanel.add((Component)this.jLabel9, gridBagConstraints);
        this.prjNamField.setText("Name");
        this.prjNamField.setToolTipText(this.rbundle.getString("Hier_kann_der_Name_des_Projekts_angegeben_werden."));
        this.prjNamField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.prjNamField.setMinimumSize(new Dimension(15, 25));
        this.prjNamField.setOpaque(true);
        this.prjNamField.setPreferredSize(new Dimension(15, 25));
        this.prjNamField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                DocumentPrefs.this.prjNamFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 5);
        this.basicPanel.add((Component)this.prjNamField, gridBagConstraints);
        this.calcLabel.setText(this.rbundle.getString("Verfahren:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.basicPanel.add((Component)this.calcLabel, gridBagConstraints);
        this.verfahrenComBox.setModel(new DefaultComboBoxModel<String>(new String[]{this.rbundle.getString("Euler"), this.rbundle.getString("Heun"), this.rbundle.getString("RKstd"), this.rbundle.getString("RKadapt")}));
        this.verfahrenComBox.setToolTipText(this.rbundle.getString("Auswahl_des_Rechenverfahrens."));
        this.verfahrenComBox.setMaximumSize(new Dimension(275, Short.MAX_VALUE));
        this.verfahrenComBox.setMinimumSize(new Dimension(275, 27));
        this.verfahrenComBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DocumentPrefs.this.verfahrenComBoxItemStateChanged(evt);
            }
        });
        this.verfahrenComBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.verfahrenComBoxActionPerformed(evt);
            }
        });
        this.verfahrenComBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 2, 0, 2);
        this.basicPanel.add(this.verfahrenComBox, gridBagConstraints);
        this.epsilonLabel.setText(this.rbundle.getString("Epsilon:"));
        ResourceBundle bundle = ResourceBundle.getBundle("de/didappslib/base/resources/DocumentPrefs");
        this.epsilonLabel.setToolTipText(bundle.getString("Epsilon_TIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.basicPanel.add((Component)this.epsilonLabel, gridBagConstraints);
        this.epsilonField.setEditable(false);
        this.epsilonField.setBackground(Statics.sidebarBackColor);
        this.epsilonField.setText("1e-4");
        this.epsilonField.setToolTipText(bundle.getString("Epsilon_TIP"));
        this.epsilonField.setPreferredSize(new Dimension(70, 25));
        this.epsilonField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.basicPanel.add((Component)this.epsilonField, gridBagConstraints);
        this.epsilonSlider.setMajorTickSpacing(3);
        this.epsilonSlider.setMaximum(10);
        this.epsilonSlider.setMinimum(1);
        this.epsilonSlider.setMinorTickSpacing(1);
        this.epsilonSlider.setPaintTicks(true);
        this.epsilonSlider.setSnapToTicks(true);
        this.epsilonSlider.setValue(4);
        this.epsilonSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DocumentPrefs.this.epsilonSliderStateChanged(evt);
            }
        });
        this.epsilonSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DocumentPrefs.this.epsilonSliderMouseReleased(evt);
            }
        });
        this.epsilonSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.basicPanel.add((Component)this.epsilonSlider, gridBagConstraints);
        this.edbarCB.setSelected(true);
        this.edbarCB.setText(this.rbundle.getString("Gleichung_editierbar"));
        this.edbarCB.setToolTipText(this.rbundle.getString("Gleichung_editierbar_TIP"));
        this.edbarCB.setMargin(new Insets(0, 0, 0, 0));
        this.edbarCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DocumentPrefs.this.edbarCBStateChanged(evt);
            }
        });
        this.edbarCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.basicPanel.add((Component)this.edbarCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 30);
        this.getContentPane().add((Component)this.basicPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 20, 6, 20);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.graphLabel.setFont(new Font("Lucida Grande", 1, 13));
        this.graphLabel.setHorizontalAlignment(4);
        this.graphLabel.setText(this.rbundle.getString("Grafik_Einstellungen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 30, 0, 0);
        this.getContentPane().add((Component)this.graphLabel, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.fontLabel.setText(this.rbundle.getString("Schriftart:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel6.add((Component)this.fontLabel, gridBagConstraints);
        this.fontCBox.setMaximumRowCount(12);
        this.fontCBox.setModel(this.fontCBoxModel);
        this.fontCBox.setToolTipText(this.rbundle.getString("Hier_koennen_Sie_die_Schriftart_auswaehlen."));
        this.fontCBox.setMaximumSize(new Dimension(210, 27));
        this.fontCBox.setMinimumSize(new Dimension(210, 27));
        this.fontCBox.setPreferredSize(new Dimension(250, 27));
        this.fontCBox.setFont(this.fonts[this.fontCBox.getSelectedIndex()]);
        this.fontCBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index < 0) {
                    return super.getListCellRendererComponent((JList<?>)list, DocumentPrefs.this.fontCBox.getItemAt(DocumentPrefs.this.fontCBox.getSelectedIndex()), index, isSelected, cellHasFocus);
                }
                Font font = DocumentPrefs.this.fonts[index];
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, DocumentPrefs.this.fontCBox.getItemAt(index), index, isSelected, cellHasFocus);
                label.setFont(font);
                return label;
            }
        });
        this.fontCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.fontCBoxActionPerformed(evt);
            }
        });
        this.fontCBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel6.add(this.fontCBox, gridBagConstraints);
        this.fontsizeCBox.setEditable(true);
        this.fontsizeCBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "10", "11", "12", "14", "16", "18", "21", "24", "30", "36", "42"}));
        this.fontsizeCBox.setToolTipText(this.rbundle.getString("Hier_koennen_Sie_die_Schriftgroesse_fuer_die_Beschriftung_der_Koordinatenachsen_einstellen."));
        this.fontsizeCBox.setPreferredSize(new Dimension(55, 27));
        this.fontsizeCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.fontsizeCBoxActionPerformed(evt);
            }
        });
        this.fontsizeCBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add(this.fontsizeCBox, gridBagConstraints);
        this.gitterCB.setSelected(true);
        this.gitterCB.setText(this.rbundle.getString("Gitter_zeichnen"));
        this.gitterCB.setToolTipText(this.rbundle.getString("Gibt_an,_ob_das_Gitter_gezeichnet_wird."));
        this.gitterCB.setMargin(new Insets(0, 0, 0, 0));
        this.gitterCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.gitterCBActionPerformed(evt);
            }
        });
        this.gitterCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel6.add((Component)this.gitterCB, gridBagConstraints);
        this.feinGitterCB.setSelected(true);
        this.feinGitterCB.setText(this.rbundle.getString("auch_feines_Gitter"));
        this.feinGitterCB.setToolTipText(this.rbundle.getString("Gibt_an,_ob_zusaezlich_ein_Gitter_fuer_die_Feineinteilung_gezeichnet_wird."));
        this.feinGitterCB.setMargin(new Insets(0, 0, 0, 0));
        this.feinGitterCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.feinGitterCBActionPerformed(evt);
            }
        });
        this.feinGitterCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 30, 0, 0);
        this.jPanel6.add((Component)this.feinGitterCB, gridBagConstraints);
        this.achsFaerbCB.setSelected(true);
        this.achsFaerbCB.setText(this.rbundle.getString("Faerben_der_Achsen_bei_Automatik"));
        this.achsFaerbCB.setToolTipText(this.rbundle.getString("Gibt_an,_ob_die_Achsen_bei_automatischer_Bereichsanpassung_gefaerbt_werden."));
        this.achsFaerbCB.setMargin(new Insets(0, 0, 0, 0));
        this.achsFaerbCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.achsFaerbCBActionPerformed(evt);
            }
        });
        this.achsFaerbCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel6.add((Component)this.achsFaerbCB, gridBagConstraints);
        this.scrollradCB.setSelected(true);
        this.scrollradCB.setText(this.rbundle.getString("Scrollradunterstuetzung"));
        this.scrollradCB.setToolTipText(this.rbundle.getString("Gibt_an,_ob_das_Verkleinern_und_Vergroessern_mit_Hilfe_des_Mausrades_erfolgen_kann."));
        this.scrollradCB.setMargin(new Insets(0, 0, 0, 0));
        this.scrollradCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DocumentPrefs.this.scrollradCBStateChanged(evt);
            }
        });
        this.scrollradCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel6.add((Component)this.scrollradCB, gridBagConstraints);
        this.achsDehnCB.setSelected(true);
        this.achsDehnCB.setText(this.rbundle.getString("Dehnen_der_Achsen_mit_der_Maus_erlauben"));
        this.achsDehnCB.setToolTipText(this.rbundle.getString("Gibt_an,_ob_die_Skalierung_der_Achsen_mit_Hilfe_der_Maus_vorgenommen_werden_kann."));
        this.achsDehnCB.setMargin(new Insets(0, 0, 0, 0));
        this.achsDehnCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DocumentPrefs.this.achsDehnCBStateChanged(evt);
            }
        });
        this.achsDehnCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel6.add((Component)this.achsDehnCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 8, 20);
        this.getContentPane().add((Component)this.jSeparator4, gridBagConstraints);
        this.aktLab.setFont(new Font("Lucida Grande", 1, 13));
        this.aktLab.setHorizontalAlignment(4);
        this.aktLab.setText(this.rbundle.getString("Actions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 30, 0, 0);
        this.getContentPane().add((Component)this.aktLab, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.defaultButt.setText(this.rbundle.getString("Restore_defaults"));
        this.defaultButt.setToolTipText(bundle.getString("Restore_defaults_TIP"));
        this.defaultButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.defaultButtActionPerformed(evt);
            }
        });
        this.defaultButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.defaultButt, gridBagConstraints);
        this.templateButt.setText(this.rbundle.getString("Adapt_template"));
        this.templateButt.setToolTipText(bundle.getString("Adapt_template_TIP"));
        this.templateButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.templateButtActionPerformed(evt);
            }
        });
        this.templateButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.templateButt, gridBagConstraints);
        this.toLoadButt.setText(this.rbundle.getString("to_Load"));
        this.toLoadButt.setToolTipText(bundle.getString("toLoad_TIP"));
        this.toLoadButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPrefs.this.toLoadButtActionPerformed(evt);
            }
        });
        this.toLoadButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DocumentPrefs.this.dialogKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.toLoadButt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 20, 30);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void verfahrenComBoxItemStateChanged(ItemEvent evt) {
        this.epsilonField.setEnabled(this.verfahrenComBox.getSelectedIndex() == 3);
        this.epsilonLabel.setEnabled(this.verfahrenComBox.getSelectedIndex() == 3);
        this.epsilonSlider.setEnabled(this.verfahrenComBox.getSelectedIndex() == 3);
    }

    private void verfahrenComBoxActionPerformed(ActionEvent evt) {
        this.document.getModel().verfahren = this.verfahrenComBox.getSelectedIndex();
        if (this.document.autoCalc && !this.init) {
            this.document.getModel().startCalculation();
        }
    }

    private void epsilonSliderStateChanged(ChangeEvent evt) {
        this.epsilonField.setText("1e-" + this.epsilonSlider.getValue());
        this.document.getModel().genauigkeit = Double.parseDouble(this.epsilonField.getText());
    }

    private void epsilonSliderMouseReleased(MouseEvent evt) {
        if (this.document.autoCalc) {
            this.document.getModel().startCalculation();
        }
    }

    private void edbarCBStateChanged(ChangeEvent evt) {
        if (!this.init) {
            this.document.getModel().setEditierbar(this.edbarCB.isSelected());
        }
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void gitterCBActionPerformed(ActionEvent evt) {
        if (!this.gitterCB.isSelected()) {
            this.feinGitterCB.setSelected(false);
        }
        this.feinGitterCB.setEnabled(this.gitterCB.isSelected());
        this.document.showMainGrid = this.gitterCB.isSelected();
        this.document.showSmallGrid = this.feinGitterCB.isSelected();
        this.document.getDiagramm().redrawDiagram();
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void feinGitterCBActionPerformed(ActionEvent evt) {
        this.document.showMainGrid = this.gitterCB.isSelected();
        this.document.showSmallGrid = this.feinGitterCB.isSelected();
        this.document.getDiagramm().redrawDiagram();
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void achsFaerbCBActionPerformed(ActionEvent evt) {
        this.document.achsenFaerben = this.achsFaerbCB.isSelected();
        this.document.getDiagramm().redrawDiagram();
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
    }

    private void fontCBoxActionPerformed(ActionEvent evt) {
        this.setzeKSFont();
        this.fontCBox.setFont(Statics.fonts[this.document.fontNumber].deriveFont(12));
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void fontsizeCBoxActionPerformed(ActionEvent evt) {
        this.setzeKSFont();
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void prefsDialogWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    private void dialogKeyPressed(KeyEvent evt) {
        if (evt.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && evt.getKeyChar() == 'w') {
            this.prefsDialogWindowClosing(null);
        }
    }

    private void scrollradCBStateChanged(ChangeEvent evt) {
        this.document.scrollRad = this.scrollradCB.isSelected();
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void achsDehnCBStateChanged(ChangeEvent evt) {
        this.document.achsenDehnen = this.achsDehnCB.isSelected();
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void defaultButtActionPerformed(ActionEvent evt) {
        this.document.setVariablesToDefault();
        this.document.getViewer().updateAll();
        this.document.getDiagramm().updateDiagramPlus();
        this.updateElements();
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
    }

    private void templateButtActionPerformed(ActionEvent evt) {
        this.document.adaptToTemplate();
        this.document.getViewer().updateAll();
        this.document.getDiagramm().updateDiagramPlus();
        this.updateElements();
    }

    private void toLoadButtActionPerformed(ActionEvent evt) {
        this.document.setVariablesToLoaded();
        this.document.getViewer().updateAll();
        this.document.getDiagramm().updateDiagramPlus();
        this.updateElements();
    }

    private void prjNamFieldKeyTyped(KeyEvent evt) {
        this.document.setPrjName(this.prjNamField.getText());
    }

    public void showPrefs() {
        this.updateElements();
        this.setVisible(true);
    }

    void updateElements() {
        this.init = true;
        int verfahren = this.document.getModel().verfahren;
        this.prjNamField.setText(this.document.getPrjName());
        this.prjNamField.selectAll();
        this.prjNamField.requestFocus();
        if (verfahren != 4 && verfahren != 5) {
            this.verfahrenComBox.setSelectedIndex(verfahren);
        } else {
            this.calcLabel.setVisible(false);
            this.verfahrenComBox.setVisible(false);
            this.epsilonLabel.setText("Epsilon:");
            this.epsilonLabel.setVisible(false);
            this.epsilonField.setVisible(false);
            this.epsilonSlider.setVisible(false);
            this.pack();
        }
        this.epsilonField.setEnabled(verfahren == 3 || verfahren == 4);
        this.epsilonLabel.setEnabled(verfahren == 3 || verfahren == 4);
        this.epsilonSlider.setEnabled(verfahren == 3 || verfahren == 4);
        this.epsilonSlider.setValue(-((int)Math.log10(this.document.getModel().genauigkeit)));
        this.edbarCB.setSelected(this.document.getModel().editierbar);
        this.fontCBox.setFont(Statics.fonts[this.document.fontNumber].deriveFont(12));
        this.fontCBox.setSelectedIndex(this.document.fontNumber);
        this.fontsizeCBox.setSelectedItem("" + Math.round(this.document.fontSize));
        this.gitterCB.setSelected(this.document.showMainGrid);
        this.feinGitterCB.setEnabled(this.gitterCB.isSelected());
        this.feinGitterCB.setSelected(this.document.showSmallGrid);
        this.achsFaerbCB.setSelected(this.document.achsenFaerben);
        this.scrollradCB.setSelected(this.document.scrollRad);
        this.achsDehnCB.setSelected(this.document.achsenDehnen);
        this.setLocation(this.document.getViewer().getWindow().getX() + this.document.getViewer().getWindow().getWidth() / 2 - this.getWidth() / 2, this.document.getViewer().getWindow().getY() + 100);
        this.defaultButt.setEnabled(!this.document.areVariablesDefault());
        this.templateButt.setEnabled(Statics.templateDoc != null && !this.document.areVariablesEqToTemplate());
        this.toLoadButt.setEnabled(!this.document.areVariablesEqToLoadedOnes());
        this.init = false;
    }

    void setzeKSFont() {
        if (this.init) {
            return;
        }
        try {
            this.document.fontNumber = this.fontCBox.getSelectedIndex();
            this.document.fontSize = (float)Statics.stringToDouble((String)this.fontsizeCBox.getSelectedItem());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.document.getDiagramm().updateDiagramPlus();
    }
}

