/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.parser.Node;
import de.didappslib.base.Diagram;
import de.didappslib.base.Document;
import de.didappslib.base.DocumentPanel;
import de.didappslib.base.Statics;
import de.didappslib.base.Tabelle;
import de.didappslib.base.VergleichsTabelle;
import de.didappslib.guitools.AuftragungsPopupMenu;
import de.didappslib.guitools.GUIDevice;
import de.didappslib.guitools.GreekLetterConstPanel;
import de.didappslib.guitools.KSEinstellung;
import de.didappslib.guitools.Legend;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class Koordinatensystem
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Cloneable,
ClipboardOwner {
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Koordinatensystem", Statics.locale);
    private final JPopupMenu popup = new JPopupMenu();
    private final Koordinatensystem me = this;
    protected Diagram diagramm;
    public Document document;
    protected DocumentPanel anzeige;
    public BufferedImage ks_image;
    protected double sf = 1.0;
    private int number;
    public double XMin = -10.0;
    public double XMax = 10.0;
    public double YMin = -10.0;
    public double YMax = 10.0;
    public double modelXMin = -10.0;
    public double modelXMax = 10.0;
    public double modelYMin = -10.0;
    public double modelYMax = 10.0;
    public double modelXMin_varVal = -10.0;
    public double modelXMax_varVal = 10.0;
    public double modelYMin_varVal = -10.0;
    public double modelYMax_varVal = 10.0;
    public double vglwerteXMin = -10.0;
    public double vglwerteXMax = 10.0;
    public double vglwerteYMin = -10.0;
    public double vglwerteYMax = 10.0;
    public double vglwerteXMin_varVal = -10.0;
    public double vglwerteXMax_varVal = 10.0;
    public double vglwerteYMin_varVal = -10.0;
    public double vglwerteYMax_varVal = 10.0;
    public double XBigTicksVon;
    public double YBigTicksVon;
    public double XBigTickDist = 1.0;
    public double YBigTickDist = 0.2;
    public double XSmallTickDist;
    public double YSmallTickDist;
    public int XSmallTicks = 4;
    public int YSmallTicks = 4;
    public boolean autoGitterX = true;
    public boolean autoGitterY = true;
    protected Color rechtsColor;
    protected Color hochColor;
    protected Color anpassColor;
    public String varRechtsStr;
    public String varHochStr;
    public boolean rechtsAnp = true;
    public boolean hochAnp = true;
    public boolean achseSichtbar = true;
    private double XVersch;
    private double YVersch;
    private double XFaktor;
    private double YFaktor;
    public double[][] plotArray = new double[1][2];
    public double[][] wertePlotArray = new double[1][2];
    public boolean fktPlotted;
    public boolean wertePlotted;
    public Node xnode;
    public Node ynode;
    public Node znode;
    public final ArrayList<Node> ynodes = new ArrayList();
    private KSEinstellung ksEinstellung;
    protected Legend legend;
    protected int legendX = 150;
    protected int legendY = 30;
    public int whatToDo = 0;
    int x1 = -1;
    int x2 = -1;
    int y1;
    int y2;
    int xkoScr;
    int ykoScr;
    boolean mouseGedrueckt = false;
    boolean tasteGedrueckt = false;
    int sliderdelta = 1;

    public Koordinatensystem() {
    }

    public Koordinatensystem(Diagram d) {
        this(d, 1);
    }

    public Koordinatensystem(Diagram d, int i) {
        this.diagramm = d;
        this.number = i;
        this.document = this.diagramm.getProjekt();
        this.anzeige = this.document.getViewer();
        this.ksEinstellung = new KSEinstellung(this, this.document);
        this.XBigTickDist = 0.2;
        this.YBigTickDist = 0.2;
        this.XSmallTicks = 1;
        this.YSmallTicks = 1;
        this.autoGitterX = true;
        this.autoGitterY = true;
        this.varRechtsStr = "#";
        this.varHochStr = "#";
        this.rechtsAnp = true;
        this.hochAnp = true;
        this.achseSichtbar = true;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Koordinatensystem.this.panelResized();
            }
        });
        this.setLayout(new AbsoluteLayout());
        this.setOpaque(false);
        this.addMouseListener(this.me);
        this.addMouseMotionListener(this.me);
        this.addMouseWheelListener(this.me);
        this.addKeyListener(this.me);
        this.createPopup();
        this.legend = new Legend(this.document);
    }

    private void createPopup() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Koordinatensystem.this.handlePopupMenu(e);
            }
        };
        JMenuItem mit = new JMenuItem(this.rbundle.getString("Alle_Werte_kopieren"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Auswahl_kopieren"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(new JSeparator());
        mit = new JMenuItem(this.rbundle.getString("Auswahl_aufheben"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Nur_Auswahl_zeichnen"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Als_neue_Startwerte_\u00fcbernehmen"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(new JSeparator());
        JMenu untermenu = new JMenu(this.rbundle.getString("automatische_Achsen"));
        mit = new JCheckBoxMenuItem(this.rbundle.getString("beide_Achsen"));
        mit.addActionListener(al);
        mit.setSelected(true);
        untermenu.add(mit);
        mit = new JCheckBoxMenuItem(this.rbundle.getString("nur_Rechtsachse"));
        mit.addActionListener(al);
        untermenu.add(mit);
        mit = new JCheckBoxMenuItem(this.rbundle.getString("nur_Hochachse"));
        mit.addActionListener(al);
        untermenu.add(mit);
        mit = new JCheckBoxMenuItem(this.rbundle.getString("ausgeschaltet"));
        mit.addActionListener(al);
        untermenu.add(mit);
        this.popup.add(untermenu);
        mit = new JMenuItem(this.rbundle.getString("Hoch-_an_Rechtsachse_anpassen"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Rechts-_an_Hochachse_anpassen"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JCheckBoxMenuItem(this.rbundle.getString("Achsen_immer_sichtbar"));
        mit.setSelected(true);
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(new JSeparator());
        mit = new JMenuItem(this.rbundle.getString("Achsen_einstellen..."));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                for (int i = 0; i < Koordinatensystem.this.popup.getComponentCount(); ++i) {
                    Koordinatensystem.this.popup.getComponent(i).setEnabled(false);
                }
                if (Koordinatensystem.this.diagramm.getProjekt().getModel().werteAnzahl > 1) {
                    Koordinatensystem.this.popup.getComponent(0).setEnabled(true);
                }
                if (Koordinatensystem.this.diagramm.getProjekt().getModelTable().tab.getSelectedRowCount() > 0) {
                    Koordinatensystem.this.popup.getComponent(1).setEnabled(true);
                    Koordinatensystem.this.popup.getComponent(3).setEnabled(true);
                    if (Koordinatensystem.this.diagramm.getProjekt().getModelTable().tab.getSelectedRowCount() == 1) {
                        Koordinatensystem.this.popup.getComponent(5).setEnabled(true);
                    }
                    String s = Koordinatensystem.this.rbundle.getString("Alles_zeichnen");
                    if (Koordinatensystem.this.diagramm.plotAll) {
                        s = Koordinatensystem.this.rbundle.getString("Nur_Auswahl_zeichnen");
                    }
                    ((JMenuItem)Koordinatensystem.this.popup.getComponent(4)).setText(s);
                    Koordinatensystem.this.popup.getComponent(4).setEnabled(true);
                } else if (!Koordinatensystem.this.diagramm.plotAll) {
                    Koordinatensystem.this.popup.getComponent(3).setEnabled(true);
                    String s = Koordinatensystem.this.rbundle.getString("Alles_zeichnen");
                    ((JMenuItem)Koordinatensystem.this.popup.getComponent(4)).setText(s);
                    Koordinatensystem.this.popup.getComponent(4).setEnabled(true);
                }
                Koordinatensystem.this.popup.getComponent(7).setEnabled(true);
                JMenu anpMenu = (JMenu)Koordinatensystem.this.popup.getComponent(7);
                for (int i = 0; i < anpMenu.getItemCount(); ++i) {
                    anpMenu.getItem(i).setSelected(false);
                }
                if (Koordinatensystem.this.rechtsAnp && Koordinatensystem.this.hochAnp) {
                    anpMenu.getItem(0).setSelected(true);
                }
                if (Koordinatensystem.this.rechtsAnp && !Koordinatensystem.this.hochAnp) {
                    anpMenu.getItem(1).setSelected(true);
                }
                if (!Koordinatensystem.this.rechtsAnp && Koordinatensystem.this.hochAnp) {
                    anpMenu.getItem(2).setSelected(true);
                }
                if (!Koordinatensystem.this.rechtsAnp && !Koordinatensystem.this.hochAnp) {
                    anpMenu.getItem(3).setSelected(true);
                }
                Koordinatensystem.this.popup.getComponent(8).setEnabled(true);
                Koordinatensystem.this.popup.getComponent(9).setEnabled(true);
                Koordinatensystem.this.popup.getComponent(10).setEnabled(true);
                if (Koordinatensystem.this.achseSichtbar) {
                    ((JCheckBoxMenuItem)Koordinatensystem.this.popup.getComponent(10)).setSelected(true);
                } else {
                    ((JCheckBoxMenuItem)Koordinatensystem.this.popup.getComponent(10)).setSelected(false);
                }
                Koordinatensystem.this.popup.getComponent(12).setEnabled(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
    }

    void handlePopupMenu(ActionEvent e) {
        Object zeile;
        Object text;
        String cmd = e.getActionCommand();
        if (cmd.equals(this.rbundle.getString("Alle_Werte_kopieren"))) {
            text = "";
            for (int i = 0; i < this.diagramm.getProjekt().getModel().werteAnzahl; ++i) {
                zeile = "";
                for (int j = 0; j < this.diagramm.getProjekt().getModel().wertetabelle[0].length; ++j) {
                    zeile = (String)zeile + this.diagramm.getProjekt().getModel().wertetabelle[i][j] + "\t";
                }
                text = (String)text + (String)zeile + "\n";
            }
            Clipboard clip = this.getToolkit().getSystemClipboard();
            StringSelection cont = new StringSelection((String)text);
            clip.setContents(cont, this.me);
        }
        if (cmd.equals(this.rbundle.getString("Auswahl_kopieren"))) {
            text = "";
            int[] rows = this.diagramm.getProjekt().getModelTable().tab.getSelectedRows();
            for (int i = 0; i < this.diagramm.getProjekt().getModel().werteAnzahl; ++i) {
                if (!this.isInArray(i, rows)) continue;
                zeile = "";
                for (int j = 0; j < this.diagramm.getProjekt().getModel().wertetabelle[0].length; ++j) {
                    zeile = (String)zeile + this.diagramm.getProjekt().getModel().wertetabelle[i][j] + "\t";
                }
                text = (String)text + (String)zeile + "\n";
            }
            Clipboard clip = this.getToolkit().getSystemClipboard();
            StringSelection cont = new StringSelection((String)text);
            clip.setContents(cont, this.me);
        }
        if (cmd.equals(this.rbundle.getString("Auswahl_aufheben"))) {
            this.diagramm.getProjekt().getModelTable().tab.removeRowSelectionInterval(0, this.diagramm.getProjekt().getModelTable().tab.getRowCount() - 1);
            this.diagramm.plotAll = true;
            this.diagramm.updateDiagramPlus();
        }
        if (cmd.equals(this.rbundle.getString("Nur_Auswahl_zeichnen"))) {
            this.diagramm.plotAll = false;
            this.diagramm.updateDiagramPlus();
        }
        if (cmd.equals(this.rbundle.getString("Alles_zeichnen"))) {
            this.diagramm.plotAll = true;
            this.diagramm.updateDiagramPlus();
        }
        if (cmd.equals(this.rbundle.getString("Als_neue_Startwerte_\u00fcbernehmen"))) {
            this.document.getModel().startwerteSetzenAusSelektion(this.document.getModelTable().tab.getSelectedRow());
            this.document.getModelTable().tab.removeRowSelectionInterval(0, this.document.getModelTable().tab.getRowCount() - 1);
            this.diagramm.updateDiagramPlus();
        }
        if (cmd.equals(this.rbundle.getString("beide_Achsen"))) {
            this.rechtsAnp = true;
            this.hochAnp = true;
            this.adjustPlotRange();
        }
        if (cmd.equals(this.rbundle.getString("nur_Rechtsachse"))) {
            this.rechtsAnp = true;
            this.hochAnp = false;
            this.adjustPlotRange();
        }
        if (cmd.equals(this.rbundle.getString("nur_Hochachse"))) {
            this.rechtsAnp = false;
            this.hochAnp = true;
            this.adjustPlotRange();
        }
        if (cmd.equals(this.rbundle.getString("ausgeschaltet"))) {
            this.rechtsAnp = false;
            this.hochAnp = false;
            this.adjustPlotRange();
        }
        if (cmd.equals(this.rbundle.getString("Hoch-_an_Rechtsachse_anpassen"))) {
            this.hochAnRechtsAnp();
        }
        if (cmd.equals(this.rbundle.getString("Rechts-_an_Hochachse_anpassen"))) {
            this.rechtsAnHochAnp();
        }
        if (cmd.equals(this.rbundle.getString("Achsen_immer_sichtbar"))) {
            this.achseSichtbar = !this.achseSichtbar;
            this.diagramm.updateDiagramPlus();
        }
        if (cmd.equals(this.rbundle.getString("Achsen_einstellen..."))) {
            this.ksEinstellung.activate(this.xkoScr, this.ykoScr + 100);
        }
    }

    public int getNumber() {
        return this.number;
    }

    public Font getBeschrFont() {
        return Statics.fonts[this.document.fontNumber].deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * this.getScale());
    }

    public BufferedImage getImage() {
        return this.ks_image;
    }

    public float getScale() {
        return (float)this.sf;
    }

    public Object clone() {
        try {
            Koordinatensystem ksneu = (Koordinatensystem)super.clone();
            return ksneu;
        }
        catch (CloneNotSupportedException e) {
            Statics.println(e.toString());
            return null;
        }
    }

    public boolean parseAchsen(XJep parser) {
        if (parser == null) {
            return false;
        }
        try {
            this.xnode = parser.parse(GreekLetterConstPanel.refactorStr(this.varRechtsStr));
            parser.preprocess(this.xnode);
        }
        catch (Error | Exception e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Rechtsachse!"), Statics.translateErrMsg(e.getMessage()), null, false);
            e.printStackTrace();
            return false;
        }
        String[] vHochStr = this.varHochStr.split(";");
        this.ynodes.clear();
        for (String vhs : vHochStr) {
            try {
                this.ynodes.add(parser.parse(GreekLetterConstPanel.refactorStr(vhs)));
                parser.preprocess(this.ynodes.get(this.ynodes.size() - 1));
            }
            catch (Error | Exception e) {
                this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Hochachse!"), Statics.translateErrMsg(e.getMessage()), null, false);
                return false;
            }
        }
        return true;
    }

    public void adjustPlotRange() {
        Statics.print("Adjust Plot Rage ...");
        this.findKSRange();
        if (this.document.getViewer().getCalcLengthSliderValue() < 100) {
            this.zeichneTeils(0, this.document.getViewer().getCalcLengthSliderValue(), true);
        } else {
            this.zeichneAlles();
        }
        this.document.setChanged(true);
        Statics.println("done.");
    }

    public void generateAllPlotArrays() {
        if (this.diagramm.getProjekt().getModel() == null) {
            return;
        }
        Statics.println("now updating KS(" + this.varHochStr + "/" + this.varRechtsStr + ")");
        this.checkAuftragungsStrings();
        this.parseAchsen(this.diagramm.getProjekt().getModel().parser);
        this.diagramm.getProjekt().getModel().generierePlotArray(this);
        if (this.diagramm.getProjekt().getExtras() != null) {
            this.diagramm.getProjekt().getExtras().createWertePlotArray(this);
        }
        this.findKSRange();
        Statics.println("KS updated");
    }

    public void generateWertePlotArrays() {
        if (this.diagramm.getProjekt().getModel() == null) {
            return;
        }
        this.parseAchsen(this.diagramm.getProjekt().getModel().parser);
        if (this.diagramm.getProjekt().getExtras() != null) {
            this.diagramm.getProjekt().getExtras().createWertePlotArray(this);
        }
        this.findKSRange();
    }

    public void zeichneAllesInImage(BufferedImage img) {
        Graphics g = img.getGraphics();
        this.zeichneAllesInGraphics(g, img);
    }

    public void zeichneAllesInGraphics(Graphics g, BufferedImage img) {
        if (img == null) {
            img = this.ks_image;
        }
        this.calcValuesForPainting(img);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        this.zeichneKS(g, img.getWidth(), img.getHeight());
        this.diagramm.getProjekt().getModel().zeichne(this, g, 0, 100, false);
        this.diagramm.getProjekt().getExtras().zeichneAlles(this, g);
    }

    public void zeichneAlles() {
        if (this.ks_image == null) {
            return;
        }
        this.document.getViewer().setCalcLengthSlider(100, false);
        this.zeichneAllesInImage(this.ks_image);
        this.repaint();
        Statics.println("KS & Extras gezeichnet");
    }

    public void zeichneTeils(int von, int bis, boolean fromSlider) {
        if (this.ks_image == null) {
            return;
        }
        Graphics g = this.ks_image.getGraphics();
        this.calcValuesForPainting(this.ks_image);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.ks_image.getWidth(), this.ks_image.getHeight());
        this.zeichneKS(g, this.ks_image.getWidth(), this.ks_image.getHeight());
        this.diagramm.getProjekt().getModel().zeichne(this, g, von, bis, fromSlider);
        if (bis == 100) {
            this.diagramm.getProjekt().getExtras().zeichneAlles(this, g);
        }
        this.repaint();
        Statics.println("KS & Extras gezeichnet");
    }

    public void zeichneTeilsForSlomo(int von, int bis) {
        if (this.ks_image == null) {
            return;
        }
        Graphics g = this.ks_image.getGraphics();
        if (bis == von) {
            this.calcValuesForPainting(this.ks_image);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.ks_image.getWidth(), this.ks_image.getHeight());
            this.zeichneKS(g, this.ks_image.getWidth(), this.ks_image.getHeight());
        }
        this.diagramm.getProjekt().getModel().zeichne(this, g, von, bis, false);
        this.repaint();
        Statics.println("KS & Extras gezeichnet");
    }

    public void panelResized() {
        Statics.println("KS panel resized (" + this.getWidth() + "/" + this.getHeight() + ")");
        Statics.print("Creating KS image...");
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.sf = GUIDevice.getDisplayScalingFactor(this);
            this.ks_image = new BufferedImage((int)((double)this.getWidth() * this.sf), (int)((double)this.getHeight() * this.sf), 1);
        }
        Statics.println("done.");
        if (this.document.getViewer().getCalcLengthSliderValue() < 100) {
            this.zeichneTeils(0, this.document.getViewer().getCalcLengthSliderValue(), true);
        } else {
            this.zeichneAlles();
        }
    }

    public double getPlotValueX(int i) {
        return this.plotArray[i][0];
    }

    public double getPlotValueY(int i, int achsennummer) {
        return this.plotArray[i][1 + achsennummer];
    }

    public void hochAnRechtsAnp() {
        this.YBigTickDist = this.XBigTickDist;
        this.YSmallTicks = this.XSmallTicks;
        Point merkeUrsprung = this.XyToScreen(0.0, 0.0);
        double fakneu = -this.XFaktor;
        this.YMax = (double)(-merkeUrsprung.y) * fakneu;
        this.YMin = this.YMax + fakneu * (double)this.ks_image.getHeight();
        this.rechtsAnp = false;
        this.hochAnp = false;
        this.adjustPlotRange();
    }

    public void rechtsAnHochAnp() {
        this.XBigTickDist = this.YBigTickDist;
        this.XSmallTicks = this.YSmallTicks;
        Point merkeUrsprung = this.XyToScreen(0.0, 0.0);
        double fakneu = -this.YFaktor;
        this.XMin = (double)(-merkeUrsprung.x) * fakneu;
        this.XMax = fakneu * (double)this.ks_image.getWidth() + this.XMin;
        this.rechtsAnp = false;
        this.hochAnp = false;
        this.adjustPlotRange();
    }

    public final void setAuftragungsStringsOhneUpdate(String r, String h) {
        if (r != null) {
            this.varRechtsStr = r;
            this.document.defaultAuftrStrR[this.getNumber() - 1] = r;
        }
        if (h != null) {
            this.varHochStr = h;
            this.document.defaultAuftrStrH[this.getNumber() - 1] = h;
        }
    }

    public void setAuftragungsStringsMitZeichnen(String r, String h) {
        this.setAuftragungsStringsOhneUpdate(r, h);
        this.generateAllPlotArrays();
        this.zeichneAlles();
        this.document.setChanged(true);
    }

    public void checkAuftragungsStrings() {
        if (this.varRechtsStr.isEmpty() || this.varRechtsStr.contains("#")) {
            this.varRechtsStr = this.document.defaultAuftrStrR[this.getNumber() - 1];
        }
        if (this.varHochStr.isEmpty() || this.varHochStr.contains("#")) {
            this.varHochStr = this.document.defaultAuftrStrH[this.getNumber() - 1];
        }
        try {
            if (this.varRechtsStr.isEmpty() || this.varRechtsStr.contains("#")) {
                this.setAuftragungsStringsOhneUpdate(this.document.getModel().getVarName(0), null);
            }
            if (this.varHochStr.isEmpty() || this.varHochStr.contains("#")) {
                this.setAuftragungsStringsOhneUpdate(null, this.document.getModel().getVarName(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInArray(int val, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (val != arr[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics g) {
        Statics.print("paint KS...");
        Graphics2D g2d = (Graphics2D)g;
        if (this.ks_image == null) {
            return;
        }
        g2d.scale(1.0 / this.sf, 1.0 / this.sf);
        g.drawImage(this.ks_image, 0, 0, this);
        g2d.scale(this.sf, this.sf);
        g2d.setStroke(new BasicStroke(1.5f));
        if ((this.whatToDo == 8 || this.whatToDo == 7) && this.mouseGedrueckt && this.x2 != -1) {
            int h;
            int y;
            int w;
            int x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            g.drawRect(x, y, w, h);
        }
        g.setColor(Statics.transpBGColorDark);
        g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        if (this.document.showLegend) {
            g.translate(this.legendX, this.legendY);
            this.legend.setKS(this);
            this.legend.paint(g);
            g.translate(-this.legendY, -this.legendY);
        }
        Statics.println("done.");
    }

    public void calcFakVersch(BufferedImage image) {
        try {
            this.XFaktor = (this.XMax - this.XMin) / (double)image.getWidth();
            this.YFaktor = -(this.YMax - this.YMin) / (double)image.getHeight();
            this.XVersch = this.XMin;
            this.YVersch = this.YMax;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Point XyToScreen(double x, double y) {
        Point point = new Point();
        point.x = (int)((x - this.XVersch) / this.XFaktor / (double)this.getScale());
        point.y = (int)((y - this.YVersch) / this.YFaktor / (double)this.getScale());
        if (x == Double.NaN || y == Double.NaN || y == Double.POSITIVE_INFINITY || y == Double.NEGATIVE_INFINITY) {
            point.setLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return point;
    }

    public Point XyToImage(double x, double y) {
        Point point = new Point();
        point.x = (int)((x - this.XVersch) / this.XFaktor);
        point.y = (int)((y - this.YVersch) / this.YFaktor);
        if (x == Double.NaN || y == Double.NaN || y == Double.POSITIVE_INFINITY || y == Double.NEGATIVE_INFINITY) {
            point.setLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return point;
    }

    public double[] ScreenToXy(int xscreen, int yscreen) {
        double[] v = new double[]{(double)((float)xscreen * this.getScale()) * this.XFaktor + this.XVersch, (double)((float)yscreen * this.getScale()) * this.YFaktor + this.YVersch};
        return v;
    }

    private void calcXTickValues(int breite) {
        double delta = this.autoGitterX ? (this.XMax - this.XMin) / this.ermittleEintAnz(breite) : this.XBigTickDist;
        int potenz = this.bestimmePotenz(delta);
        if (this.autoGitterX) {
            if ((delta = (double)this.bestimmeDelta(Math.round(delta / Math.pow(10.0, potenz)))) != 0.0) {
                this.XBigTickDist = delta * Math.pow(10.0, potenz);
            }
        } else {
            delta = Math.round(this.XBigTickDist / Math.pow(10.0, potenz));
        }
        this.XBigTicksVon = Math.ceil(this.XMin / this.XBigTickDist) * this.XBigTickDist;
        if (this.autoGitterX) {
            switch ((int)delta) {
                case 0: 
                case 1: {
                    this.XSmallTicks = 5;
                    break;
                }
                case 6: 
                case 9: {
                    this.XSmallTicks = 3;
                    break;
                }
                case 8: {
                    this.XSmallTicks = 4;
                    break;
                }
                default: {
                    this.XSmallTicks = (int)delta;
                }
            }
        }
        this.XSmallTickDist = this.XBigTickDist / (double)this.XSmallTicks;
    }

    private void calcYTickValues(int hoehe) {
        double delta = this.autoGitterY ? (this.YMax - this.YMin) / this.ermittleEintAnz(hoehe) : this.XBigTickDist;
        int potenz = this.bestimmePotenz(delta);
        if (this.autoGitterY) {
            if ((delta = (double)this.bestimmeDelta(Math.round(delta / Math.pow(10.0, potenz)))) != 0.0) {
                this.YBigTickDist = delta * Math.pow(10.0, potenz);
            }
        } else {
            delta = Math.round(this.YBigTickDist / Math.pow(10.0, potenz));
        }
        this.YBigTicksVon = Math.ceil(this.YMin / this.YBigTickDist) * this.YBigTickDist;
        if (this.autoGitterY) {
            switch ((int)delta) {
                case 0: 
                case 1: {
                    this.YSmallTicks = 5;
                    break;
                }
                case 6: 
                case 9: {
                    this.YSmallTicks = 3;
                    break;
                }
                case 8: {
                    this.YSmallTicks = 4;
                    break;
                }
                default: {
                    this.YSmallTicks = (int)delta;
                }
            }
        }
        this.YSmallTickDist = this.YBigTickDist / (double)this.YSmallTicks;
    }

    public void findKSRange() {
        double max;
        double min;
        if (this.plotArray.length < 2) {
            return;
        }
        if (this.rechtsAnp) {
            min = this.findeXMin();
            max = this.findeXMax();
            if (Double.isInfinite(min) || Double.isInfinite(max)) {
                this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Anpassung_der_Rechtsachse!"), this.rbundle.getString("Eingabe_\u00fcberpr\u00fcfen_oder_Achse_manuell_Anpassen."), null, false);
                return;
            }
            if (Math.abs(min) <= Double.MIN_VALUE && Math.abs(max) <= Double.MIN_VALUE) {
                min = -1.0;
                max = 1.0;
            }
            if (Math.abs(max - min) < Double.MIN_VALUE) {
                if (min < 0.0) {
                    min = 2.0 * min;
                    max = 0.0;
                } else if (min > 0.0) {
                    min = 0.0;
                    max = 2.0 * max;
                }
            }
            this.XMin = min - 0.05 * (max - min);
            this.XMax = max + 0.05 * (max - min);
        }
        if (this.hochAnp) {
            min = this.findeYMin();
            max = this.findeYMax();
            if (Double.isInfinite(min) || Double.isInfinite(max)) {
                this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Anpassung_der_Hochachse!"), this.rbundle.getString("Eingabe_\u00fcberpr\u00fcfen_oder_Achse_manuell_Anpassen."), null, false);
                return;
            }
            if (Math.abs(min) <= Double.MIN_VALUE && Math.abs(max) <= Double.MIN_VALUE) {
                min = -1.0;
                max = 1.0;
            }
            if (Math.abs(max - min) < Double.MIN_VALUE) {
                if (min < 0.0) {
                    min = 2.0 * min;
                    max = 0.0;
                } else if (min > 0.0) {
                    min = 0.0;
                    max = 2.0 * max;
                }
            }
            this.YMin = min - 0.05 * (max - min);
            this.YMax = max + 0.05 * (max - min);
        }
        if (this.XMin >= this.XMax) {
            this.XMax = this.XMin + Math.abs(this.XMin);
        }
        if (this.YMin >= this.YMax) {
            this.YMax = this.YMin + Math.abs(this.YMin);
        }
    }

    public void calcValuesForPainting(BufferedImage img) {
        double minabstand;
        this.calcFakVersch(img);
        this.calcXTickValues(img.getWidth());
        this.calcYTickValues(img.getHeight());
        DecimalFormat df = new DecimalFormat("#.##");
        if (this.XBigTickDist > 900.0 || this.XBigTickDist < 0.01) {
            df = new DecimalFormat("0.0##E0");
        }
        int maxbeschrbreite = 0;
        Graphics g = img.getGraphics();
        g.setFont(this.getBeschrFont());
        for (double xxx = this.YBigTicksVon; xxx <= this.YMax; xxx += this.YBigTickDist) {
            int sbreite = (int)((float)(g.getFontMetrics().stringWidth(df.format(xxx)) + 10) / this.getScale());
            if (sbreite <= maxbeschrbreite) continue;
            maxbeschrbreite = sbreite;
        }
        double[] nullpunkt = this.ScreenToXy(0, 0);
        double[] zeichenplatz = this.ScreenToXy(maxbeschrbreite + 10, (int)((float)g.getFontMetrics().getHeight() / this.getScale()) + 10);
        double[] rechtsoben = this.ScreenToXy(5, 5);
        this.anpassColor = !this.document.achsenFaerben ? Color.BLACK : new Color(180, 80, 120);
        if (this.rechtsAnp) {
            minabstand = Math.abs(nullpunkt[0] - zeichenplatz[0]);
            if (this.XMin < 0.0 && this.XMin > -minabstand) {
                this.XMin = -minabstand;
            }
            minabstand = Math.abs(nullpunkt[0] - rechtsoben[0]);
            if (this.XMax > 0.0 && this.XMax < minabstand) {
                this.XMax = minabstand;
            }
            this.rechtsColor = this.anpassColor;
        } else {
            this.rechtsColor = Color.BLACK;
        }
        if (this.hochAnp) {
            minabstand = Math.abs(nullpunkt[1] - zeichenplatz[1]);
            if (this.YMin < 0.0 && this.YMin > -minabstand) {
                this.YMin = -minabstand;
            }
            minabstand = Math.abs(nullpunkt[1] - rechtsoben[1]);
            if (this.YMax > 0.0 && this.YMax < minabstand) {
                this.YMax = minabstand;
            }
            this.hochColor = this.anpassColor;
        } else {
            this.hochColor = Color.black;
        }
        this.calcFakVersch(img);
    }

    public void zeichneKS(Graphics g, int breite, int hoehe) {
        double yyy;
        int sbreite;
        String s;
        Point point;
        double xxx;
        double yyy2;
        Point point2;
        Point point1;
        double xxx2;
        float gscale = Statics.prefsDialog.graphicsScale * this.getScale();
        Statics.print("zeicheKS2D...");
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setStroke(new BasicStroke(gscale * (Statics.prefsDialog.graphicsScale == 1.0f ? 0.9f : 0.8f)));
        if (this.document.showSmallGrid) {
            g.setColor(Color.LIGHT_GRAY);
            for (xxx2 = this.XBigTicksVon; xxx2 > this.XMin; xxx2 -= this.XSmallTickDist) {
                point1 = this.XyToImage(xxx2, this.YMin);
                point2 = this.XyToImage(xxx2, this.YMax);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
            for (xxx2 = this.XBigTicksVon; xxx2 < this.XMax; xxx2 += this.XSmallTickDist) {
                point1 = this.XyToImage(xxx2, this.YMin);
                point2 = this.XyToImage(xxx2, this.YMax);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
            for (yyy2 = this.YBigTicksVon; yyy2 > this.YMin; yyy2 -= this.YSmallTickDist) {
                point1 = this.XyToImage(this.XMin, yyy2);
                point2 = this.XyToImage(this.XMax, yyy2);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
            for (yyy2 = this.YBigTicksVon; yyy2 < this.YMax; yyy2 += this.YSmallTickDist) {
                point1 = this.XyToImage(this.XMin, yyy2);
                point2 = this.XyToImage(this.XMax, yyy2);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
        }
        if (this.document.showMainGrid) {
            g.setColor(Color.GRAY);
            for (xxx2 = this.XBigTicksVon; xxx2 > this.XMin; xxx2 -= this.XBigTickDist) {
                point1 = this.XyToImage(xxx2, this.YMin);
                point2 = this.XyToImage(xxx2, this.YMax);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
            for (xxx2 = this.XBigTicksVon; xxx2 < this.XMax; xxx2 += this.XBigTickDist) {
                point1 = this.XyToImage(xxx2, this.YMin);
                point2 = this.XyToImage(xxx2, this.YMax);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
            for (yyy2 = this.YBigTicksVon; yyy2 > this.YMin; yyy2 -= this.YBigTickDist) {
                point1 = this.XyToImage(this.XMin, yyy2);
                point2 = this.XyToImage(this.XMax, yyy2);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
            for (yyy2 = this.YBigTicksVon; yyy2 < this.YMax; yyy2 += this.YBigTickDist) {
                point1 = this.XyToImage(this.XMin, yyy2);
                point2 = this.XyToImage(this.XMax, yyy2);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
            }
        }
        ((Graphics2D)g).setStroke(new BasicStroke(gscale * (Statics.prefsDialog.graphicsScale == 1.0f ? 1.5f : 1.2f)));
        g.setColor(this.rechtsColor);
        point1 = this.XyToImage(this.XMin, 0.0);
        point2 = this.XyToImage(this.XMax, 0.0);
        g.drawLine(point1.x, point1.y, point2.x, point2.y);
        g.drawLine(point2.x - (int)(9.0f * gscale), point2.y - (int)(5.0f * gscale), point2.x - (int)gscale, point2.y);
        g.drawLine(point2.x - (int)(9.0f * gscale), point2.y + (int)(5.0f * gscale), point2.x - (int)gscale, point2.y);
        g.setColor(this.hochColor);
        point1 = this.XyToImage(0.0, this.YMin);
        point2 = this.XyToImage(0.0, this.YMax);
        g.drawLine(point1.x, point1.y, point2.x, point2.y);
        g.drawLine(point2.x - (int)(5.0f * gscale), point2.y + (int)(9.0f * gscale), point2.x, point2.y);
        g.drawLine(point2.x + (int)(5.0f * gscale), point2.y + (int)(9.0f * gscale), point2.x, point2.y);
        int zwei = (int)(2.0f * gscale);
        int drei = (int)(3.0f * gscale);
        int vier = (int)(4.0f * gscale);
        int fuenf = (int)(5.0f * gscale);
        g.setColor(this.rechtsColor);
        for (xxx = this.XBigTicksVon; xxx > this.XMin; xxx -= this.XSmallTickDist) {
            point = this.XyToImage(xxx, 0.0);
            g.drawLine(point.x, point.y - drei, point.x, point.y + drei);
        }
        for (xxx = this.XBigTicksVon; xxx < this.XMax; xxx += this.XSmallTickDist) {
            point = this.XyToImage(xxx, 0.0);
            g.drawLine(point.x, point.y - drei, point.x, point.y + drei);
        }
        if (this.varRechtsStr.contains("#")) {
            g.setColor(Color.GRAY);
        }
        point = this.XyToImage(this.XMax, 0.0);
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * this.getScale() * 1.2f));
        g.setColor(Color.BLACK);
        g.drawString(this.varRechtsStr, point.x - g.getFontMetrics().stringWidth(this.varRechtsStr) - (int)(12.0f * gscale), point.y - (int)(5.0f * gscale));
        g.setColor(Color.BLACK);
        g.setFont(this.getBeschrFont());
        int fh = (int)((float)g.getFontMetrics().getAscent() * 52.0f / 70.0f);
        DecimalFormat df = this.XBigTickDist > 900.0 || this.XBigTickDist < 0.01 ? new DecimalFormat("0.0##E0") : new DecimalFormat("#.##");
        for (double xxx3 = this.XBigTicksVon; xxx3 < this.XMax; xxx3 += this.XBigTickDist) {
            point = this.XyToImage(xxx3, 0.0);
            g.setColor(this.rechtsColor);
            g.drawLine(point.x, point.y - fuenf, point.x, point.y + vier);
            s = df.format(xxx3);
            sbreite = g.getFontMetrics().stringWidth(s);
            if (xxx3 < 0.0) {
                sbreite += g.getFontMetrics().stringWidth("-");
            }
            if (point.y > hoehe - 20) {
                if (this.document.achsenFaerben) {
                    g.setColor(Color.DARK_GRAY);
                }
                g.drawString(s, point.x - sbreite / zwei, hoehe - drei);
                continue;
            }
            if (point.y < -3) {
                if (this.document.achsenFaerben) {
                    g.setColor(Color.DARK_GRAY);
                }
                g.drawString(s, point.x - sbreite / zwei, (int)(13.0f * gscale));
                continue;
            }
            g.setColor(Color.BLACK);
            g.drawString(s, point.x - sbreite / 2, point.y + fh + (int)(9.0f * gscale));
        }
        g.setColor(this.hochColor);
        for (yyy = this.YBigTicksVon; yyy > this.YMin; yyy -= this.YSmallTickDist) {
            point = this.XyToImage(0.0, yyy);
            g.drawLine(point.x - drei, point.y, point.x + drei, point.y);
        }
        for (yyy = this.YBigTicksVon; yyy < this.YMax; yyy += this.YSmallTickDist) {
            point = this.XyToImage(0.0, yyy);
            g.drawLine(point.x - drei, point.y, point.x + drei, point.y);
        }
        df = this.YBigTickDist > 900.0 || this.YBigTickDist < 0.01 ? new DecimalFormat("0.0##E0") : new DecimalFormat("#.##");
        if (this.varHochStr.contains("#")) {
            g.setColor(Color.GRAY);
        }
        point = this.XyToImage(0.0, this.YMax);
        g.setColor(Color.BLACK);
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * this.getScale() * 1.2f));
        g.drawString(this.varHochStr, point.x + (int)(8.0f * gscale), point.y + g.getFontMetrics().getHeight() + (int)(0.0f * gscale));
        g.setColor(Color.BLACK);
        g.setFont(this.getBeschrFont());
        for (yyy = this.YBigTicksVon; yyy < this.YMax; yyy += this.YBigTickDist) {
            point = this.XyToImage(0.0, yyy);
            g.setColor(this.hochColor);
            g.drawLine(point.x - vier, point.y, point.x + fuenf, point.y);
            s = df.format(yyy);
            sbreite = g.getFontMetrics().stringWidth(s);
            if (point.x < sbreite) {
                if (this.document.achsenFaerben) {
                    g.setColor(Color.DARK_GRAY);
                }
                g.drawString(s, zwei, point.y + fh / 2 + zwei);
                continue;
            }
            if (point.x > breite + drei) {
                if (this.document.achsenFaerben) {
                    g.setColor(Color.DARK_GRAY);
                }
                g.drawString(s, breite - sbreite - drei, point.y + fh / 2 + zwei);
                continue;
            }
            g.setColor(Color.BLACK);
            if (s.equals("0") || s.equals("-0")) continue;
            g.drawString(s, point.x - sbreite - fuenf, point.y + fh / 2 + zwei);
        }
        Statics.println("done");
    }

    public void activate() {
        this.requestFocus();
        this.diagramm.aktKS = this;
        this.diagramm.repaint();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private boolean isOnRechtsAuftr(Point point) {
        Rectangle rect = new Rectangle();
        Point textOrigin = this.XyToScreen(this.XMax, 0.0);
        Graphics g = this.getGraphics();
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * 1.2f));
        rect.x = textOrigin.x - g.getFontMetrics().stringWidth(this.varRechtsStr) - 12 - 2;
        rect.y = textOrigin.y - 5 - g.getFontMetrics().getAscent();
        rect.width = (int)g.getFontMetrics().getStringBounds(this.varRechtsStr, g).getWidth() + 4;
        rect.height = g.getFontMetrics().getHeight();
        return rect.contains(point);
    }

    private boolean isOnHochAuftr(Point point) {
        Rectangle rect = new Rectangle();
        Point textOrigin = this.XyToScreen(0.0, this.YMax);
        Graphics g = this.getGraphics();
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * 1.2f));
        rect.x = textOrigin.x + 8 - 2;
        rect.y = textOrigin.y + g.getFontMetrics().getDescent();
        rect.width = (int)g.getFontMetrics().getStringBounds(this.varHochStr, g).getWidth() + 4;
        rect.height = g.getFontMetrics().getHeight();
        return rect.contains(point);
    }

    private boolean isOnXAxis(Point point) {
        Point nullpkt = this.XyToScreen(0.0, 0.0);
        return (double)Math.abs(point.y - nullpkt.y) < 3.0 * this.sf;
    }

    private boolean isOnYAxis(Point point) {
        Point nullpkt = this.XyToScreen(0.0, 0.0);
        return (double)Math.abs(point.x - nullpkt.x) < 3.0 * this.sf;
    }

    private boolean isOnModelGraph(Point point) {
        for (int achsnr = 0; achsnr < this.ynodes.size(); ++achsnr) {
            for (int i = 1; i < this.plotArray.length; ++i) {
                Point start = this.XyToScreen(this.getPlotValueX(i - 1), this.getPlotValueY(i - 1, achsnr));
                Point end = this.XyToScreen(this.getPlotValueX(i), this.getPlotValueY(i, achsnr));
                if (!(Line2D.ptSegDist(start.x, start.y, end.x, end.y, point.x, point.y) < 4.0 * this.sf)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOnWerteGraph(Point point) {
        for (double[] wertePlotValue : this.wertePlotArray) {
            for (int jj = 0; jj < this.ynodes.size(); ++jj) {
                Point modelPoint1 = this.XyToScreen(wertePlotValue[0], wertePlotValue[1 + jj]);
                if (!(modelPoint1.distance(point.x, point.y) < 4.0 * this.sf)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOnLegend(Point point) {
        return point.x > this.legendX && (float)point.x < (float)this.legendX + (float)this.legend.getWidth() * Statics.prefsDialog.graphicsScale && point.y > this.legendY && (float)point.y < (float)this.legendY + (float)this.legend.getHeight() * Statics.prefsDialog.graphicsScale;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.tasteGedrueckt) {
            return;
        }
        if (this.document.showLegend && this.isOnLegend(e.getPoint())) {
            this.setCursor(new Cursor(12));
            return;
        }
        if (this.isOnRechtsAuftr(e.getPoint()) || this.isOnHochAuftr(e.getPoint())) {
            this.setCursor(new Cursor(12));
            return;
        }
        if (this.isOnXAxis(e.getPoint()) && this.isOnYAxis(e.getPoint())) {
            if (Statics.os.contains("Mac")) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(13));
            }
            this.whatToDo = 4;
            return;
        }
        if (this.isOnXAxis(e.getPoint())) {
            if (this.document.achsenDehnen) {
                this.setCursor(new Cursor(12));
                this.whatToDo = 5;
            }
            return;
        }
        if (this.isOnYAxis(e.getPoint())) {
            if (this.document.achsenDehnen) {
                this.setCursor(new Cursor(12));
                this.whatToDo = 6;
            }
            return;
        }
        if (this.isOnModelGraph(e.getPoint())) {
            this.setCursor(new Cursor(12));
            return;
        }
        if (this.document.getExtras().isOnFktGraph(e.getPoint(), this.sf)) {
            this.setCursor(new Cursor(12));
            return;
        }
        if (this.isOnWerteGraph(e.getPoint())) {
            this.setCursor(new Cursor(12));
            return;
        }
        this.setCursor(new Cursor(0));
        this.whatToDo = 0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.whatToDo == 0 || !this.mouseGedrueckt) {
            return;
        }
        if (this.whatToDo == 20) {
            // empty if block
        }
        if (Math.abs(e.getX() - this.x2) > 5 || Math.abs(e.getY() - this.y2) > 5) {
            switch (this.whatToDo) {
                case 20: {
                    this.x2 = e.getPoint().x;
                    this.y2 = e.getPoint().y;
                    if (this.legendX + this.x2 - this.x1 > 0 && (float)(this.legendX + this.x2 - this.x1) < (float)this.getWidth() - (float)this.legend.getWidth() * Statics.prefsDialog.graphicsScale) {
                        this.legendX = this.legendX + this.x2 - this.x1;
                        this.x1 = this.x2;
                    }
                    if (this.legendY + this.y2 - this.y1 > 0 && (float)(this.legendY + this.y2 - this.y1) < (float)this.getHeight() - (float)this.legend.getHeight() * Statics.prefsDialog.graphicsScale) {
                        this.legendY = this.legendY + this.y2 - this.y1;
                        this.y1 = this.y2;
                    }
                    this.repaint();
                    break;
                }
                case 4: {
                    if (this.x2 > 0 && this.x2 < this.getWidth() && this.y2 > 0 && this.y2 < this.getHeight()) {
                        this.x2 = e.getX();
                        this.y2 = e.getY();
                        double[] ko1 = this.ScreenToXy(this.x1, this.y1);
                        double[] ko2 = this.ScreenToXy(this.x2, this.y2);
                        this.XMin -= ko2[0] - ko1[0];
                        this.XMax -= ko2[0] - ko1[0];
                        this.YMin -= ko2[1] - ko1[1];
                        this.YMax -= ko2[1] - ko1[1];
                        this.rechtsAnp = false;
                        this.hochAnp = false;
                        this.adjustPlotRange();
                    }
                    this.x1 = this.x2 = e.getX();
                    this.y1 = this.y2 = e.getY();
                    break;
                }
                case 5: {
                    if (this.x2 > 0 && this.x2 < this.getWidth()) {
                        double xf;
                        this.x2 = e.getX();
                        this.y2 = e.getY();
                        double[] ko1 = this.ScreenToXy(this.x1, this.y1);
                        if (ko1[0] < 0.0) {
                            xf = (this.XMax - ko1[0]) / (double)(this.getWidth() - this.x2);
                            this.XMin = this.XMax - xf * (double)this.getWidth();
                        }
                        if (ko1[0] >= 0.0) {
                            xf = (ko1[0] - this.XMin) / (double)this.x2;
                            this.XMax = this.XMin + xf * (double)this.getWidth();
                        }
                        this.rechtsAnp = false;
                        this.adjustPlotRange();
                    }
                    this.x1 = this.x2 = e.getX();
                    this.y1 = this.y2 = e.getY();
                    break;
                }
                case 6: {
                    if (this.y2 > 0 && this.y2 < this.getHeight()) {
                        double yf;
                        this.x2 = e.getX();
                        this.y2 = e.getY();
                        double[] ko1 = this.ScreenToXy(this.x1, this.y1);
                        if (ko1[1] < 0.0) {
                            yf = (this.YMax - ko1[1]) / (double)this.y2;
                            this.YMin = this.YMax - yf * (double)this.getHeight();
                        }
                        if (ko1[1] >= 0.0) {
                            yf = (ko1[1] - this.YMin) / (double)(this.getHeight() - this.y2);
                            this.YMax = this.YMin + yf * (double)this.getHeight();
                        }
                        this.hochAnp = false;
                        this.adjustPlotRange();
                    }
                    this.x1 = this.x2 = e.getX();
                    this.y1 = this.y2 = e.getY();
                    break;
                }
                case 7: {
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    this.repaint();
                    break;
                }
                case 8: {
                    double hh;
                    double[] vect2;
                    Tabelle table = this.document.getViewer().getAktTable();
                    if (table == null || table instanceof VergleichsTabelle) {
                        table = this.document.getModelTable();
                    }
                    if (this.whatToDo != 8 || table.tab.getRowCount() <= 1) break;
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    double[] vect1 = this.ScreenToXy(this.x1, this.y1);
                    if (vect1[0] > (vect2 = this.ScreenToXy(this.x2, this.y2))[0]) {
                        hh = vect1[0];
                        vect1[0] = vect2[0];
                        vect2[0] = hh;
                    }
                    if (vect1[1] > vect2[1]) {
                        hh = vect1[1];
                        vect1[1] = vect2[1];
                        vect2[1] = hh;
                    }
                    table.disallowUpdateView();
                    table.tab.removeRowSelectionInterval(0, table.tab.getRowCount() - 1);
                    for (int i = 0; i < this.plotArray.length; ++i) {
                        if (!(this.plotArray[i][0] > vect1[0]) || !(this.plotArray[i][0] < vect2[0]) || !(this.plotArray[i][1] > vect1[1]) || !(this.plotArray[i][1] < vect2[1])) continue;
                        table.tab.changeSelection(i, 0, true, false);
                    }
                    table.allowUpdateView();
                    table.updateView();
                    this.zeichneAlles();
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point pkt = e.getPoint();
        this.whatToDo = 0;
        if (e.getClickCount() == 2) {
            if (this.document.showLegend && this.isOnLegend(pkt)) {
                this.legend.setKS(this);
                pkt.translate(-this.legendX, -this.legendY);
                if (this.legend.isOnModel(pkt)) {
                    this.diagramm.overlayState = 1;
                    this.diagramm.setOverlayValues(this.diagramm.overlayState);
                    this.repaint();
                    return;
                }
                if (this.legend.isOnFkt(pkt)) {
                    this.diagramm.overlayState = 5;
                    this.diagramm.setOverlayValues(this.diagramm.overlayState);
                    this.repaint();
                    return;
                }
                if (this.legend.isOnWerte(pkt)) {
                    this.diagramm.overlayState = 8;
                    this.diagramm.setOverlayValues(this.diagramm.overlayState);
                    this.repaint();
                    return;
                }
            }
            if (this.isOnXAxis(pkt)) {
                this.ksEinstellung.activate(e.getXOnScreen(), e.getYOnScreen());
                return;
            }
            if (this.isOnYAxis(pkt)) {
                this.whatToDo = 6;
                this.ksEinstellung.activate(e.getXOnScreen(), e.getYOnScreen());
                this.whatToDo = 0;
                return;
            }
            if (this.isOnModelGraph(pkt)) {
                this.diagramm.showOverlay(1);
                this.diagramm.repaint();
                return;
            }
            if (this.document.getExtras().isOnFktGraph(pkt, this.sf)) {
                this.diagramm.showOverlay(5);
                this.diagramm.repaint();
                return;
            }
            if (this.wertePlotted && this.isOnWerteGraph(e.getPoint())) {
                this.diagramm.showOverlay(8);
                this.diagramm.repaint();
                return;
            }
            this.rechtsAnp = true;
            this.hochAnp = true;
            this.autoGitterY = true;
            this.autoGitterX = true;
            this.adjustPlotRange();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.x1 = e.getX();
        this.y1 = e.getY();
        this.x2 = -1;
        this.y2 = -1;
        this.mouseGedrueckt = true;
        if (this.diagramm.aktKS != this) {
            this.activate();
        }
        if (this.document.showLegend && this.isOnLegend(e.getPoint())) {
            this.whatToDo = 20;
            return;
        }
        if (this.isOnRechtsAuftr(e.getPoint())) {
            AuftragungsPopupMenu auftrPopup = new AuftragungsPopupMenu(this.document.getModel(), evt -> {
                if (evt.getActionCommand().equals("Weitere Einstellungen")) {
                    this.ksEinstellung.activate(e.getXOnScreen() + 150, e.getYOnScreen() + 150);
                } else {
                    this.setAuftragungsStringsMitZeichnen(evt.getActionCommand(), this.varHochStr);
                }
            }, false, null, null, null);
            auftrPopup.show(this, e.getPoint().x, e.getPoint().y);
            return;
        }
        if (this.isOnHochAuftr(e.getPoint())) {
            AuftragungsPopupMenu auftrPopup = new AuftragungsPopupMenu(this.document.getModel(), evt -> {
                if (evt.getActionCommand().equals("Weitere Einstellungen")) {
                    this.whatToDo = 6;
                    this.ksEinstellung.activate(e.getXOnScreen() + 150, e.getYOnScreen() + 150);
                    this.whatToDo = 0;
                } else {
                    this.setAuftragungsStringsMitZeichnen(this.varRechtsStr, evt.getActionCommand());
                }
            }, this.varHochStr.split(";").length < 4, evt -> this.setAuftragungsStringsMitZeichnen(this.varRechtsStr, this.varHochStr + "; " + evt.getActionCommand()), this.varHochStr.split(";"), evt -> {
                String[] ss = this.varHochStr.split(";");
                Object neu = "";
                boolean ausschlussErfolgt = false;
                for (String s : ss) {
                    if (!s.trim().equals(evt.getActionCommand()) || ausschlussErfolgt) {
                        if (!((String)neu).isEmpty()) {
                            neu = (String)neu + "; ";
                        }
                        neu = (String)neu + s.trim();
                        continue;
                    }
                    ausschlussErfolgt = true;
                }
                this.setAuftragungsStringsMitZeichnen(this.varRechtsStr, (String)neu);
            });
            auftrPopup.show(this, e.getPoint().x, e.getPoint().y);
            return;
        }
        if (e.getButton() == 2) {
            this.whatToDo = 4;
        }
        if (e.getButton() == 3) {
            this.popup.show(this, e.getPoint().x, e.getPoint().y);
            return;
        }
        this.diagramm.mousePressed(e);
        if (this.whatToDo == 0) {
            this.whatToDo = 8;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.xkoScr = e.getXOnScreen();
        this.ykoScr = e.getYOnScreen();
        this.mouseGedrueckt = false;
        if (this.whatToDo == 0) {
            return;
        }
        if (this.whatToDo == 7) {
            double[] vect2;
            double[] vect1 = this.ScreenToXy(this.x1, this.y1);
            if (vect1[0] < (vect2 = this.ScreenToXy(this.x2, this.y2))[0]) {
                this.XMin = vect1[0];
                this.XMax = vect2[0];
            } else {
                this.XMin = vect2[0];
                this.XMax = vect1[0];
            }
            if (vect1[1] < vect2[1]) {
                this.YMin = vect1[1];
                this.YMax = vect2[1];
            } else {
                this.YMin = vect2[1];
                this.YMax = vect1[1];
            }
            this.diagramm.redrawDiagram();
        }
        if (this.whatToDo == 8 && this.x1 != e.getX() && this.y1 != e.getY()) {
            this.diagramm.redrawDiagram();
        }
        if (!this.tasteGedrueckt) {
            this.whatToDo = 0;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.document.scrollRad) {
            return;
        }
        boolean skaliereX = true;
        boolean skaliereY = true;
        if (e.getModifiersEx() != 0) {
            int onmask = 64;
            if ((e.getModifiersEx() & onmask) == onmask) {
                this.rechtsAnp = false;
                skaliereX = true;
                skaliereY = false;
            }
            onmask = 512;
            if ((e.getModifiersEx() & onmask) == onmask) {
                this.hochAnp = false;
                skaliereX = false;
                skaliereY = true;
            }
        } else if (this.rechtsAnp && this.hochAnp) {
            this.rechtsAnp = false;
            this.hochAnp = false;
        }
        double[] ko = this.ScreenToXy(e.getX(), e.getY());
        double zoomFaktor = -e.getWheelRotation();
        if (zoomFaktor == 0.0) {
            return;
        }
        double factor = 1.1;
        if (!Statics.os.contains("mac")) {
            factor = 1.2;
        }
        if (Math.abs((zoomFaktor = zoomFaktor < 0.0 ? 1.0 / (factor * Math.pow(-zoomFaktor, 0.1)) : factor * Math.pow(zoomFaktor, 0.1)) - 1.0) > 0.1) {
            if (skaliereX) {
                this.XMin = ko[0] - (double)((float)e.getX() * this.getScale()) * this.XFaktor * zoomFaktor;
                this.XMax = this.XMin + (double)((float)this.getWidth() * this.getScale()) * this.XFaktor * zoomFaktor;
            }
            if (skaliereY) {
                this.YMax = ko[1] - (double)((float)e.getY() * this.getScale()) * this.YFaktor * zoomFaktor;
                this.YMin = this.YMax + (double)((float)this.getHeight() * this.getScale()) * this.YFaktor * zoomFaktor;
            }
            this.adjustPlotRange();
            this.document.setChanged(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.setCursor(new Cursor(12));
            this.whatToDo = 4;
            this.tasteGedrueckt = true;
        }
        if (e.getKeyCode() == 18 || e.getKeyCode() == 65406) {
            this.setCursor(new Cursor(1));
            this.whatToDo = 7;
            this.tasteGedrueckt = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.setCursor(new Cursor(0));
        this.whatToDo = 0;
        this.tasteGedrueckt = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void adjustLegend() {
        if (this.getWidth() == 0) {
            return;
        }
        if (this.legend != null && this.document.showLegend) {
            if ((float)this.legendX + (float)this.legend.getWidth() * Statics.prefsDialog.graphicsScale > (float)this.getWidth()) {
                this.legendX = (int)((float)this.getWidth() - (float)this.legend.getWidth() * Statics.prefsDialog.graphicsScale - 15.0f);
            }
            if ((float)this.legendY + (float)this.legend.getHeight() * Statics.prefsDialog.graphicsScale > (float)this.getHeight()) {
                this.legendY = (int)((float)this.getHeight() - (float)this.legend.getHeight() * Statics.prefsDialog.graphicsScale - 15.0f);
            }
            if (this.legendX < 15) {
                this.legendX = 15;
            }
            if (this.legendY < 15) {
                this.legendY = 15;
            }
        }
    }

    private double ermittleEintAnz(int groesse) {
        double ret = (double)groesse / this.sf / 90.0;
        return ret;
    }

    private int bestimmePotenz(double zahl) {
        int potenz = 0;
        if (zahl < 1.0) {
            do {
                ++potenz;
            } while ((int)(zahl *= 10.0) < 1);
            potenz = -potenz;
        } else {
            do {
                ++potenz;
            } while ((int)(zahl /= 10.0) >= 1);
            --potenz;
        }
        return potenz;
    }

    private int bestimmeDelta(long ersteZiffer) {
        int delta = 0;
        if (ersteZiffer == 1L) {
            delta = 1;
        }
        if (ersteZiffer == 2L || ersteZiffer == 3L) {
            delta = 2;
        }
        if (ersteZiffer == 4L || ersteZiffer == 5L || ersteZiffer == 6L || ersteZiffer == 7L) {
            delta = 5;
        }
        if (ersteZiffer == 8L || ersteZiffer == 9L || ersteZiffer == 10L) {
            delta = 10;
        }
        return delta;
    }

    private double findeXMin() {
        int[] rows = this.diagramm.getProjekt().getModelTable().tab.getSelectedRows();
        int anz = this.plotArray.length;
        if (anz == 0 || this.plotArray[0].length == 0) {
            return 1.0;
        }
        double min = Double.MAX_VALUE;
        min = this.modelXMin;
        if (this.diagramm.getProjekt().getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    double xvalue = wertePlotArray1[0];
                    double yvalue = wertePlotArray1[1];
                    if (!this.hochAnp && (!(yvalue > this.YMin) || !(yvalue < this.YMax)) || !(xvalue < min)) continue;
                    min = xvalue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (min > 0.0 && this.XMax > 0.0 && this.achseSichtbar) {
            min = 0.0;
        }
        return min;
    }

    private double findeXMax() {
        int[] rows = this.diagramm.getProjekt().getModelTable().tab.getSelectedRows();
        int anz = this.plotArray.length;
        if (anz == 0) {
            return 1.0;
        }
        double max = -1.7976931348623157E308;
        max = this.modelXMax;
        if (this.diagramm.getProjekt().getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    double xvalue = wertePlotArray1[0];
                    double yvalue = wertePlotArray1[1];
                    if (!this.hochAnp && (!(yvalue > this.YMin) || !(yvalue < this.YMax)) || !(xvalue > max)) continue;
                    max = xvalue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (max < 0.0 && this.XMin < 0.0 && this.achseSichtbar) {
            max = 0.0;
        }
        return max;
    }

    private double findeYMin() {
        int[] rows = this.diagramm.getProjekt().getModelTable().tab.getSelectedRows();
        int anz = this.plotArray.length;
        if (anz == 0) {
            return -1.0;
        }
        double y = Double.MAX_VALUE;
        double min = Double.MAX_VALUE;
        min = this.modelYMin;
        double yvalue = Double.MAX_VALUE;
        if (this.diagramm.getProjekt().getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    double xvalue = wertePlotArray1[0];
                    if (!this.rechtsAnp && (!(xvalue > this.XMin) || !(xvalue < this.XMax))) continue;
                    for (int j = 1; j < wertePlotArray1.length; ++j) {
                        yvalue = wertePlotArray1[j];
                        if (!(yvalue < min)) continue;
                        min = yvalue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (min > 0.0 && this.YMax > 0.0 && this.achseSichtbar) {
            min = 0.0;
        }
        return min;
    }

    private double findeYMax() {
        int[] rows = this.diagramm.getProjekt().getModelTable().tab.getSelectedRows();
        int anz = this.plotArray.length;
        if (anz == 0) {
            return 1.0;
        }
        double y = -1.7976931348623157E308;
        double max = -1.7976931348623157E308;
        max = this.modelYMax;
        double yvalue = -1.7976931348623157E308;
        if (this.diagramm.getProjekt().getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    double xvalue = wertePlotArray1[0];
                    if (!this.rechtsAnp && (!(xvalue > this.XMin) || !(xvalue < this.XMax))) continue;
                    for (int j = 1; j < wertePlotArray1.length; ++j) {
                        yvalue = wertePlotArray1[j];
                        if (!(yvalue > max)) continue;
                        max = yvalue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (max < 0.0 && this.YMin < 0.0 && this.achseSichtbar) {
            max = 0.0;
        }
        return max;
    }

    public void readData(ObjectInputStream objstr, float datversion, String kennung) throws Exception {
        this.XBigTickDist = objstr.readDouble();
        this.YBigTickDist = objstr.readDouble();
        this.autoGitterX = objstr.readBoolean();
        this.autoGitterY = objstr.readBoolean();
        this.XSmallTicks = objstr.readInt();
        this.YSmallTicks = objstr.readInt();
        if ((double)datversion < 2.5) {
            objstr.readBoolean();
            objstr.readBoolean();
        }
        this.varRechtsStr = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        this.rechtsAnp = objstr.readBoolean();
        this.XMin = objstr.readDouble();
        this.XMax = objstr.readDouble();
        this.varHochStr = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        this.hochAnp = objstr.readBoolean();
        this.YMin = objstr.readDouble();
        this.YMax = objstr.readDouble();
        this.achseSichtbar = objstr.readBoolean();
        this.setAuftragungsStringsOhneUpdate(this.varRechtsStr, this.varHochStr);
        if ((double)datversion > 2.3) {
            this.legendX = objstr.readInt();
            this.legendY = objstr.readInt();
        }
    }

    public void readDataV12(ObjectInputStream objstr) throws Exception {
        double xbig = objstr.readDouble();
        double ybig = objstr.readDouble();
        boolean agx = objstr.readBoolean();
        boolean agy = objstr.readBoolean();
        boolean smg = objstr.readBoolean();
        int xsmt = objstr.readInt();
        int ysmt = objstr.readInt();
        boolean afx = objstr.readBoolean();
        boolean afy = objstr.readBoolean();
        boolean ssmg = objstr.readBoolean();
        boolean achsf = objstr.readBoolean();
        boolean sr = objstr.readBoolean();
        boolean ad = objstr.readBoolean();
        String vr = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        boolean ra = objstr.readBoolean();
        double xmi = objstr.readDouble();
        double xma = objstr.readDouble();
        String vh = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        boolean ha = objstr.readBoolean();
        double ymi = objstr.readDouble();
        double yma = objstr.readDouble();
        boolean as = objstr.readBoolean();
        int zf = objstr.readInt();
        int af = objstr.readInt();
        this.XBigTickDist = xbig;
        this.YBigTickDist = ybig;
        this.autoGitterX = agx;
        this.autoGitterY = agy;
        this.document.showMainGrid = smg;
        this.XSmallTicks = xsmt;
        this.YSmallTicks = ysmt;
        this.document.showSmallGrid = ssmg;
        this.document.achsenFaerben = achsf;
        this.document.scrollRad = sr;
        this.document.achsenDehnen = ad;
        this.XMin = xmi;
        this.XMax = xma;
        this.YMin = ymi;
        this.YMax = yma;
        this.achseSichtbar = as;
        this.setAuftragungsStringsOhneUpdate(GreekLetterConstPanel.repairCDot(vr), GreekLetterConstPanel.repairCDot(vh));
        this.rechtsAnp = ra;
        this.hochAnp = ha;
        this.diagramm.plotAll = true;
        this.diagramm.zeichenFarbe = new Color(zf);
        this.diagramm.auswahlFarbe = new Color(af);
    }

    public void writeData(ObjectOutputStream objstr) throws Exception {
        objstr.writeDouble(this.XBigTickDist);
        objstr.writeDouble(this.YBigTickDist);
        objstr.writeBoolean(this.autoGitterX);
        objstr.writeBoolean(this.autoGitterY);
        objstr.writeInt(this.XSmallTicks);
        objstr.writeInt(this.YSmallTicks);
        objstr.writeUTF(this.varRechtsStr);
        objstr.writeBoolean(this.rechtsAnp);
        objstr.writeDouble(this.XMin);
        objstr.writeDouble(this.XMax);
        objstr.writeUTF(this.varHochStr);
        objstr.writeBoolean(this.hochAnp);
        objstr.writeDouble(this.YMin);
        objstr.writeDouble(this.YMax);
        objstr.writeBoolean(this.achseSichtbar);
        objstr.writeInt(this.legendX);
        objstr.writeInt(this.legendY);
    }

    public void export(Graphics g) {
        double scalefac = 1.0f / this.getScale();
        ((Graphics2D)g).scale(scalefac * scalefac, scalefac * scalefac);
        this.zeichneAllesInGraphics(g, this.ks_image);
        g.setColor(Color.BLACK);
        ((Graphics2D)g).setStroke(new BasicStroke(2.0f * this.getScale()));
        g.drawRect(0, 0, this.ks_image.getWidth() - 1, this.ks_image.getHeight() - 1);
        if (this.document.showLegend) {
            int dx = this.legendX;
            g.translate(dx, this.legendY);
            this.legend.paint(g);
            g.translate(-dx, -this.legendY);
        }
    }
}

