/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.parser.TokenMgrError;
import de.didappslib.base.Diagram;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Statics;
import de.didappslib.base.Tabelle;
import de.didappslib.guitools.AuftragungsPopupMenu;
import de.didappslib.guitools.GUIDevice;
import de.didappslib.guitools.GreekLetterConstPanel;
import de.didappslib.guitools.KSEinstellung3D;
import de.didappslib.guitools.Legend;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Koordinatensystem3D
extends Koordinatensystem
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Koordinatensystem", Statics.locale);
    private final Koordinatensystem3D me = this;
    private final KSEinstellung3D ksEinstellung3D;
    private Color xColor;
    private Color yColor;
    private Color zColor;
    private double Cosa;
    private double Sina;
    private double Cosb;
    private double Sinb;
    private double Cosc;
    private double Sinc;
    private final double pers = 500.0;
    private double phi = -2.356194490192345;
    private double theta = 2.792526803190927;
    private double gamma = 0.0;
    private final double scalefactor_init = 0.47;
    private double scalefactor = 0.47;
    private int xoffset;
    private int yoffset;
    private final Color gridColor = new Color(120, 120, 120, 120);
    public String varXStr = "";
    public String varYStr = "";
    public String varZStr = "";
    public double ZMin;
    public double ZMax;
    public double ZBigTicksVon;
    public double ZBigTickDist;
    public double ZSmallTickDist;
    public int ZSmallTicks;
    public boolean autoGitterZ = true;
    double[][] fplotArray = new double[0][0];
    double[][] wplotArray = new double[0][0];
    public boolean achse1Anp = true;
    public boolean achse2Anp = true;
    public boolean achse3Anp = true;
    private int paintModelVon;
    private int paintModelBis;
    private boolean fromSlider;
    private float extraFontFac = 1.0f;
    private JPopupMenu popup = new JPopupMenu();
    private boolean showPlane1 = true;
    private boolean showPlane2 = false;
    private boolean showPlane3 = false;
    int oldwidth;
    int oldheight;
    int mousex;
    int mousey;

    public Koordinatensystem3D(Diagram d) {
        this.diagramm = d;
        this.document = this.diagramm.getProjekt();
        this.anzeige = this.document.getViewer();
        this.ksEinstellung3D = new KSEinstellung3D(this, this.document);
        this.createPopup();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Koordinatensystem3D.this.panelResized();
                if (Koordinatensystem3D.this.oldwidth == 0 || Koordinatensystem3D.this.oldheight == 0) {
                    Koordinatensystem3D.this.xoffset = Koordinatensystem3D.this.ks_image.getWidth() / 2;
                    Koordinatensystem3D.this.yoffset = (int)((double)Koordinatensystem3D.this.ks_image.getHeight() / 1.5);
                    Koordinatensystem3D.this.oldwidth = Koordinatensystem3D.this.ks_image.getWidth();
                    Koordinatensystem3D.this.oldheight = Koordinatensystem3D.this.ks_image.getHeight();
                    Koordinatensystem3D.this.generateAllPlotArrays();
                    Koordinatensystem3D.this.zeichneAlles();
                } else {
                    Koordinatensystem3D.this.xoffset = Koordinatensystem3D.this.xoffset * Koordinatensystem3D.this.ks_image.getWidth() / Koordinatensystem3D.this.oldwidth;
                    Koordinatensystem3D.this.yoffset = Koordinatensystem3D.this.yoffset * Koordinatensystem3D.this.ks_image.getHeight() / Koordinatensystem3D.this.oldheight;
                    Koordinatensystem3D.this.oldwidth = Koordinatensystem3D.this.ks_image.getWidth();
                    Koordinatensystem3D.this.oldheight = Koordinatensystem3D.this.ks_image.getHeight();
                    Koordinatensystem3D.this.zeichneAlles();
                }
            }
        });
        this.setBackground(Color.white);
        this.addMouseListener(this.me);
        this.addMouseMotionListener(this.me);
        this.addMouseWheelListener(this.me);
        this.plotArray = new double[0][3];
        this.legend = new Legend(this.document);
    }

    private void createPopup() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Koordinatensystem3D.this.handlePopupMenu(e);
            }
        };
        JMenuItem mit = new JMenuItem(this.rbundle.getString("Reset_view"));
        mit.addActionListener(al);
        this.popup.add(mit);
        JMenu untermenu = new JMenu(this.rbundle.getString("Show_planes"));
        mit = new JCheckBoxMenuItem(this.rbundle.getString("Plane_1"));
        mit.addActionListener(al);
        mit.setSelected(true);
        untermenu.add(mit);
        mit = new JCheckBoxMenuItem(this.rbundle.getString("Plane_2"));
        mit.addActionListener(al);
        mit.setSelected(true);
        untermenu.add(mit);
        mit = new JCheckBoxMenuItem(this.rbundle.getString("Plane_3"));
        mit.addActionListener(al);
        mit.setSelected(true);
        untermenu.add(mit);
        this.popup.add(untermenu);
        this.popup.add(new JSeparator());
        mit = new JMenuItem(this.rbundle.getString("Auto_axis"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Axis_setup"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                JMenu planesMenu = (JMenu)Koordinatensystem3D.this.popup.getComponent(1);
                planesMenu.getItem(0).setSelected(Koordinatensystem3D.this.showPlane1);
                planesMenu.getItem(1).setSelected(Koordinatensystem3D.this.showPlane2);
                planesMenu.getItem(2).setSelected(Koordinatensystem3D.this.showPlane3);
                Koordinatensystem3D.this.popup.getComponent(3).setEnabled(!Koordinatensystem3D.this.achse1Anp || !(Koordinatensystem3D.this.achse2Anp & Koordinatensystem3D.this.achse3Anp));
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
    }

    @Override
    public void handlePopupMenu(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(this.rbundle.getString("Reset_view"))) {
            this.phi = -2.356194490192345;
            this.theta = 2.792526803190927;
            this.scalefactor = 0.47;
            this.xoffset = this.ks_image.getWidth() / 2;
            this.yoffset = (int)((double)this.ks_image.getHeight() / 1.5);
            this.generateAllPlotArrays();
            this.zeichneAlles();
        }
        if (cmd.equals(this.rbundle.getString("Plane_1"))) {
            this.showPlane1 = !this.showPlane1;
            this.generateAllPlotArrays();
            this.zeichneAlles();
        }
        if (cmd.equals(this.rbundle.getString("Plane_2"))) {
            this.showPlane2 = !this.showPlane2;
            this.generateAllPlotArrays();
            this.zeichneAlles();
        }
        if (cmd.equals(this.rbundle.getString("Plane_3"))) {
            this.showPlane3 = !this.showPlane3;
            this.generateAllPlotArrays();
            this.zeichneAlles();
        }
        if (cmd.equals(this.rbundle.getString("Auto_axis"))) {
            this.achse3Anp = true;
            this.achse2Anp = true;
            this.achse1Anp = true;
            this.generateAllPlotArrays();
            this.zeichneAlles();
        }
        if (cmd.equals(this.rbundle.getString("Axis_setup"))) {
            this.ksEinstellung3D.activate(this.getWidth() / 2 + this.getLocationOnScreen().x, this.getHeight() / 3 + this.getLocationOnScreen().y, 0);
        }
    }

    private Point calc3DXY(double x, double y, double z) {
        double xx1 = x * this.Cosa - y * this.Sina;
        double yy1 = -y * this.Cosa - x * this.Sina;
        double zz2 = z * this.Cosb - xx1 * this.Sinb;
        double yy3 = yy1 * this.Cosc + zz2 * this.Sinc;
        double zz3 = zz2 * this.Cosc - yy1 * this.Sinc;
        return new Point((int)((double)this.getHeight() * this.scalefactor * this.sf * (500.0 * yy3 / (500.0 - yy1))) + this.xoffset, (int)((double)this.getHeight() * this.scalefactor * this.sf * (500.0 * zz3 / (500.0 - zz2))) + this.yoffset);
    }

    @Override
    public void zeichneKS(Graphics g, int breite, int hoehe) {
        int i;
        float gscale = Statics.prefsDialog.graphicsScale * this.getScale();
        Graphics2D g2 = (Graphics2D)g;
        this.Sina = Math.sin(this.phi);
        this.Sinb = Math.sin(this.theta);
        this.Sinc = Math.sin(this.gamma);
        this.Cosa = Math.cos(this.phi);
        this.Cosb = Math.cos(this.theta);
        this.Cosc = Math.cos(this.gamma);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.5f * gscale));
        g.setColor(this.xColor);
        this.draw3DLine(g2, -1.0, 0.0, 0.0, 1.05f, 0.0, 0.0);
        this.draw3DLine(g2, 1.05f, 0.0, 0.0, 1.02f, 0.0, 0.02f);
        this.draw3DLine(g2, 1.05f, 0.0, 0.0, 1.02f, 0.0, -0.02f);
        g.setColor(this.yColor);
        this.draw3DLine(g2, 0.0, -1.0, 0.0, 0.0, 1.05f, 0.0);
        this.draw3DLine(g2, 0.0, 1.05f, 0.0, 0.0, 1.02f, 0.02f);
        this.draw3DLine(g2, 0.0, 1.05f, 0.0, 0.0, 1.02f, -0.02f);
        g.setColor(this.zColor);
        this.draw3DLine(g2, 0.0, 0.0, -1.0, 0.0, 0.0, 1.05f);
        this.draw3DLine(g2, 0.0, 0.0, 1.05f, 0.02f, 0.0, 1.02f);
        this.draw3DLine(g2, 0.0, 0.0, 1.05f, -0.02f, -0.0, 1.02f);
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * (float)(this.scalefactor / 0.47) * this.getScale() * this.extraFontFac));
        g.setColor(Color.BLACK);
        int delta_beschr = (int)(5.0 * this.scalefactor / 0.47 * (double)this.getScale() * (double)this.extraFontFac);
        Point p = this.calc3DXY(1.05f, 0.0, 0.0);
        g.drawString(this.varXStr, p.x + delta_beschr, p.y - delta_beschr);
        p = this.calc3DXY(0.0, 1.05f, 0.0);
        g.drawString(this.varYStr, p.x + delta_beschr, p.y - delta_beschr);
        p = this.calc3DXY(0.0, 0.0, 1.05f);
        g.drawString(this.varZStr, p.x - delta_beschr / 2, p.y - (int)(1.3f * (float)delta_beschr));
        g.setColor(this.gridColor);
        g2.setStroke(new BasicStroke(1.0f));
        if (this.showPlane1) {
            for (i = -10; i < 11; ++i) {
                this.draw3DLine(g2, (float)i * 0.1f, -1.0, 0.0, (float)i * 0.1f, 1.0, 0.0);
                this.draw3DLine(g2, -1.0, (float)i * 0.1f, 0.0, 1.0, (float)i * 0.1f, 0.0);
            }
        }
        if (this.showPlane2) {
            for (i = -10; i < 11; ++i) {
                this.draw3DLine(g2, (float)i * 0.1f, 0.0, -1.0, (float)i * 0.1f, 0.0, 1.0);
                this.draw3DLine(g2, -1.0, 0.0, (float)i * 0.1f, 1.0, 0.0, (float)i * 0.1f);
            }
        }
        if (this.showPlane3) {
            for (i = -10; i < 11; ++i) {
                this.draw3DLine(g2, 0.0, (float)i * 0.1f, -1.0, 0.0, (float)i * 0.1f, 1.0);
                this.draw3DLine(g2, 0.0, -1.0, (float)i * 0.1f, 0.0, 1.0, (float)i * 0.1f);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.ks_image == null) {
            return;
        }
        g2d.scale(1.0 / this.sf, 1.0 / this.sf);
        g.drawImage(this.ks_image, 0, 0, this);
        g2d.scale(this.sf, this.sf);
        if (this.document.showLegend) {
            g.translate(this.legendX, this.legendY);
            this.legend.paint(g);
            g.translate(-this.legendY, -this.legendY);
        }
    }

    @Override
    public void zeichneAllesInGraphics(Graphics g, BufferedImage img) {
        if (img == null) {
            img = this.ks_image;
        }
        double sf_save = this.scalefactor;
        int xo_save = this.xoffset;
        int yo_save = this.yoffset;
        this.extraFontFac = 1.05f;
        if (img != this.ks_image) {
            float fac = (float)img.getWidth() / (float)this.document.getDiagramm().getWidth();
            this.scalefactor = this.scalefactor * (double)img.getWidth() / (double)this.ks_image.getWidth() / (double)fac;
            this.xoffset = (int)((double)this.xoffset / (double)this.ks_image.getWidth() * (double)img.getWidth());
            this.yoffset = (int)((double)this.yoffset / (double)this.ks_image.getHeight() * (double)img.getHeight());
            this.generateAllPlotArrays();
            this.extraFontFac = 2.5f;
        }
        this.paintModelVon = 0;
        this.paintModelBis = 100;
        this.fromSlider = false;
        g.setColor(Color.white);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        this.zeichneKS(g, img.getWidth(), img.getHeight());
        this.drawModel((Graphics2D)g);
        this.drawVWerte((Graphics2D)g);
        this.repaint();
        this.scalefactor = sf_save;
        this.xoffset = xo_save;
        this.yoffset = yo_save;
    }

    @Override
    public void zeichneTeils(int von, int bis, boolean fromSlider) {
        Graphics g = this.ks_image.getGraphics();
        this.paintModelBis = bis;
        this.fromSlider = fromSlider;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.ks_image.getWidth(), this.ks_image.getHeight());
        this.zeichneKS(g, this.ks_image.getWidth(), this.ks_image.getHeight());
        this.drawModel((Graphics2D)g);
        if (bis == 100) {
            this.drawVWerte((Graphics2D)g);
        }
        this.repaint();
    }

    @Override
    public void zeichneTeilsForSlomo(int vonNeu, int bis) {
        Graphics g = this.ks_image.getGraphics();
        if (vonNeu == 0) {
            this.paintModelVon = vonNeu;
        }
        this.paintModelBis = bis;
        this.fromSlider = false;
        if (this.paintModelVon == 0) {
            this.calcValuesForPainting(this.ks_image);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.ks_image.getWidth(), this.ks_image.getHeight());
            this.zeichneKS(g, this.ks_image.getWidth(), this.ks_image.getHeight());
        }
        this.drawModel((Graphics2D)g);
        this.paintModelVon = vonNeu;
        this.repaint();
    }

    public void draw3DPoint(Graphics g, double x, double y, double z, int w) {
        Point p = this.calc3DXY(x, y, z);
        g.fillOval(p.x - w / 2, p.y - w / 2, w, w);
    }

    public void draw3DLine(Graphics2D g, double x1, double y1, double z1, double x2, double y2, double z2) {
        Point p1 = this.calc3DXY(x1, y1, z1);
        Point p2 = this.calc3DXY(x2, y2, z2);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void calcMinMaxValues() {
        double max;
        double min;
        this.anpassColor = !this.document.achsenFaerben ? Color.BLACK : new Color(180, 80, 120);
        if (this.achse1Anp) {
            min = this.findeXMin();
            max = this.findeXMax();
            if (Double.isInfinite(min) || Double.isInfinite(max)) {
                return;
            }
            if (Math.abs(min) <= Double.MIN_VALUE && Math.abs(max) <= Double.MIN_VALUE) {
                min = -1.0;
                max = 1.0;
            }
            if (Math.abs(max - min) < Double.MIN_VALUE) {
                if (min < 0.0) {
                    min = 2.0 * min;
                    max = 0.0;
                } else if (min > 0.0) {
                    min = 0.0;
                    max = 2.0 * max;
                }
            }
            this.XMin = min - 0.05 * (max - min);
            this.XMax = max + 0.05 * (max - min);
            this.xColor = this.anpassColor;
        } else {
            this.xColor = Color.BLACK;
        }
        if (this.achse2Anp) {
            min = this.findeYMin();
            max = this.findeYMax();
            if (Double.isInfinite(min) || Double.isInfinite(max)) {
                return;
            }
            if (Math.abs(min) <= Double.MIN_VALUE && Math.abs(max) <= Double.MIN_VALUE) {
                min = -1.0;
                max = 1.0;
            }
            if (Math.abs(max - min) < Double.MIN_VALUE) {
                if (min < 0.0) {
                    min = 2.0 * min;
                    max = 0.0;
                } else if (min > 0.0) {
                    min = 0.0;
                    max = 2.0 * max;
                }
            }
            this.YMin = min - 0.05 * (max - min);
            this.YMax = max + 0.05 * (max - min);
            this.yColor = this.anpassColor;
        } else {
            this.yColor = Color.BLACK;
        }
        if (this.achse3Anp) {
            min = this.findeZMin();
            max = this.findeZMax();
            if (Double.isInfinite(min) || Double.isInfinite(max)) {
                return;
            }
            if (Math.abs(min) <= Double.MIN_VALUE && Math.abs(max) <= Double.MIN_VALUE) {
                min = -1.0;
                max = 1.0;
            }
            if (Math.abs(max - min) < Double.MIN_VALUE) {
                if (min < 0.0) {
                    min = 2.0 * min;
                    max = 0.0;
                } else if (min > 0.0) {
                    min = 0.0;
                    max = 2.0 * max;
                }
            }
            this.ZMin = min - 0.05 * (max - min);
            this.ZMax = max + 0.05 * (max - min);
            this.zColor = this.anpassColor;
        } else {
            this.zColor = Color.BLACK;
        }
        if (this.XMin >= this.XMax) {
            this.XMax = this.XMin + Math.abs(this.XMin);
        }
        if (this.YMin >= this.YMax) {
            this.YMax = this.YMin + Math.abs(this.YMin);
        }
        if (this.ZMin >= this.ZMax) {
            this.ZMax = this.ZMin + Math.abs(this.ZMin);
        }
    }

    public void drawModel(Graphics2D g) {
        if (this.plotArray.length <= 1) {
            return;
        }
        int plotStartIndex = (int)((float)this.paintModelVon / 100.0f * (float)this.plotArray.length);
        int plotEndIndex = (int)((float)this.paintModelBis / 100.0f * (float)this.plotArray.length);
        float gscale = Statics.prefsDialog.graphicsScale * this.getScale();
        if (this.document.getModel().werteAuslassenAnz > 0 && plotStartIndex == 0) {
            plotStartIndex = 1;
        }
        g.setColor(Diagram.colorArray[this.document.zeichFarbIndex]);
        g.setStroke(new BasicStroke((float)this.document.linienStaerke * gscale));
        int drawPSize = (int)((float)this.document.punktGroesse * gscale);
        this.draw3DPoint(g, this.plotArray[plotStartIndex][0], this.plotArray[plotStartIndex][1], this.plotArray[plotStartIndex][2], drawPSize);
        int imax = plotEndIndex;
        if (imax > this.plotArray.length) {
            imax = this.plotArray[0].length;
        }
        for (int i = plotStartIndex + 1; i < imax; ++i) {
            int j = i - 1;
            this.draw3DLine(g, this.plotArray[j][0], this.plotArray[j][1], this.plotArray[j][2], this.plotArray[i][0], this.plotArray[i][1], this.plotArray[i][2]);
            this.draw3DPoint(g, this.plotArray[i][0], this.plotArray[i][1], this.plotArray[i][2], drawPSize);
        }
        if (this.fromSlider && plotEndIndex > 0) {
            g.setColor(Color.black);
            this.draw3DPoint(g, this.plotArray[plotEndIndex - 1][0], this.plotArray[plotEndIndex - 1][1], this.plotArray[plotEndIndex - 1][2], drawPSize);
            Tabelle tabelle = this.document.getViewer().getAktTable();
            if (tabelle != null) {
                tabelle.disallowUpdateView();
                if (plotEndIndex < tabelle.tab.getRowCount()) {
                    tabelle.tab.changeSelection(plotEndIndex, 0, false, false);
                }
                tabelle.allowUpdateView();
            }
        }
    }

    public void drawFunction(Graphics2D g) {
    }

    public void drawVWerte(Graphics2D g) {
        if (!this.document.getExtras().showVglWerte()) {
            return;
        }
        float gscale = Statics.prefsDialog.graphicsScale * this.getScale();
        float pGr = 0.0012f * (float)this.document.wertePktGr * gscale * (Statics.prefsDialog.graphicsScale == 1.0f ? 0.9f : 0.7f);
        float lSt = (float)this.document.wertePktGr * gscale * 0.2f;
        g.setStroke(new BasicStroke(lSt));
        g.setColor(Diagram.colorArray[this.document.werteFarbIndex]);
        for (double[] wplotArray1 : this.wplotArray) {
            this.draw3DLine(g, wplotArray1[0] - (double)pGr, wplotArray1[1] - (double)pGr, wplotArray1[2] - (double)pGr, wplotArray1[0] + (double)pGr, wplotArray1[1] + (double)pGr, wplotArray1[2] + (double)pGr);
            this.draw3DLine(g, wplotArray1[0] + (double)pGr, wplotArray1[1] - (double)pGr, wplotArray1[2] - (double)pGr, wplotArray1[0] - (double)pGr, wplotArray1[1] + (double)pGr, wplotArray1[2] + (double)pGr);
            this.draw3DLine(g, wplotArray1[0] + (double)pGr, wplotArray1[1] + (double)pGr, wplotArray1[2] - (double)pGr, wplotArray1[0] - (double)pGr, wplotArray1[1] - (double)pGr, wplotArray1[2] + (double)pGr);
        }
    }

    @Override
    public boolean parseAchsen(XJep parser) {
        if (parser == null) {
            return false;
        }
        try {
            this.xnode = parser.parse(GreekLetterConstPanel.refactorStr(this.varXStr));
            parser.preprocess(this.xnode);
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Achse_1"), e.getMessage(), null, false);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Achse_1"), e.getMessage(), null, false);
            return false;
        }
        try {
            this.ynode = parser.parse(GreekLetterConstPanel.refactorStr(this.varYStr));
            parser.preprocess(this.ynode);
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Achse_2"), e.getMessage(), null, false);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Achse_2"), e.getMessage(), null, false);
            return false;
        }
        try {
            this.znode = parser.parse(GreekLetterConstPanel.refactorStr(this.varZStr));
            parser.preprocess(this.znode);
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Achse_3"), e.getMessage(), null, false);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Auftragung_f\u00fcr_die_Achse_3"), e.getMessage(), null, false);
            return false;
        }
        return true;
    }

    private double findeXMin() {
        double z;
        double y;
        double x;
        int[] rows = this.document.getModel().getProjekt().getModelTable().tab.getSelectedRows();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.plotArray.length; ++i) {
            boolean isok = this.document.getDiagramm().plotAll || rows.length == 0 || this.isInArray(i, rows);
            x = this.plotArray[i][0];
            y = this.plotArray[i][1];
            z = this.plotArray[i][2];
            if (!this.achse2Anp && !this.achse3Anp && (!(y > this.YMin) || !(y < this.YMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(x < min) || !isok) continue;
            min = x;
        }
        if (this.document.getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    x = wertePlotArray1[0];
                    y = wertePlotArray1[1];
                    z = wertePlotArray1[2];
                    if (!this.achse2Anp && !this.achse3Anp && (!(y > this.YMin) || !(y < this.YMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(x < min)) continue;
                    min = x;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (min == Double.MAX_VALUE) {
            for (double[] plotArray1 : this.plotArray) {
                x = plotArray1[0];
                if (!(x < min)) continue;
                min = x;
            }
        }
        if (min > 0.0 && this.XMax > 0.0 && this.achseSichtbar) {
            min = 0.0;
        }
        return min;
    }

    private double findeXMax() {
        double z;
        double y;
        double x;
        int[] rows = this.document.getModel().getProjekt().getModelTable().tab.getSelectedRows();
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.plotArray.length; ++i) {
            boolean isok = this.document.getDiagramm().plotAll || rows.length == 0 || this.isInArray(i, rows);
            x = this.plotArray[i][0];
            y = this.plotArray[i][1];
            z = this.plotArray[i][2];
            if (!this.achse2Anp && !this.achse3Anp && (!(y > this.YMin) || !(y < this.YMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(x > max) || !isok) continue;
            max = x;
        }
        if (this.document.getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    x = wertePlotArray1[0];
                    y = wertePlotArray1[1];
                    z = wertePlotArray1[2];
                    if (!this.achse2Anp && !this.achse3Anp && (!(y > this.YMin) || !(y < this.YMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(x > max)) continue;
                    max = x;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (max == -1.7976931348623157E308) {
            for (double[] plotArray1 : this.plotArray) {
                x = plotArray1[0];
                if (!(x > max)) continue;
                max = x;
            }
        }
        if (max < 0.0 && this.XMin < 0.0 && this.achseSichtbar) {
            max = 0.0;
        }
        return max;
    }

    private double findeYMin() {
        double z;
        double y;
        double x;
        int[] rows = this.document.getModel().getProjekt().getModelTable().tab.getSelectedRows();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.plotArray.length; ++i) {
            boolean isok = this.document.getDiagramm().plotAll || rows.length == 0 || this.isInArray(i, rows);
            x = this.plotArray[i][0];
            y = this.plotArray[i][1];
            z = this.plotArray[i][2];
            if (!this.achse1Anp && !this.achse3Anp && (!(x > this.XMin) || !(x < this.XMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(y < min) || !isok) continue;
            min = y;
        }
        if (this.document.getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    x = wertePlotArray1[0];
                    y = wertePlotArray1[1];
                    z = wertePlotArray1[2];
                    if (!this.achse1Anp && !this.achse3Anp && (!(x > this.XMin) || !(x < this.XMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(y < min)) continue;
                    min = y;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (min == Double.MAX_VALUE) {
            for (double[] plotArray1 : this.plotArray) {
                y = plotArray1[1];
                if (!(y < min)) continue;
                min = y;
            }
        }
        if (min > 0.0 && this.YMax > 0.0 && this.achseSichtbar) {
            min = 0.0;
        }
        return min;
    }

    private double findeYMax() {
        double z;
        double y;
        double x;
        int[] rows = this.document.getModel().getProjekt().getModelTable().tab.getSelectedRows();
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.plotArray.length; ++i) {
            boolean isok = this.document.getDiagramm().plotAll || rows.length == 0 || this.isInArray(i, rows);
            x = this.plotArray[i][0];
            y = this.plotArray[i][1];
            z = this.plotArray[i][2];
            if (!this.achse1Anp && !this.achse3Anp && (!(x > this.XMin) || !(x < this.XMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(y > max) || !isok) continue;
            max = y;
        }
        if (this.document.getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    x = wertePlotArray1[0];
                    y = wertePlotArray1[1];
                    z = wertePlotArray1[2];
                    if (!this.achse1Anp && !this.achse3Anp && (!(x > this.XMin) || !(x < this.XMax) || !(z > this.ZMin) || !(z < this.ZMax)) || !(y > max)) continue;
                    max = y;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (max == -1.7976931348623157E308) {
            for (double[] plotArray1 : this.plotArray) {
                y = plotArray1[1];
                if (!(y > max)) continue;
                max = y;
            }
        }
        if (max < 0.0 && this.YMin < 0.0 && this.achseSichtbar) {
            max = 0.0;
        }
        return max;
    }

    private double findeZMin() {
        double z;
        double y;
        double x;
        int[] rows = this.document.getModel().getProjekt().getModelTable().tab.getSelectedRows();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.plotArray.length; ++i) {
            boolean isok = this.document.getDiagramm().plotAll || rows.length == 0 || this.isInArray(i, rows);
            x = this.plotArray[i][0];
            y = this.plotArray[i][1];
            z = this.plotArray[i][2];
            if (!this.achse1Anp && !this.achse2Anp && (!(x > this.XMin) || !(x < this.XMax) || !(y > this.YMin) || !(y < this.YMax)) || !(z < min) || !isok) continue;
            min = z;
        }
        if (this.document.getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    x = wertePlotArray1[0];
                    y = wertePlotArray1[1];
                    z = wertePlotArray1[2];
                    if (!this.achse1Anp && !this.achse2Anp && (!(x > this.XMin) || !(x < this.XMax) || !(y > this.YMin) || !(y < this.YMax)) || !(z < min)) continue;
                    min = z;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (min == Double.MAX_VALUE) {
            for (double[] plotArray1 : this.plotArray) {
                z = plotArray1[2];
                if (!(z < min)) continue;
                min = z;
            }
        }
        if (min > 0.0 && this.ZMax > 0.0 && this.achseSichtbar) {
            min = 0.0;
        }
        return min;
    }

    private double findeZMax() {
        double z;
        double y;
        double x;
        int[] rows = this.document.getModel().getProjekt().getModelTable().tab.getSelectedRows();
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.plotArray.length; ++i) {
            boolean isok = this.document.getDiagramm().plotAll || rows.length == 0 || this.isInArray(i, rows);
            x = this.plotArray[i][0];
            y = this.plotArray[i][1];
            z = this.plotArray[i][2];
            if (!this.achse1Anp && !this.achse2Anp && (!(x > this.XMin) || !(x < this.XMax) || !(y > this.YMin) || !(y < this.YMax)) || !(z > max) || !isok) continue;
            max = z;
        }
        if (this.document.getExtras().showVglWerte()) {
            for (double[] wertePlotArray1 : this.wertePlotArray) {
                try {
                    x = wertePlotArray1[0];
                    y = wertePlotArray1[1];
                    z = wertePlotArray1[2];
                    if (!this.achse1Anp && !this.achse2Anp && (!(x > this.XMin) || !(x < this.XMax) || !(y > this.YMin) || !(y < this.YMax)) || !(z > max)) continue;
                    max = z;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (max == -1.7976931348623157E308) {
            for (double[] plotArray1 : this.plotArray) {
                z = plotArray1[2];
                if (!(z > max)) continue;
                max = z;
            }
        }
        if (max < 0.0 && this.ZMin < 0.0 && this.achseSichtbar) {
            max = 0.0;
        }
        return max;
    }

    public void setAuftragungsStrings(String xstr, String ystr, String zstr) {
        this.varXStr = xstr;
        this.varYStr = ystr;
        this.varZStr = zstr;
        this.document.defaultAuftrStr3D[0] = xstr;
        this.document.defaultAuftrStr3D[1] = ystr;
        this.document.defaultAuftrStr3D[2] = zstr;
        this.generateAllPlotArrays();
        this.zeichneAlles();
    }

    @Override
    public void checkAuftragungsStrings() {
        if (this.varXStr.isEmpty()) {
            this.varXStr = this.document.defaultAuftrStr3D[0];
        }
        if (this.varYStr.isEmpty()) {
            this.varYStr = this.document.defaultAuftrStr3D[1];
        }
        if (this.varZStr.isEmpty()) {
            this.varZStr = this.document.defaultAuftrStr3D[2];
        }
    }

    public void setSelectedXAnp(boolean what) {
        this.achse1Anp = what;
        this.zeichneAlles();
    }

    public void setSelectedYAnp(boolean what) {
        this.achse2Anp = what;
        this.zeichneAlles();
    }

    public void setSelectedZAnp(boolean what) {
        this.achse3Anp = what;
        this.zeichneAlles();
    }

    @Override
    public boolean isInArray(int val, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (val != arr[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generateAllPlotArrays() {
        int i;
        if (this.document.getModel() == null || this.document.getModel().parser == null) {
            return;
        }
        int wanz = this.document.getModel().werteAnzahl;
        if (this.document.errorOccured() && this.document.getModel().werteAnzahl > 1) {
            --wanz;
        }
        if (this.document.getModel().werteAltAnzahl + wanz != this.plotArray.length) {
            try {
                this.plotArray = new double[this.document.getModel().werteAltAnzahl + wanz][3];
            }
            catch (OutOfMemoryError ex) {
                this.document.errorMsg(this.rbundle.getString("Java_Speicherfehler!"), this.rbundle.getString("Anzahl_verringern"), null, true);
                this.plotArray = new double[0][3];
                return;
            }
        }
        this.parseAchsen(this.document.getModel().parser);
        try {
            for (i = 0; i < this.document.getModel().werteAltAnzahl; ++i) {
                this.document.getModel().addModelVarsToParser(this.document.getModel().wertetabelleAlt[i]);
                this.plotArray[i][0] = (Double)this.document.getModel().parser.evaluate(this.xnode);
                this.plotArray[i][1] = (Double)this.document.getModel().parser.evaluate(this.ynode);
                this.plotArray[i][2] = (Double)this.document.getModel().parser.evaluate(this.znode);
            }
            for (i = 0; i < wanz; ++i) {
                this.document.getModel().addModelVarsToParser(this.document.getModel().wertetabelle[i]);
                this.plotArray[i + this.document.getModel().werteAltAnzahl][0] = (Double)this.document.getModel().parser.evaluate(this.xnode);
                this.plotArray[i + this.document.getModel().werteAltAnzahl][1] = (Double)this.document.getModel().parser.evaluate(this.ynode);
                this.plotArray[i + this.document.getModel().werteAltAnzahl][2] = (Double)this.document.getModel().parser.evaluate(this.znode);
            }
        }
        catch (Exception e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Berechnung_der_Werte_f\u00fcr_das_Diagramm!"), e.toString(), null, false);
            this.plotArray = new double[0][3];
            return;
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(this.rbundle.getString("Fehler_bei_der_Berechnung_der_Werte_f\u00fcr_das_Diagramm!"), e.toString(), null, false);
            this.plotArray = new double[0][3];
            return;
        }
        this.calcMinMaxValues();
        double DeltaX = this.XMax - this.XMin;
        double DeltaY = this.YMax - this.YMin;
        double DeltaZ = this.ZMax - this.ZMin;
        for (i = 0; i < this.plotArray.length; ++i) {
            this.plotArray[i][0] = this.plotArray[i][0] / DeltaX;
            this.plotArray[i][1] = this.plotArray[i][1] / DeltaY;
            this.plotArray[i][2] = this.plotArray[i][2] / DeltaZ;
        }
        if (this.document.getExtras().showVglWerte()) {
            this.document.getExtras().createWertePlotArray(this);
            this.wplotArray = new double[this.wertePlotArray.length][3];
            for (i = 0; i < this.wertePlotArray.length; ++i) {
                this.wplotArray[i][0] = this.wertePlotArray[i][0] / DeltaX;
                this.wplotArray[i][1] = this.wertePlotArray[i][1] / DeltaY;
                this.wplotArray[i][2] = this.wertePlotArray[i][2] / DeltaZ;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point pkt = e.getPoint();
        this.x1 = e.getX();
        this.y1 = e.getY();
        if (this.isOnAchse1Auftr(pkt)) {
            AuftragungsPopupMenu auftrPopup = new AuftragungsPopupMenu(this.document.getModel(), evt -> {
                if (evt.getActionCommand().equals("Weitere Einstellungen")) {
                    this.ksEinstellung3D.activate(e.getXOnScreen() + 150, e.getYOnScreen() + 50, 1);
                } else {
                    this.setAuftragungsStrings(evt.getActionCommand(), this.varYStr, this.varZStr);
                }
            }, false, null, null, null);
            auftrPopup.show(this, pkt.x, pkt.y);
            return;
        }
        if (this.isOnAchse2Auftr(pkt)) {
            AuftragungsPopupMenu auftrPopup = new AuftragungsPopupMenu(this.document.getModel(), evt -> {
                if (evt.getActionCommand().equals("Weitere Einstellungen")) {
                    this.ksEinstellung3D.activate(e.getXOnScreen() + 150, e.getYOnScreen() + 50, 2);
                } else {
                    this.setAuftragungsStrings(this.varXStr, evt.getActionCommand(), this.varZStr);
                }
            }, false, null, null, null);
            auftrPopup.show(this, pkt.x, pkt.y);
            return;
        }
        if (this.isOnAchse3Auftr(pkt)) {
            AuftragungsPopupMenu auftrPopup = new AuftragungsPopupMenu(this.document.getModel(), evt -> {
                if (evt.getActionCommand().equals("Weitere Einstellungen")) {
                    this.ksEinstellung3D.activate(e.getXOnScreen() + 150, e.getYOnScreen() + 100, 3);
                } else {
                    this.setAuftragungsStrings(this.varXStr, this.varYStr, evt.getActionCommand());
                }
            }, false, null, null, null);
            auftrPopup.show(this, pkt.x, pkt.y);
            return;
        }
        if (e.getButton() == 2) {
            this.whatToDo = 4;
            return;
        }
        if (e.getButton() == 3) {
            this.popup.show(this, e.getPoint().x, e.getPoint().y);
            this.whatToDo = 0;
            return;
        }
        if (this.document.showLegend) {
            int xs = e.getXOnScreen();
            int ys = e.getYOnScreen();
            int lxs = this.legendX + this.getLocationOnScreen().x;
            int lys = this.legendY + this.getLocationOnScreen().y;
            if (xs > lxs && (float)xs < (float)lxs + (float)this.legend.getWidth() * Statics.prefsDialog.graphicsScale && ys > lys && (float)ys < (float)lys + (float)this.legend.getHeight() * Statics.prefsDialog.graphicsScale) {
                this.whatToDo = 20;
                return;
            }
        }
        this.whatToDo = 4;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.whatToDo = 0;
    }

    private int checkOnAxis(Point point) {
        Point start = this.calc3DXY(-1.0, 0.0, 0.0);
        Point end = this.calc3DXY(1.05, 0.0, 0.0);
        if (Line2D.ptSegDist(start.x, start.y, end.x, end.y, point.x, point.y) < 5.0) {
            return 1;
        }
        start = this.calc3DXY(0.0, -1.0, 0.0);
        end = this.calc3DXY(0.0, 1.05, 0.0);
        if (Line2D.ptSegDist(start.x, start.y, end.x, end.y, point.x, point.y) < 5.0) {
            return 2;
        }
        start = this.calc3DXY(0.0, 0.0, -1.0);
        end = this.calc3DXY(0.0, 0.0, 1.05);
        if (Line2D.ptSegDist(start.x, start.y, end.x, end.y, point.x, point.y) < 5.0) {
            return 3;
        }
        return 0;
    }

    private boolean isOnAchse1Auftr(Point point) {
        Graphics g = this.getGraphics();
        int delta_beschr = (int)(5.0 * this.scalefactor / 0.47 * (double)this.extraFontFac);
        Point textOrigin = this.calc3DXY(1.05f, 0.0, 0.0);
        textOrigin.x = (int)((double)textOrigin.x / this.sf) + delta_beschr;
        textOrigin.y = (int)((double)textOrigin.y / this.sf) - delta_beschr;
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * 1.1f));
        Rectangle rect = new Rectangle(textOrigin.x - 1, textOrigin.y - g.getFontMetrics().getAscent(), g.getFontMetrics().stringWidth(this.varXStr) + 4, g.getFontMetrics().getHeight() + 2);
        return rect.contains(point);
    }

    private boolean isOnAchse2Auftr(Point point) {
        Graphics g = this.getGraphics();
        int delta_beschr = (int)(5.0 * this.scalefactor / 0.47 * (double)this.extraFontFac);
        Point textOrigin = this.calc3DXY(0.0, 1.05f, 0.0);
        textOrigin.x = (int)((double)textOrigin.x / this.sf) + delta_beschr;
        textOrigin.y = (int)((double)textOrigin.y / this.sf) - delta_beschr;
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * 1.1f));
        Rectangle rect = new Rectangle(textOrigin.x - 1, textOrigin.y - g.getFontMetrics().getAscent(), g.getFontMetrics().stringWidth(this.varYStr) + 4, g.getFontMetrics().getHeight() + 2);
        return rect.contains(point);
    }

    private boolean isOnAchse3Auftr(Point point) {
        Graphics g = this.getGraphics();
        int delta_beschr = (int)(5.0 * this.scalefactor / 0.47 * (double)this.extraFontFac);
        Point textOrigin = this.calc3DXY(0.0, 0.0, 1.05f);
        textOrigin.x = (int)((double)textOrigin.x / this.sf) - delta_beschr / 2;
        textOrigin.y = (int)((double)textOrigin.y / this.sf) - (int)(1.3f * (float)delta_beschr);
        g.setFont(Statics.mathFont.deriveFont(this.document.fontSize * Statics.prefsDialog.graphicsScale * 1.1f));
        Rectangle rect = new Rectangle(textOrigin.x - 1, textOrigin.y - g.getFontMetrics().getAscent(), g.getFontMetrics().stringWidth(this.varZStr) + 4, g.getFontMetrics().getHeight() + 2);
        return rect.contains(point);
    }

    private boolean isOnModelGraph(Point point) {
        for (int i = 1; i < this.plotArray.length; ++i) {
            Point start = this.calc3DXY(this.plotArray[i - 1][0], this.plotArray[i - 1][1], this.plotArray[i - 1][2]);
            Point end = this.calc3DXY(this.plotArray[i][0], this.plotArray[i][1], this.plotArray[i][2]);
            if (!(Line2D.ptSegDist(start.x, start.y, end.x, end.y, point.x, point.y) < 5.0)) continue;
            return true;
        }
        return false;
    }

    private boolean isOnWerteGraph(Point point) {
        for (int i = 1; i < this.wplotArray.length; ++i) {
            Point modelPoint = this.calc3DXY(this.wplotArray[i - 1][0], this.wplotArray[i - 1][1], this.wplotArray[i - 1][2]);
            if (!(modelPoint.distance(point.x, point.y) < 5.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point pkt = e.getPoint();
        pkt.x = (int)((float)pkt.x * this.getScale());
        pkt.y = (int)((float)pkt.y * this.getScale());
        if (e.getClickCount() == 2) {
            if (this.checkOnAxis(pkt) > 0) {
                this.ksEinstellung3D.activate(e.getXOnScreen(), e.getYOnScreen(), this.checkOnAxis(pkt));
                return;
            }
            if (this.isOnModelGraph(pkt)) {
                this.diagramm.showOverlay(1);
                return;
            }
            if (this.document.getExtras().showVglWerte() && this.isOnWerteGraph(pkt)) {
                this.diagramm.showOverlay(8);
                return;
            }
            if (this.document.showLegend) {
                pkt = e.getPoint();
                int dy = pkt.y - this.legendY;
                if (pkt.x > this.legendX && (float)pkt.x < (float)this.legendX + (float)this.legend.getWidth() * Statics.prefsDialog.graphicsScale && pkt.y > this.legendY && (float)dy < (float)this.legend.getHeight() * Statics.prefsDialog.graphicsScale) {
                    this.diagramm.showOverlay(1);
                    if (this.legend.getHeight() == 39 && (float)dy > 20.0f * Statics.prefsDialog.graphicsScale) {
                        if (this.fktPlotted) {
                            this.diagramm.showOverlay(5);
                        } else {
                            this.diagramm.showOverlay(8);
                        }
                    }
                    if (this.legend.getHeight() == 55 && (float)dy > 20.0f * Statics.prefsDialog.graphicsScale) {
                        if ((float)dy < 38.0f * Statics.prefsDialog.graphicsScale) {
                            this.diagramm.showOverlay(5);
                        } else {
                            this.diagramm.showOverlay(8);
                        }
                    }
                    return;
                }
            }
            this.achse3Anp = true;
            this.achse2Anp = true;
            this.achse1Anp = true;
            this.scalefactor = 0.47;
            this.xoffset = this.ks_image.getWidth() / 2;
            this.yoffset = (int)((double)this.ks_image.getHeight() / 1.5);
            this.generateAllPlotArrays();
            this.zeichneAlles();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        if (this.isOnAchse1Auftr(p) || this.isOnAchse2Auftr(p) | this.isOnAchse3Auftr(p)) {
            this.setCursor(new Cursor(12));
            return;
        }
        this.setCursor(null);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.whatToDo == 20) {
            this.x2 = e.getPoint().x;
            this.y2 = e.getPoint().y;
            if (this.legendX + this.x2 - this.x1 > 0 && (float)(this.legendX + this.x2 - this.x1) < (float)this.getWidth() - (float)this.legend.getWidth() * Statics.prefsDialog.graphicsScale) {
                this.legendX = this.legendX + this.x2 - this.x1;
                this.x1 = this.x2;
            }
            if (this.legendY + this.y2 - this.y1 > 0 && (float)(this.legendY + this.y2 - this.y1) < (float)this.getHeight() - (float)this.legend.getHeight() * Statics.prefsDialog.graphicsScale) {
                this.legendY = this.legendY + this.y2 - this.y1;
                this.y1 = this.y2;
            }
            this.document.setChanged(true);
            this.repaint();
            return;
        }
        if (this.whatToDo == 4) {
            int mx = e.getX();
            int my = e.getY();
            int onmask = 64;
            if ((e.getModifiersEx() & onmask) == onmask || e.getButton() == 2) {
                this.xoffset -= (int)((float)(this.x1 - mx) * this.getScale());
                this.yoffset -= (int)((float)(this.y1 - my) * this.getScale());
                this.x1 = mx;
                this.y1 = my;
            } else {
                if (this.x1 > mx) {
                    this.phi -= 0.03 * (double)this.getScale();
                }
                if (this.x1 < mx) {
                    this.phi += 0.03 * (double)this.getScale();
                }
                if (this.y1 > my) {
                    this.theta += 0.03 * (double)this.getScale();
                }
                if (this.y1 < my) {
                    this.theta -= 0.03 * (double)this.getScale();
                }
                this.x1 = mx;
                this.y1 = my;
            }
            this.document.setChanged(true);
            this.zeichneTeils(this.paintModelVon, this.paintModelBis, false);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.document.scrollRad) {
            return;
        }
        double zoomFaktor = -e.getWheelRotation();
        if (zoomFaktor == 0.0) {
            return;
        }
        double factor = 1.05;
        if (!Statics.os.contains("mac")) {
            factor = 1.2;
        }
        zoomFaktor = zoomFaktor < 0.0 ? 1.0 / (factor * Math.pow(-zoomFaktor, 0.1)) : factor * Math.pow(zoomFaktor, 0.1);
        if (e.getModifiersEx() != 0) {
            int onmask = 64;
            if ((e.getModifiersEx() & onmask) == onmask) {
                this.scalefactor /= zoomFaktor;
                this.document.setChanged(true);
                this.generateAllPlotArrays();
                this.zeichneAlles();
                return;
            }
        } else if (Math.abs(zoomFaktor - 1.0) > 0.1) {
            this.achse3Anp = false;
            this.achse2Anp = false;
            this.achse1Anp = false;
            this.XMin *= zoomFaktor;
            this.XMax *= zoomFaktor;
            this.YMin = this.XMin * zoomFaktor;
            this.YMax *= zoomFaktor;
            this.ZMin *= zoomFaktor;
            this.ZMax *= zoomFaktor;
            this.document.setChanged(true);
            this.generateAllPlotArrays();
            this.zeichneAlles();
        }
    }

    @Override
    public void readData(ObjectInputStream objstr, float datversion, String kennung) throws Exception {
        String xstr = objstr.readUTF();
        boolean xa = objstr.readBoolean();
        double xmi = objstr.readDouble();
        double xma = objstr.readDouble();
        String ystr = objstr.readUTF();
        boolean ya = objstr.readBoolean();
        double ymi = objstr.readDouble();
        double yma = objstr.readDouble();
        String zstr = objstr.readUTF();
        boolean za = objstr.readBoolean();
        double zmi = objstr.readDouble();
        double zma = objstr.readDouble();
        boolean as = objstr.readBoolean();
        this.achse1Anp = xa;
        this.achse2Anp = ya;
        this.achse3Anp = za;
        this.XMin = xmi;
        this.XMax = xma;
        this.YMin = ymi;
        this.YMax = yma;
        this.ZMin = zmi;
        this.ZMax = zma;
        this.achseSichtbar = as;
        this.setAuftragungsStrings(GreekLetterConstPanel.repairCDot(xstr), GreekLetterConstPanel.repairCDot(ystr), GreekLetterConstPanel.repairCDot(zstr));
        this.phi = objstr.readDouble();
        this.theta = objstr.readDouble();
        this.gamma = objstr.readDouble();
        this.scalefactor = objstr.readDouble();
        double xfak = objstr.readDouble();
        double yfak = objstr.readDouble();
        this.sf = GUIDevice.getDisplayScalingFactor(this.diagramm);
        this.xoffset = (int)(xfak * (double)this.diagramm.getWidth() * this.sf);
        this.yoffset = (int)(yfak * (double)this.diagramm.getHeight() * this.sf);
        this.oldwidth = (int)((double)this.diagramm.getWidth() * this.sf);
        this.oldheight = (int)((double)this.diagramm.getHeight() * this.sf);
        if ((double)datversion > 2.3) {
            this.showPlane1 = objstr.readBoolean();
            this.showPlane2 = objstr.readBoolean();
            this.showPlane3 = objstr.readBoolean();
            this.legendX = objstr.readInt();
            this.legendY = objstr.readInt();
        }
    }

    @Override
    public void writeData(ObjectOutputStream objstr) throws Exception {
        objstr.writeUTF(this.varXStr);
        objstr.writeBoolean(this.achse1Anp);
        objstr.writeDouble(this.XMin);
        objstr.writeDouble(this.XMax);
        objstr.writeUTF(this.varYStr);
        objstr.writeBoolean(this.achse2Anp);
        objstr.writeDouble(this.YMin);
        objstr.writeDouble(this.YMax);
        objstr.writeUTF(this.varZStr);
        objstr.writeBoolean(this.achse3Anp);
        objstr.writeDouble(this.ZMin);
        objstr.writeDouble(this.ZMax);
        objstr.writeBoolean(this.achseSichtbar);
        objstr.writeDouble(this.phi);
        objstr.writeDouble(this.theta);
        objstr.writeDouble(this.gamma);
        objstr.writeDouble(this.scalefactor);
        objstr.writeDouble((double)this.xoffset * 1.0 / (double)this.ks_image.getWidth());
        objstr.writeDouble((double)this.yoffset * 1.0 / (double)this.ks_image.getHeight());
        objstr.writeBoolean(this.showPlane1);
        objstr.writeBoolean(this.showPlane2);
        objstr.writeBoolean(this.showPlane3);
        objstr.writeInt(this.legendX);
        objstr.writeInt(this.legendY);
    }
}

