/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import com.singularsys.extensions.xjep.XEvaluator;
import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.parser.TokenMgrError;
import de.didappslib.base.Diagram;
import de.didappslib.base.Document;
import de.didappslib.base.Extras;
import de.didappslib.base.Koordinatensystem;
import de.didappslib.base.Statics;
import de.didappslib.base.ZusatzDef;
import de.didappslib.base.ZusatzDefsAnzeige;
import de.didappslib.calculation.CalcThread;
import de.didappslib.calculation.RungeKutta;
import de.didappslib.guitools.GreekLetterConstPanel;
import de.didappslib.guitools.SuperSlider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Model
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int CALC_DONE = 1;
    public static final int CALC_ERROR = -1;
    public static final int STEP_DONE = 0;
    public static final ResourceBundle rBundle = ResourceBundle.getBundle("de/didappslib/base/resources/Model", Statics.locale);
    public static final String varNamePattern = "[_a-zA-Z\u0391-\u03d5]+[_0-9]*";
    public static final String termPattern = "[\\s\\p{Print}a-zA-Z\u0391-\u03d5\u0207\u0109\u011d\u011c\u0299\u00fb\u0125\u0127\u00d1\u04bd\u00ea\u00e9\u0271\u1e3f]*";
    public final RungeKutta rk = new RungeKutta();
    public Document document;
    public int dimension = 1;
    public int DGLNVAR;
    public int WERTENVAR;
    public int verfahren;
    public double genauigkeit;
    public boolean editierbar;
    public ZusatzDefsAnzeige zdefs;
    public CalcThread berechnung;
    public XJep parser;
    public ArrayList<Node> parserNodeList = new ArrayList();
    public ArrayList<SuperSlider> sliderListe = new ArrayList();
    public ArrayList<String> fktVariableNames = new ArrayList();
    public double tAnfang;
    public double tEnde;
    public double delta_t = 0.2;
    public double tstern;
    public String varName = "t";
    public String var0Name = "t\u2080";
    public String dVarName = "dt";
    public String deltaVarName = "\u0394t";
    public int stepNummer;
    public int auswahlStep;
    public int werteAuslassenAnz;
    public boolean ersteWerteAuslassen;
    public Node abbruchBedingung;
    public boolean calcSlomo;
    public boolean calcFromSlider;
    public boolean hasFinishedCorrectly;
    public double[] PhaseVector;
    public double[] PhaseVectorNeu;
    public double[] PhaseVectorStern;
    public double[][] wertetabelleAlt;
    public double[][] wertetabelle;
    public int werteAltAnzahl;
    public int werteAnzahl;

    public Model(Document prj) {
        this.document = prj;
    }

    public void setEditierbar(boolean bool) {
    }

    public JButton getAddKonstButton() {
        return null;
    }

    public JTextField getErsteField() {
        return null;
    }

    public void startwerteSetzen(double[] werte) {
    }

    public void konstanteHinzu(String n, double v, double mi, double ma) {
        SuperSlider slider = new SuperSlider(GreekLetterConstPanel.factorASCIIStr(n), v, mi, ma, this.document.getViewer());
        slider.resize(Statics.prefsDialog.guiScale);
        this.sliderListe.add(slider);
        this.updateParamPanel(this.getParamPanel(), this.getAddKonstButton());
    }

    public void konstanteWeg(SuperSlider slider) {
        this.sliderListe.remove(slider);
        this.updateParamPanel(this.getParamPanel(), this.getAddKonstButton());
    }

    public void setZusatzDefsButton() {
    }

    public void setZusatzDefsButton(JLabel zusatzDefsLabel, JButton zusatzDefsButton) {
        if (this.zdefs.defListe.isEmpty()) {
            zusatzDefsLabel.setText(Statics.prg_Bundle.getString("Zus\u00e4tzliche_Definitionen"));
            if (this.editierbar) {
                zusatzDefsButton.setText(Statics.prg_Bundle.getString("hinzuf\u00fcgen..."));
                zusatzDefsButton.setEnabled(true);
            } else {
                zusatzDefsButton.setText("---");
                zusatzDefsButton.setEnabled(false);
            }
        } else {
            zusatzDefsLabel.setText(Statics.prg_Bundle.getString("Zus\u00e4tzliche_Definitionen") + "  \u2714");
            if (this.editierbar) {
                zusatzDefsButton.setText(Statics.prg_Bundle.getString("bearbeiten..."));
                zusatzDefsButton.setEnabled(true);
            } else {
                zusatzDefsButton.setText(Statics.prg_Bundle.getString("anzeigen..."));
                zusatzDefsButton.setEnabled(true);
            }
        }
    }

    public int checkSlidersForChange() {
        int i = 0;
        for (SuperSlider s : this.sliderListe) {
            if (s.checkSlider()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public JPanel getParamPanel() {
        return null;
    }

    public void panelResized() {
    }

    public void parameterPanelPropertyChanged(PropertyChangeEvent evt) {
        if (evt.getPropertyName().startsWith("NameChanged")) {
            this.werteAuslesen(false);
            this.document.setChanged(true);
        }
        if (evt.getPropertyName().startsWith("ActionEvent") && this.checkSlidersForChange() >= 0) {
            this.document.setChanged(true);
            if (this.document.autoCalc) {
                this.startCalculation();
            }
        }
        if (evt.getPropertyName().startsWith("SuperSliderValueChanged") && this.checkSlidersForChange() >= 0) {
            this.document.setChanged(true);
            if (this.document.autoCalc) {
                this.startCalculationSlider();
            }
        }
        if (evt.getPropertyName().startsWith("MouseReleasedSuperSliderValueChanged")) {
            this.document.setChanged(true);
            this.document.getModel().startCalculationSlider();
        }
        if (evt.getPropertyName().startsWith("Deleted")) {
            String ss = evt.getPropertyName().substring(8);
            for (SuperSlider sliderListe1 : this.sliderListe) {
                if (!sliderListe1.getName().equals(ss)) continue;
                this.konstanteWeg(sliderListe1);
                this.werteAuslesen(false);
                break;
            }
        }
    }

    public void updateParamPanel(JPanel paramPanel, JButton addKonstButton) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 18;
        SuperSlider slider = null;
        paramPanel.removeAll();
        int i = 0;
        while (i < this.sliderListe.size()) {
            slider = this.sliderListe.get(i);
            gridBagConstraints.gridy = i++;
            gridBagConstraints.fill = 2;
            paramPanel.add((Component)slider, gridBagConstraints);
        }
        if (this.document.isEditierbar()) {
            gridBagConstraints.fill = 0;
            if (slider == null) {
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(2, 2, 0, 0);
                paramPanel.add((Component)addKonstButton, gridBagConstraints);
            } else {
                slider.adjustAddKonstButton(addKonstButton);
            }
        }
        addKonstButton.setEnabled(this.document.isEditierbar());
        if (this.document.getViewer() != null) {
            this.document.getViewer().validateSidebar();
        }
        this.document.setChanged(true);
    }

    public void dgl(double t, double[] y, double[] ys) throws Exception {
    }

    public void neu() {
    }

    public boolean createWertetabelle() {
        if (this.document.errorOccured()) {
            this.werteAnzahl = 0;
            this.wertetabelle = new double[0][this.WERTENVAR + this.document.getCustomTable().extraSpaltenNamen.size()];
            return false;
        }
        int len = (int)Math.ceil(((this.tEnde - this.tAnfang) / this.delta_t - (double)this.werteAuslassenAnz) / (double)this.auswahlStep) + 1;
        if (len < 2) {
            this.document.errorMsg(rBundle.getString("Die_Wertetabelle_kann_nicht_angelegt_werden!"), rBundle.getString("Fehler_im_Feld_fuer_die_Angabe_der_zu_ueberspringenden_ersten_Werte!"), this.getErsteField(), true);
            len = 1;
        }
        if (this.wertetabelle == null || this.wertetabelle.length != len || this.wertetabelle[0].length != this.WERTENVAR + this.document.getCustomTable().extraSpaltenNamen.size()) {
            try {
                this.wertetabelle = new double[len][this.WERTENVAR + this.document.getCustomTable().extraSpaltenNamen.size()];
            }
            catch (OutOfMemoryError err) {
                this.document.errorMsg(rBundle.getString("Java_Speicherfehler!"), rBundle.getString("Anzahl_verringern"), null, true);
                this.werteAnzahl = 0;
                this.wertetabelle = new double[0][this.WERTENVAR + this.document.getCustomTable().extraSpaltenNamen.size()];
                return false;
            }
        }
        return true;
    }

    public boolean initWertetabelle() {
        return false;
    }

    private XJep parserNeu() {
        XJep p = new XJep();
        ((XEvaluator)p.getEvaluator()).setForce(true);
        p.setAllowUndeclared(true);
        p.setAllowAssignment(true);
        p.setImplicitMul(true);
        p.getVariableTable().remove("i");
        try {
            p.addFunction("sgn", new SgnFunc());
            p.addFunction("abs", new AbsFunc());
            p.addConstant("pi", Math.PI);
            p.addConstant("\u03c0", Math.PI);
            p.addConstant("\u0207", Math.E);
            p.addConstant("\u0109", 299792458);
            p.addConstant("\u011d", 9.80665);
            p.addConstant("\u011c", 6.6743E-11);
            p.addConstant("\u03bc_0", 1.25663706212E-6);
            p.addConstant("\u03bc\u0299", 9.2740100783E-7);
            p.addConstant("\u03b5_0", 8.8541878128E-12);
            p.addConstant("qe", 1.602176634E-19);
            p.addConstant("me", 9.1093837015E-31);
            p.addConstant("mp", 1.67262192369E-27);
            p.addConstant("mn", 1.67492749804E-27);
            p.addConstant("m\u03b1", 6.6446573357E-27);
            p.addConstant("m\u03bc", 1.883531627E-28);
            p.addConstant("\u00fb", 1.6605390666E-27);
            p.addConstant("\u0125", 6.62607015E-34);
            p.addConstant("\u0127", 1.054571817E-34);
            p.addConstant("k\u0299", 1.380649E-23);
            p.addConstant("\u00d1", 6.02214076E23);
            p.addConstant("\u04bd", Math.E);
            p.addConstant("\u00ea", 1.602176462E-19);
            p.addConstant("q_el", 1.602176462E-19);
            p.addConstant("\u00e9", 1.602176462E-19);
            p.addConstant("m_el", 9.10938188E-31);
            p.addConstant("m\u0302", 9.10938188E-31);
            p.addConstant("\u0271", 9.10938188E-31);
            p.addConstant("\u1e3f", 9.10938188E-31);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fktVariableNames.clear();
        return p;
    }

    public void parseFunction(String ss) throws JepException {
        String fktName = ss.substring(0, ss.indexOf("("));
        String[] args = ss.substring(ss.indexOf("(") + 1, ss.indexOf(")")).split(",");
        String fktTerm = ss.substring(ss.indexOf("=") + 1);
        MyNaryFunction fkt = new MyNaryFunction(fktName, args.length, args, fktTerm, this.parser);
        this.parser.addFunction(GreekLetterConstPanel.refactorStr(fktName), fkt);
    }

    public boolean werteAuslesen(boolean verbose) {
        Statics.print("Werte auslesen...");
        this.document.clrError();
        this.parser = this.parserNeu();
        this.parserNodeList.clear();
        if (!this.sliderParsen(verbose)) {
            return false;
        }
        if (!this.zdefsParsen1(verbose)) {
            return false;
        }
        if (!this.zdefsParsen2(verbose)) {
            return false;
        }
        if (!this.modellParsen(verbose)) {
            return false;
        }
        if (!this.startwerteParsen(verbose)) {
            return false;
        }
        if (!this.zeitenParsen(verbose)) {
            return false;
        }
        if (!this.zusatzParsen(verbose)) {
            return false;
        }
        if (!this.doTestCalculations(verbose)) {
            return false;
        }
        this.document.checkDefaultAuftragungsStrings();
        Statics.println("done.");
        return true;
    }

    public boolean sliderParsen(boolean verbose) {
        if (this.parser == null || this.document.getExtras() == null) {
            return false;
        }
        SuperSlider slider = null;
        this.document.getExtras().sliderListe.forEach(slider1 -> this.parser.getVariableTable().remove(slider1.getName()));
        try {
            Iterator<SuperSlider> iterator = this.sliderListe.iterator();
            while (iterator.hasNext()) {
                SuperSlider slider12;
                slider = slider12 = iterator.next();
                double d = Statics.textFieldToDouble(slider.getValueField(), false);
                this.parser.addVariable(slider.getName().trim(), d);
                if (!("" + d).equals("NaN")) {
                    this.document.clrErrColor(slider.getValueField());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.document.errorMsg(rBundle.getString("Fehler_bei_einem_veraenderbaren_Parameter!"), e.getMessage(), slider.getValueField(), verbose);
            return false;
        }
        this.document.getExtras().sliderListe.stream().map(slider1 -> {
            if (this.parser.getVariableValue(slider1.getName()) != null) {
                this.document.warningMsg(Extras.rbundle.getString("Warnung"), "Der Funktionsparameter '" + slider1.getName() + "' ist mehrfach definiert.");
            }
            return slider1;
        }).map(slider1 -> {
            try {
                this.parser.addVariable(slider1.getName(), slider1.getValue());
            }
            catch (JepException jepException) {
                // empty catch block
            }
            return slider1;
        }).forEachOrdered(slider1 -> this.document.clrErrColor(slider1.getValueField()));
        return true;
    }

    public boolean zdefsParsen1(boolean verbose) {
        for (ZusatzDef zd : this.zdefs.defListe) {
            if (zd.art.equals(ZusatzDef.RBUNDLE.getString("Bedingte_Var"))) continue;
            zd.parse(this.document, this.parser, this.zdefs, verbose);
        }
        return true;
    }

    public boolean zdefsParsen2(boolean verbose) {
        for (ZusatzDef zd : this.zdefs.defListe) {
            if (!zd.art.equals(ZusatzDef.RBUNDLE.getString("Bedingte_Var"))) continue;
            zd.parse(this.document, this.parser, this.zdefs, verbose);
        }
        return true;
    }

    public boolean modellParsen(boolean verbose) {
        return false;
    }

    public boolean startwerteParsen(boolean verbose) {
        return false;
    }

    public boolean zeitenParsen(boolean verbose) {
        return false;
    }

    public boolean zeitenParsen(JTextField t0Field, JTextField deltatField, JTextField dtField, JTextField nField, boolean verbose) {
        Node node;
        try {
            node = this.parser.parse(GreekLetterConstPanel.refactorTF(t0Field));
            this.parser.preprocess(node);
            this.tAnfang = (Double)this.parser.evaluate(node);
            this.document.clrErrColor(t0Field);
        }
        catch (StackOverflowError e) {
            this.document.errorMsg("", "", t0Field, false);
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(rBundle.getString("Fehler_im_Feld") + this.var0Name + "!", Statics.translateErrMsg(e.getMessage()), t0Field, verbose);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(rBundle.getString("Fehler_im_Feld") + this.var0Name + "!", Statics.translateErrMsg(e.getMessage()), t0Field, verbose);
            return false;
        }
        try {
            node = this.parser.parse(GreekLetterConstPanel.refactorTF(deltatField));
            this.parser.preprocess(node);
            this.tEnde = this.tAnfang + (Double)this.parser.evaluate(node);
            this.document.clrErrColor(deltatField);
        }
        catch (StackOverflowError e) {
            this.document.errorMsg("", "", deltatField, false);
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(rBundle.getString("Fehler_im_Feld") + this.deltaVarName + "!", Statics.translateErrMsg(e.getMessage()), deltatField, verbose);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(rBundle.getString("Fehler_im_Feld") + this.deltaVarName + "!", Statics.translateErrMsg(e.getMessage()), deltatField, verbose);
            return false;
        }
        try {
            node = this.parser.parse(GreekLetterConstPanel.refactorTF(dtField));
            this.parser.preprocess(node);
            this.delta_t = (Double)this.parser.evaluate(node);
            this.document.clrErrColor(dtField);
            nField.setText("" + (long)Math.ceil((this.tEnde - this.tAnfang) / this.delta_t));
        }
        catch (StackOverflowError e) {
            this.document.errorMsg("", "", dtField, false);
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(rBundle.getString("Fehler_im_Feld") + this.dVarName + "!", Statics.translateErrMsg(e.getMessage()), dtField, verbose);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(rBundle.getString("Fehler_im_Feld") + this.dVarName + "!", Statics.translateErrMsg(e.getMessage()), dtField, verbose);
            return false;
        }
        return true;
    }

    public boolean zusatzParsen(boolean verbose) {
        return false;
    }

    public boolean zusatzParsen(JTextField abbrBedField, JCheckBox auswahlCB, JTextField auswahlField, JCheckBox ersteCB, JTextField ersteField, boolean verbose) {
        Node node;
        String s = "1<0";
        if (abbrBedField.getText().length() != 0) {
            s = GreekLetterConstPanel.refactorTF(abbrBedField);
        }
        try {
            this.abbruchBedingung = this.parser.parse(s);
            this.parser.preprocess(this.abbruchBedingung);
            this.document.clrErrColor(abbrBedField);
        }
        catch (TokenMgrError e) {
            this.document.errorMsg(rBundle.getString("Fehler_bei_der_Analyse_der_Abbruchbedingung!"), Statics.translateErrMsg(e.getMessage()), abbrBedField, verbose);
            return false;
        }
        catch (Exception e) {
            this.document.errorMsg(rBundle.getString("Fehler_bei_der_Analyse_der_Abbruchbedingung!"), Statics.translateErrMsg(e.getMessage()), abbrBedField, verbose);
            return false;
        }
        this.document.clrErrColor(auswahlField);
        if (auswahlCB.isSelected()) {
            try {
                node = this.parser.parse(GreekLetterConstPanel.refactorTF(auswahlField));
                this.parser.preprocess(node);
                this.auswahlStep = ((Double)this.parser.evaluate(node)).intValue();
            }
            catch (Exception e) {
                this.document.errorMsg(rBundle.getString("Fehler_im_Feld_fuer_die_Angabe_der_zu_ueberspringenden_Werte!"), e.getMessage(), auswahlField, verbose);
                return false;
            }
        } else {
            this.auswahlStep = 1;
        }
        if (this.auswahlStep <= 0) {
            this.auswahlStep = 1;
        }
        this.document.clrErrColor(ersteField);
        if (ersteCB.isSelected()) {
            try {
                node = this.parser.parse(GreekLetterConstPanel.refactorTF(ersteField));
                this.parser.preprocess(node);
                this.werteAuslassenAnz = ((Double)this.parser.evaluate(node)).intValue();
            }
            catch (Exception e) {
                this.document.errorMsg(rBundle.getString("Fehler_im_Feld_fuer_die_Angabe_der_zu_ueberspringenden_ersten_Werte!"), e.getMessage(), ersteField, verbose);
                return false;
            }
        } else {
            this.werteAuslassenAnz = 0;
        }
        return true;
    }

    public boolean doTestCalculations(boolean verbose) {
        return false;
    }

    public boolean initBerechnung() {
        this.document.setErrorOccured(false);
        if (!this.werteAuslesen(false)) {
            return false;
        }
        this.initWertetabelle();
        if (this.wertetabelle.length < 1) {
            return false;
        }
        this.document.getModelTable().updateTab();
        this.document.getCustomTable().updateTab();
        this.rk.rkinit(this, false, this.DGLNVAR, this.genauigkeit, this.tEnde + this.delta_t, this.delta_t);
        this.PhaseVector = new double[this.DGLNVAR + 1];
        this.PhaseVector[this.DGLNVAR] = this.wertetabelle[0][0];
        for (int j = 0; j < this.DGLNVAR; ++j) {
            this.PhaseVector[j] = this.wertetabelle[0][j + 1];
        }
        for (int i = 0; i < this.document.getModelTable().extraSpaltenNamen.size(); ++i) {
            try {
                Node node = this.parser.parse(GreekLetterConstPanel.refactorStr(this.document.getModelTable().extraSpaltenNamen.get(i)));
                this.parser.preprocess(node);
                this.wertetabelle[0][this.dimension + i + 1] = (Double)this.parser.evaluate(node);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tstern = this.tAnfang + this.delta_t;
        this.stepNummer = 0;
        this.document.getDiagramm().plotAll = true;
        return true;
    }

    public void addModelVarsToParser(double[] values) throws JepException {
    }

    public void startwerteSetzenAusSelektion(int row) {
        int anzalt = 0;
        try {
            anzalt = this.wertetabelleAlt.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (row < anzalt) {
            this.startwerteSetzen(this.wertetabelleAlt[row]);
        } else {
            this.startwerteSetzen(this.wertetabelle[row - anzalt]);
        }
        this.sichereWertetabelle(row);
        this.clearData(1);
        if (this.document.getViewer() != null && this.document.getViewer().getAktTable() != null) {
            this.document.getViewer().getAktTable().updateTab();
        }
    }

    public void startCalcThread(boolean immediateButtonFeedback) {
        Statics.println("Berechnung starten aufgerufen");
        this.stopCalculation(false);
        if (this.initBerechnung()) {
            if (!this.calcSlomo && (this.tEnde - this.tAnfang) / this.delta_t < 10001.0) {
                while (this.calcStep() == 0) {
                }
                this.calculationHasFinished(true);
                this.getProjekt().getDiagramm().updateDiagramPlus();
                return;
            }
            this.document.getViewer().startBusyTimer(immediateButtonFeedback);
            this.berechnung = new CalcThread(this);
            this.berechnung.execute();
        }
    }

    public void startCalculation() {
        this.calcSlomo = false;
        this.calcFromSlider = false;
        this.startCalcThread(true);
    }

    public void startCalculationSlomo() {
        this.calcSlomo = true;
        this.calcFromSlider = false;
        this.startCalcThread(true);
    }

    public void startCalculationSlider() {
        this.calcSlomo = false;
        this.calcFromSlider = true;
        this.startCalcThread(false);
    }

    public void stopCalculation(boolean clearIfBreak) {
        int i = 0;
        Statics.println("try to stop calc...");
        if (this.berechnung == null) {
            return;
        }
        while (this.isCalculating() || this.document.getViewer().isUpdating()) {
            ++i;
            this.berechnung.cancel(true);
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Statics.println("calc stopped (" + i + ")trys.");
        this.document.getDiagramm().stopSlomoAnimation();
    }

    public void calculationHasFinished(boolean correctly) {
        this.hasFinishedCorrectly = correctly;
        if (!correctly) {
            return;
        }
        this.sliderListe.forEach(s -> s.setSavedSliderValueToAktSliderValue());
    }

    public boolean hasCalcFinishedCorrectly() {
        return this.hasFinishedCorrectly;
    }

    public boolean isCalculating() {
        if (this.berechnung == null) {
            return false;
        }
        return !this.berechnung.isDone();
    }

    public void insertAccel() throws Exception {
    }

    public int calcStep() {
        boolean abbruch;
        if (this.wertetabelle == null || this.wertetabelle.length < 1) {
            return -1;
        }
        if (this.tstern - this.delta_t / 2.0 > this.tEnde) {
            return 1;
        }
        ++this.stepNummer;
        try {
            this.addModelVarsToParser(this.wertetabelle[this.werteAnzahl - 1]);
            abbruch = (Boolean)this.parser.evaluate(this.abbruchBedingung);
        }
        catch (Exception e) {
            this.document.errorMsg(rBundle.getString("Fehler_bei_der_Abbruchbedingung!"), e.toString() + "\n" + e.getMessage(), null, true);
            e.printStackTrace();
            return -1;
        }
        if (abbruch) {
            return 1;
        }
        if (this.verfahren == 3 && this.tstern >= this.PhaseVector[this.DGLNVAR]) {
            try {
                do {
                    this.PhaseVectorNeu = this.rk.rkstep(this.PhaseVector[this.DGLNVAR], this.PhaseVector);
                    if (this.PhaseVectorNeu[this.DGLNVAR] == Double.NaN) {
                        this.parser = null;
                        return -1;
                    }
                    System.arraycopy(this.PhaseVectorNeu, 0, this.PhaseVector, 0, this.PhaseVector.length);
                } while (this.PhaseVector[this.DGLNVAR] <= this.tstern && !this.document.errorOccured());
            }
            catch (Exception e) {
                this.document.errorMsg(rBundle.getString("Fehler_beim_RKPLUS-Integrationsschritt!"), e.toString() + "\n" + e.getMessage(), null, true);
                return -1;
            }
        }
        if (this.DGLNVAR > 0) {
            try {
                switch (this.verfahren) {
                    case 0: {
                        this.PhaseVectorStern = this.rk.eulerstep(this.PhaseVector[this.DGLNVAR], this.PhaseVector);
                        System.arraycopy(this.PhaseVectorStern, 0, this.PhaseVector, 0, this.PhaseVector.length);
                        break;
                    }
                    case 1: {
                        this.PhaseVectorStern = this.rk.heunstep(this.PhaseVector[this.DGLNVAR], this.PhaseVector);
                        System.arraycopy(this.PhaseVectorStern, 0, this.PhaseVector, 0, this.PhaseVector.length);
                        break;
                    }
                    case 2: {
                        this.PhaseVectorStern = this.rk.rkstdstep(this.PhaseVector[this.DGLNVAR], this.PhaseVector);
                        System.arraycopy(this.PhaseVectorStern, 0, this.PhaseVector, 0, this.PhaseVector.length);
                        break;
                    }
                    case 3: {
                        this.PhaseVectorStern = this.rk.rkipol(this.tstern);
                        break;
                    }
                    case 5: {
                        this.PhaseVectorStern = this.rk.iteration(this.PhaseVector[this.DGLNVAR], this.PhaseVector);
                        System.arraycopy(this.PhaseVectorStern, 0, this.PhaseVector, 0, this.PhaseVector.length);
                    }
                }
                this.insertAccel();
            }
            catch (Exception ex) {
                this.document.errorMsg(rBundle.getString("Fehler_beim_Rechenschritt!"), ex.getMessage(), null, true);
                return -1;
            }
        }
        if (this.stepNummer % this.auswahlStep == 0 && this.stepNummer >= this.werteAuslassenAnz) {
            if (this.ersteWerteAuslassen && this.stepNummer <= this.werteAuslassenAnz + this.auswahlStep) {
                this.werteAnzahl = 1;
            }
            this.wertetabelle[this.werteAnzahl][0] = this.tstern;
            if (this.PhaseVectorStern != null) {
                System.arraycopy(this.PhaseVectorStern, 0, this.wertetabelle[this.werteAnzahl], 1, this.DGLNVAR);
            }
            int i = 0;
            try {
                if (this.verfahren == 5) {
                    this.addModelVarsToParser(this.wertetabelle[this.werteAnzahl]);
                }
                for (i = 0; i < this.document.getCustomTable().extraSpaltenNamen.size(); ++i) {
                    Node node = this.parser.parse(GreekLetterConstPanel.refactorStr(this.document.getCustomTable().extraSpaltenNamen.get(i)));
                    this.parser.preprocess(node);
                    this.wertetabelle[this.werteAnzahl][this.WERTENVAR + i] = (Double)this.parser.evaluate(node);
                }
            }
            catch (Exception ex) {
                this.document.errorMsg(rBundle.getString("Fehler_beim_Berechnen_der_Wertetabelle!"), ex.toString() + "\n" + ex.getMessage(), null, false);
                this.wertetabelle[this.werteAnzahl][this.WERTENVAR + i] = Double.NaN;
            }
            for (i = 0; i < this.wertetabelle[0].length; ++i) {
                if (Double.isNaN(this.wertetabelle[this.werteAnzahl][i])) {
                    this.document.errorMsg(rBundle.getString("ungueltiger_Zahlenwert"), rBundle.getString("ein_Wert_ist_ungueltig"), null, false);
                    break;
                }
                if (!Double.isInfinite(this.wertetabelle[this.werteAnzahl][i])) continue;
                this.document.errorMsg(rBundle.getString("ungueltiger_Zahlenwert"), rBundle.getString("ein_Wert_ist_unendlich"), null, false);
                break;
            }
            ++this.werteAnzahl;
        }
        this.tstern += this.delta_t;
        return 0;
    }

    public void generierePlotArray(Koordinatensystem ks) {
    }

    public void zeichnePunkt(Graphics g, Point point, float pGr, int art) {
        int pGri = (int)pGr;
        int pGr2 = (int)(pGr / 2.0f);
        int pGr7 = (int)((double)pGr * 0.7);
        int[] dreieckKoX = new int[]{0, 0, 0};
        int[] dreieckKoY = new int[]{0, 0, 0};
        int[] dreieckKoX_ = new int[]{-pGr7, pGr7, 0};
        int[] dreieckKoY_ = new int[]{pGr7, pGr7, -pGr7};
        int[] rauteKoX = new int[]{0, 0, 0, 0};
        int[] rauteKoY = new int[]{0, 0, 0, 0};
        int[] rauteKoX_ = new int[]{-pGr7, 0, pGr7, 0};
        int[] rauteKoY_ = new int[]{0, pGr7, 0, -pGr7};
        switch (art) {
            case 1: {
                int i;
                for (i = 0; i < dreieckKoX.length; ++i) {
                    dreieckKoX[i] = dreieckKoX_[i] + point.x;
                }
                for (i = 0; i < dreieckKoY.length; ++i) {
                    dreieckKoY[i] = dreieckKoY_[i] + point.y - 1;
                }
                g.fillPolygon(dreieckKoX, dreieckKoY, 3);
                break;
            }
            case 2: {
                g.fillRect(point.x - pGr2, point.y - pGr2, pGri, pGri);
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < rauteKoX.length; ++i) {
                    rauteKoX[i] = rauteKoX_[i] + point.x;
                }
                for (i = 0; i < rauteKoY.length; ++i) {
                    rauteKoY[i] = rauteKoY_[i] + point.y;
                }
                g.fillPolygon(rauteKoX, rauteKoY, 4);
                break;
            }
            case 4: {
                int i;
                for (i = 0; i < dreieckKoX.length; ++i) {
                    dreieckKoX[i] = dreieckKoX_[i] + point.x;
                }
                for (i = 0; i < dreieckKoY.length; ++i) {
                    dreieckKoY[i] = -dreieckKoY_[i] + point.y + 1;
                }
                g.fillPolygon(dreieckKoX, dreieckKoY, 3);
                break;
            }
            case 10: {
                g.drawOval(point.x - pGr2, point.y - pGr2, pGri, pGri);
                break;
            }
            case 11: {
                int i;
                for (i = 0; i < dreieckKoX.length; ++i) {
                    dreieckKoX[i] = dreieckKoX_[i] + point.x;
                }
                for (i = 0; i < dreieckKoY.length; ++i) {
                    dreieckKoY[i] = dreieckKoY_[i] + point.y - 1;
                }
                g.drawPolygon(dreieckKoX, dreieckKoY, 3);
                break;
            }
            case 12: {
                g.drawRect(point.x - pGr2, point.y - pGr2, pGri, pGri);
                break;
            }
            case 13: {
                int i;
                for (i = 0; i < rauteKoX.length; ++i) {
                    rauteKoX[i] = rauteKoX_[i] + point.x;
                }
                for (i = 0; i < rauteKoY.length; ++i) {
                    rauteKoY[i] = rauteKoY_[i] + point.y;
                }
                g.drawPolygon(rauteKoX, rauteKoY, 4);
                break;
            }
            case 14: {
                int i;
                for (i = 0; i < dreieckKoX.length; ++i) {
                    dreieckKoX[i] = dreieckKoX_[i] + point.x;
                }
                for (i = 0; i < dreieckKoY.length; ++i) {
                    dreieckKoY[i] = -dreieckKoY_[i] + point.y + 1;
                }
                g.drawPolygon(dreieckKoX, dreieckKoY, 3);
                break;
            }
            default: {
                g.fillOval(point.x - pGr2, point.y - pGr2, pGri, pGri);
            }
        }
    }

    public void zeichne(Koordinatensystem ks, Graphics g, int vonPercentage, int toPercentage, boolean fromSlider) {
        int bisIndex;
        if (ks.plotArray.length == 0 || ks.plotArray.length < this.werteAltAnzahl + this.werteAnzahl) {
            return;
        }
        float gscale = Statics.prefsDialog.graphicsScale * ks.getScale();
        float pGr = (float)this.document.punktGroesse * gscale * 1.1f;
        float lSt = (float)this.document.linienStaerke * gscale;
        int pGri = (int)pGr;
        int pGr2 = (int)(pGr / 2.0f);
        ((Graphics2D)g).setStroke(new BasicStroke(lSt));
        Color zeichenFarbe = Diagram.colorArray[this.document.zeichFarbIndex];
        Color heller = new Color(zeichenFarbe.getRed(), zeichenFarbe.getGreen(), zeichenFarbe.getBlue(), 120);
        int plotStartIndex = (int)((double)(vonPercentage * this.werteAnzahl) / 100.0);
        if (plotStartIndex > 0 && !fromSlider) {
            --plotStartIndex;
        }
        if (this.werteAuslassenAnz > 0 && this.werteAnzahl > 1) {
            plotStartIndex = 1;
        }
        if (this.werteAltAnzahl > 0) {
            plotStartIndex += this.werteAltAnzahl;
        }
        if ((bisIndex = (int)((double)(toPercentage * this.werteAnzahl) / 100.0) + this.werteAltAnzahl) < 0) {
            bisIndex = 0;
        }
        for (int hAchsVarNr = 0; hAchsVarNr < ks.ynodes.size(); ++hAchsVarNr) {
            int row;
            Point point;
            Point pointAlt = ks.XyToImage(ks.getPlotValueX(0), ks.getPlotValueY(0, hAchsVarNr));
            g.setColor(Color.WHITE);
            g.fillOval(pointAlt.x - pGr2, pointAlt.y - pGr2, pGri, pGri);
            g.setColor(heller);
            g.fillOval(pointAlt.x - pGr2, pointAlt.y - pGr2, pGri, pGri);
            for (int i = 0; i < this.werteAltAnzahl; ++i) {
                point = ks.XyToImage(ks.getPlotValueX(i), ks.getPlotValueY(i, hAchsVarNr));
                if (point.x != pointAlt.x || point.y != pointAlt.y) {
                    if (this.document.linienStaerke > 0) {
                        g.setColor(Color.WHITE);
                        g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                        g.setColor(heller);
                        g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                    }
                    if (this.document.punktGroesse > 0) {
                        g.setColor(Color.WHITE);
                        this.zeichnePunkt(g, point, pGr, hAchsVarNr);
                        g.setColor(heller);
                        this.zeichnePunkt(g, point, pGr, hAchsVarNr);
                    }
                }
                pointAlt = point;
            }
            point = ks.XyToImage(ks.getPlotValueX(this.werteAltAnzahl), ks.getPlotValueY(this.werteAltAnzahl, hAchsVarNr));
            g.setColor(Color.WHITE);
            g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
            g.setColor(heller);
            g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
            pointAlt = ks.XyToImage(ks.getPlotValueX(plotStartIndex), ks.getPlotValueY(plotStartIndex, hAchsVarNr));
            g.setColor(zeichenFarbe);
            this.zeichnePunkt(g, pointAlt, pGr, hAchsVarNr);
            for (int j = plotStartIndex + 1; j < bisIndex; ++j) {
                point = ks.XyToImage(ks.getPlotValueX(j), ks.getPlotValueY(j, hAchsVarNr));
                if (point.x == pointAlt.x && point.y == pointAlt.y) continue;
                if (this.document.linienStaerke > 0) {
                    g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                }
                if (this.document.punktGroesse > 0 && point.y != Integer.MAX_VALUE) {
                    this.zeichnePunkt(g, point, pGr, hAchsVarNr);
                }
                pointAlt = point;
            }
            int[] selectedRows = this.document.getViewer().getAktTable() != null ? this.document.getViewer().getAktTable().tab.getSelectedRows() : this.document.getModelTable().tab.getSelectedRows();
            if (selectedRows.length != 0 && (row = selectedRows[0]) >= plotStartIndex - this.werteAltAnzahl && row <= bisIndex) {
                Color auswahlFarbe = Diagram.colorArray[this.document.auswFarbIndex];
                heller = new Color(auswahlFarbe.getRed(), auswahlFarbe.getGreen(), auswahlFarbe.getBlue(), 120);
                if (row < this.werteAltAnzahl) {
                    g.setColor(heller);
                    pointAlt = ks.XyToImage(ks.getPlotValueX(row), ks.getPlotValueY(row, hAchsVarNr));
                    g.setColor(Color.WHITE);
                    this.zeichnePunkt(g, pointAlt, pGr, hAchsVarNr);
                    g.setColor(heller);
                    this.zeichnePunkt(g, pointAlt, pGr, hAchsVarNr);
                } else {
                    g.setColor(auswahlFarbe);
                    pointAlt = ks.XyToImage(ks.getPlotValueX(row), ks.getPlotValueY(row, hAchsVarNr));
                    this.zeichnePunkt(g, pointAlt, pGr, hAchsVarNr);
                }
                int rowmerke = row;
                for (int i = 1; i < selectedRows.length; ++i) {
                    row = selectedRows[i];
                    if (row < plotStartIndex - this.werteAltAnzahl || row > bisIndex) continue;
                    if (row < this.werteAltAnzahl) {
                        point = ks.XyToImage(ks.getPlotValueX(row), ks.getPlotValueY(row, hAchsVarNr));
                        if ((point.x != pointAlt.x || point.y != pointAlt.y) && row - rowmerke < 2 && this.document.linienStaerke > 0) {
                            g.setColor(Color.WHITE);
                            g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                            g.setColor(heller);
                            g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                        }
                        g.setColor(Color.WHITE);
                        this.zeichnePunkt(g, point, pGr, hAchsVarNr);
                        g.setColor(heller);
                        this.zeichnePunkt(g, point, pGr, hAchsVarNr);
                    } else {
                        g.setColor(auswahlFarbe);
                        point = ks.XyToImage(ks.getPlotValueX(row), ks.getPlotValueY(row, hAchsVarNr));
                        if ((point.x != pointAlt.x || point.y != pointAlt.y) && row - rowmerke < 2 && this.document.linienStaerke > 0) {
                            if (row == this.werteAltAnzahl) {
                                g.setColor(Color.WHITE);
                                g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                                g.setColor(heller);
                                g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                                g.setColor(auswahlFarbe);
                            } else {
                                g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                            }
                        }
                        this.zeichnePunkt(g, point, pGr, hAchsVarNr);
                    }
                    pointAlt = point;
                    rowmerke = row;
                }
            }
            point = ks.XyToImage(ks.getPlotValueX(this.werteAltAnzahl), ks.getPlotValueY(this.werteAltAnzahl, hAchsVarNr));
            g.setColor(Color.black);
            this.zeichnePunkt(g, point, pGr + 1.0f, hAchsVarNr + 10);
            if (!fromSlider || toPercentage >= 100) continue;
            if (bisIndex < 1) {
                bisIndex = 1;
            }
            if (bisIndex < this.werteAltAnzahl + 1) {
                bisIndex = this.werteAltAnzahl + 1;
            }
            point = ks.XyToImage(ks.getPlotValueX(bisIndex - 1), ks.getPlotValueY(bisIndex - 1, hAchsVarNr));
            Point point2 = ks.XyToImage(0.0, 0.0);
            g.setColor(Color.black);
            this.zeichnePunkt(g, point, pGr, hAchsVarNr);
            float[] dash1 = new float[]{5.0f * gscale, 2.0f * gscale};
            ((Graphics2D)g).setStroke(new BasicStroke(gscale, 0, 0, gscale, dash1, 0.0f));
            g.setColor(new Color(50, 50, 50));
            g.drawLine(point.x, point.y, point.x, point2.y);
            g.drawLine(point.x, point.y, point2.x, point.y);
        }
    }

    public boolean isInStringListe(ArrayList<String> liste, String s) {
        return liste.stream().anyMatch(el -> el.equals(s));
    }

    public boolean isSliderParameter(String s) {
        return this.sliderListe.stream().anyMatch(slider -> slider.getName().equals(s));
    }

    public void clearData(int how) {
        this.document.getDiagramm().stopSlomoAnimation();
        switch (how) {
            case 0: {
                if (this.werteAnzahl == 1 && this.wertetabelleAlt != null && this.wertetabelleAlt.length > 0) {
                    this.startwerteSetzen(this.wertetabelleAlt[0]);
                    this.wertetabelleAlt = null;
                    this.werteAltAnzahl = 0;
                    this.initWertetabelle();
                    this.document.setChanged(true);
                    break;
                }
                this.initWertetabelle();
                this.document.setChanged(true);
                break;
            }
            case 1: {
                this.initWertetabelle();
                this.document.setChanged(true);
                break;
            }
            case 2: {
                this.startwerteSetzen(this.wertetabelleAlt[0]);
                this.wertetabelleAlt = null;
                this.werteAltAnzahl = 0;
                this.initWertetabelle();
                this.document.setChanged(true);
                break;
            }
        }
        this.document.getDiagramm().updateDiagramPlus();
        this.document.getModelTable().updateTab();
        this.document.getCustomTable().updateTab();
    }

    public void sichereWertetabelle(int toIndex) {
        if (toIndex == -1) {
            return;
        }
        int anzalt = 0;
        if (this.wertetabelleAlt != null) {
            anzalt = this.wertetabelleAlt.length;
        }
        double[][] tab = new double[toIndex][this.wertetabelle[0].length];
        for (int i = 0; i < toIndex; ++i) {
            if (i < anzalt) {
                System.arraycopy(this.wertetabelleAlt[i], 0, tab[i], 0, this.wertetabelle[0].length);
                continue;
            }
            System.arraycopy(this.wertetabelle[i - anzalt], 0, tab[i], 0, this.wertetabelle[0].length);
        }
        this.wertetabelleAlt = tab;
        this.werteAltAnzahl = toIndex;
    }

    public Document getProjekt() {
        return this.document;
    }

    public String getVarName(int i) {
        return "";
    }

    public String[] getSpaltenNamen() {
        String[] spnam = new String[this.WERTENVAR];
        for (int i = 0; i < this.WERTENVAR; ++i) {
            spnam[i] = this.getVarName(i);
        }
        return spnam;
    }

    public String[] getVariableArray() {
        return null;
    }

    public void readData(ObjectInputStream objstr, float datversion, String kennung) throws Exception {
    }

    public void writeData(ObjectOutputStream objstr) throws Exception {
    }

    public void writeSliderList(ObjectOutputStream objstr) throws Exception {
        objstr.writeInt(this.sliderListe.size());
        for (SuperSlider slider : this.sliderListe) {
            objstr.writeUTF(slider.getName());
            objstr.writeDouble(slider.getValue());
            objstr.writeDouble(slider.getMin());
            objstr.writeDouble(slider.getMax());
        }
    }

    public void writeCalculatedValues(ObjectOutputStream objstr) throws Exception {
        int i;
        objstr.writeInt(this.document.getCustomTable().extraSpaltenNamen.size());
        for (String extraSpaltenName : this.document.getCustomTable().extraSpaltenNamen) {
            objstr.writeUTF(extraSpaltenName);
        }
        objstr.writeInt(this.werteAltAnzahl);
        for (i = 0; i < this.werteAltAnzahl; ++i) {
            for (int j = 0; j < this.wertetabelleAlt[0].length; ++j) {
                objstr.writeDouble(this.wertetabelleAlt[i][j]);
            }
        }
        objstr.writeInt(this.werteAnzahl);
        for (i = 0; i < this.werteAnzahl; ++i) {
            for (int j = 0; j < this.wertetabelle[0].length; ++j) {
                objstr.writeDouble(this.wertetabelle[i][j]);
            }
        }
    }

    public void writeTextData(RandomAccessFile f) throws Exception {
        f.writeBytes("\n" + GreekLetterConstPanel.refactorASCIIStr(this.getDataString()));
    }

    public void printTextData(PrintWriter f) throws Exception {
        f.print("\n" + this.getDataString());
    }

    public String getDataString() {
        return "";
    }

    public class MyNaryFunction
    extends NaryFunction {
        private final String myName;
        private final String[] variableNames;
        private final XJep pars;
        private Node node;
        private final String term;
        private boolean alreadyUsed;

        public MyNaryFunction(String name, int argNumber, String[] vNames, String t, XJep p) {
            super(argNumber);
            this.alreadyUsed = false;
            this.myName = name;
            for (String vName : vNames) {
                Model.this.fktVariableNames.add(vName);
            }
            this.variableNames = vNames;
            this.term = t;
            this.pars = p;
        }

        @Override
        public Object eval(Object[] args) throws EvaluationException {
            if (!this.alreadyUsed) {
                Object[] vArr;
                Collection<Variable> vars = Model.this.document.getModel().parser.getVariableTable().getVariables();
                for (Object v : vArr = vars.toArray()) {
                    String s = ((Variable)v).getName();
                    if (!Model.this.fktVariableNames.contains(s)) continue;
                    throw new EvaluationException("Die_Funktionsvariable '" + s + "' wird zugleich im Modell verwendet.");
                }
                try {
                    this.node = this.pars.parse(this.term);
                    this.alreadyUsed = true;
                }
                catch (JepException ex) {
                    throw new EvaluationException("Die_Funktion '" + this.myName + "' ist fehlerhaft definiert.");
                }
            }
            try {
                for (int i = 0; i < args.length; ++i) {
                    this.pars.addVariable(this.variableNames[i], this.asDouble(0, args[i]));
                }
                return (Double)this.pars.evaluate(this.node);
            }
            catch (Exception ex) {
                if (ex.toString().contains("Cannot find value of")) {
                    throw new EvaluationException(ex.getMessage());
                }
                return Double.NaN;
            }
        }
    }

    private class AbsFunc
    extends UnaryFunction {
        private AbsFunc() {
        }

        @Override
        public Object eval(Object l) {
            if (l instanceof Number) {
                double x = ((Number)l).doubleValue();
                return Math.abs(x);
            }
            Vector v = (Vector)l;
            double r = 0.0;
            String s = "";
            for (int i = 0; i < v.size(); ++i) {
                r += (Double)v.get(i) * (Double)v.get(i);
            }
            return Math.sqrt(r);
        }
    }

    private class SgnFunc
    extends UnaryFunction {
        private SgnFunc() {
        }

        @Override
        public Object eval(Object l) {
            double x = ((Number)l).doubleValue();
            x = x < -4.9E-324 ? -1.0 : (x > Double.MIN_VALUE ? 1.0 : 0.0);
            return x;
        }
    }
}

