/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import de.didappslib.base.TemplateDoc;
import de.didappslib.guitools.AutoDialog;
import de.didappslib.guitools.SmartInput;
import de.didappslib.guitools.UpdateDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrefsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/PrefsDialog", Statics.locale);
    public static final int START_DIALOG = 0;
    public static final int START_NEW = 1;
    public static final int START_LAST = 2;
    public static final int START_OPEN = 3;
    public static final int NEW_DOCS = 1;
    public static final int LOADING_DOCS = 2;
    public static final int ALL_DOCS = 3;
    private String language;
    public int progStart;
    public boolean showProgBar;
    public boolean checkUpdate;
    private String templateDocPath;
    private String templateDocName;
    public boolean adjustWindowToScreen = true;
    private int smartInput;
    public float guiScale;
    public float graphicsScale;
    public float displayScale;
    private boolean scaleGraphics;
    private int toolTipState;
    public String examplesFolder;
    public String examplesFolder_absolutePath;
    public String examplesFolder_default;
    public String stdTemplatesFolder;
    public String stdTemplatesFolder_absolutePath;
    public String stdTemplatesFolder_default;
    public String defaultFolder;
    public String lastProjectPath = "";
    public String lastProjectFName = "";
    private final Preferences thePrefs;
    private final Icon templateDocIcon;
    private final SmartInput smartInputObject;
    private boolean esc_pressed;
    private boolean updating;
    private JLabel UILabel;
    private JPanel UIPanel;
    private JCheckBox autoSizeWinCB;
    private JComboBox<String> backslashCB;
    private JLabel backslashLab;
    private JButton bspButt;
    private JLabel bspLabel;
    private JTextField bspTF;
    private JCheckBox checkUpdateCB;
    private JButton defaultButt;
    private JLabel fPrefsLab;
    private JPanel fPrefsPanel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPopupMenu jPopupMenu1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JCheckBox multZeichCB;
    private JCheckBox numIndCB;
    public JComboBox<String> progStartCB;
    private JButton remTemplDocButt;
    private JButton resetBspFolder;
    private JButton resetStdVZFolder;
    private JButton resetTemplFolder;
    private JCheckBox scaleCB;
    private JCheckBox scaleGraphicsCB;
    public JSlider scalingSlider;
    private JButton selTemplDocButt;
    private JCheckBox showHelpCB;
    private JCheckBox showProgBarCB;
    private JCheckBox smartInputCB;
    private JPanel smartInputPanel;
    private JComboBox<String> specifyTooltipsCB;
    private JComboBox<String> spracheCB;
    private JButton stdVZButt;
    private JLabel stdVZLabel;
    private JTextField stdVZTF;
    private JPanel tempDocPanel;
    private JLabel templDocLab;
    private JLabel templDocNameLab;
    private JButton templFolderButt;
    private JLabel templFolderLabel;
    private JTextField templFolderTF;

    public PrefsDialog(SmartInput smi) {
        int y;
        Statics.prefsDialog = this;
        this.smartInputObject = smi;
        this.initComponents();
        this.resetBspFolder.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/reset", 1.0f));
        this.resetTemplFolder.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/reset", 1.0f));
        this.resetStdVZFolder.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/reset", 1.0f));
        this.specifyTooltipsCB.setModel(new DefaultComboBoxModel<String>(new String[]{this.rbundle.getString("waitshort-holdshort"), this.rbundle.getString("waitshort-holdmedium"), this.rbundle.getString("waitmedium-holdmedium"), this.rbundle.getString("waitmedium-holdlong"), this.rbundle.getString("waitlong-holdmedium"), this.rbundle.getString("waitlong-holdlong")}));
        this.displayScale = 2.0f;
        this.templateDocIcon = Statics.splashScreen.getMultiResIcon("/images/DocIcon", 1.0f);
        this.progStartCB.setModel(new DefaultComboBoxModel<String>(new String[]{this.rbundle.getString("Auswahl_zeigen"), this.rbundle.getString("Neues_Dokument_erstellen"), this.rbundle.getString("Zuletzt_verwendetes_Dokument_\u00f6ffnen"), this.rbundle.getString("Dialog_zum_\u00d6ffnen_eines_Dokuments")}));
        this.backslashCB.setModel(new DefaultComboBoxModel<String>(new String[]{this.rbundle.getString("wird_nicht_ben\u00f6tigt"), this.rbundle.getString("wird_ben\u00f6tigt")}));
        this.thePrefs = Preferences.userRoot().node(Statics.prg_Bundle.getString("PROGRAM_PREFERECES"));
        this.language = this.thePrefs.get("LANGUAGE", "");
        if (this.language.length() == 0) {
            this.language = Locale.getDefault().getLanguage();
        }
        this.progStart = this.thePrefs.getInt("PROGSTART", 0);
        this.checkUpdate = this.thePrefs.getBoolean("CHECKUPDATE", true);
        this.showProgBar = this.thePrefs.getBoolean("SHOWPROGBAR", true);
        this.adjustWindowToScreen = this.thePrefs.getBoolean("ADJUSTWINDOWTOSCREEN", true);
        this.smartInput = this.thePrefs.getInt("SMART_INPUT", 13);
        this.guiScale = this.thePrefs.getFloat("GUISCALE", 1.05f);
        this.scaleGraphics = this.thePrefs.getBoolean("SCALEGRAPHICS", true);
        this.graphicsScale = this.scaleGraphics ? this.guiScale * 1.05f : 1.0f;
        this.toolTipState = this.thePrefs.getInt("TOOLTIPSTATE", 3);
        this.adjustToolTips(this.toolTipState);
        this.templateDocPath = this.thePrefs.get("TEMPLATEDOCPATH", "");
        this.templateDocName = this.thePrefs.get("TEMPLATEDOCNAME", "");
        this.loadTemplateDoc(false);
        this.examplesFolder_default = Statics.prg_Bundle.getString("Beispiele_Ordner");
        if (Statics.os.contains("Mac")) {
            String appExamplesPath = Statics.prgName + ".app/Contents/Resources/" + Statics.prg_Bundle.getString("Beispiele_Ordner");
            if (PrefsDialog.class.getResource("PrefsDialog.class").getFile().contains(".app")) {
                this.examplesFolder_default = appExamplesPath;
                this.examplesFolder = this.thePrefs.get("EX_FOLDER_NEW", this.examplesFolder_default);
                if (this.examplesFolder.equals(Statics.prg_Bundle.getString("Beispiele_Ordner"))) {
                    this.examplesFolder = this.examplesFolder_default;
                }
            } else {
                this.examplesFolder = this.thePrefs.get("EX_FOLDER_NEW", this.examplesFolder_default);
                if (this.examplesFolder.equals(appExamplesPath)) {
                    this.examplesFolder = this.examplesFolder_default;
                }
            }
        } else {
            this.examplesFolder = this.thePrefs.get("EX_FOLDER_NEW", this.examplesFolder_default);
        }
        this.bspTF.setText(this.examplesFolder);
        this.examplesFolder_absolutePath = this.bspTF.getText().isEmpty() || this.bspTF.getText().equals(this.examplesFolder_default) ? Statics.homePath + this.examplesFolder_default : this.bspTF.getText();
        this.stdTemplatesFolder_default = Statics.prg_Bundle.getString("Vorlagen_Ordner");
        if (Statics.os.contains("Mac")) {
            String appTemplatesPath = Statics.prgName + ".app/Contents/Resources/" + Statics.prg_Bundle.getString("Vorlagen_Ordner");
            if (PrefsDialog.class.getResource("PrefsDialog.class").getFile().contains(".app")) {
                this.stdTemplatesFolder_default = appTemplatesPath;
                this.stdTemplatesFolder = this.thePrefs.get("STDTEMPL_FOLDER", this.stdTemplatesFolder_default);
                if (this.stdTemplatesFolder.equals(Statics.prg_Bundle.getString("Vorlagen_Ordner"))) {
                    this.stdTemplatesFolder = this.stdTemplatesFolder_default;
                }
            } else {
                this.stdTemplatesFolder = this.thePrefs.get("STDTEMPL_FOLDER", this.stdTemplatesFolder_default);
                if (this.stdTemplatesFolder.equals(appTemplatesPath)) {
                    this.stdTemplatesFolder = this.stdTemplatesFolder_default;
                }
            }
        } else {
            this.stdTemplatesFolder = this.thePrefs.get("STDTEMPL_FOLDER", this.stdTemplatesFolder_default);
        }
        this.templFolderTF.setText(this.stdTemplatesFolder);
        this.stdTemplatesFolder_absolutePath = this.templFolderTF.getText().isEmpty() || this.templFolderTF.getText().equals(this.stdTemplatesFolder_default) ? Statics.homePath + this.stdTemplatesFolder_default : this.templFolderTF.getText();
        this.defaultFolder = this.thePrefs.get("DEF_FOLDER", "");
        this.stdVZTF.setText(this.defaultFolder);
        Rectangle screenBounds = Statics.getRealScreenBounds(this);
        int x = (screenBounds.width - this.getWidth()) / 2 + screenBounds.x;
        if (x < 0) {
            x = 0;
        }
        if ((y = (screenBounds.height - this.getHeight()) / 3 + screenBounds.y) < 0) {
            y = 0;
        }
        this.setLocation(x, y);
        if (this.checkUpdate) {
            new UpdateDialog((Frame)null, true).checkUpdate(false);
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.UILabel = new JLabel();
        this.UIPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.spracheCB = new JComboBox();
        this.checkUpdateCB = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel7 = new JLabel();
        this.progStartCB = new JComboBox();
        this.showProgBarCB = new JCheckBox();
        this.autoSizeWinCB = new JCheckBox();
        this.showHelpCB = new JCheckBox();
        this.specifyTooltipsCB = new JComboBox();
        this.smartInputCB = new JCheckBox();
        this.smartInputPanel = new JPanel();
        this.numIndCB = new JCheckBox();
        this.multZeichCB = new JCheckBox();
        this.backslashLab = new JLabel();
        this.backslashCB = new JComboBox();
        this.jPanel1 = new JPanel();
        this.scaleCB = new JCheckBox();
        this.scaleGraphicsCB = new JCheckBox();
        this.scalingSlider = new JSlider();
        this.templDocLab = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.tempDocPanel = new JPanel();
        this.templDocNameLab = new JLabel();
        this.selTemplDocButt = new JButton();
        this.remTemplDocButt = new JButton();
        this.fPrefsLab = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.fPrefsPanel = new JPanel();
        this.bspLabel = new JLabel();
        this.bspTF = new JTextField();
        this.bspButt = new JButton();
        this.resetBspFolder = new JButton();
        this.templFolderLabel = new JLabel();
        this.templFolderTF = new JTextField();
        this.templFolderButt = new JButton();
        this.resetTemplFolder = new JButton();
        this.stdVZLabel = new JLabel();
        this.stdVZTF = new JTextField();
        this.stdVZButt = new JButton();
        this.resetStdVZFolder = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.defaultButt = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.rbundle.getString("Programmeinstellungen"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                PrefsDialog.this.formWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                PrefsDialog.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                PrefsDialog.this.formWindowOpened(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.UILabel.setFont(new Font("Lucida Grande", 1, 13));
        this.UILabel.setHorizontalAlignment(4);
        this.UILabel.setText(this.rbundle.getString("Erscheinungsbild"));
        this.UILabel.setHorizontalTextPosition(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(18, 30, 0, 0);
        this.getContentPane().add((Component)this.UILabel, gridBagConstraints);
        this.UIPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.rbundle.getString("Sprache"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 5, 0, 0);
        this.UIPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.spracheCB.setModel(new DefaultComboBoxModel<String>(new String[]{"deutsch", "english"}));
        this.spracheCB.setToolTipText(this.rbundle.getString("Auswahl_der_Sprache_TIP"));
        this.spracheCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrefsDialog.this.spracheCBItemStateChanged(evt);
            }
        });
        this.spracheCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.UIPanel.add(this.spracheCB, gridBagConstraints);
        this.checkUpdateCB.setText(this.rbundle.getString("Check_update"));
        this.checkUpdateCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.checkUpdateCBStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        this.UIPanel.add((Component)this.checkUpdateCB, gridBagConstraints);
        this.jLabel3.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel3.setText(this.rbundle.getString("nach_Neustart"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.UIPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel7.setText(this.rbundle.getString("Programmstart"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.UIPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.progStartCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Auswahl zeigen", "Neues Projekt erstellen", "Zuletzt verwendetes Projekt \u00f6ffnen", "Dialog zum \u00d6ffnen eines Projeks"}));
        ResourceBundle bundle = ResourceBundle.getBundle("de/didappslib/base/resources/PrefsDialog");
        this.progStartCB.setToolTipText(bundle.getString("PrefsDialog.progStartCB.toolTipText"));
        this.progStartCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrefsDialog.this.progStartCBItemStateChanged(evt);
            }
        });
        this.progStartCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 6);
        this.UIPanel.add(this.progStartCB, gridBagConstraints);
        this.showProgBarCB.setSelected(true);
        this.showProgBarCB.setText(this.rbundle.getString("IconLeiste_einaus"));
        this.showProgBarCB.setToolTipText(this.rbundle.getString("Iconleiste_TIP"));
        this.showProgBarCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.showProgBarCBStateChanged(evt);
            }
        });
        this.showProgBarCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.UIPanel.add((Component)this.showProgBarCB, gridBagConstraints);
        this.autoSizeWinCB.setSelected(true);
        this.autoSizeWinCB.setText(this.rbundle.getString("PrefsDialog.autoSizeWinCB.text"));
        this.autoSizeWinCB.setToolTipText(this.rbundle.getString("PrefsDialog.autoSizeWinCB.toolTipText"));
        this.autoSizeWinCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.autoSizeWinCBStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.UIPanel.add((Component)this.autoSizeWinCB, gridBagConstraints);
        this.showHelpCB.setSelected(true);
        this.showHelpCB.setText(bundle.getString("PrefsDialog.showHelpCB.text"));
        this.showHelpCB.setToolTipText(bundle.getString("PrefsDialog.showHelpCB.toolTipText"));
        this.showHelpCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrefsDialog.this.showHelpCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.UIPanel.add((Component)this.showHelpCB, gridBagConstraints);
        this.specifyTooltipsCB.setModel(new DefaultComboBoxModel<String>(new String[]{"wait short - hold short", "wait short - hold medium", "wait medium - hold medium", "wait medium - hold long", "wait long - hold medium", "wait long - hold long"}));
        this.specifyTooltipsCB.setToolTipText(bundle.getString("PrefsDialog.specifyHelpCB.toolTipText"));
        this.specifyTooltipsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrefsDialog.this.specifyTooltipsCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.UIPanel.add(this.specifyTooltipsCB, gridBagConstraints);
        this.smartInputCB.setSelected(true);
        this.smartInputCB.setText(this.rbundle.getString("Smart-Input_verwenden"));
        this.smartInputCB.setToolTipText(this.rbundle.getString("Smart-Input_TIP"));
        this.smartInputCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.smartInputCBStateChanged(evt);
            }
        });
        this.smartInputCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.UIPanel.add((Component)this.smartInputCB, gridBagConstraints);
        this.smartInputPanel.setLayout(new GridBagLayout());
        this.numIndCB.setSelected(true);
        this.numIndCB.setText(this.rbundle.getString("numerische_Indizes"));
        this.numIndCB.setToolTipText(this.rbundle.getString("numerische_Indizes_TIP"));
        this.numIndCB.setMargin(new Insets(0, 0, 0, 0));
        this.numIndCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.numIndCBStateChanged(evt);
            }
        });
        this.numIndCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.numIndCBActionPerformed(evt);
            }
        });
        this.numIndCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.smartInputPanel.add((Component)this.numIndCB, gridBagConstraints);
        this.multZeichCB.setSelected(true);
        this.multZeichCB.setText(this.rbundle.getString("Multiplikationszeichen"));
        this.multZeichCB.setToolTipText(this.rbundle.getString("Multiplikationszeichen_TIP"));
        this.multZeichCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.multZeichCBStateChanged(evt);
            }
        });
        this.multZeichCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 10, 0, 0);
        this.smartInputPanel.add((Component)this.multZeichCB, gridBagConstraints);
        this.backslashLab.setText(bundle.getString("griechische_Buchstaben"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        this.smartInputPanel.add((Component)this.backslashLab, gridBagConstraints);
        this.backslashCB.setModel(new DefaultComboBoxModel<String>(new String[]{"is not needed", "is needed"}));
        this.backslashCB.setMinimumSize(new Dimension(150, 27));
        this.backslashCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrefsDialog.this.backslashCBItemStateChanged(evt);
            }
        });
        this.backslashCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.smartInputPanel.add(this.backslashCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 0, 0);
        this.UIPanel.add((Component)this.smartInputPanel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.scaleCB.setSelected(true);
        this.scaleCB.setText(bundle.getString("PrefsDialog.scaleCB.text"));
        this.scaleCB.setToolTipText(bundle.getString("PrefsDialog.scaleCB.toolTipText"));
        this.scaleCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.scaleCBStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.jPanel1.add((Component)this.scaleCB, gridBagConstraints);
        this.scaleGraphicsCB.setSelected(true);
        this.scaleGraphicsCB.setText(bundle.getString("PrefsDialog.scaleGraphicsCB.text"));
        this.scaleGraphicsCB.setToolTipText(bundle.getString("PrefsDialog.scaleGraphicsCB.toolTipText"));
        this.scaleGraphicsCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.scaleGraphicsCBStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel1.add((Component)this.scaleGraphicsCB, gridBagConstraints);
        this.scalingSlider.setMaximum(10);
        this.scalingSlider.setMinimum(1);
        this.scalingSlider.setMinorTickSpacing(1);
        this.scalingSlider.setPaintTicks(true);
        this.scalingSlider.setSnapToTicks(true);
        this.scalingSlider.setToolTipText(bundle.getString("PrefsDialog.scalingSlider.toolTipText"));
        this.scalingSlider.setValue(2);
        this.scalingSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PrefsDialog.this.scalingSliderStateChanged(evt);
            }
        });
        this.scalingSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 10);
        this.jPanel1.add((Component)this.scalingSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.UIPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(15, 5, 0, 30);
        this.getContentPane().add((Component)this.UIPanel, gridBagConstraints);
        this.templDocLab.setFont(new Font("Lucida Grande", 1, 13));
        this.templDocLab.setText(bundle.getString("PrefsDialog.templDocLab.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 30, 7, 0);
        this.getContentPane().add((Component)this.templDocLab, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.tempDocPanel.setLayout(new GridBagLayout());
        this.templDocNameLab.setText(bundle.getString("PrefsDialog.templDocName.text"));
        this.tempDocPanel.add((Component)this.templDocNameLab, new GridBagConstraints());
        this.selTemplDocButt.setText(bundle.getString("PrefsDialog.selTemplDocButt.Text"));
        this.selTemplDocButt.setToolTipText(this.rbundle.getString("PrefsDialog.selTemplDocButt.toolTipText"));
        this.selTemplDocButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.selTemplDocButtActionPerformed(evt);
            }
        });
        this.selTemplDocButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.tempDocPanel.add((Component)this.selTemplDocButt, gridBagConstraints);
        this.remTemplDocButt.setText(bundle.getString("PrefsDialog.remTemplDocButt.text"));
        this.remTemplDocButt.setToolTipText(this.rbundle.getString("PrefsDialog.remTemplDocButt.toolTipText"));
        this.remTemplDocButt.setEnabled(false);
        this.remTemplDocButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.remTemplDocButtActionPerformed(evt);
            }
        });
        this.remTemplDocButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.tempDocPanel.add((Component)this.remTemplDocButt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.tempDocPanel, gridBagConstraints);
        this.fPrefsLab.setFont(new Font("Lucida Grande", 1, 13));
        this.fPrefsLab.setHorizontalAlignment(4);
        this.fPrefsLab.setText(this.rbundle.getString("Ordnereinstellungen"));
        this.fPrefsLab.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 30, 0, 0);
        this.getContentPane().add((Component)this.fPrefsLab, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.fPrefsPanel.setLayout(new GridBagLayout());
        this.bspLabel.setText(this.rbundle.getString("Verzeichnis_Beispiele"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.fPrefsPanel.add((Component)this.bspLabel, gridBagConstraints);
        this.bspTF.setToolTipText(this.rbundle.getString("Pfad_zum_Beispielordner"));
        this.bspTF.setOpaque(true);
        this.bspTF.setPreferredSize(new Dimension(440, 22));
        this.bspTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.fPrefsPanel.add((Component)this.bspTF, gridBagConstraints);
        this.bspButt.setText("...");
        this.bspButt.setToolTipText(this.rbundle.getString("Ordner_auswaehlen"));
        this.bspButt.setMaximumSize(new Dimension(24, 23));
        this.bspButt.setMinimumSize(new Dimension(24, 23));
        this.bspButt.setPreferredSize(new Dimension(24, 23));
        this.bspButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.bspButtActionPerformed(evt);
            }
        });
        this.bspButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.fPrefsPanel.add((Component)this.bspButt, gridBagConstraints);
        this.resetBspFolder.setBackground(new Color(237, 237, 237));
        this.resetBspFolder.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/reset.png")));
        this.resetBspFolder.setToolTipText(this.rbundle.getString("Reset_to_default"));
        this.resetBspFolder.setBorder(null);
        this.resetBspFolder.setBorderPainted(false);
        this.resetBspFolder.setPreferredSize(new Dimension(23, 23));
        this.resetBspFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.resetBspFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.fPrefsPanel.add((Component)this.resetBspFolder, gridBagConstraints);
        this.templFolderLabel.setText(this.rbundle.getString("PrefsDialog.templFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.fPrefsPanel.add((Component)this.templFolderLabel, gridBagConstraints);
        this.templFolderTF.setToolTipText(this.rbundle.getString("PrefsDialog.templFolderTF.toolTipText"));
        this.templFolderTF.setOpaque(true);
        this.templFolderTF.setPreferredSize(new Dimension(440, 22));
        this.templFolderTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.fPrefsPanel.add((Component)this.templFolderTF, gridBagConstraints);
        this.templFolderButt.setText("...");
        this.templFolderButt.setToolTipText(this.rbundle.getString("Ordner_auswaehlen"));
        this.templFolderButt.setMaximumSize(new Dimension(24, 23));
        this.templFolderButt.setMinimumSize(new Dimension(24, 23));
        this.templFolderButt.setPreferredSize(new Dimension(24, 23));
        this.templFolderButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.templFolderButtActionPerformed(evt);
            }
        });
        this.templFolderButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.fPrefsPanel.add((Component)this.templFolderButt, gridBagConstraints);
        this.resetTemplFolder.setBackground(new Color(237, 237, 237));
        this.resetTemplFolder.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/reset.png")));
        this.resetTemplFolder.setToolTipText(this.rbundle.getString("Reset_to_default"));
        this.resetTemplFolder.setBorder(null);
        this.resetTemplFolder.setBorderPainted(false);
        this.resetTemplFolder.setOpaque(true);
        this.resetTemplFolder.setPreferredSize(new Dimension(23, 23));
        this.resetTemplFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.resetTemplFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.fPrefsPanel.add((Component)this.resetTemplFolder, gridBagConstraints);
        this.stdVZLabel.setHorizontalAlignment(2);
        this.stdVZLabel.setText(this.rbundle.getString("Standardverzeichnis_fuer_Dialoge"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.fPrefsPanel.add((Component)this.stdVZLabel, gridBagConstraints);
        this.stdVZTF.setToolTipText(this.rbundle.getString("Ausgangsordner_fuer_Dialoge"));
        this.stdVZTF.setOpaque(true);
        this.stdVZTF.setPreferredSize(new Dimension(440, 22));
        this.stdVZTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.fPrefsPanel.add((Component)this.stdVZTF, gridBagConstraints);
        this.stdVZButt.setText("...");
        this.stdVZButt.setToolTipText(this.rbundle.getString("Ordner_auswaehlen"));
        this.stdVZButt.setMaximumSize(new Dimension(24, 23));
        this.stdVZButt.setMinimumSize(new Dimension(24, 23));
        this.stdVZButt.setPreferredSize(new Dimension(24, 23));
        this.stdVZButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.stdVZButtActionPerformed(evt);
            }
        });
        this.stdVZButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.fPrefsPanel.add((Component)this.stdVZButt, gridBagConstraints);
        this.resetStdVZFolder.setBackground(new Color(237, 237, 237));
        this.resetStdVZFolder.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/reset.png")));
        this.resetStdVZFolder.setToolTipText(this.rbundle.getString("Reset_to_default"));
        this.resetStdVZFolder.setBorder(null);
        this.resetStdVZFolder.setBorderPainted(false);
        this.resetStdVZFolder.setOpaque(true);
        this.resetStdVZFolder.setPreferredSize(new Dimension(23, 23));
        this.resetStdVZFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.resetStdVZFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.fPrefsPanel.add((Component)this.resetStdVZFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 20);
        this.getContentPane().add((Component)this.fPrefsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 20, 0, 20);
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel2.setMaximumSize(new Dimension(222, Integer.MAX_VALUE));
        this.jPanel2.setLayout(new GridBagLayout());
        this.defaultButt.setText(this.rbundle.getString("Standardwerte_wiederherstellen"));
        this.defaultButt.setToolTipText(this.rbundle.getString("Standardeinstellungen_TIP"));
        this.defaultButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsDialog.this.defaultButtActionPerformed(evt);
            }
        });
        this.defaultButt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrefsDialog.this.formKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.defaultButt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 180, 20, 180);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void defaultButtActionPerformed(ActionEvent evt) {
        this.progStart = 0;
        this.showProgBar = true;
        this.adjustWindowToScreen = true;
        this.smartInput = 13;
        this.guiScale = 1.05f;
        this.scaleGraphics = true;
        this.graphicsScale = this.scaleGraphics ? this.guiScale * 1.05f : 1.0f;
        this.toolTipState = 3;
        this.templateDocPath = "";
        this.templateDocName = "";
        this.removeTemplateDoc();
        this.examplesFolder = this.examplesFolder_default;
        this.stdTemplatesFolder = this.stdTemplatesFolder_default;
        this.defaultFolder = "";
        this.update();
    }

    private void spracheCBItemStateChanged(ItemEvent evt) {
        String oldlang = this.language;
        switch (this.spracheCB.getSelectedIndex()) {
            case 0: {
                this.language = "de";
                break;
            }
            case 1: {
                this.language = "en";
            }
        }
        if (!oldlang.equals(this.language)) {
            new AutoDialog(this).display(this.rbundle.getString("Die_neue_Sprache_wird_beim_n\u00e4chsten_Start_des_Programms_eingestellt."), this.rbundle.getString("Bitte_starten_Sie_das_Programm_neu."), Statics.prg_Bundle.getString("OK"));
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (!this.esc_pressed) {
            this.savePrefs();
        }
        this.setVisible(false);
    }

    private void bspButtActionPerformed(ActionEvent evt) {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle(this.rbundle.getString("W\u00e4hlen_Sie_den_Beispieleordner_aus"));
        fileDialog.setFileSelectionMode(1);
        Object dir = this.bspTF.getText().isEmpty() || this.bspTF.getText().equals(this.examplesFolder_default) ? Statics.homePath + this.examplesFolder_default : this.bspTF.getText();
        fileDialog.setCurrentDirectory(new File((String)dir));
        if (fileDialog.showOpenDialog(this) == 1) {
            return;
        }
        this.examplesFolder = fileDialog.getSelectedFile().getPath();
        this.bspTF.setText(this.examplesFolder);
    }

    private void stdVZButtActionPerformed(ActionEvent evt) {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle(this.rbundle.getString("W\u00e4hlen_Sie_den_Standardordner_aus"));
        fileDialog.setFileSelectionMode(1);
        fileDialog.setCurrentDirectory(new File(this.stdVZTF.getText()));
        if (fileDialog.showOpenDialog(this) == 1) {
            return;
        }
        this.defaultFolder = fileDialog.getSelectedFile().getPath();
        this.stdVZTF.setText(this.defaultFolder);
    }

    private void smartInputCBStateChanged(ChangeEvent evt) {
        this.smartInput = this.smartInputCB.isSelected() ? this.smartInput | 1 : this.smartInput & 0x7FFFFFFE;
        this.numIndCB.setEnabled(this.smartInputCB.isSelected());
        this.multZeichCB.setEnabled(this.smartInputCB.isSelected());
        this.backslashLab.setEnabled(this.smartInputCB.isSelected());
        this.backslashCB.setEnabled(this.smartInputCB.isSelected());
    }

    private void numIndCBStateChanged(ChangeEvent evt) {
        this.smartInput = this.numIndCB.isSelected() ? this.smartInput | 4 : this.smartInput & 0x7FFFFFFB;
    }

    private void multZeichCBStateChanged(ChangeEvent evt) {
        this.smartInput = this.multZeichCB.isSelected() ? this.smartInput | 8 : this.smartInput & 0x7FFFFFF7;
    }

    private void showProgBarCBStateChanged(ChangeEvent evt) {
        this.showProgBar = this.showProgBarCB.isSelected();
        Iterator<Document> iterator = Statics.projektListe.iterator();
        while (iterator.hasNext()) {
            Document projektListe;
            Document prj = projektListe = iterator.next();
            prj.getViewer().showHideProgBar(this.showProgBar);
        }
    }

    private void progStartCBItemStateChanged(ItemEvent evt) {
        this.progStart = this.progStartCB.getSelectedIndex();
        Statics.startAuswahl.showCB.setSelected(this.progStart == 0);
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && evt.getKeyChar() == 'w') {
            this.formWindowClosing(null);
        }
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void backslashCBItemStateChanged(ItemEvent evt) {
        this.smartInput = this.backslashCB.getSelectedIndex() == 0 ? (this.smartInput &= 0x7FFFFFDF) : (this.smartInput |= 0x20);
    }

    private void numIndCBActionPerformed(ActionEvent evt) {
    }

    private void selTemplDocButtActionPerformed(ActionEvent evt) {
        this.loadTemplateDoc(true);
    }

    private void autoSizeWinCBStateChanged(ChangeEvent evt) {
        this.adjustWindowToScreen = this.autoSizeWinCB.isSelected();
    }

    private void remTemplDocButtActionPerformed(ActionEvent evt) {
        this.removeTemplateDoc();
    }

    private void scalingSliderStateChanged(ChangeEvent evt) {
        if (!this.updating && this.scalingSlider.isEnabled()) {
            this.guiScale = 0.95f + 0.1f * (float)this.scalingSlider.getValue();
            this.graphicsScale = this.scaleGraphics ? this.guiScale * 1.05f : 1.0f;
            Statics.scaleAllOpenDocuments(this.guiScale);
        }
    }

    private void scaleCBStateChanged(ChangeEvent evt) {
        this.scalingSlider.setEnabled(this.scaleCB.isSelected());
        this.scaleGraphicsCB.setEnabled(this.scaleCB.isSelected());
        if (!this.updating) {
            if (this.scaleCB.isSelected()) {
                this.guiScale = 0.95f + 0.1f * (float)this.scalingSlider.getValue();
                this.graphicsScale = this.scaleGraphics ? this.guiScale * 1.05f : 1.0f;
            } else {
                this.guiScale = 1.0f;
                this.graphicsScale = 1.0f;
            }
            Statics.scaleAllOpenDocuments(this.guiScale);
        }
    }

    private void scaleGraphicsCBStateChanged(ChangeEvent evt) {
        if (!this.updating) {
            this.scaleGraphics = this.scaleGraphicsCB.isSelected();
            this.graphicsScale = this.scaleGraphics ? this.guiScale * 1.05f : 1.0f;
            Statics.scaleAllOpenDocuments(this.guiScale);
        }
    }

    private void showHelpCBItemStateChanged(ItemEvent evt) {
        this.specifyTooltipsCB.setEnabled(this.showHelpCB.isSelected());
        if (this.showHelpCB.isSelected()) {
            this.adjustToolTips(this.specifyTooltipsCB.getSelectedIndex() + 1);
        } else {
            this.adjustToolTips(0);
        }
    }

    private void specifyTooltipsCBItemStateChanged(ItemEvent evt) {
        this.adjustToolTips(this.specifyTooltipsCB.getSelectedIndex() + 1);
    }

    private void templFolderButtActionPerformed(ActionEvent evt) {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle(this.rbundle.getString("W\u00e4hlen_Sie_den_Vorlagenordner_aus"));
        fileDialog.setFileSelectionMode(1);
        Object dir = this.templFolderTF.getText().isEmpty() || this.templFolderTF.getText().equals(this.stdTemplatesFolder_default) ? Statics.homePath + this.stdTemplatesFolder_default : this.templFolderTF.getText();
        fileDialog.setCurrentDirectory(new File((String)dir));
        if (fileDialog.showOpenDialog(this) == 1) {
            return;
        }
        this.stdTemplatesFolder = fileDialog.getSelectedFile().getPath();
        this.templFolderTF.setText(this.stdTemplatesFolder);
    }

    private void formWindowOpened(WindowEvent evt) {
        this.update();
    }

    private void resetBspFolderActionPerformed(ActionEvent evt) {
        this.examplesFolder = this.examplesFolder_default;
        this.update();
    }

    private void resetTemplFolderActionPerformed(ActionEvent evt) {
        this.stdTemplatesFolder = this.stdTemplatesFolder_default;
        this.update();
    }

    private void resetStdVZFolderActionPerformed(ActionEvent evt) {
        this.defaultFolder = "";
        this.update();
    }

    private void checkUpdateCBStateChanged(ChangeEvent evt) {
        this.checkUpdate = this.checkUpdateCB.isSelected();
    }

    private void loadTemplateDoc(boolean fragen) {
        TemplateDoc tdoc = new TemplateDoc();
        int result = 1;
        if (fragen) {
            tdoc.dateiVerzeichnis = this.templFolderTF.getText().isEmpty() || this.templFolderTF.getText().equals(this.stdTemplatesFolder_default) ? Statics.homePath + this.stdTemplatesFolder_default : this.templFolderTF.getText();
            result = tdoc.projektLadenMitDialog();
        } else {
            File f = new File(this.templateDocPath, this.templateDocName);
            result = !f.exists() || this.templateDocName.length() == 0 ? 1 : (tdoc.projektLaden(this.templateDocPath, this.templateDocName) ? 2 : 0);
        }
        switch (result) {
            case 0: {
                this.removeTemplateDoc();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Statics.templateDoc = tdoc;
                this.templateDocName = tdoc.dateiName;
                this.templateDocPath = tdoc.dateiVerzeichnis;
                this.templDocNameLab.setIcon(this.templateDocIcon);
                this.templDocNameLab.setText(this.templateDocName + "  ");
                this.remTemplDocButt.setEnabled(true);
            }
        }
        tdoc.saveRAM();
    }

    private void removeTemplateDoc() {
        Statics.templateDoc = null;
        this.templateDocPath = "";
        this.templateDocName = "";
        this.templDocNameLab.setText(this.rbundle.getString("PrefsDialog.templDocName.text"));
        this.templDocNameLab.setIcon(null);
        this.remTemplDocButt.setEnabled(false);
    }

    private void adjustToolTips(int state) {
        switch (state) {
            case 1: {
                ToolTipManager.sharedInstance().setEnabled(true);
                ToolTipManager.sharedInstance().setInitialDelay(600);
                ToolTipManager.sharedInstance().setDismissDelay(3000);
                ToolTipManager.sharedInstance().setReshowDelay(300);
                break;
            }
            case 2: {
                ToolTipManager.sharedInstance().setEnabled(true);
                ToolTipManager.sharedInstance().setInitialDelay(600);
                ToolTipManager.sharedInstance().setDismissDelay(6000);
                ToolTipManager.sharedInstance().setReshowDelay(300);
                break;
            }
            case 3: {
                ToolTipManager.sharedInstance().setEnabled(true);
                ToolTipManager.sharedInstance().setInitialDelay(1200);
                ToolTipManager.sharedInstance().setDismissDelay(6000);
                ToolTipManager.sharedInstance().setReshowDelay(500);
                break;
            }
            case 4: {
                ToolTipManager.sharedInstance().setEnabled(true);
                ToolTipManager.sharedInstance().setInitialDelay(1200);
                ToolTipManager.sharedInstance().setDismissDelay(9000);
                ToolTipManager.sharedInstance().setReshowDelay(500);
                break;
            }
            case 5: {
                ToolTipManager.sharedInstance().setEnabled(true);
                ToolTipManager.sharedInstance().setInitialDelay(2500);
                ToolTipManager.sharedInstance().setDismissDelay(6000);
                ToolTipManager.sharedInstance().setReshowDelay(800);
                break;
            }
            case 6: {
                ToolTipManager.sharedInstance().setEnabled(true);
                ToolTipManager.sharedInstance().setInitialDelay(2500);
                ToolTipManager.sharedInstance().setDismissDelay(9000);
                ToolTipManager.sharedInstance().setReshowDelay(800);
                break;
            }
            default: {
                ToolTipManager.sharedInstance().setEnabled(false);
            }
        }
        this.toolTipState = state;
    }

    private void update() {
        this.updating = true;
        if ("de".equals(this.language)) {
            this.spracheCB.setSelectedIndex(0);
        }
        if ("en".equals(this.language)) {
            this.spracheCB.setSelectedIndex(1);
        }
        if ("fr".equals(this.language)) {
            this.spracheCB.setSelectedIndex(2);
        }
        if ("es".equals(this.language)) {
            this.spracheCB.setSelectedIndex(3);
        }
        this.progStartCB.setSelectedIndex(this.progStart);
        this.checkUpdateCB.setSelected(this.checkUpdate);
        this.showProgBarCB.setSelected(this.showProgBar);
        this.autoSizeWinCB.setSelected(this.adjustWindowToScreen);
        this.smartInputCB.setSelected((this.smartInput & 1) != 0);
        this.numIndCB.setSelected((this.smartInput & 4) != 0);
        this.multZeichCB.setSelected((this.smartInput & 8) != 0);
        if ((this.smartInput & 0x20) == 0) {
            this.backslashCB.setSelectedIndex(0);
        } else {
            this.backslashCB.setSelectedIndex(1);
        }
        this.scaleCB.setSelected(this.guiScale > 1.0f);
        if (this.guiScale > 1.0f) {
            this.scalingSlider.setValue((int)(this.guiScale * 10.0f - 9.5f));
        } else {
            this.scalingSlider.setValue(2);
        }
        this.scaleGraphicsCB.setSelected(this.scaleGraphics);
        this.loadTemplateDoc(false);
        this.showHelpCB.setSelected(this.toolTipState != 0);
        if (this.toolTipState > 0) {
            this.specifyTooltipsCB.setSelectedIndex(this.toolTipState - 1);
        }
        this.bspTF.setText(this.examplesFolder);
        this.templFolderTF.setText(this.stdTemplatesFolder);
        this.stdVZTF.setText(this.defaultFolder);
        this.updating = false;
    }

    public boolean checkLastProject(boolean verbose) {
        boolean ergebnis = false;
        this.lastProjectPath = this.thePrefs.get("LAST_PROJECT_PATH", "");
        this.lastProjectFName = this.thePrefs.get("LAST_PROJECT_FNAME", "");
        if (!this.lastProjectPath.equals("") && !this.lastProjectFName.equals("") && !(ergebnis = new File(this.lastProjectPath, this.lastProjectFName).exists()) && verbose) {
            new AutoDialog((JFrame)null).display(this.rbundle.getString("checkLastProject_Error"));
        }
        return ergebnis;
    }

    public void checkTemplateDoc(String path, String fname) {
        if (path.equals(this.templateDocPath) && fname.equals(this.templateDocName)) {
            this.loadTemplateDoc(false);
        }
    }

    public String getUsedDocs() {
        return this.thePrefs.get("USED_DOCS", "0\n");
    }

    public void putUsedDocs(String useddocstring) {
        this.thePrefs.put("USED_DOCS", useddocstring);
    }

    public void savePrefs() {
        this.thePrefs.put("LANGUAGE", this.language);
        this.thePrefs.putInt("PROGSTART", this.progStart);
        this.thePrefs.putBoolean("CHECKUPDATE", this.checkUpdate);
        this.thePrefs.putBoolean("SHOWPROGBAR", this.showProgBar);
        this.thePrefs.putBoolean("ADJUSTWINDOWTOSCREEN", this.adjustWindowToScreen);
        this.smartInputObject.setValue(this.smartInput);
        this.thePrefs.putInt("SMART_INPUT", this.smartInput);
        this.thePrefs.putFloat("GUISCALE", this.guiScale);
        this.thePrefs.putInt("TOOLTIPSTATE", this.toolTipState);
        this.thePrefs.putBoolean("SCALEGRAPHICS", this.scaleGraphics);
        if (Statics.templateDoc != null) {
            this.thePrefs.put("TEMPLATEDOCPATH", this.templateDocPath);
            this.thePrefs.put("TEMPLATEDOCNAME", this.templateDocName);
        } else {
            this.thePrefs.put("TEMPLATEDOCPATH", this.templateDocPath);
            this.thePrefs.put("TEMPLATEDOCNAME", "");
        }
        this.examplesFolder = this.bspTF.getText();
        this.examplesFolder_absolutePath = this.bspTF.getText().isEmpty() || this.bspTF.getText().equals(this.examplesFolder_default) ? Statics.homePath + this.examplesFolder_default : this.bspTF.getText();
        this.thePrefs.put("EX_FOLDER_NEW", this.examplesFolder.trim());
        this.stdTemplatesFolder = this.templFolderTF.getText();
        this.stdTemplatesFolder_absolutePath = this.templFolderTF.getText().isEmpty() || this.templFolderTF.getText().equals(this.stdTemplatesFolder_default) ? Statics.homePath + this.stdTemplatesFolder_default : this.templFolderTF.getText();
        this.thePrefs.put("STDTEMPL_FOLDER", this.stdTemplatesFolder.trim());
        this.defaultFolder = this.stdVZTF.getText();
        this.thePrefs.put("DEF_FOLDER", this.defaultFolder.trim());
        this.thePrefs.put("LAST_PROJECT_PATH", this.lastProjectPath);
        this.thePrefs.put("LAST_PROJECT_FNAME", this.lastProjectFName);
    }
}

