/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Document;
import de.didappslib.base.ModelLauncher;
import de.didappslib.base.PrefsDialog;
import de.didappslib.base.TemplateDoc;
import de.didappslib.guitools.AboutBox;
import de.didappslib.guitools.AskSaveChangesDialog;
import de.didappslib.guitools.GUIDevice;
import de.didappslib.guitools.GreekLetterConstPanel;
import de.didappslib.guitools.SmartInput;
import de.didappslib.guitools.SplashScreen;
import de.didappslib.guitools.StartAuswahl;
import de.didappslib.guitools.UsedDocs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JTextField;

public class Statics {
    private static final boolean printing = false;
    public static final Locale locale;
    public static final ResourceBundle rBundle;
    public static final ResourceBundle prg_Bundle;
    public static final String os;
    public static Boolean macStartupFile;
    public static String homePath;
    public static final String fileExtension;
    public static final String prgName;
    public static final String prgVersion;
    public static String buildDate;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int EULER = 0;
    public static final int HEUN = 1;
    public static final int RK = 2;
    public static final int RKPLUS = 3;
    public static final int LAGRANGE = 4;
    public static final int ITERATION = 5;
    public static final int NOTHING = 0;
    public static final int ZOOM_IN = 1;
    public static final int ZOOM_OUT = 2;
    public static final int MOVE = 3;
    public static final int MOVEKS = 4;
    public static final int ZOOMKSX = 5;
    public static final int ZOOMKSY = 6;
    public static final int ZOOMKS = 7;
    public static final int DOSELECTION = 8;
    public static final int CHOOSEPOINTWIDTH = 10;
    public static final int CHOOSELINEWIDTH = 11;
    public static final int MOVELEGEND = 20;
    public static final Color sidebarBackColor;
    public static final Color sidebarErrorColor;
    public static final Color sidebarWarningColor;
    public static final Color sidebarTextColor;
    public static final Color fieldBackColor;
    public static final Color fieldErrorColor;
    public static final Color transpBGColor;
    public static final Color transpBGColorDark;
    public static final Color GRAYBACKGROUND;
    public static final Color sidebarButtColor;
    public static final Color sidebarBackButtColor_ro;
    public static final String validChars = "a-zA-Z\u0391-\u03d5";
    public static final String extraChars = "\u0207\u0109\u011d\u011c\u0299\u00fb\u0125\u0127\u00d1\u04bd\u00ea\u00e9\u0271\u1e3f";
    public static Font[] fonts;
    public static int labelFontSize;
    public static int mathFontSize;
    public static Font mathFont;
    public static final String SEPARATOR = "SEPARATOR";
    public static final String FKT_VARIABLE = "\u01b6";
    public static Insets winBorder;
    public static ModelLauncher modelLauncher;
    public static ArrayList<Document> projektListe;
    public static Document aktProjekt;
    public static UsedDocs usedDocs;
    public static TemplateDoc templateDoc;
    public static boolean launchReady;
    public static SmartInput smartInput;
    public static AboutBox aboutBox;
    public static SplashScreen splashScreen;
    public static PrefsDialog prefsDialog;
    public static StartAuswahl startAuswahl;
    public static boolean macSpecialsLoaded;

    public static String doubleToString(double d) {
        NumberFormat df = NumberFormat.getInstance(locale);
        double betrag = Math.abs(d);
        if (betrag >= 10000.0 || betrag < 0.001 && betrag > Double.MIN_VALUE) {
            ((DecimalFormat)df).applyPattern("0.######E0");
        } else {
            ((DecimalFormat)df).applyPattern("0.######");
        }
        String s = df.format(d);
        if (locale.getLanguage().equals("de")) {
            s = s.replace(".", ",");
        }
        return s;
    }

    public static double stringToDouble(String s) {
        return Double.parseDouble(s.replace(',', '.'));
    }

    public static double textFieldToDouble(JTextField tf, boolean verbose) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(tf.getText().replace(',', '.'));
            tf.setBackground(fieldBackColor);
        }
        catch (Exception e) {
            aktProjekt.errorMsg(rBundle.getString("Fehler_im_Eingabefeld!"), rBundle.getString("Das_Eingabefeld_beschreibt_keine_Dezimalzahl."), tf, verbose);
        }
        return d;
    }

    public static int drawText(Graphics g, String s, int x, int y) {
        String[] ss = s.split("\n");
        for (int i = 0; i < ss.length; ++i) {
            g.drawString(ss[i], x, y);
            y += g.getFontMetrics().getHeight();
        }
        return y;
    }

    public static Rectangle getRealScreenBounds(Window window) {
        Rectangle scrBounds = window.getGraphicsConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(window.getGraphicsConfiguration());
        double sf = GUIDevice.getDisplayScalingFactor(window);
        if (os.contains("Win")) {
            insets.set((int)((double)insets.top / sf), (int)((double)insets.left / sf), (int)((double)insets.bottom / sf), (int)((double)insets.right / sf));
        }
        scrBounds.x = insets.left;
        scrBounds.y = insets.top;
        scrBounds.width = scrBounds.width - insets.left - insets.right;
        scrBounds.height = scrBounds.height - insets.top - insets.bottom;
        return scrBounds;
    }

    public static String translateErrMsg(String msg) {
        if (msg == null) {
            msg = "";
        }
        if (((String)msg).contains("util.Vector") && ((String)msg).contains("lang.Double")) {
            msg = rBundle.getString("A_single_value_can_not_be_assigned_to_a_vector_and_vice_versa.");
        }
        if (!locale.getCountry().equals("en")) {
            if (((String)msg).contains("No expression entered")) {
                msg = rBundle.getString("Kein_g\u00fcltiger_Ausdruck_angegeben.");
            }
            if (((String)msg).contains("Cannot find value of")) {
                msg = ((String)msg).replace("Cannot find value of ", rBundle.getString("Die_Variable_'")).replace(": no equation", rBundle.getString("'_ist_nicht_definiert")).replace(" and no value set", "");
            }
            if (((String)msg).contains("Encountered")) {
                msg = ((String)msg).charAt(((String)msg).indexOf(34) + 1) == '<' ? rBundle.getString("Unerwartetes_Ende_des_Audrucks") : rBundle.getString("Unerwartet_aufgetretenes_Zeichen_'") + ((String)msg).substring(((String)msg).indexOf(34) + 1, ((String)msg).indexOf(34) + 2) + "'";
            }
            if (((String)msg).contains("Function") && ((String)msg).contains("requires")) {
                msg = ((String)msg).replace("Function", rBundle.getString("Function")).replace("requires", rBundle.getString("requires")).replace("arguments.", rBundle.getString("arguments"));
            }
        }
        return GreekLetterConstPanel.refactorASCIIStr((String)msg);
    }

    public static void print(String s) {
    }

    public static void println(String s) {
    }

    public static void neuesProjekt() {
        Document prj;
        aktProjekt = prj = new Document(0);
        projektListe.add(prj);
        winBorder = prj.getViewer().getWindow().getInsets();
        Statics.adjustPrjWindow(prj);
        prj.show();
        prj.getViewer().prjNameField.requestFocus();
    }

    public static Boolean projektLadenMitDialog() {
        Document prj = new Document(0);
        if (prj.projektLadenMitDialog() != 2) {
            prj.getViewer().getWindow().dispose();
            return false;
        }
        projektListe.add(prj);
        usedDocs.insertNewElement(prj.dateiName, prj.dateiVerzeichnis);
        winBorder = prj.getViewer().getWindow().getInsets();
        Statics.adjustPrjWindow(prj);
        prj.show();
        if (prj.tableViewSize_loaded > 100 && prj.tableViewSize_loaded < prj.getViewer().getAnzeigePane().getWidth()) {
            prj.getViewer().getAnzeigePane().setRightComponent(prj.getViewer().tablePane);
            prj.getViewer().getAnzeigePane().setDividerLocation(prj.getViewer().getAnzeigePane().getWidth() - prj.tableViewSize_loaded);
        } else {
            prj.getViewer().showHideTable(0.0);
        }
        prj.getViewer().getAnzeigePane().doLayout();
        return true;
    }

    public static Boolean projektLaden(String folder, String filename) {
        Document prj = Statics.lookupProjekt(folder, filename);
        if (prj != null) {
            prj.aktivieren();
            return true;
        }
        prj = new Document(0);
        if (!prj.projektLaden(folder, filename)) {
            prj.getViewer().getWindow().dispose();
            return false;
        }
        projektListe.add(prj);
        usedDocs.insertNewElement(filename, folder);
        winBorder = prj.getViewer().getWindow().getInsets();
        Statics.adjustPrjWindow(prj);
        prj.show();
        if (prj.tableViewSize_loaded > 100 && prj.tableViewSize_loaded < prj.getViewer().getAnzeigePane().getWidth()) {
            prj.getViewer().getAnzeigePane().setRightComponent(prj.getViewer().tablePane);
            prj.getViewer().getAnzeigePane().setDividerLocation(prj.getViewer().getAnzeigePane().getWidth() - prj.tableViewSize_loaded);
        } else {
            prj.getViewer().showHideTable(0.0);
        }
        return true;
    }

    public static boolean projektSchliessen(Document prj) {
        if (prj.hasChanged()) {
            switch (new AskSaveChangesDialog(prj).display()) {
                case 0: {
                    break;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    if (prj.projektSpeichern(true)) break;
                    return false;
                }
            }
        }
        prj.getViewer().getWindow().dispose();
        projektListe.remove(prj);
        if (projektListe.isEmpty()) {
            startAuswahl.setVisible(true);
        } else {
            aktProjekt = projektListe.get(projektListe.size() - 1);
            aktProjekt.show();
        }
        return true;
    }

    public static Document lookupProjekt(String pathname, String filename) {
        Document prj = null;
        for (Document projektListe1 : projektListe) {
            prj = projektListe1;
            if (prj.getPath().equals(pathname) && prj.getFileName().equals(filename)) {
                return prj;
            }
            prj = null;
        }
        return prj;
    }

    public static void scaleAllOpenDocuments(float newscale) {
        Iterator<Document> iterator = projektListe.iterator();
        while (iterator.hasNext()) {
            Document projektListe1;
            Document doc = projektListe1 = iterator.next();
            doc.scale(newscale);
        }
    }

    public static void adjustPrjWindow(Document prj) {
        Dimension sdim = Toolkit.getDefaultToolkit().getScreenSize();
        int top = prj.windowBounds.y;
        int left = prj.windowBounds.x;
        int width = prj.windowBounds.width;
        int height = prj.windowBounds.height;
        int swidth = sdim.width;
        int sheight = sdim.height - prj.getViewer().getWindow().getInsets().top;
        if (Statics.prefsDialog.adjustWindowToScreen) {
            width = swidth - 10;
            if (swidth > 1024) {
                width = (int)(0.95 * (double)swidth);
            }
            if (swidth > 1450) {
                width = (int)(0.85 * (double)swidth);
            }
            if (swidth > 1920) {
                width = (int)(0.75 * (double)swidth);
            }
            height = (int)((double)sdim.height * 0.9);
            left = (swidth - width) / 2;
            top = (sheight - height) / 2 + prj.getViewer().getWindow().getInsets().top / 2;
            left += (projektListe.size() - 1) * 15;
            top += (projektListe.size() - 1) * 10;
        } else if (top == -1) {
            width = (int)((float)swidth * 0.8f);
            height = (int)((float)sheight * 0.9f);
            top = (int)((float)(sheight - height) / 2.0f * 0.9f);
            left = (swidth - width) / 2;
        }
        if (width > swidth) {
            width = swidth;
        }
        if (height > sheight) {
            height = sheight;
        }
        if (left + width > swidth) {
            left = swidth - width;
        }
        if (top + height > sheight) {
            top = sheight - height;
        }
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        prj.getViewer().getWindow().setBounds(left, top, width, height);
    }

    public static boolean quit() {
        int i;
        ArrayList<Document> plist = new ArrayList<Document>();
        for (i = 0; i < projektListe.size(); ++i) {
            plist.add(projektListe.get(i));
        }
        for (i = plist.size() - 1; i >= 0; --i) {
            Document p = (Document)plist.get(i);
            if (Statics.projektSchliessen(p)) continue;
            return false;
        }
        if (usedDocs != null) {
            usedDocs.writeListToPrefs();
            prefsDialog.savePrefs();
        }
        System.exit(0);
        return true;
    }

    static {
        String s = Preferences.userRoot().node(ResourceBundle.getBundle("resources/Programm").getString("PROGRAM_PREFERECES")).get("LANGUAGE", "");
        locale = s.isEmpty() ? Locale.getDefault() : new Locale(s);
        rBundle = ResourceBundle.getBundle("de/didappslib/base/resources/Statics", locale);
        prg_Bundle = ResourceBundle.getBundle("resources/Programm", locale);
        os = System.getProperty("os.name");
        macStartupFile = false;
        fileExtension = prg_Bundle.getString("prj_suffix");
        prgName = prg_Bundle.getString("PROGRAM_NAME");
        prgVersion = prg_Bundle.getString("VERSION_NR");
        sidebarBackColor = new Color(245, 245, 245);
        sidebarErrorColor = new Color(100, 0, 0);
        sidebarWarningColor = new Color(180, 90, 0);
        sidebarTextColor = new Color(40, 40, 40);
        fieldBackColor = new Color(255, 255, 255);
        fieldErrorColor = new Color(255, 230, 230);
        transpBGColor = new Color(160, 160, 160, 160);
        transpBGColorDark = new Color(70, 70, 70, 80);
        GRAYBACKGROUND = new Color(225, 225, 225);
        sidebarButtColor = new Color(251, 251, 251);
        sidebarBackButtColor_ro = new Color(235, 235, 235);
        fonts = new Font[]{new Font("Serif", 0, 13), new Font("Serif", 1, 13), new Font("Serif", 2, 13), new Font("Serif", 3, 13), new Font("SansSerif", 0, 12), new Font("SansSerif", 1, 12), new Font("SansSerif", 2, 12), new Font("SansSerif", 3, 12), new Font("Monospaced", 0, 12), new Font("Monospaced", 1, 12), new Font("Monospaced", 2, 12), new Font("Monospaced", 3, 12)};
        labelFontSize = 13;
        mathFontSize = os.contains("Mac") || os.contains("Win") ? 15 : 13;
        mathFont = new Font("Serif", 2, mathFontSize);
        projektListe = new ArrayList();
        launchReady = false;
        macSpecialsLoaded = false;
    }
}

