/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import de.didappslib.guitools.GreekLetterConstPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class Tabelle
extends JScrollPane
implements MouseListener,
ListSelectionListener,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    public static final int MODEL_TABLE = 1;
    public static final int CUSTOM_TABLE = 2;
    public static final int COMPVAL_TABLE = 3;
    public static DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Statics.locale);
    public static int nachkStellen = 3;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Tabelle", Statics.locale);
    private final JPopupMenu popup = new JPopupMenu();
    private JPopupMenu headerPopup;
    private final JMenu nachkStellenMenu = new JMenu(this.rbundle.getString("Nachkommastellen"));
    private final Tabelle me = this;
    public int type;
    public Document document;
    public JTable tab;
    public static boolean scientificNotation = false;
    private boolean updateViewAllowed = true;
    private int aktiveSpalte;
    public ArrayList<String> extraSpaltenNamen = new ArrayList();

    public Tabelle() {
    }

    public Tabelle(Document prj, int t) {
        this.document = prj;
        this.type = t;
        ActionListener al = e -> this.handlePopupMenu(e.getActionCommand());
        JMenuItem mit = new JMenuItem(this.rbundle.getString("Alle_Werte_kopieren"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Auswahl_kopieren"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(new JSeparator());
        mit = new JMenuItem(this.rbundle.getString("Auswahl_aufheben"));
        mit.addActionListener(al);
        this.popup.add(mit);
        if (this.type != 2) {
            mit = new JMenuItem(this.rbundle.getString("Nur_Auswahl_zeichnen"));
            mit.addActionListener(al);
            this.popup.add(mit);
            mit = new JMenuItem(this.rbundle.getString("Als_neue_Startwerte_uebernehmen"));
            mit.addActionListener(al);
            this.popup.add(mit);
        }
        this.popup.add(new JSeparator());
        mit = new JMenuItem(this.rbundle.getString("Wissenschaftliche_Notation"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(this.nachkStellenMenu);
        for (int j = 0; j < 10; ++j) {
            mit = new JCheckBoxMenuItem("" + j);
            mit.addActionListener(al);
            this.nachkStellenMenu.add(mit);
        }
        String[] spaltenNamen = new String[]{"t"};
        this.tab = new JTable(new myTableModel(spaltenNamen));
        if (this.type == 1) {
            this.tab.setBackground(new Color(255, 255, 235));
            this.tab.setSelectionBackground(new Color(249, 237, 215));
        } else {
            this.tab.setBackground(new Color(255, 240, 240));
            this.tab.setSelectionBackground(new Color(249, 220, 220));
        }
        this.tab.setDefaultRenderer(String.class, new MyCellRenderer());
        this.tab.setGridColor(Color.LIGHT_GRAY);
        this.tab.addMouseListener(this.me);
        this.tab.getSelectionModel().addListSelectionListener(this.me);
        this.tab.getTableHeader().setReorderingAllowed(false);
        this.tab.getTableHeader().setResizingAllowed(false);
        this.tab.getTableHeader().addMouseListener(this.me);
        this.tab.getTableHeader().setDefaultRenderer(new MyHeaderCellRenderer());
        if (this.type == 2) {
            this.tab.getTableHeader().setToolTipText(this.rbundle.getString("Def_table_header_TIP"));
        }
        this.setViewportView(this.tab);
        this.setHorizontalScrollBarPolicy(30);
        this.setMinimumSize(new Dimension(200, 30));
        df.applyPattern("0.###");
        this.setzeStellenAnz(5);
    }

    public void updateTab() {
        String[] spaltenNamen;
        Statics.println("Update table...");
        if (this.document.getModel() == null) {
            return;
        }
        String[] modelSpaltenNamen = this.document.getModel().getSpaltenNamen();
        if (this.type == 1) {
            spaltenNamen = new String[modelSpaltenNamen.length + this.extraSpaltenNamen.size()];
            System.arraycopy(modelSpaltenNamen, 0, spaltenNamen, 0, modelSpaltenNamen.length);
        } else {
            spaltenNamen = new String[1 + this.extraSpaltenNamen.size()];
            spaltenNamen[0] = this.document.getModel().getVarName(0);
            for (int i = 0; i < this.extraSpaltenNamen.size(); ++i) {
                spaltenNamen[1 + i] = GreekLetterConstPanel.factorASCIIStr(this.extraSpaltenNamen.get(i));
            }
        }
        this.tab.setModel(new myTableModel(spaltenNamen));
        Statics.println("finished");
    }

    void handlePopupMenu(String cmd) {
        if (cmd.equals(this.rbundle.getString("Alle_Werte_kopieren"))) {
            this.toClipboard(true);
            return;
        }
        if (cmd.equals(this.rbundle.getString("Auswahl_kopieren"))) {
            this.toClipboard(false);
            return;
        }
        if (cmd.equals(this.rbundle.getString("Auswahl_aufheben"))) {
            this.tab.removeRowSelectionInterval(0, this.tab.getRowCount() - 1);
            this.document.getDiagramm().plotAll = true;
            this.tab.repaint();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Nur_Auswahl_zeichnen"))) {
            this.document.getDiagramm().plotAll = false;
            this.document.getDiagramm().updateDiagramPlus();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Alles_zeichnen"))) {
            this.document.getDiagramm().plotAll = true;
            this.document.getDiagramm().updateDiagramPlus();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Als_neue_Startwerte_uebernehmen"))) {
            this.document.getModel().startwerteSetzenAusSelektion(this.document.getModelTable().tab.getSelectedRow());
            this.document.getModelTable().tab.removeRowSelectionInterval(0, this.document.getModelTable().tab.getRowCount() - 1);
            this.document.getDiagramm().updateDiagramPlus();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Wissenschaftliche_Notation"))) {
            this.toScientificNotation();
            this.document.getViewer().showHideTable(1.0);
            return;
        }
        if (cmd.equals(this.rbundle.getString("Dezimale_Notation"))) {
            this.toDecimalNotation();
            this.document.getViewer().showHideTable(1.0);
            return;
        }
        if (cmd.equals(this.rbundle.getString("Spalte_entfernen"))) {
            this.spalteWeg(this.aktiveSpalte);
            return;
        }
        for (int j = 0; j < 10; ++j) {
            if (!cmd.equals("" + j)) continue;
            this.setzeStellenAnz(j);
            this.document.getViewer().showHideTable(1.0);
            return;
        }
        this.extraSpaltenNamen.remove(this.aktiveSpalte - 1);
        this.extraSpaltenNamen.add(this.aktiveSpalte - 1, cmd);
        this.document.getModel().startCalculation();
        this.document.getViewer().showHideTable(1.0);
    }

    void handleHeaderPopupSubMenu(String cmd) {
        this.extraSpaltenNamen.add(this.aktiveSpalte, cmd);
        this.document.getModel().startCalculation();
        this.document.getViewer().showHideTable(1.0);
    }

    private void spalteWeg(int welche) {
        this.extraSpaltenNamen.remove(welche - 1);
        this.document.getModel().startCalculation();
        this.document.getViewer().showHideTable(1.0);
    }

    public int getType() {
        return this.type;
    }

    public boolean isInArray(int val, int[] arr) {
        for (int j = 0; j < arr.length; ++j) {
            if (val != arr[j]) continue;
            return true;
        }
        return false;
    }

    public int evalTabWidth() {
        int b = 3;
        try {
            for (int i = 0; i < this.tab.getRowCount(); ++i) {
                for (int j = 0; j < this.tab.getColumnCount(); ++j) {
                    String s = (String)this.tab.getValueAt(i, j);
                    if (s == null || s.length() <= b) continue;
                    b = s.length();
                }
            }
            b = (int)((float)(this.tab.getColumnCount() * b * 9) * Statics.prefsDialog.guiScale);
            if (b < 250) {
                b = 250;
            }
        }
        catch (Exception e) {
            b = 250;
        }
        return b;
    }

    public void allowUpdateView() {
        this.updateViewAllowed = true;
    }

    public void disallowUpdateView() {
        this.updateViewAllowed = false;
    }

    public void updateView() {
        if (this.updateViewAllowed) {
            this.document.getDiagramm().redrawDiagram();
        }
    }

    @Override
    public void requestFocus() {
        this.tab.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.aktiveSpalte = this.tab.columnAtPoint(e.getPoint());
        if (e.isPopupTrigger()) {
            if (e.getComponent() instanceof JTableHeader && this.type == 2) {
                JMenuItem mit;
                ActionListener al = ae -> this.handleHeaderPopupSubMenu(ae.getActionCommand());
                this.headerPopup = new JPopupMenu();
                JMenu spmenu = new JMenu(this.rbundle.getString("Spalte_hinzuf\u00fcgen"));
                String[] vList = this.document.getModel().getVariableArray();
                if (vList == null) {
                    return;
                }
                UIManager.put("MenuItem.font", Statics.mathFont);
                SwingUtilities.updateComponentTreeUI(spmenu);
                for (String s : vList) {
                    if (s.equals("SEPARATOR")) {
                        spmenu.add(new JSeparator());
                        continue;
                    }
                    mit = new JMenuItem(s);
                    mit.addActionListener(al);
                    spmenu.add(mit);
                }
                spmenu.remove(0);
                if (spmenu.getItemCount() > 0 && spmenu.getMenuComponent(0) instanceof JSeparator) {
                    spmenu.remove(0);
                }
                if (this.aktiveSpalte == 0) {
                    this.headerPopup.add(spmenu);
                }
                if (this.aktiveSpalte > 0) {
                    al = ae -> this.handlePopupMenu(ae.getActionCommand());
                    for (String s : vList) {
                        if (s.equals("SEPARATOR")) {
                            this.headerPopup.add(new JSeparator());
                            continue;
                        }
                        mit = new JMenuItem(s);
                        mit.addActionListener(al);
                        this.headerPopup.add(mit);
                    }
                    this.headerPopup.remove(0);
                    if (this.headerPopup.getComponent(0) instanceof JSeparator) {
                        this.headerPopup.remove(0);
                    }
                    this.headerPopup.add(new JSeparator());
                    this.headerPopup.add(spmenu);
                    UIManager.put("MenuItem.font", null);
                    mit = new JMenuItem(this.rbundle.getString("Spalte_entfernen"));
                    mit.addActionListener(al);
                    this.headerPopup.add(mit);
                }
                UIManager.put("MenuItem.font", null);
                this.headerPopup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                this.popup.getComponent(1).setEnabled(false);
                this.popup.getComponent(3).setEnabled(false);
                this.popup.getComponent(4).setEnabled(false);
                if (this.tab.getSelectedRowCount() > 0) {
                    this.popup.getComponent(1).setEnabled(true);
                    this.popup.getComponent(3).setEnabled(true);
                    if (this.type == 1) {
                        this.popup.getComponent(5).setEnabled(false);
                        if (this.tab.getSelectedRowCount() == 1) {
                            this.popup.getComponent(5).setEnabled(true);
                        } else {
                            String s = this.rbundle.getString("Alles_zeichnen");
                            if (this.document.getDiagramm().plotAll) {
                                s = this.rbundle.getString("Nur_Auswahl_zeichnen");
                            }
                            ((JMenuItem)this.popup.getComponent(4)).setText(s);
                            this.popup.getComponent(4).setEnabled(true);
                        }
                    }
                }
                if (scientificNotation) {
                    ((JMenuItem)this.popup.getComponent(this.popup.getComponentIndex(this.nachkStellenMenu) - 1)).setText(this.rbundle.getString("Dezimale_Notation"));
                } else {
                    ((JMenuItem)this.popup.getComponent(this.popup.getComponentIndex(this.nachkStellenMenu) - 1)).setText(this.rbundle.getString("Wissenschaftliche_Notation"));
                }
                JMenu umenu = (JMenu)this.popup.getComponent(this.type == 1 ? 8 : 6);
                for (Component item : umenu.getMenuComponents()) {
                    ((JMenuItem)item).setSelected(false);
                }
                ((JMenuItem)umenu.getMenuComponent(nachkStellen)).setSelected(true);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseClicked(e);
        this.tab.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateView();
    }

    public int[] getSelectedRows() {
        return this.tab.getSelectedRows();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void toClipboard(boolean alles) {
        String text = "";
        if (alles) {
            Clipboard clip = this.getToolkit().getSystemClipboard();
            StringSelection cont = new StringSelection(this.tabelleToText());
            clip.setContents(cont, this);
        } else {
            int[] rows = this.tab.getSelectedRows();
            for (int i = 0; i < this.tab.getRowCount(); ++i) {
                if (!this.isInArray(i, rows)) continue;
                String zeile = "";
                for (int j = 0; j < this.tab.getColumnCount(); ++j) {
                    zeile = this.tab.getValueAt(i, j) != null ? zeile.concat((String)this.tab.getValueAt(i, j)).concat("\t") : zeile.concat("\t");
                }
                text = text.concat(zeile).concat("\n");
            }
            if (text.length() == 0) {
                return;
            }
            Clipboard clip = this.getToolkit().getSystemClipboard();
            StringSelection cont = new StringSelection(text);
            clip.setContents(cont, this);
        }
    }

    public void toScientificNotation() {
        scientificNotation = true;
        df.applyPattern("#.#E0");
        df.setMinimumFractionDigits(nachkStellen);
    }

    public void toDecimalNotation() {
        scientificNotation = false;
        df.applyPattern("#.##");
        df.setMinimumFractionDigits(nachkStellen);
    }

    public void setzeStellenAnz(int anz) {
        JCheckBoxMenuItem item;
        for (int i = 0; i < this.nachkStellenMenu.getItemCount(); ++i) {
            item = (JCheckBoxMenuItem)this.nachkStellenMenu.getItem(i);
            item.setSelected(false);
        }
        item = (JCheckBoxMenuItem)this.nachkStellenMenu.getItem(anz);
        item.setSelected(true);
        nachkStellen = anz;
        df.setMinimumFractionDigits(nachkStellen);
        df.setMaximumFractionDigits(nachkStellen);
    }

    private String tabelleToText() {
        Object zeile = "";
        for (int j = 0; j < this.tab.getColumnCount(); ++j) {
            zeile = (String)zeile + this.tab.getColumnName(j) + "\t";
        }
        String text = (String)zeile + "\n";
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            zeile = "";
            for (int j = 0; j < this.tab.getColumnCount(); ++j) {
                zeile = this.tab.getValueAt(i, j) != null ? (String)zeile + this.tab.getValueAt(i, j) + "\t" : (String)zeile + "\t";
            }
            text = text + (String)zeile + "\n";
        }
        return text;
    }

    public void writeDataAsText(RandomAccessFile f) throws Exception {
        f.writeBytes(this.tabelleToText());
    }

    public void printDataAsText(PrintWriter f) throws Exception {
        f.print(this.tabelleToText());
    }

    class MyCellRenderer
    extends DefaultTableCellRenderer {
        String s;

        public MyCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            this.s = (String)value;
            if (this.s == null) {
                this.s = " ";
            }
            if (this.s.charAt(0) == '#') {
                this.setForeground(Color.GRAY);
                value = this.s.substring(1);
            } else {
                this.setForeground(Color.BLACK);
            }
            super.setValue(value);
        }
    }

    class MyHeaderCellRenderer
    extends DefaultTableCellRenderer {
        public MyHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setVerticalAlignment(0);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            table.setRowHeight((int)(13.0f * Statics.prefsDialog.guiScale) + 4);
            table.setFont(new Font("Dialog", 0, (int)(13.0f * Statics.prefsDialog.guiScale)));
            this.setFont(Statics.mathFont.deriveFont(3, 13.0f * Statics.prefsDialog.guiScale));
            this.setPreferredSize(new Dimension(this.getWidth(), (int)(16.0f * Statics.prefsDialog.guiScale)));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    class myTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames;

        public myTableModel(String[] colNam) {
            this.columnNames = colNam;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Tabelle.this.document.getModel().werteAltAnzahl + Tabelle.this.document.getModel().werteAnzahl;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (Tabelle.this.type == 1) {
                if (Tabelle.this.document.getModel().werteAltAnzahl > 0 && row < Tabelle.this.document.getModel().werteAltAnzahl) {
                    return "#".concat(df.format(Tabelle.this.document.getModel().wertetabelleAlt[row][col]));
                }
                return df.format(Tabelle.this.document.getModel().wertetabelle[row - Tabelle.this.document.getModel().werteAltAnzahl][col]);
            }
            if (col == 0) {
                if (Tabelle.this.document.getModel().werteAltAnzahl > 0 && row < Tabelle.this.document.getModel().werteAltAnzahl) {
                    return "#".concat(df.format(Tabelle.this.document.getModel().wertetabelleAlt[row][col]));
                }
                return df.format(Tabelle.this.document.getModel().wertetabelle[row - Tabelle.this.document.getModel().werteAltAnzahl][col]);
            }
            if (Tabelle.this.document.getModel().werteAltAnzahl > 0 && row < Tabelle.this.document.getModel().werteAltAnzahl) {
                return "#".concat(df.format(Tabelle.this.document.getModel().wertetabelleAlt[row][Tabelle.this.document.getModel().WERTENVAR + col - 1]));
            }
            return df.format(Tabelle.this.document.getModel().wertetabelle[row - Tabelle.this.document.getModel().werteAltAnzahl][Tabelle.this.document.getModel().WERTENVAR + col - 1]);
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return "e".getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (Tabelle.this.document.getModel().werteAltAnzahl > 0 && row < Tabelle.this.document.getModel().werteAltAnzahl) {
                Tabelle.this.document.getModel().wertetabelleAlt[row][col] = Statics.stringToDouble((String)value);
            } else {
                Tabelle.this.document.getModel().wertetabelle[row - Tabelle.this.document.getModel().werteAltAnzahl][col] = Statics.stringToDouble((String)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

