/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.calculation;

import de.didappslib.base.Model;
import de.didappslib.base.Statics;
import de.didappslib.guitools.AutoDialog;
import java.util.ResourceBundle;

public class RungeKutta {
    private static final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/calculation/RungeKutta");
    private static final int SMAX = 16;
    private static final int DMAX = 7;
    private static final int NVARMAX = 18;
    private long ngood;
    private long nfail;
    private int s;
    private int ss;
    private int q;
    private int p;
    private int d;
    private boolean fsal;
    private final double[][] a = new double[16][15];
    private final double[] b = new double[16];
    private final double[] bdach = new double[16];
    private final double[] berr = new double[16];
    private final double[] c = new double[16];
    private final double[][] beta = new double[8][16];
    private double potenz;
    private double eps;
    private double tend;
    private int nvar;
    private boolean autonom;
    private boolean neu;
    private final double[][] k = new double[16][18];
    private double h0;
    private double tt;
    private final double[] ybeg = new double[18];
    private double Schrittweite;
    private double tlast = Double.MAX_VALUE;
    private Model dgl;
    int maxfail;
    double[] ytemp = new double[19];
    private final double[][] aa = new double[8][18];
    private final double[] yneu = new double[19];
    private final double[] ytemp1 = new double[18];
    private final double[] ytemp2 = new double[18];
    private final double[] dy = new double[18];
    private final double[] yA = new double[18];
    private final double[] dyA = new double[18];
    private final double[] yB = new double[18];
    private final double[] dyB = new double[18];
    private final double[] yC = new double[18];
    private final double[] dyC = new double[18];

    public RungeKutta() {
        this.rkcoeff();
    }

    private void error(String s) throws Exception {
        if (!new AutoDialog(this.dgl.getProjekt().getViewer().getWindow()).display(rbundle.getString("Achtung!") + " dt=" + Statics.doubleToString(this.Schrittweite), rbundle.getString("Die_Schrittweite_muss_weiter_verkleinert_werden."), rbundle.getString("Weiter"), rbundle.getString("Abbrechen"))) {
            throw new Exception(s);
        }
    }

    private static double max(double x1, double x2) {
        return x1 > x2 ? x1 : x2;
    }

    private void rkcoeff() {
        int i;
        this.q = 5;
        this.p = 4;
        this.s = 7;
        this.ss = 7;
        this.d = 5;
        this.fsal = true;
        this.a[1][0] = 0.2;
        this.a[2][0] = 0.075;
        this.a[2][1] = 0.225;
        this.a[3][0] = 0.9777777777777777;
        this.a[3][1] = -3.7333333333333334;
        this.a[3][2] = 3.5555555555555554;
        this.a[4][0] = 2.9525986892242035;
        this.a[4][1] = -11.595793324188385;
        this.a[4][2] = 9.822892851699436;
        this.a[4][3] = -0.2908093278463649;
        this.a[5][0] = 2.8462752525252526;
        this.a[5][1] = -10.757575757575758;
        this.a[5][2] = 8.906422717743473;
        this.a[5][3] = 0.2784090909090909;
        this.a[5][4] = -0.2735313036020583;
        this.a[6][0] = 0.09114583333333333;
        this.a[6][2] = 0.44923629829290207;
        this.a[6][3] = 0.6510416666666666;
        this.a[6][4] = -0.322376179245283;
        this.a[6][5] = 0.13095238095238096;
        this.b[0] = 0.09114583333333333;
        this.b[2] = 0.44923629829290207;
        this.b[3] = 0.6510416666666666;
        this.b[4] = -0.322376179245283;
        this.b[5] = 0.13095238095238096;
        this.bdach[0] = 0.08991319444444444;
        this.bdach[2] = 0.4534890685834082;
        this.bdach[3] = 0.6140625;
        this.bdach[4] = -0.2715123820754717;
        this.bdach[5] = 0.08904761904761904;
        this.bdach[6] = 0.025;
        this.beta[0][0] = 1.0;
        this.beta[1][0] = -2.8605386690370884;
        this.beta[2][0] = 3.099577878709121;
        this.beta[3][0] = -1.1618105836403092;
        this.beta[4][0] = 0.013917207301610328;
        this.beta[1][2] = 4.047141499642786;
        this.beta[2][2] = -6.345354046938926;
        this.beta[3][2] = 2.795465086414005;
        this.beta[4][2] = -0.04801624082496286;
        this.beta[1][3] = -3.941160071112659;
        this.beta[2][3] = 10.904003027940295;
        this.beta[3][3] = -6.729317509209278;
        this.beta[4][3] = 0.4175162190483098;
        this.beta[1][4] = 2.8419447015870345;
        this.beta[2][4] = -7.547675862959386;
        this.beta[3][4] = 4.957636724931253;
        this.beta[4][4] = -0.5742817428041846;
        this.beta[1][5] = -1.6109886359167997;
        this.beta[2][5] = 4.218915839039518;
        this.beta[3][5] = -2.950103865566732;
        this.beta[4][5] = 0.47312904339639456;
        this.beta[1][6] = 1.523601174836727;
        this.beta[2][6] = -4.329466835790622;
        this.beta[3][6] = 3.0881301470710616;
        this.beta[4][6] = -0.2822644861171672;
        for (i = 0; i < this.ss; ++i) {
            for (int j = 0; j < i; ++j) {
                int n = i;
                this.c[n] = this.c[n] + this.a[i][j];
            }
        }
        for (i = 0; i < this.s; ++i) {
            this.berr[i] = this.bdach[i] - this.b[i];
        }
        this.potenz = 1.0 / ((double)this.p + 1.0);
    }

    public void rkinit(Model dgl_p, boolean autonom_p, int nvar_p, double eps_p, double tend_p, double h_p) {
        this.dgl = dgl_p;
        this.eps = eps_p;
        this.nvar = nvar_p;
        this.tend = tend_p;
        this.tlast = Double.MAX_VALUE;
        this.autonom = autonom_p;
        if (Math.abs(h_p) >= 9.9E-324) {
            this.Schrittweite = h_p;
        }
        this.maxfail = 0;
    }

    public double[] rkstep(double t, double[] y) throws Exception {
        boolean fail;
        int i;
        double ydiff = 0.0;
        double ttemp = 0.0;
        int ifail = 0;
        this.tt = t;
        if (!this.fsal || Math.abs(t - this.tlast) > 9.9E-324) {
            this.dgl.dgl(t, y, this.k[0]);
        } else {
            for (i = 0; i < this.nvar; ++i) {
                this.k[0][i] = this.k[this.s - 1][i];
            }
        }
        do {
            double hfakt;
            int l;
            if (t + this.Schrittweite > this.tend) {
                this.Schrittweite = this.tend - t;
            }
            for (i = 1; i < this.s; ++i) {
                for (l = 0; l < this.nvar; ++l) {
                    this.ytemp[l] = 0.0;
                    for (int j = 0; j < i; ++j) {
                        int n = l;
                        this.ytemp[n] = this.ytemp[n] + this.a[i][j] * this.k[j][l];
                    }
                    this.ytemp[l] = y[l] + this.Schrittweite * this.ytemp[l];
                }
                if (!this.autonom) {
                    ttemp = t + this.c[i] * this.Schrittweite;
                }
                this.dgl.dgl(ttemp, this.ytemp, this.k[i]);
            }
            double err = 0.0;
            for (l = 0; l < this.nvar; ++l) {
                ydiff = 0.0;
                this.yneu[l] = 0.0;
                for (i = 0; i < this.s; ++i) {
                    int n = l;
                    this.yneu[n] = this.yneu[n] + this.b[i] * this.k[i][l];
                    ydiff += this.berr[i] * this.k[i][l];
                }
                ydiff = Math.abs(this.Schrittweite * ydiff);
                err = RungeKutta.max(err, ydiff);
                this.yneu[l] = y[l] + this.Schrittweite * this.yneu[l];
            }
            fail = err > this.eps;
            if (fail) {
                ++ifail;
            }
            if (ifail > this.maxfail && ifail % 10 == 0) {
                this.error(rbundle.getString("Schrittweite_erfolglos_verkleinert").replace("#", "" + ifail));
                this.maxfail = ifail;
            }
            if ((hfakt = 0.9 * Math.pow(this.eps / err, this.potenz)) < 0.1) {
                hfakt = 0.1;
            }
            if (hfakt > 5.0) {
                hfakt = 5.0;
            }
            this.h0 = this.Schrittweite;
            if (ifail != 0 && !(hfakt < 1.0)) continue;
            this.Schrittweite *= hfakt;
        } while (fail);
        this.nfail += (long)ifail;
        ++this.ngood;
        for (i = 0; i < this.nvar; ++i) {
            this.ybeg[i] = y[i];
        }
        this.neu = true;
        this.yneu[this.nvar] = this.tlast = t + this.h0;
        return this.yneu;
    }

    public double[] rkipol(double ts) throws Exception {
        double sigma;
        int l;
        int i;
        double ttemp = 0.0;
        if (this.neu) {
            int j;
            for (i = this.s; i < this.ss; ++i) {
                for (l = 0; l < this.nvar; ++l) {
                    this.ytemp1[l] = 0.0;
                    for (j = 0; j < i; ++j) {
                        int n = l;
                        this.ytemp1[n] = this.ytemp1[n] + this.a[i][j] * this.k[j][l];
                    }
                    this.ytemp1[l] = this.ybeg[l] + this.h0 * this.ytemp1[l];
                }
                if (!this.autonom) {
                    ttemp = this.tt + this.c[i] * this.h0;
                }
                this.dgl.dgl(ttemp, this.ytemp1, this.k[i]);
            }
            for (l = 0; l < this.nvar; ++l) {
                this.aa[0][l] = this.ybeg[l];
                for (j = 1; j <= this.d; ++j) {
                    this.aa[j][l] = 0.0;
                    for (i = 0; i < this.ss; ++i) {
                        double[] dArray = this.aa[j];
                        int n = l;
                        dArray[n] = dArray[n] + this.beta[j - 1][i] * this.k[i][l];
                    }
                    double[] dArray = this.aa[j];
                    int n = l;
                    dArray[n] = dArray[n] * this.h0;
                }
            }
            this.neu = false;
        }
        if ((sigma = (ts - this.tt) / this.h0) < 0.0 || sigma > 1.0) {
            this.error("sigma au\u00dferhalb Bereich 0...1. ts=" + ts + " tt=" + this.tt + " h0=" + this.h0);
        }
        for (l = 0; l < this.nvar; ++l) {
            this.yneu[l] = this.aa[this.d][l];
            for (i = this.d - 1; i >= 0; --i) {
                this.yneu[l] = this.yneu[l] * sigma + this.aa[i][l];
            }
        }
        return this.yneu;
    }

    public double[] iteration(double t, double[] y) throws Exception {
        this.dgl.dgl(t, y, this.ytemp1);
        System.arraycopy(this.ytemp1, 0, this.yneu, 0, this.nvar);
        this.yneu[this.nvar] = t + this.Schrittweite;
        return this.yneu;
    }

    public double[] eulerstep(double t, double[] y) throws Exception {
        double dt = this.Schrittweite;
        this.dgl.dgl(t, y, this.ytemp1);
        for (int i = 0; i < this.nvar; ++i) {
            this.yneu[i] = y[i] + this.ytemp1[i] * dt;
        }
        this.yneu[this.nvar] = t + dt;
        return this.yneu;
    }

    public double[] heunstep(double t, double[] y) throws Exception {
        int i;
        double dt = this.Schrittweite;
        this.dgl.dgl(t, y, this.ytemp1);
        for (i = 0; i < this.nvar; ++i) {
            this.ytemp2[i] = y[i] + this.ytemp1[i] * dt;
        }
        this.dgl.dgl(t + dt, this.ytemp2, this.ytemp2);
        for (i = 0; i < this.nvar; ++i) {
            this.yneu[i] = y[i] + 0.5 * dt * (this.ytemp1[i] + this.ytemp2[i]);
        }
        this.yneu[this.nvar] = t + dt;
        return this.yneu;
    }

    public double[] rkstdstep(double t, double[] y) throws Exception {
        int i;
        double dt = this.Schrittweite;
        double dth = dt / 2.0;
        this.dgl.dgl(t, y, this.dy);
        for (i = 0; i < this.nvar; ++i) {
            this.yA[i] = y[i] + dth * this.dy[i];
        }
        this.dgl.dgl(t + dth, this.yA, this.dyA);
        for (i = 0; i < this.nvar; ++i) {
            this.yB[i] = y[i] + dth * this.dyA[i];
        }
        this.dgl.dgl(t + dth, this.yA, this.dyB);
        for (i = 0; i < this.nvar; ++i) {
            this.yC[i] = y[i] + dt * this.dyB[i];
        }
        this.dgl.dgl(t + dt, this.yC, this.dyC);
        for (i = 0; i < this.nvar; ++i) {
            this.yneu[i] = y[i] + dt / 6.0 * (this.dy[i] + 2.0 * (this.dyA[i] + this.dyB[i]) + this.dyC[i]);
        }
        this.yneu[this.nvar] = t + dt;
        return this.yneu;
    }
}

