/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class AskSaveChangesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/AskSaveChangesDialog", Statics.locale);
    public static final int DONTSAVE = 0;
    public static final int CANCEL = 1;
    public static final int SAVE = 2;
    Document projekt;
    int state = 1;
    private JButton cancelButton;
    private JButton dontSaveButton;
    private JLabel explanationLabel;
    private JLabel questionLabel;
    private JButton saveButton;

    public AskSaveChangesDialog(Document prj) {
        super(prj.getViewer().getWindow());
        this.projekt = prj;
        this.initComponents();
        this.questionLabel.setText(this.questionLabel.getText().replace("xy", "\"" + prj.getPrjName() + "\""));
        this.saveButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.saveButton);
        this.saveButton.requestFocus();
    }

    @Override
    public void setVisible(boolean what) {
        Point p;
        try {
            p = this.getParent().getLocationOnScreen();
            p.translate((this.getParent().getWidth() - this.getWidth()) / 2, (this.getParent().getHeight() - this.getHeight()) / 4);
        }
        catch (Exception ex) {
            Dimension sdim = Toolkit.getDefaultToolkit().getScreenSize();
            p = new Point(sdim.width / 2 - this.getWidth() / 2, (int)((double)sdim.height * 0.2));
        }
        this.setLocation(p);
        super.setVisible(what);
    }

    public int display() {
        this.setVisible(true);
        return this.state;
    }

    private void initComponents() {
        JLabel imageLabel = new JLabel();
        this.questionLabel = new JLabel();
        this.explanationLabel = new JLabel();
        this.dontSaveButton = new JButton();
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("");
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        imageLabel.setHorizontalAlignment(0);
        imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/ProgramIcon_100.png")));
        imageLabel.setMaximumSize(new Dimension(160, 160));
        imageLabel.setName("imageLabel");
        imageLabel.setPreferredSize(new Dimension(120, 115));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)imageLabel, gridBagConstraints);
        this.questionLabel.setFont(new Font("Dialog", 1, 13));
        this.questionLabel.setText(this.rbundle.getString("MainText"));
        this.questionLabel.setName("questionLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(17, 6, 0, 0);
        this.getContentPane().add((Component)this.questionLabel, gridBagConstraints);
        this.explanationLabel.setFont(new Font("Dialog", 0, 12));
        this.explanationLabel.setText(this.rbundle.getString("SubText"));
        this.explanationLabel.setName("explanationLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 6, 0, 0);
        this.getContentPane().add((Component)this.explanationLabel, gridBagConstraints);
        this.dontSaveButton.setText(this.rbundle.getString("Nicht_sichern"));
        this.dontSaveButton.setName("dontSaveButton");
        this.dontSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskSaveChangesDialog.this.dontSaveButtonActionPerformed(evt);
            }
        });
        this.dontSaveButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AskSaveChangesDialog.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.getContentPane().add((Component)this.dontSaveButton, gridBagConstraints);
        this.cancelButton.setText(this.rbundle.getString("Abbrechen"));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskSaveChangesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AskSaveChangesDialog.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(6, 38, 12, 0);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.saveButton.setText(this.rbundle.getString("Sichern..."));
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AskSaveChangesDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.saveButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AskSaveChangesDialog.this.keyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 12, 16);
        this.getContentPane().add((Component)this.saveButton, gridBagConstraints);
        this.pack();
    }

    private void dontSaveButtonActionPerformed(ActionEvent evt) {
        this.state = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.state = 1;
        this.setVisible(false);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.state = 2;
        this.setVisible(false);
    }

    private void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.cancelButton.doClick();
        }
        if (evt.getKeyChar() == 'd' && (evt.getKeyCode() & 0x9D) != 0) {
            this.dontSaveButton.doClick();
        }
    }
}

