/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Statics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class GreekLetterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Border border = BorderFactory.createLineBorder(new Color(0, 0, 0));
    private static final Border emptyborder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final String[] greekLetters = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "jota", "kappa", "lambda", "mu", "nu", "xi", "omikron", "pi", "rho", "sigma", "tau", "ypsilon", "phi", "chi", "psi", "omega", "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Jota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omikron", "Pi", "Rho", "Sigma", "Tau", "Ypsilon", "Phi", "Chi", "Psi", "Omega"};
    public static final String[] greekSymbols = new String[]{"\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03d1", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9", "\u0391", "\u0392", "\u0393", "\u0394", "\u0395", "\u0396", "\u0397", "\u0398", "\u0399", "\u039a", "\u039b", "\u039c", "\u039d", "\u039e", "\u039f", "\u03a0", "\u03a1", "\u03a3", "\u03a4", "\u03a5", "\u03a6", "\u03a7", "\u03a8", "\u03a9"};
    public static JPopupMenu greekLettersPM;

    public GreekLetterPanel() {
        ResourceBundle prop = ResourceBundle.getBundle("de/didappslib/guitools/resources/GreekLetterPanel", Statics.locale);
        if (Statics.os.contains("Mac")) {
            GreekLetterPanel.greekSymbols[20] = "\u03d5";
        }
        this.initComponents();
        greekLettersPM.setBackground(Statics.sidebarBackColor);
        this.setBackground(Statics.sidebarBackColor);
        Font font = new Font("Serif", 2, 15);
        GridBagConstraints constraints = new GridBagConstraints();
        for (int i = 0; i < greekLetters.length; ++i) {
            JLabel label = new JLabel(greekSymbols[i]);
            if (i != 15) {
                label.setToolTipText(greekLetters[i]);
            } else {
                label.setToolTipText(prop.getString("\u03c0_is_a_constant"));
                label.setEnabled(false);
            }
            label.setFont(font);
            label.setHorizontalAlignment(0);
            label.setBorder(emptyborder);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    GreekLetterPanel.this.labelMouseClicked(evt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    GreekLetterPanel.this.labelMouseExited(evt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    GreekLetterPanel.this.labelMouseEntered(evt);
                }
            });
            constraints.gridx = i % 12;
            constraints.gridy = i / 12;
            constraints.fill = 2;
            label.setPreferredSize(new Dimension(26, label.getMinimumSize().height));
            constraints.ipady = 2;
            this.add((Component)label, constraints);
        }
        greekLettersPM.insert(this, 0);
    }

    private void labelMouseExited(MouseEvent evt) {
        if (evt.getComponent() instanceof JLabel) {
            ((JLabel)evt.getComponent()).setBorder(emptyborder);
        }
    }

    private void labelMouseEntered(MouseEvent evt) {
        if (evt.getComponent() instanceof JLabel && !((JLabel)evt.getComponent()).getText().equals("\u03c0")) {
            ((JLabel)evt.getComponent()).setBorder(border);
        }
    }

    private void labelMouseClicked(MouseEvent evt) {
        JTextComponent tc = (JTextComponent)greekLettersPM.getInvoker();
        greekLettersPM.setVisible(false);
        if (tc == null || ((JLabel)evt.getComponent()).getText().equals("\u03c0")) {
            return;
        }
        int cpos = tc.getSelectionStart();
        int l = ((JLabel)evt.getComponent()).getText().length();
        tc.replaceSelection(((JLabel)evt.getComponent()).getText());
        tc.setCaretPosition(cpos + l);
        tc.moveCaretPosition(cpos + l);
        tc.firePropertyChange("GreekInserted", true, false);
    }

    private void initComponents() {
        greekLettersPM = new JPopupMenu();
        greekLettersPM.setInheritsPopupMenu(true);
        greekLettersPM.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                GreekLetterPanel.this.greekLettersPMPopupMenuWillBecomeVisible(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GreekLetterPanel.this.formMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GreekLetterPanel.this.formMouseExited(evt);
            }
        });
        this.setLayout(new GridBagLayout());
    }

    private void formMouseExited(MouseEvent evt) {
    }

    private void formMouseEntered(MouseEvent evt) {
    }

    private void greekLettersPMPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((JLabel)this.getComponent(i)).setBorder(emptyborder);
        }
    }
}

