/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Statics;
import de.didappslib.guitools.AutoDialog;
import java.awt.Desktop;
import java.io.File;
import javax.swing.JDialog;

public class MacSpecials {
    public MacSpecials() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        try {
            Desktop thisDesktop = Desktop.getDesktop();
            thisDesktop.setAboutHandler(ae -> Statics.aboutBox.setVisible(true));
            thisDesktop.setPreferencesHandler(pe -> {
                Statics.prefsDialog.setVisible(true);
                Statics.prefsDialog.toFront();
            });
            thisDesktop.setOpenFileHandler(ofe -> {
                Statics.macStartupFile = true;
                File file = ofe.getFiles().get(0);
                Statics.projektLaden(file.getParent(), file.getName());
            });
            thisDesktop.setPrintFileHandler(pfe -> {
                File file = pfe.getFiles().get(0);
                Statics.projektLaden(file.getParent(), file.getName());
                Statics.aktProjekt.getViewer().getMenus().druckeAktDarstellung();
            });
            thisDesktop.setQuitHandler((qe, qr) -> {
                if (Statics.quit()) {
                    qr.performQuit();
                } else {
                    qr.cancelQuit();
                }
            });
        }
        catch (Error e) {
            new AutoDialog((JDialog)null).display("Notification: Mac desktop integration failed.", "Standard Java is used.");
        }
        Statics.macSpecialsLoaded = true;
    }
}

