/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.PrefsDialog;
import de.didappslib.base.Statics;
import java.io.File;
import java.util.Stack;

public class UsedDocs
extends Stack {
    private final int maxElements = 10;
    private final PrefsDialog pDialog;

    public UsedDocs(PrefsDialog pd) {
        this.pDialog = pd;
        this.readListFromPrefs();
    }

    public void insertNewElement(String filename, String pathname) {
        usedDoc udoc = new usedDoc(filename, pathname);
        if (this.contains(udoc)) {
            this.remove(udoc);
        }
        this.add(0, udoc);
        if (this.size() > 10) {
            this.remove(this.size() - 1);
        }
        Statics.prefsDialog.lastProjectPath = pathname;
        Statics.prefsDialog.lastProjectFName = filename;
    }

    public final void readListFromPrefs() {
        String[] s = Statics.prefsDialog.getUsedDocs().split("\n");
        for (int i = 0; i < Integer.parseInt(s[0]); ++i) {
            usedDoc udoc;
            String[] ss = s[i + 1].split("\t");
            if (ss.length != 2 || !(udoc = new usedDoc(ss[0], ss[1])).check()) continue;
            this.push(udoc);
        }
    }

    public void writeListToPrefs() {
        String s = this.size() + "\n";
        for (int i = 0; i < this.size(); ++i) {
            s = s + ((usedDoc)this.get(i)).prints() + "\n";
        }
        this.pDialog.putUsedDocs(s);
    }

    public String getDisplayName(int i) {
        return ((usedDoc)this.get((int)i)).displayName;
    }

    public String getFileName(int i) {
        return ((usedDoc)this.get((int)i)).fileName;
    }

    public String getPathName(int i) {
        return ((usedDoc)this.get((int)i)).pathName;
    }

    public boolean check(int i) {
        return ((usedDoc)this.get(i)).check();
    }

    private class usedDoc {
        String displayName = "";
        String fileName = "";
        String pathName = "";

        public usedDoc(String fn, String pn) {
            this.fileName = fn;
            this.pathName = pn;
            this.displayName = fn;
        }

        public boolean check() {
            boolean ergebnis = false;
            if (!this.pathName.equals("") && !this.fileName.equals("")) {
                ergebnis = new File(this.pathName, this.fileName).exists();
            }
            return ergebnis;
        }

        public boolean equals(Object o) {
            return ((usedDoc)o).fileName.equals(this.fileName) && ((usedDoc)o).pathName.equals(this.pathName);
        }

        public String prints() {
            return this.fileName + "\t" + this.pathName;
        }
    }
}

