/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.djep.diffRules;

import com.singularsys.extensions.djep.DJep;
import com.singularsys.extensions.djep.DiffRulesI;
import com.singularsys.extensions.djep.DifferentiationVisitor;
import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.DeepCopyVisitor;
import com.singularsys.jep.walkers.SubstitutionVisitor;

public abstract class ChainRuleDiffRules
implements DiffRulesI {
    private static final long serialVersionUID = 340L;
    private String name;
    private PostfixMathCommandI pfmc;
    private Node[] rules = null;
    private String[] descriptions = null;
    private String[] argNames = null;
    protected DifferentiationVisitor dv;
    protected OperatorTableI opSet;
    protected NodeFactory nf;
    protected DeepCopyVisitor copier;
    protected SubstitutionVisitor subv;

    protected ChainRuleDiffRules(DJep dJep) {
        this.opSet = dJep.getOperatorTable();
        this.nf = dJep.getNodeFactory();
        this.dv = dJep.getDifferentationVisitor();
        this.copier = dJep.getCopier();
        this.subv = dJep.getSubstitutionVisitor();
    }

    protected void setup(String string, PostfixMathCommandI postfixMathCommandI, Node node, String string2) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.rules = new Node[]{node};
        this.descriptions = new String[]{string2};
        this.argNames = new String[]{"x"};
    }

    protected void setup(String string, PostfixMathCommandI postfixMathCommandI, Node node, Node node2, String string2, String string3) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.rules = new Node[]{node, node2};
        this.descriptions = new String[]{string2, string3};
        this.argNames = new String[]{"x", "y"};
    }

    protected void setup(String string, PostfixMathCommandI postfixMathCommandI, Node[] nodeArray, String[] stringArray, String[] stringArray2) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.rules = nodeArray;
        this.descriptions = stringArray;
        this.argNames = stringArray2;
    }

    @Override
    public Node differentiate(ASTFunNode aSTFunNode, String string, Node[] nodeArray, Node[] nodeArray2) throws JepException {
        int n;
        int n2 = this.rules.length;
        if (n2 != nodeArray.length) {
            throw new ParseException("Error differentiating " + this.name + " number of rules " + n2 + " != number of arguments " + nodeArray.length);
        }
        if (n2 == 1) {
            Node node = this.copier.deepCopy(this.rules[0]);
            Node node2 = nodeArray[0];
            if (node2 instanceof ASTVarNode && ((ASTVarNode)node2).getName().equals(string)) {
                Node node3 = this.subv.substitute(node, this.argNames[0], node2);
                return node3;
            }
            Node node4 = this.subv.substitute(node, this.argNames[0], node2);
            Node node5 = nodeArray2[0];
            return this.nf.buildOperatorNode(this.opSet.getMultiply(), node4, node5);
        }
        if (n2 == 2) {
            Node node = this.copier.deepCopy(this.rules[0]);
            Node node6 = this.copier.deepCopy(this.rules[1]);
            Node node7 = nodeArray2[0];
            Node node8 = nodeArray2[1];
            node = this.subv.substitute(node, this.argNames, nodeArray);
            node6 = this.subv.substitute(node6, this.argNames, nodeArray);
            return this.nf.buildOperatorNode(this.opSet.getAdd(), this.nf.buildOperatorNode(this.opSet.getMultiply(), node, node7), this.nf.buildOperatorNode(this.opSet.getMultiply(), node6, node8));
        }
        if (n2 < 1) {
            throw new ParseException("Error differentiating " + this.name + " zero differention rules!");
        }
        String[] stringArray = new String[n2];
        Node[] nodeArray3 = new Node[n2];
        Node[] nodeArray4 = new Node[n2];
        for (n = 0; n < n2; ++n) {
            nodeArray3[n] = this.copier.deepCopy(this.rules[n]);
            stringArray[n] = "x" + (n + 1);
        }
        for (n = 0; n < n2; ++n) {
            nodeArray3[n] = this.subv.substitute(nodeArray3[n], this.argNames, nodeArray);
            nodeArray4[n] = this.nf.buildOperatorNode(this.opSet.getMultiply(), nodeArray3[n], nodeArray2[n]);
        }
        return this.nf.buildOperatorNode(this.opSet.getAdd(), nodeArray4);
    }

    @Override
    public void init(Jep jep) {
        this.opSet = jep.getOperatorTable();
        this.nf = jep.getNodeFactory();
        this.dv = ((DJep)jep).getDifferentationVisitor();
        this.copier = ((XJep)jep).getCopier();
        this.subv = ((XJep)jep).getSubstitutionVisitor();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public PostfixMathCommandI getPfmc() {
        return this.pfmc;
    }

    public int getNumRules() {
        return this.rules.length;
    }

    public Node getRule(int n) {
        return this.rules[n];
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.rules == null) {
            stringBuffer.append("no diff rules possible parse error?");
        } else {
            int n;
            stringBuffer.append("diff(" + this.name + "(");
            for (n = 0; n < this.argNames.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.argNames[n]);
            }
            stringBuffer.append("),t) -> ");
            for (n = 0; n < this.getNumRules(); ++n) {
                if (n > 0) {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append(this.descriptions[n] + "*diff(" + this.argNames[n] + ",t)");
            }
        }
        return stringBuffer.toString();
    }
}

