/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.djep.diffRules;

import com.singularsys.extensions.djep.DJep;
import com.singularsys.extensions.djep.DiffRulesI;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.Node;

public class PassThroughDiffRule
implements DiffRulesI {
    private static final long serialVersionUID = 340L;
    private final String name;
    private final PostfixMathCommandI pfmc;
    private Operator op = null;
    private NodeFactory nf;

    public PassThroughDiffRule(DJep dJep, String string) {
        this.name = string;
        this.pfmc = dJep.getFunctionTable().getFunction(this.name);
        this.nf = dJep.getNodeFactory();
    }

    public PassThroughDiffRule(DJep dJep, String string, PostfixMathCommandI postfixMathCommandI) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.nf = dJep.getNodeFactory();
    }

    public PassThroughDiffRule(DJep dJep, Operator operator) {
        this(dJep, operator.getName(), operator.getPFMC());
        this.op = operator;
        this.nf = dJep.getNodeFactory();
    }

    @Override
    public void init(Jep jep) {
        this.nf = jep.getNodeFactory();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    @Override
    public String toString() {
        if (this.pfmc == null) {
            return this.name + " Passthrough but no math command!";
        }
        switch (this.pfmc.getNumberOfParameters()) {
            case 0: {
                return "diff(" + this.name + "(),x) -> " + this.name + "()";
            }
            case 1: {
                return "diff(" + this.name + "(a),x) -> " + this.name + "(diff(a,x))";
            }
            case 2: {
                return "diff(" + this.name + "(a,b),x) -> " + this.name + "(diff(a,x),diff(b,x))";
            }
        }
        return "diff(" + this.name + "(a,b,...),x) -> " + this.name + "(diff(a,x),diff(b,x),...)";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node differentiate(ASTFunNode aSTFunNode, String string, Node[] nodeArray, Node[] nodeArray2) throws ParseException {
        if (this.op != null) {
            return this.nf.buildOperatorNode(this.op, nodeArray2);
        }
        return this.nf.buildFunctionNode(aSTFunNode, nodeArray2);
    }
}

