/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MObjStore;
import com.singularsys.extensions.fastmatrix.MScalerStore;
import com.singularsys.extensions.fastmatrix.MatObj;
import com.singularsys.extensions.fastmatrix.MatStore;
import com.singularsys.extensions.fastmatrix.MrpCommandList;
import com.singularsys.extensions.fastmatrix.MrpRes;
import com.singularsys.extensions.fastmatrix.MrpVarRef;
import com.singularsys.extensions.fastmatrix.ScalerObj;
import com.singularsys.extensions.fastmatrix.VecObj;
import com.singularsys.extensions.fastmatrix.VecStore;
import com.singularsys.extensions.fastreal.AbstractEval;
import com.singularsys.extensions.matrix.DimensionVisitor;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.NaryBinaryFunction;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.reals.RealNaryFunction;
import com.singularsys.jep.reals.RealNullaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public final class MrpEval
extends AbstractEval {
    private static final long serialVersionUID = 350L;
    private MatrixFactoryI mfac;
    private int indexShift = -1;
    private final ScalerObj scalerRes = new ScalerObj(0.0);
    MScalerStore scalerStore = new MScalerStore(this);
    private final VecStore vnStore = new VecStore(this);
    private final MatStore mnnStore = new MatStore(this);
    private List<VectorI> vectorArgs = new ArrayList<VectorI>();
    private List<MatrixI> matrixArgs = new ArrayList<MatrixI>();
    private MrpCommandList curCommandList;
    private static final double LOG10 = Math.log(10.0);
    private final Stack<Object> stack = new Stack();
    private final double[] unaryArgs = new double[1];
    private final Double[] unaryArgsD = new Double[1];
    private final double[] binaryArgs = new double[2];
    private final Double[] binaryArgsD = new Double[2];
    private final double[] triArgs = new double[3];
    private final Double[] triArgsD = new Double[3];
    private final double[] quartArgs = new double[4];
    private final Double[] quartArgsD = new Double[4];

    public MrpEval(Jep jep, MatrixFactoryI matrixFactoryI) {
        super(jep);
        this.mfac = matrixFactoryI;
    }

    private Dimensions getDimensions(Node node) {
        return (Dimensions)node.getHook(DimensionVisitor.DIM_KEY);
    }

    public final MrpCommandList compile(Variable variable, Node node) throws ParseException {
        MrpCommandList mrpCommandList = this.compile(node);
        Dimensions dimensions = (Dimensions)variable.getHook(DimensionVisitor.DIM_KEY);
        short s = MrpEval.getDimType(dimensions);
        MObjStore mObjStore = this.getStoreByDimType(s);
        short s2 = (short)mObjStore.addVar(variable, dimensions);
        mObjStore.decStack();
        mrpCommandList.addCommand((short)20, MrpEval.getDimType(dimensions), s2);
        return mrpCommandList;
    }

    public final MrpCommandList compile(Node node) throws ParseException {
        this.curCommandList = new MrpCommandList();
        this.resetStores();
        try {
            node.jjtAccept(this, null);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        this.scalerStore.alloc();
        this.vnStore.alloc();
        this.mnnStore.alloc();
        Dimensions dimensions = this.getDimensions(node);
        this.curCommandList.setResultDim(dimensions, MrpEval.getDimType(dimensions));
        return this.curCommandList;
    }

    private static final short getDimType(Dimensions dimensions) {
        if (dimensions.is0D()) {
            return 1;
        }
        if (dimensions.is1D()) {
            return 5;
        }
        if (dimensions.is2D()) {
            return 15;
        }
        return 16;
    }

    private short getBigDimType(Dimensions dimensions) throws ParseException {
        if (dimensions.is0D()) {
            return 1;
        }
        if (dimensions.is1D()) {
            int n = dimensions.getFirstDim();
            if (n >= 256) {
                throw new ParseException("Max suported dimensions is 255");
            }
            return (short)n;
        }
        if (dimensions.is2D()) {
            int n = dimensions.getFirstDim();
            int n2 = dimensions.getLastDim();
            if (n >= 256 || n2 >= 256) {
                throw new ParseException("Max suported dimensions is 255");
            }
            short s = (short)((n << 8) + n2);
            return s;
        }
        throw new ParseException("Only two and three dimensional arguments supported");
    }

    final Dimensions getDimByValue(Object object) throws ParseException {
        if (object instanceof MatrixI) {
            return ((MatrixI)object).getDimensions();
        }
        if (object instanceof VectorI) {
            return ((VectorI)object).getDimensions();
        }
        if (object instanceof Number) {
            return Dimensions.ONE;
        }
        throw new ParseException("Sorry, can only handle scaler, vectors and matrices");
    }

    private final MObjStore getStoreByDimType(short s) {
        switch (s) {
            case 1: {
                return this.scalerStore;
            }
            case 5: {
                return this.vnStore;
            }
            case 15: {
                return this.mnnStore;
            }
        }
        return null;
    }

    private final void incStackByDim(Dimensions dimensions) {
        short s = MrpEval.getDimType(dimensions);
        MObjStore mObjStore = this.getStoreByDimType(s);
        mObjStore.incStack();
    }

    private final void decStackByDim(Dimensions dimensions) throws ParseException {
        short s = MrpEval.getDimType(dimensions);
        MObjStore mObjStore = this.getStoreByDimType(s);
        mObjStore.decStack();
    }

    private short incHeapByDim(Dimensions dimensions) {
        switch (dimensions.order()) {
            case 0: {
                this.scalerStore.incHeap();
                return -1;
            }
            case 1: {
                return this.vnStore.incHeap(dimensions.getFirstDim());
            }
            case 2: {
                return this.mnnStore.incHeap(dimensions.getFirstDim(), dimensions.getLastDim());
            }
        }
        return Short.MIN_VALUE;
    }

    private short getArgNumber(Dimensions dimensions) throws EvaluationException {
        if (dimensions.is0D()) {
            return 1;
        }
        if (dimensions.is1D()) {
            VectorI vectorI = this.mfac.zeroVec(dimensions.getFirstDim());
            this.vectorArgs.add(vectorI);
            return (short)(this.vectorArgs.size() << 1);
        }
        if (dimensions.is2D()) {
            MatrixI matrixI = this.mfac.zeroMat(dimensions.getFirstDim(), dimensions.getLastDim());
            this.matrixArgs.add(matrixI);
            return (short)((this.matrixArgs.size() << 1) + 1);
        }
        return 0;
    }

    private Object getVectorMatrixArg(short s) {
        if (s == 1) {
            return null;
        }
        if (s % 2 == 0) {
            int n = (s >> 1) - 1;
            return this.vectorArgs.get(n);
        }
        int n = (s >> 1) - 1;
        return this.matrixArgs.get(n);
    }

    private final void addConstant(Object object) throws ParseException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            this.scalerStore.incStack();
            short s = this.scalerStore.addConstant(d);
            this.curCommandList.addCommand((short)0, (short)1, s);
        } else if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            this.scalerStore.incStack();
            short s = this.scalerStore.addConstant(bl ? 1.0 : 0.0);
            this.curCommandList.addCommand((short)0, (short)1, s);
        } else if (object instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            Dimensions dimensions = Dimensions.valueOf(vectorI);
            short s = MrpEval.getDimType(dimensions);
            if (s == 1) {
                Double d = (Double)vectorI.getEle(0);
                short s2 = this.scalerStore.addConstant(d);
                this.scalerStore.incStack();
                this.curCommandList.addCommand((short)0, s, s2);
            } else {
                short s3 = this.vnStore.addConstant(vectorI);
                this.vnStore.incStack();
                this.curCommandList.addCommand((short)0, s, s3);
            }
        } else if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            Dimensions dimensions = Dimensions.valueOf(matrixI);
            short s = MrpEval.getDimType(dimensions);
            this.mnnStore.incStack();
            short s4 = this.mnnStore.addConstant(matrixI);
            this.curCommandList.addCommand((short)0, s, s4);
        } else {
            throw new ParseException("RpeEval: only constants of double type allowed, found " + object + "(" + object.getClass().getSimpleName() + ")");
        }
    }

    @Override
    public final Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        this.addConstant(aSTConstant.getValue());
        return null;
    }

    @Override
    public final Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        Dimensions dimensions = this.getDimensions(aSTVarNode);
        Variable variable = aSTVarNode.getVar();
        if (variable.isConstant()) {
            this.addConstant(variable.getValue());
            return null;
        }
        if (dimensions == null) {
            throw new ParseException("No dimensions specified for node " + aSTVarNode.toString());
        }
        Dimensions dimensions2 = (Dimensions)variable.getHook(DimensionVisitor.DIM_KEY);
        if (dimensions2 != null && !dimensions.equalsDim(dimensions2)) {
            System.out.println("Variable " + variable.toString() + " dimensions do not match " + dimensions2 + " " + dimensions);
        }
        short s = MrpEval.getDimType(dimensions);
        this.checkOutOfDateVarRefs(variable, s);
        MObjStore mObjStore = this.getStoreByDimType(s);
        short s2 = (short)mObjStore.addVar(variable, dimensions);
        mObjStore.incStack();
        this.curCommandList.addCommand((short)1, s, s2);
        return null;
    }

    void checkOutOfDateVarRefs(Variable variable, int n) {
        int n2 = this.scalerStore.jepVarIndex.indexOf(variable);
        int n3 = this.vnStore.jepVarIndex.indexOf(variable);
        int n4 = this.mnnStore.jepVarIndex.indexOf(variable);
        switch (n) {
            case 1: {
                if (n3 >= 0) {
                    this.vnStore.removeVariable(variable);
                }
                if (n4 < 0) break;
                this.mnnStore.removeVariable(variable);
                break;
            }
            case 5: {
                if (n2 >= 0) {
                    this.scalerStore.removeVariable(variable);
                }
                if (n4 < 0) break;
                this.mnnStore.removeVariable(variable);
                break;
            }
            case 15: {
                if (n2 >= 0) {
                    this.scalerStore.removeVariable(variable);
                }
                if (n3 < 0) break;
                this.vnStore.removeVariable(variable);
                break;
            }
        }
    }

    public Object visitAssign(ASTOpNode aSTOpNode) throws JepException, ParseException {
        aSTOpNode.jjtGetChild(1).jjtAccept(this, null);
        Dimensions dimensions = this.getDimensions(aSTOpNode);
        Variable variable = aSTOpNode.jjtGetChild(0).getVar();
        if (variable == null) {
            if (this.opSet.getEle().equals(aSTOpNode.jjtGetChild(0).getOperator())) {
                return this.visitSetEle(aSTOpNode);
            }
            throw new ParseException("visitAssign only implemented for simple variables on lhs, not lvalue array elements like x[3] = 4");
        }
        Dimensions dimensions2 = (Dimensions)variable.getHook(DimensionVisitor.DIM_KEY);
        if (dimensions2 != null && !dimensions.equalsDim(dimensions2)) {
            throw new ParseException("visitAssign: Variable " + variable.toString() + " dimensions do not match " + dimensions2 + " " + dimensions);
        }
        short s = MrpEval.getDimType(dimensions);
        this.checkOutOfDateVarRefs(variable, s);
        MObjStore mObjStore = this.getStoreByDimType(s);
        short s2 = (short)mObjStore.addVar(variable, dimensions);
        this.curCommandList.addCommand((short)20, s, s2);
        return null;
    }

    public Object visitSetEle(ASTOpNode aSTOpNode) throws JepException, ParseException {
        Node node;
        short s;
        Node node2 = aSTOpNode.jjtGetChild(0);
        int n = node2.jjtGetNumChildren();
        for (s = n - 1; s >= 1; --s) {
            node = node2.jjtGetChild(s);
            node.jjtAccept(this, null);
        }
        s = MrpEval.getDimType(this.getDimensions(aSTOpNode));
        node = node2.jjtGetChild(0);
        Variable variable = node.getVar();
        Dimensions dimensions = (Dimensions)variable.getHook(DimensionVisitor.DIM_KEY);
        short s2 = MrpEval.getDimType(dimensions);
        MObjStore mObjStore = this.getStoreByDimType(s2);
        short s3 = (short)mObjStore.addVar(variable, dimensions);
        this.curCommandList.addCommand((short)29, s2, s3, s);
        return null;
    }

    @Override
    public final Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        Operator operator = aSTOpNode.getOperator();
        if (operator == this.opSet.getAssign()) {
            return this.visitAssign(aSTOpNode);
        }
        Node node = null;
        Node node2 = null;
        int n = aSTOpNode.jjtGetNumChildren();
        Dimensions dimensions = this.getDimensions(aSTOpNode);
        Dimensions dimensions2 = null;
        Dimensions dimensions3 = null;
        if (aSTOpNode.getOperator() != this.opSet.getPower()) {
            aSTOpNode.childrenAccept(this, null);
        }
        if (n >= 1) {
            node = aSTOpNode.jjtGetChild(0);
            dimensions2 = this.getDimensions(node);
        }
        if (n >= 2) {
            node2 = aSTOpNode.jjtGetChild(1);
            dimensions3 = this.getDimensions(node2);
        }
        if (operator.isBinary() && n != 2) {
            throw new ParseException("RpeEval: binary operator must have two children, but it has " + n);
        }
        if (operator.isUnary() && n != 1) {
            throw new ParseException("RpeEval: unary operator must have one child, but it has " + n);
        }
        if (operator == this.opSet.getAdd()) {
            if (!dimensions.equalsDim(dimensions2) || !dimensions.equalsDim(dimensions3)) {
                throw new ParseException("RpeEval: dims for add must be equal");
            }
            this.decStackByDim(dimensions);
            short s = this.incHeapByDim(dimensions);
            this.curCommandList.addCommand((short)2, MrpEval.getDimType(dimensions), s);
            return null;
        }
        if (operator == this.opSet.getSubtract()) {
            if (!dimensions.equalsDim(dimensions2) || !dimensions.equalsDim(dimensions3)) {
                throw new ParseException("RpeEval: dims for add must be equal");
            }
            short s = this.incHeapByDim(dimensions);
            this.curCommandList.addCommand((short)3, MrpEval.getDimType(dimensions), s);
            this.decStackByDim(dimensions);
            return null;
        }
        if (operator == this.opSet.getUMinus()) {
            short s = this.incHeapByDim(dimensions);
            this.curCommandList.addCommand((short)21, MrpEval.getDimType(dimensions), s);
            return null;
        }
        if (operator == this.opSet.getUPlus()) {
            return null;
        }
        if (operator == this.opSet.getMultiply()) {
            this.decStackByDim(dimensions3);
            this.decStackByDim(dimensions2);
            this.incStackByDim(dimensions);
            short s = this.incHeapByDim(dimensions);
            this.curCommandList.addCommand((short)4, MrpEval.getDimType(dimensions2), MrpEval.getDimType(dimensions3), s);
            return null;
        }
        if (operator == this.opSet.getDivide()) {
            if (!dimensions3.is0D()) {
                throw new ParseException("RHS operands of / operator must be a Scaler");
            }
            this.decStackByDim(dimensions3);
            this.decStackByDim(dimensions2);
            this.incStackByDim(dimensions);
            short s = this.incHeapByDim(dimensions);
            this.curCommandList.addCommand((short)5, MrpEval.getDimType(dimensions2), MrpEval.getDimType(dimensions3), s);
            return null;
        }
        if (operator == this.opSet.getMod()) {
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for % operator must both be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)6, (short)1);
            return null;
        }
        if (operator == this.opSet.getPower()) {
            Object object2;
            if (dimensions2 == null || dimensions3 == null) {
                throw new ParseException("BAD DIMS");
            }
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for ^ operator must both be one");
            }
            Node node3 = aSTOpNode.jjtGetChild(0);
            Node node4 = aSTOpNode.jjtGetChild(1);
            node3.jjtAccept(this, null);
            if (node4 instanceof ASTConstant && (object2 = ((ASTConstant)node4).getValue()) instanceof Number) {
                double d = ((Number)object2).doubleValue();
                short s = ((Number)object2).shortValue();
                if (d >= 0.0 && d == (double)s) {
                    this.curCommandList.addCommand((short)22, s);
                    return null;
                }
                if (d == (double)s) {
                    this.curCommandList.addCommand((short)22, -s);
                    this.curCommandList.addCommand((short)23, (short)1);
                    return null;
                }
            }
            node4.jjtAccept(this, null);
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)7, (short)1);
            return null;
        }
        if (operator == this.opSet.getList()) {
            this.visitList(aSTOpNode, n, dimensions);
            return null;
        }
        if (operator == this.opSet.getDot()) {
            this.scalerStore.incStack();
            this.decStackByDim(dimensions3);
            this.decStackByDim(dimensions2);
            this.curCommandList.addCommand((short)18, MrpEval.getDimType(dimensions2));
            return null;
        }
        if (operator == this.opSet.getCross()) {
            if (dimensions2.equalsDim(Dimensions.THREE) && dimensions3.equalsDim(Dimensions.THREE)) {
                this.vnStore.decStack();
                short s = this.vnStore.incHeap(3);
                this.curCommandList.addCommand((short)19, (short)3, s);
                return null;
            }
            if (dimensions2.equalsDim(Dimensions.TWO) && dimensions3.equalsDim(Dimensions.TWO)) {
                this.scalerStore.incStack();
                this.decStackByDim(dimensions2);
                this.decStackByDim(dimensions3);
                this.curCommandList.addCommand((short)19, (short)2);
                return null;
            }
            throw new ParseException("Bad dimensions for cross product " + dimensions2 + " " + dimensions3);
        }
        if (operator == this.opSet.getEQ()) {
            if (!dimensions2.equalsDim(dimensions3)) {
                this.decStackByDim(dimensions2);
                this.decStackByDim(dimensions3);
                this.addConstant(0);
                return null;
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)16, MrpEval.getDimType(dimensions2));
            return null;
        }
        if (operator == this.opSet.getNE()) {
            if (!dimensions2.equalsDim(dimensions3)) {
                this.decStackByDim(dimensions2);
                this.decStackByDim(dimensions3);
                this.addConstant(1);
                return null;
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)15, MrpEval.getDimType(dimensions2));
            return null;
        }
        if (operator == this.opSet.getLT()) {
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for < operator must both be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)11, (short)1);
            return null;
        }
        if (operator == this.opSet.getGT()) {
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for > operator must both be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)13, (short)1);
            return null;
        }
        if (operator == this.opSet.getLE()) {
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for <= operator must both be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)12, (short)1);
            return null;
        }
        if (operator == this.opSet.getGE()) {
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for >= operator must both be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)14, (short)1);
            return null;
        }
        if (operator == this.opSet.getAnd()) {
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for && operator must both be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)8, (short)1);
            return null;
        }
        if (operator == this.opSet.getOr()) {
            if (!dimensions2.is0D() || !dimensions3.is0D()) {
                throw new ParseException("Dimensions of operands for || operator must both be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.decStackByDim(dimensions3);
            this.curCommandList.addCommand((short)9, (short)1);
            return null;
        }
        if (operator == this.opSet.getNot()) {
            if (!dimensions2.is0D()) {
                throw new ParseException("Dimension of operand for not operator must be one");
            }
            this.scalerStore.incStack();
            this.decStackByDim(dimensions2);
            this.curCommandList.addCommand((short)10, (short)1);
            return null;
        }
        if (operator == this.opSet.getEle()) {
            if (n == 3) {
                Node node5 = aSTOpNode.jjtGetChild(2);
                Dimensions dimensions4 = this.getDimensions(node5);
                if (dimensions3.is0D() && dimensions4.is0D()) {
                    this.decStackByDim(dimensions4);
                    this.decStackByDim(dimensions3);
                    this.decStackByDim(dimensions2);
                    this.scalerStore.incStack();
                    this.curCommandList.addCommand((short)26, MrpEval.getDimType(dimensions2), (short)16);
                    return null;
                }
                throw new ParseException("RpeEval: x[a][b], both a, b, must be scalers");
            }
            this.decStackByDim(dimensions3);
            this.decStackByDim(dimensions2);
            this.incStackByDim(dimensions);
            short s = this.incHeapByDim(dimensions);
            this.curCommandList.addCommand((short)26, MrpEval.getDimType(dimensions2), MrpEval.getDimType(dimensions3), MrpEval.getDimType(dimensions), s);
            return null;
        }
        throw new ParseException("RpeEval: Sorry unsupported operator: " + aSTOpNode.getName());
    }

    private void visitList(ASTOpNode aSTOpNode, int n, Dimensions dimensions) throws ParseException {
        this.incStackByDim(dimensions);
        short s = this.incHeapByDim(dimensions);
        Dimensions dimensions2 = this.getDimensions(aSTOpNode.jjtGetChild(0));
        if (dimensions.is1D() && dimensions2.is0D()) {
            for (int i = 0; i < dimensions.numEles(); ++i) {
                this.scalerStore.decStack();
            }
            this.curCommandList.addCommand((short)24, (short)dimensions.getFirstDim(), s);
        } else if (dimensions.is2D() && dimensions2.is1D() && dimensions.getLastDim() == dimensions2.getFirstDim()) {
            for (int i = 0; i < n; ++i) {
                this.vnStore.decStack();
            }
            this.curCommandList.addCommand((short)28, (short)dimensions.getFirstDim(), (short)dimensions.getLastDim(), s);
        } else {
            throw new ParseException("Bad dims for list creation " + dimensions + " " + dimensions2);
        }
    }

    @Override
    public final Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        int n;
        short s;
        Node node = null;
        Node node2 = null;
        int n2 = aSTFunNode.jjtGetNumChildren();
        Dimensions dimensions = null;
        Dimensions dimensions2 = null;
        Dimensions dimensions3 = this.getDimensions(aSTFunNode);
        aSTFunNode.childrenAccept(this, null);
        if (n2 >= 1) {
            node = aSTFunNode.jjtGetChild(0);
            dimensions = this.getDimensions(node);
        }
        if (n2 >= 2) {
            node2 = aSTFunNode.jjtGetChild(1);
            dimensions2 = this.getDimensions(node2);
        }
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (n2 == 0) {
            if (!dimensions3.is0D()) {
                throw new ParseException("RpeEval: Function '" + aSTFunNode.getName() + "' not supported: only nullary functions with scalar results are supported");
            }
        } else if (n2 == 1) {
            if (dimensions3.is0D() && !dimensions.is0D()) {
                // empty if block
            }
        } else if (n2 == 2) {
            if (dimensions3.is0D() && dimensions.is0D() && !dimensions2.is0D()) {
                // empty if block
            }
        } else if (!(dimensions3.is0D() && dimensions.is0D() && dimensions2.is0D())) {
            throw new ParseException("RpeEval: Function '" + aSTFunNode.getName() + "' not supported: only nullary functions with scalar results are supported");
        }
        if ((s = this.getUserFunction(aSTFunNode.getName(), postfixMathCommandI)) >= 23 && postfixMathCommandI instanceof CallbackEvaluationI) {
            throw new ParseException("RpeEval: Sorry function '" + aSTFunNode.getName() + "' not support: it implements CallbackEvaluationI.");
        }
        if (postfixMathCommandI.getNumberOfParameters() != -1 && postfixMathCommandI.getNumberOfParameters() != n2) {
            throw new ParseException("RpEval: miss match between expected number of arguments " + postfixMathCommandI.getNumberOfParameters() + " and actual number of arguments " + n2);
        }
        if (n2 == 0) {
            this.incStackByDim(dimensions3);
            short s2 = this.incHeapByDim(dimensions3);
            this.curCommandList.addCommand((short)50, s, s2);
            return null;
        }
        if (n2 == 1) {
            this.decStackByDim(dimensions);
            this.incStackByDim(dimensions3);
            short s3 = this.incHeapByDim(dimensions3);
            short s4 = this.getArgNumber(dimensions);
            this.curCommandList.addCommand((short)51, s, s4, this.getBigDimType(dimensions3), s3);
            return null;
        }
        if (n2 == 2) {
            this.decStackByDim(dimensions);
            this.decStackByDim(dimensions2);
            this.incStackByDim(dimensions3);
            short s5 = this.incHeapByDim(dimensions3);
            short s6 = this.getArgNumber(dimensions);
            short s7 = this.getArgNumber(dimensions2);
            if (s6 >= 256 || s7 >= 256) {
                throw new ParseException("Limit of 256 separate arguments to binary function calls. Attempted use arguments " + s6 + " and " + s7);
            }
            short s8 = (short)(s6 + (s7 << 8));
            this.curCommandList.addCommand((short)52, s, s8, this.getBigDimType(dimensions3), s5);
            return null;
        }
        if (n2 == 3) {
            this.decStackByDim(dimensions);
            this.decStackByDim(dimensions2);
            this.decStackByDim(this.getDimensions(aSTFunNode.jjtGetChild(2)));
            this.incStackByDim(dimensions3);
            short s9 = this.incHeapByDim(dimensions3);
            this.curCommandList.addCommand((short)53, s, s9);
            return null;
        }
        if (n2 == 4) {
            this.decStackByDim(dimensions);
            this.decStackByDim(dimensions2);
            this.decStackByDim(this.getDimensions(aSTFunNode.jjtGetChild(2)));
            this.decStackByDim(this.getDimensions(aSTFunNode.jjtGetChild(3)));
            this.incStackByDim(dimensions3);
            short s10 = this.incHeapByDim(dimensions3);
            this.curCommandList.addCommand((short)54, s, s10);
            return null;
        }
        for (n = 0; n < n2; ++n) {
            this.decStackByDim(this.getDimensions(aSTFunNode.jjtGetChild(n)));
        }
        this.incStackByDim(dimensions3);
        n = this.incHeapByDim(dimensions3);
        this.curCommandList.addCommand((short)(50 + n2), s, (short)n);
        return null;
    }

    public final MrpRes evaluate(MrpCommandList mrpCommandList) {
        this.resetStores();
        int n = mrpCommandList.getNumCommands();
        try {
            block113: for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
                MrpCommandList.MrpCommand mrpCommand = mrpCommandList.commands[n2];
                short s = mrpCommand.aux1;
                short s2 = mrpCommand.aux2;
                switch (mrpCommand.command) {
                    case 0: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.pushConstant(s2);
                                break;
                            }
                            case 5: {
                                this.vnStore.pushConstant(s2);
                                break;
                            }
                            case 15: {
                                this.mnnStore.pushConstant(s2);
                            }
                        }
                        continue block113;
                    }
                    case 1: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.pushVariable(s2);
                                break;
                            }
                            case 5: {
                                this.vnStore.stack[this.vnStore.sp++] = this.vnStore.vars[s2];
                                break;
                            }
                            case 15: {
                                this.mnnStore.stack[this.mnnStore.sp++] = this.mnnStore.vars[s2];
                            }
                        }
                        continue block113;
                    }
                    case 2: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.add();
                                break;
                            }
                            case 5: {
                                this.vnStore.add(s2);
                                break;
                            }
                            case 15: {
                                this.mnnStore.add(s2);
                            }
                        }
                        continue block113;
                    }
                    case 3: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.sub();
                                break;
                            }
                            case 5: {
                                this.vnStore.sub(s2);
                                break;
                            }
                            case 15: {
                                this.mnnStore.sub(s2);
                            }
                        }
                        continue block113;
                    }
                    case 4: {
                        block55 : switch (s) {
                            case 1: {
                                switch (s2) {
                                    case 1: {
                                        this.scalerStore.mulS();
                                        break;
                                    }
                                    case 5: {
                                        this.vnStore.mulS(mrpCommand.aux3);
                                        break;
                                    }
                                    case 15: {
                                        this.mnnStore.mulS(mrpCommand.aux3);
                                    }
                                }
                                break;
                            }
                            case 5: {
                                MrpRes mrpRes;
                                MrpRes mrpRes2;
                                switch (s2) {
                                    case 1: {
                                        this.vnStore.mulS(mrpCommand.aux3);
                                        break;
                                    }
                                    case 5: {
                                        mrpRes2 = this.vnStore.stack[--this.vnStore.sp];
                                        mrpRes = this.vnStore.stack[--this.vnStore.sp];
                                        this.mulVnVn((VecObj)mrpRes, (VecObj)mrpRes2, mrpCommand.aux3);
                                        break;
                                    }
                                    case 15: {
                                        this.mulVnMnn(this.vnStore.stack[--this.vnStore.sp], this.mnnStore.stack[--this.mnnStore.sp], mrpCommand.aux3);
                                    }
                                }
                                break;
                            }
                            case 15: {
                                MrpRes mrpRes;
                                MrpRes mrpRes2;
                                switch (s2) {
                                    case 1: {
                                        this.mnnStore.mulS(mrpCommand.aux3);
                                        break block55;
                                    }
                                    case 5: {
                                        this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.vnStore.stack[--this.vnStore.sp], mrpCommand.aux3);
                                        break block55;
                                    }
                                    case 15: {
                                        mrpRes2 = this.mnnStore.stack[--this.mnnStore.sp];
                                        mrpRes = this.mnnStore.stack[--this.mnnStore.sp];
                                        this.mulMnnMnn((MatObj)mrpRes, (MatObj)mrpRes2, mrpCommand.aux3);
                                    }
                                }
                            }
                        }
                        continue block113;
                    }
                    case 5: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.divS();
                                break;
                            }
                            case 5: {
                                this.vnStore.divS(mrpCommand.aux3);
                                break;
                            }
                            case 15: {
                                this.mnnStore.divS(mrpCommand.aux3);
                            }
                        }
                        continue block113;
                    }
                    case 6: {
                        this.scalerStore.mod();
                        continue block113;
                    }
                    case 7: {
                        this.scalerStore.pow();
                        continue block113;
                    }
                    case 8: {
                        this.scalerStore.and();
                        continue block113;
                    }
                    case 9: {
                        this.scalerStore.or();
                        continue block113;
                    }
                    case 10: {
                        this.scalerStore.not();
                        continue block113;
                    }
                    case 11: {
                        this.scalerStore.lt();
                        continue block113;
                    }
                    case 12: {
                        this.scalerStore.le();
                        continue block113;
                    }
                    case 13: {
                        this.scalerStore.gt();
                        continue block113;
                    }
                    case 14: {
                        this.scalerStore.ge();
                        continue block113;
                    }
                    case 15: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.ne();
                                break;
                            }
                            case 5: {
                                this.vnStore.ne();
                                break;
                            }
                            case 15: {
                                this.mnnStore.ne();
                            }
                        }
                        continue block113;
                    }
                    case 16: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.eq();
                                break;
                            }
                            case 5: {
                                this.vnStore.eq();
                                break;
                            }
                            case 15: {
                                this.mnnStore.eq();
                            }
                        }
                        continue block113;
                    }
                    case 20: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.assign(s2);
                                break;
                            }
                            case 5: {
                                this.vnStore.assign(s2);
                                break;
                            }
                            case 15: {
                                this.mnnStore.assign(s2);
                            }
                        }
                        continue block113;
                    }
                    case 18: {
                        switch (s) {
                            case 5: {
                                this.dotVn();
                            }
                        }
                        continue block113;
                    }
                    case 19: {
                        switch (s) {
                            case 2: {
                                this.crossV2();
                                break;
                            }
                            case 3: {
                                this.crossV3(s2);
                            }
                        }
                        continue block113;
                    }
                    case 21: {
                        switch (s) {
                            case 1: {
                                this.scalerStore.neg();
                                break;
                            }
                            case 5: {
                                this.vnStore.neg(s2);
                                break;
                            }
                            case 15: {
                                this.mnnStore.neg(s2);
                            }
                        }
                        continue block113;
                    }
                    case 22: {
                        this.scalerStore.powN(s);
                        continue block113;
                    }
                    case 23: {
                        this.scalerStore.recroprical();
                        continue block113;
                    }
                    case 24: {
                        this.vnStore.makeList(s, s2);
                        continue block113;
                    }
                    case 26: {
                        this.evalElementOf(s, s2, mrpCommand.aux3, mrpCommand.aux4);
                        continue block113;
                    }
                    case 28: {
                        this.MNNfromVN(s, s2, mrpCommand.aux3);
                        continue block113;
                    }
                    case 29: {
                        this.evalSetElementOf(s, s2, mrpCommand.aux3);
                        continue block113;
                    }
                    case 50: {
                        this.nullaryFunction(s);
                        continue block113;
                    }
                    case 51: {
                        this.unitaryFunction(mrpCommand);
                        continue block113;
                    }
                    case 52: {
                        this.binaryFunction(mrpCommand);
                        continue block113;
                    }
                    case 53: {
                        this.trianaryFunction(s);
                        continue block113;
                    }
                    case 54: {
                        this.quarteraryFunction(s);
                        continue block113;
                    }
                    default: {
                        this.naryFunction(s, mrpCommand.command - 50);
                    }
                }
            }
        }
        catch (EvaluationException evaluationException) {
            this.scalerRes.a = Double.NaN;
            return this.scalerRes;
        }
        switch (mrpCommandList.getFinalType()) {
            case 1: {
                this.scalerRes.a = this.scalerStore.popDouble();
                return this.scalerRes;
            }
            case 5: {
                return this.vnStore.stack[--this.vnStore.sp];
            }
            case 15: {
                return this.mnnStore.stack[--this.mnnStore.sp];
            }
        }
        return null;
    }

    private void evalElementOf(short s, short s2, short s3, short s4) {
        if (s2 == 1) {
            int n = (int)this.scalerStore.popDouble() + this.indexShift;
            double d = Double.NaN;
            switch (s) {
                case 5: {
                    VecObj vecObj = this.vnStore.popVecObj();
                    d = vecObj.data[n];
                    this.scalerStore.pushDouble(d);
                    break;
                }
                case 15: {
                    MatObj matObj = this.mnnStore.popMatObj();
                    switch (s3) {
                        case 5: {
                            VecObj vecObj = this.vnStore.getHeapObj(s4);
                            for (int i = 0; i < matObj.cols; ++i) {
                                vecObj.data[i] = matObj.data[n * matObj.cols + i];
                            }
                            this.vnStore.pushVecObj(vecObj);
                        }
                    }
                }
            }
        } else if (s2 == 5 || s2 == 16) {
            int n = (int)this.scalerStore.popDouble() + this.indexShift;
            int n2 = (int)this.scalerStore.popDouble() + this.indexShift;
            double d = 0.0;
            switch (s) {
                case 15: {
                    MatObj matObj = this.mnnStore.popMatObj();
                    d = matObj.data[n2 * matObj.cols + n];
                    this.scalerStore.pushDouble(d);
                }
            }
        }
    }

    private void evalSetElementOf(short s, short s2, short s3) {
        int n = (int)this.scalerStore.popDouble() + this.indexShift;
        int n2 = -1;
        if (s > 5 && s3 == 1) {
            n2 = (int)this.scalerStore.popDouble() + this.indexShift;
        }
        double d = 0.0;
        if (s3 == 1) {
            d = this.scalerStore.popDouble();
            this.scalerStore.pushDouble(d);
        }
        switch (s) {
            case 5: {
                VecObj vecObj = this.vnStore.getVarValue(s2);
                vecObj.data[n] = d;
                break;
            }
            case 15: {
                MatObj matObj = this.mnnStore.getVarValue(s2);
                if (n2 >= 0) {
                    matObj.setEle(n, n2, d);
                    break;
                }
                VecObj vecObj = this.vnStore.popVecObj();
                this.vnStore.pushVecObj(vecObj);
                for (int i = 0; i < matObj.cols; ++i) {
                    matObj.setEle(n, i, vecObj.getEleDouble(i));
                }
                break;
            }
        }
    }

    private void resetStores() {
        this.scalerStore.rewind();
        this.vnStore.rewind();
        this.mnnStore.rewind();
    }

    private final void crossV2() {
        VecObj vecObj = this.vnStore.stack[--this.vnStore.sp];
        VecObj vecObj2 = this.vnStore.stack[--this.vnStore.sp];
        double d = vecObj2.getEleDouble(0) * vecObj.getEleDouble(1) - vecObj2.getEleDouble(1) * vecObj.getEleDouble(0);
        this.scalerStore.pushDouble(d);
    }

    private final void crossV3(short s) {
        VecObj vecObj = this.vnStore.stack[--this.vnStore.sp];
        VecObj vecObj2 = this.vnStore.stack[--this.vnStore.sp];
        VecObj vecObj3 = this.vnStore.getHeapObj(s);
        for (int i = 0; i < vecObj2.data.length; ++i) {
            vecObj3.data[i] = vecObj2.data[(i + 1) % 3] * vecObj.data[(i + 2) % 3] - vecObj2.data[(i + 2) % 3] * vecObj.data[(i + 1) % 3];
        }
        this.vnStore.pushVecObj(vecObj3);
    }

    private final void dotVn() {
        VecObj vecObj = this.vnStore.stack[--this.vnStore.sp];
        VecObj vecObj2 = this.vnStore.stack[--this.vnStore.sp];
        double d = vecObj2.data[0] * vecObj.data[0];
        for (int i = 1; i < vecObj2.data.length; ++i) {
            d += vecObj2.data[i] * vecObj.data[i];
        }
        this.scalerStore.pushDouble(d);
    }

    private final void mulMnnVn(MatObj matObj, VecObj vecObj, short s) {
        VecObj vecObj2 = this.vnStore.getHeapObj(s);
        for (int i = 0; i < matObj.rows; ++i) {
            vecObj2.data[i] = 0.0;
            for (int j = 0; j < matObj.cols; ++j) {
                int n = i;
                vecObj2.data[n] = vecObj2.data[n] + matObj.data[i * matObj.cols + j] * vecObj.data[j];
            }
        }
        this.vnStore.pushVecObj(vecObj2);
    }

    private final void mulVnMnn(VecObj vecObj, MatObj matObj, short s) {
        VecObj vecObj2 = this.vnStore.getHeapObj(s);
        for (int i = 0; i < matObj.cols; ++i) {
            vecObj2.data[i] = 0.0;
            for (int j = 0; j < matObj.rows; ++j) {
                int n = i;
                vecObj2.data[n] = vecObj2.data[n] + matObj.data[j * matObj.cols + i] * vecObj.data[j];
            }
        }
        this.vnStore.pushVecObj(vecObj2);
    }

    private final void mulVnVn(VecObj vecObj, VecObj vecObj2, short s) {
        MatObj matObj = this.mnnStore.getHeapObj(s);
        for (int i = 0; i < vecObj.len; ++i) {
            for (int j = 0; j < vecObj2.len; ++j) {
                matObj.setEle(i, j, vecObj.getEleDouble(i) * vecObj2.getEleDouble(j));
            }
        }
        this.mnnStore.pushMatObj(matObj);
    }

    private final void mulMnnMnn(MatObj matObj, MatObj matObj2, short s) {
        MatObj matObj3 = this.mnnStore.getHeapObj(s);
        int n = matObj.rows;
        int n2 = matObj2.rows;
        int n3 = matObj2.cols;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = matObj.data[i * matObj.cols + 0] * matObj2.data[j];
                for (int k = 1; k < n2; ++k) {
                    d += matObj.data[i * matObj.cols + k] * matObj2.data[k * matObj2.cols + j];
                }
                matObj3.setEle(i, j, d);
            }
        }
        this.mnnStore.pushMatObj(matObj3);
    }

    private final void MNNfromVN(short s, short s2, short s3) {
        MatObj matObj = this.mnnStore.getHeapObj(s3);
        for (int i = s - 1; i >= 0; --i) {
            VecObj vecObj = this.vnStore.stack[--this.vnStore.sp];
            for (int j = s2 - 1; j >= 0; --j) {
                matObj.data[i * matObj.cols + j] = vecObj.data[j];
            }
        }
        this.mnnStore.stack[this.mnnStore.sp++] = matObj;
    }

    private final void nullaryFunction(short s) throws EvaluationException {
        double d;
        int n = s - 23;
        PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
        if (postfixMathCommandI instanceof RealNullaryFunction) {
            d = ((RealNullaryFunction)((Object)postfixMathCommandI)).evaluate();
        } else if (postfixMathCommandI instanceof RealNaryFunction) {
            double[] dArray = new double[]{};
            d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(dArray);
        } else {
            postfixMathCommandI.setCurNumberOfParameters(0);
            postfixMathCommandI.run(this.stack);
            d = ((Number)this.stack.pop()).doubleValue();
        }
        this.scalerStore.pushDouble(d);
    }

    private void storeFunctionResult(Object object, short s) {
        if (s < 0) {
            short s2 = -s;
            switch (s2) {
                case 1: {
                    this.scalerStore.pushDouble((Double)object);
                    return;
                }
            }
        }
        if (object instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            VecObj vecObj = this.vnStore.getHeapObj(s);
            vecObj.fromVec(vectorI);
            this.vnStore.pushVecObj(vecObj);
        } else {
            MatrixI matrixI = (MatrixI)object;
            MatObj matObj = this.mnnStore.getHeapObj(s);
            matObj.fromMat(matrixI);
            this.mnnStore.pushMatObj(matObj);
        }
    }

    private Object getFunctionArgument(short s) throws EvaluationException {
        Object object;
        if (s == 1) {
            object = this.scalerStore.popDouble();
        } else if (s % 2 == 0) {
            VectorI vectorI = (VectorI)this.getVectorMatrixArg(s);
            VecObj vecObj = this.vnStore.popVecObj();
            if (vecObj.len != vectorI.getNEles()) {
                throw new EvaluationException("Lengths of vectors do not match");
            }
            vecObj.copyToVec(vectorI);
            object = vectorI;
        } else {
            MatrixI matrixI = (MatrixI)this.getVectorMatrixArg(s);
            MatObj matObj = this.mnnStore.popMatObj();
            matObj.copyToMat(matrixI);
            object = matrixI;
        }
        return object;
    }

    private final void unitaryFunction(MrpCommandList.MrpCommand mrpCommand) throws EvaluationException {
        short s = mrpCommand.aux1;
        if (mrpCommand.aux2 != 1 || mrpCommand.aux3 != 1) {
            this.unitaryMatrixFunction(s, mrpCommand.aux2, mrpCommand.aux3, mrpCommand.aux4);
            return;
        }
        double d = this.scalerStore.popDouble();
        switch (s) {
            case 1: {
                d = Math.sin(d);
                break;
            }
            case 2: {
                d = Math.cos(d);
                break;
            }
            case 3: {
                d = Math.tan(d);
                break;
            }
            case 4: {
                d = Math.asin(d);
                break;
            }
            case 5: {
                d = Math.acos(d);
                break;
            }
            case 6: {
                d = Math.atan(d);
                break;
            }
            case 7: {
                d = (Math.exp(d) - Math.exp(-d)) / 2.0;
                break;
            }
            case 8: {
                d = (Math.exp(d) + Math.exp(-d)) / 2.0;
                break;
            }
            case 9: {
                double d2 = Math.exp(d * 2.0);
                d = (d2 - 1.0) / (d2 + 1.0);
                break;
            }
            case 10: {
                d = Math.log(d + Math.sqrt(1.0 + d * d));
                break;
            }
            case 11: {
                d = Math.log(d + Math.sqrt(d * d - 1.0));
                break;
            }
            case 12: {
                d = Math.log((1.0 + d) / (1.0 - d)) / 2.0;
                break;
            }
            case 13: {
                d = Math.abs(d);
                break;
            }
            case 14: {
                d = Math.exp(d);
                break;
            }
            case 15: {
                d = Math.log(d) / LOG10;
                break;
            }
            case 16: {
                d = Math.log(d);
                break;
            }
            case 17: {
                d = Math.sqrt(d);
                break;
            }
            case 18: {
                d = 1.0 / Math.cos(d);
                break;
            }
            case 19: {
                d = 1.0 / Math.sin(d);
                break;
            }
            case 20: {
                d = 1.0 / Math.tan(d);
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealUnaryFunction) {
                    d = ((RealUnaryFunction)((Object)postfixMathCommandI)).evaluate(d);
                    break;
                }
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.unaryArgs[0] = d;
                    d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.unaryArgs);
                    break;
                }
                if (postfixMathCommandI instanceof UnaryFunction) {
                    d = (Double)((UnaryFunction)postfixMathCommandI).eval(d);
                    break;
                }
                if (postfixMathCommandI instanceof NaryBinaryFunction) break;
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.unaryArgsD[0] = d;
                    d = (Double)((NaryFunction)postfixMathCommandI).eval(this.unaryArgsD);
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(1);
                this.stack.push(new Double(d));
                postfixMathCommandI.run(this.stack);
                d = ((Number)this.stack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d);
    }

    private final void unitaryMatrixFunction(short s, short s2, short s3, short s4) throws EvaluationException {
        Object object = this.getFunctionArgument(s2);
        int n = s - 23;
        PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
        if (postfixMathCommandI instanceof UnaryFunction) {
            Object object2 = ((UnaryFunction)postfixMathCommandI).eval(object);
            this.storeFunctionResult(object2, s4);
        } else {
            this.stack.push(object);
            postfixMathCommandI.setCurNumberOfParameters(1);
            postfixMathCommandI.run(this.stack);
            Object object3 = this.stack.pop();
            this.storeFunctionResult(object3, s4);
        }
    }

    private final void binaryFunction(MrpCommandList.MrpCommand mrpCommand) throws EvaluationException {
        short s = mrpCommand.aux1;
        if (mrpCommand.aux2 != 257 || mrpCommand.aux3 != 1 || mrpCommand.aux4 != -1) {
            this.binaryMatrixFunction(mrpCommand);
            return;
        }
        double d = this.scalerStore.popDouble();
        double d2 = this.scalerStore.popDouble();
        switch (s) {
            case 21: {
                d = Math.atan2(d2, d);
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealBinaryFunction) {
                    d = ((RealBinaryFunction)((Object)postfixMathCommandI)).evaluate(d2, d);
                    break;
                }
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.binaryArgs[0] = d2;
                    this.binaryArgs[1] = d;
                    d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.binaryArgs);
                    break;
                }
                if (postfixMathCommandI instanceof BinaryFunction) {
                    d = ((Number)((BinaryFunction)postfixMathCommandI).eval(d2, d)).doubleValue();
                    break;
                }
                if (postfixMathCommandI instanceof NaryBinaryFunction) {
                    d = ((Number)((NaryBinaryFunction)postfixMathCommandI).eval(d2, d)).doubleValue();
                    break;
                }
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.binaryArgsD[0] = d2;
                    this.binaryArgsD[1] = d;
                    d = ((Number)((NaryFunction)postfixMathCommandI).eval(this.binaryArgsD)).doubleValue();
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(2);
                this.stack.push(new Double(d2));
                this.stack.push(new Double(d));
                postfixMathCommandI.run(this.stack);
                d = ((Number)this.stack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d);
    }

    private void binaryMatrixFunction(MrpCommandList.MrpCommand mrpCommand) throws EvaluationException {
        short s = (short)(mrpCommand.aux2 & 0xFF);
        short s2 = (short)(mrpCommand.aux2 >> 8);
        Object object = this.getFunctionArgument(s2);
        Object object2 = this.getFunctionArgument(s);
        int n = mrpCommand.aux1 - 23;
        PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
        if (postfixMathCommandI instanceof BinaryFunction) {
            Object object3 = ((BinaryFunction)postfixMathCommandI).eval(object2, object);
            this.storeFunctionResult(object3, mrpCommand.aux4);
        } else if (postfixMathCommandI instanceof NaryBinaryFunction) {
            Object object4 = ((NaryBinaryFunction)postfixMathCommandI).eval(object2, object);
            this.storeFunctionResult(object4, mrpCommand.aux4);
        } else {
            this.stack.push(object2);
            this.stack.push(object);
            postfixMathCommandI.setCurNumberOfParameters(2);
            postfixMathCommandI.run(this.stack);
            Object object5 = this.stack.pop();
            this.storeFunctionResult(object5, mrpCommand.aux4);
        }
    }

    private final void trianaryFunction(short s) throws EvaluationException {
        double d = this.scalerStore.popDouble();
        double d2 = this.scalerStore.popDouble();
        double d3 = this.scalerStore.popDouble();
        switch (s) {
            case 22: {
                d2 = d3 != d3 ? d3 : (d3 > 0.0 ? d2 : d);
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.triArgs[0] = d3;
                    this.triArgs[1] = d2;
                    this.triArgs[2] = d;
                    d2 = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.triArgs);
                    break;
                }
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.triArgsD[0] = d3;
                    this.triArgsD[1] = d2;
                    this.triArgsD[2] = d;
                    d2 = (Double)((NaryFunction)postfixMathCommandI).eval(this.triArgsD);
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(3);
                this.stack.push(new Double(d3));
                this.stack.push(new Double(d2));
                this.stack.push(new Double(d));
                postfixMathCommandI.run(this.stack);
                d2 = ((Number)this.stack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d2);
    }

    private final void quarteraryFunction(short s) throws EvaluationException {
        double d = this.scalerStore.popDouble();
        double d2 = this.scalerStore.popDouble();
        double d3 = this.scalerStore.popDouble();
        double d4 = this.scalerStore.popDouble();
        switch (s) {
            case 22: {
                d3 = d4 > 0.0 ? d3 : (d4 < 0.0 ? d2 : d);
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.quartArgs[0] = d4;
                    this.quartArgs[1] = d3;
                    this.quartArgs[2] = d2;
                    this.quartArgs[3] = d;
                    d3 = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.quartArgs);
                    break;
                }
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.quartArgsD[0] = d4;
                    this.quartArgsD[1] = d3;
                    this.quartArgsD[2] = d2;
                    this.quartArgsD[3] = d;
                    d3 = (Double)((NaryFunction)postfixMathCommandI).eval(this.quartArgsD);
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(4);
                this.stack.push(new Double(d4));
                this.stack.push(new Double(d3));
                this.stack.push(new Double(d2));
                this.stack.push(new Double(d));
                postfixMathCommandI.run(this.stack);
                d3 = ((Number)this.stack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d3);
    }

    private final void naryFunction(short s, int n) throws EvaluationException {
        int n2 = s - 23;
        PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n2);
        if (postfixMathCommandI instanceof RealNaryFunction) {
            double[] dArray = new double[n];
            for (int i = n - 1; i >= 0; --i) {
                dArray[i] = this.scalerStore.popDouble();
            }
            double d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(dArray);
            this.scalerStore.pushDouble(d);
        } else {
            this.scalerStore.popN(n, this.stack);
            postfixMathCommandI.setCurNumberOfParameters(n);
            postfixMathCommandI.run(this.stack);
            double d = ((Number)this.stack.pop()).doubleValue();
            this.scalerStore.pushDouble(d);
        }
    }

    @Override
    protected Object getConstantValue(short s) {
        return this.scalerStore.getConstant(s);
    }

    public MrpVarRef getVarRef(Variable variable) throws ParseException {
        Dimensions dimensions = (Dimensions)variable.getHook(DimensionVisitor.DIM_KEY);
        if (dimensions == null) {
            Object object = variable.getValue();
            if (!variable.hasValidValue() || object == null) {
                throw new ParseException("Cannot get dimension for variable " + variable.toString());
            }
            dimensions = this.getDimByValue(object);
            variable.setHook(DimensionVisitor.DIM_KEY, dimensions);
        }
        short s = MrpEval.getDimType(dimensions);
        MObjStore mObjStore = this.getStoreByDimType(s);
        int n = mObjStore.addVar(variable, dimensions);
        return new MrpVarRef(dimensions, n, s);
    }

    public MrpVarRef getVarRef(String string) throws ParseException {
        Variable variable = this.jep.getVariable(string);
        return this.getVarRef(variable);
    }

    public void setVarValue(MrpVarRef mrpVarRef, double d) throws EvaluationException {
        if (mrpVarRef.dimType != 1) {
            throw new EvaluationException("Variable must be of scaler type");
        }
        this.scalerStore.setVarValue(mrpVarRef.index, d);
    }

    public void setVarValue(MrpVarRef mrpVarRef, double ... dArray) throws EvaluationException {
        if (!mrpVarRef.dims.is1D() || mrpVarRef.dims.getFirstDim() != dArray.length) {
            throw new EvaluationException("Dimensions do not match " + mrpVarRef.dims + ", " + dArray.length);
        }
        if (mrpVarRef.dimType != 5) {
            throw new EvaluationException("Wrong dimensions for values of variable. Was " + dArray.length);
        }
        this.vnStore.setVarValue(mrpVarRef.index, dArray);
    }

    public void setVarValue(MrpVarRef mrpVarRef, VectorI vectorI) throws EvaluationException {
        if (!mrpVarRef.dims.equals(vectorI.getDimensions())) {
            throw new EvaluationException("Dimensions do not match " + mrpVarRef.dims + ", " + vectorI.getDimensions());
        }
        this.vnStore.setVarValue(mrpVarRef.index, vectorI);
    }

    public void setVarValue(MrpVarRef mrpVarRef, MatrixI matrixI) throws EvaluationException {
        if (!mrpVarRef.dims.equals(matrixI.getDimensions())) {
            throw new EvaluationException("Dimensions do not match " + mrpVarRef.dims + ", " + matrixI.getDimensions());
        }
        this.mnnStore.setVarValue(mrpVarRef.index, matrixI);
    }

    public MrpRes getVarValue(MrpVarRef mrpVarRef) {
        MObjStore mObjStore = this.getStoreByDimType(mrpVarRef.dimType);
        MrpRes mrpRes = mObjStore.getVarValue(mrpVarRef.index);
        return mrpRes;
    }

    public Variable getVariable(MrpVarRef mrpVarRef) throws ParseException {
        MObjStore mObjStore = this.getStoreByDimType(mrpVarRef.dimType);
        return mObjStore.getJepVariable(mrpVarRef.index);
    }

    public void updateFromJepVariables() throws EvaluationException {
        this.scalerStore.updateFromJepVariables();
        this.vnStore.updateFromJepVariables();
        this.mnnStore.updateFromJepVariables();
    }

    public void updateToJepVariables() throws EvaluationException {
        this.scalerStore.updateToJepVariables();
        this.vnStore.updateToJepVariables();
        this.mnnStore.updateToJepVariables();
    }

    public Object convertResult(MrpRes mrpRes) throws EvaluationException {
        Dimensions dimensions = mrpRes.getDimensions();
        switch (dimensions.order()) {
            case 0: {
                return mrpRes.doubleValue();
            }
            case 1: {
                VectorI vectorI = this.mfac.zeroVec(dimensions.getFirstDim());
                mrpRes.copyToVec(vectorI);
                return vectorI;
            }
            case 2: {
                MatrixI matrixI = this.mfac.zeroMat(dimensions.getFirstDim(), dimensions.getLastDim());
                mrpRes.copyToMat(matrixI);
                return matrixI;
            }
        }
        return null;
    }

    public MatrixI convertToMatrix(MrpRes mrpRes) throws EvaluationException {
        Dimensions dimensions = mrpRes.getDimensions();
        switch (dimensions.order()) {
            case 2: {
                MatrixI matrixI = this.mfac.zeroMat(dimensions.getFirstDim(), dimensions.getLastDim());
                mrpRes.copyToMat(matrixI);
                return matrixI;
            }
        }
        throw new EvaluationException("Result cannot be convered to a MatrixI " + mrpRes.toString());
    }

    public VectorI convertToVector(MrpRes mrpRes) throws EvaluationException {
        Dimensions dimensions = mrpRes.getDimensions();
        switch (dimensions.order()) {
            case 1: {
                VectorI vectorI = this.mfac.zeroVec(dimensions.getFirstDim());
                mrpRes.copyToVec(vectorI);
                return vectorI;
            }
        }
        throw new EvaluationException("Result cannot be convered to a VectorI " + mrpRes.toString());
    }

    public void reset() {
        this.scalerStore.cleanUp();
        this.vnStore.cleanUp();
        this.mnnStore.cleanUp();
    }

    public String toString() {
        String string = this.scalerStore.toString() + this.vnStore.toString() + this.mnnStore.toString();
        return string;
    }

    public String toString(MrpCommandList.MrpCommand mrpCommand) {
        return mrpCommand.toString(this);
    }
}

