/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MrpRes;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;

final class VecObj
extends MrpRes {
    double[] data;
    int len;

    VecObj(int n) {
        this.len = n;
        this.data = new double[n];
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.valueOf(this.data.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.data[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public double[] toArrayVec() {
        return (double[])this.data.clone();
    }

    public void fromVec(VectorI vectorI) {
        if (vectorI.getNEles() != this.data.length) {
            this.data = new double[vectorI.getNEles()];
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (Double)vectorI.getEle(i);
        }
    }

    @Override
    public void copyToVec(VectorI vectorI) throws EvaluationException {
        if (vectorI.getNEles() != this.data.length) {
            throw new EvaluationException("Miss match in dimensions " + vectorI.getNEles() + " " + this.data.length);
        }
        for (int i = 0; i < this.data.length; ++i) {
            vectorI.setEle(i, this.data[i]);
        }
    }

    public void fromArray(double[] dArray) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = dArray[i];
        }
    }

    final double getEleDouble(int n) {
        return this.data[n];
    }

    final void setEle(int n, double d) {
        this.data[n] = d;
    }

    @Override
    public void copyToMat(MatrixI matrixI) throws EvaluationException {
        throw new EvaluationException("Cannot convert vector to matrix");
    }

    @Override
    public double[][] toArrayMat() {
        return null;
    }

    @Override
    public Double[][] toDoubleMat() throws EvaluationException {
        throw new EvaluationException("Cannot convert vector to matrix");
    }

    @Override
    public Double[] toDoubleVec() {
        Double[] doubleArray = new Double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            doubleArray[i] = this.data[i];
        }
        return doubleArray;
    }

    public Object[] toObjectVec() {
        Object[] objectArray = new Double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            objectArray[i] = this.data[i];
        }
        return objectArray;
    }
}

