/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.standard.Complex;

public class IntDoubleNumberFactory
implements NumberFactory {
    private static final long serialVersionUID = 330L;
    boolean aggressive = false;
    public static final Integer MINUS_ONE = -1;
    public static final Integer ONE = 1;
    public static final Integer TWO = 2;
    public static final Integer ZERO = 0;

    public IntDoubleNumberFactory() {
    }

    public IntDoubleNumberFactory(boolean bl) {
        this.aggressive = bl;
    }

    @Override
    public Object createNumber(String string) throws ParseException {
        if (!this.aggressive && (string.contains(".") || string.toLowerCase().contains("e"))) {
            return Double.parseDouble(string);
        }
        double d = Double.parseDouble(string);
        return this.createNumber(d);
    }

    @Override
    public Object createNumber(double d) throws ParseException {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        return d;
    }

    @Override
    public Object createNumber(int n) throws ParseException {
        return n;
    }

    @Override
    public Object createNumber(short s) throws ParseException {
        return (int)s;
    }

    @Override
    public Object createNumber(long l) throws ParseException {
        return this.createNumber((double)l);
    }

    @Override
    public Object createNumber(float f) throws ParseException {
        return this.createNumber((double)f);
    }

    @Override
    public Object createNumber(boolean bl) throws ParseException {
        return bl;
    }

    @Override
    public Object createNumber(Number number) throws ParseException {
        return this.createNumber(number.doubleValue());
    }

    @Override
    public Object createNumber(Complex complex) throws ParseException {
        return complex;
    }

    @Override
    public Object getMinusOne() {
        return MINUS_ONE;
    }

    @Override
    public Object getOne() {
        return ONE;
    }

    @Override
    public Object getTwo() {
        return TWO;
    }

    @Override
    public Object getZero() {
        return ZERO;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    @Override
    public void init(Jep jep) {
    }
}

