/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml;

import com.singularsys.extensions.mathml.parser.AnnotationHandler;
import com.singularsys.extensions.mathml.parser.ApplyHandler;
import com.singularsys.extensions.mathml.parser.ConcatReader;
import com.singularsys.extensions.mathml.parser.ConstantHandler;
import com.singularsys.extensions.mathml.parser.DeclareHandler;
import com.singularsys.extensions.mathml.parser.FnHandler;
import com.singularsys.extensions.mathml.parser.IdentifierHandler;
import com.singularsys.extensions.mathml.parser.LogHandler;
import com.singularsys.extensions.mathml.parser.MathMLDocumentHandler;
import com.singularsys.extensions.mathml.parser.MathTagHandler;
import com.singularsys.extensions.mathml.parser.MatrixHandler;
import com.singularsys.extensions.mathml.parser.MinusHandler;
import com.singularsys.extensions.mathml.parser.NullHandler;
import com.singularsys.extensions.mathml.parser.NumericConstantHandler;
import com.singularsys.extensions.mathml.parser.OperatorHandler;
import com.singularsys.extensions.mathml.parser.RootHandler;
import com.singularsys.extensions.mathml.parser.SelectorHandler;
import com.singularsys.extensions.mathml.parser.SemanticHandler;
import com.singularsys.extensions.mathml.parser.SimpleArrayHandler;
import com.singularsys.extensions.mathml.parser.SpecialNodeHandler;
import com.singularsys.extensions.mathml.parser.StandardFunctionHandler;
import com.singularsys.extensions.mathml.parser.TagHandler;
import com.singularsys.extensions.mathml.parser.UnSupportedHandler;
import com.singularsys.jep.Jep;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.parser.Node;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MathMLContentParser {
    protected SAXParserFactory spf;
    protected MathMLDocumentHandler mdh;
    protected Jep jep;
    protected OperatorTableI ot;
    protected MathTagHandler mathElementHandler;
    protected UnSupportedHandler unsuportedHandler;
    protected ConstantHandler constantHandler;
    protected IdentifierHandler identifierHandler;
    protected OperatorHandler operatorHandler;
    protected ApplyHandler applyHandler;
    protected StandardFunctionHandler standardFunctionHandler;
    protected SpecialNodeHandler specialNodeHandler;
    protected MatrixHandler matrixHandler;
    protected DeclareHandler declareHandler;
    protected SemanticHandler semanticHandler;
    protected AnnotationHandler annotationHandler;
    boolean preprendMathMLEntities = false;
    protected String mathMLEntitiesString = "<!DOCTYPE math [<!ENTITY pi \"&#x003c0;\">]>\n";
    protected static final String MathMLEntitiesStart = "<!DOCTYPE math [";
    protected static final String MathMLEntitiesEnd = "]>\n";
    protected Map<String, String> mathMLEntities = new HashMap<String, String>();

    public MathMLContentParser(Jep jep, SAXParserFactory sAXParserFactory, MathMLDocumentHandler mathMLDocumentHandler) {
        this.jep = jep;
        this.ot = jep.getOperatorTable();
        this.spf = sAXParserFactory;
        this.mdh = mathMLDocumentHandler;
        sAXParserFactory.setNamespaceAware(true);
    }

    public MathMLContentParser(Jep jep) {
        this(jep, SAXParserFactory.newInstance(), new MathMLDocumentHandler());
        this.mathElementHandler = new MathTagHandler(jep);
        this.constantHandler = new ConstantHandler(jep);
        this.identifierHandler = new IdentifierHandler(jep);
        this.operatorHandler = new OperatorHandler();
        this.applyHandler = new ApplyHandler(jep);
        this.standardFunctionHandler = new StandardFunctionHandler(jep);
        this.specialNodeHandler = new SpecialNodeHandler();
        this.matrixHandler = new MatrixHandler(jep);
        this.declareHandler = new DeclareHandler(jep);
        this.unsuportedHandler = new UnSupportedHandler();
        this.semanticHandler = new SemanticHandler(jep, this.mdh);
        this.annotationHandler = new AnnotationHandler(jep);
        this.put("math", this.mathElementHandler);
        this.put("cn", this.constantHandler);
        this.put("ci", this.identifierHandler);
        this.put("csymbol", this.unsuportedHandler);
        this.put("apply", this.applyHandler);
        this.put("reln", this.applyHandler);
        this.put("fn", new FnHandler(jep));
        this.put("interval", this.unsuportedHandler);
        this.put("inverse", this.unsuportedHandler);
        this.putSpecialNode("sep", 0);
        this.put("condition", this.unsuportedHandler);
        this.put("declare", this.declareHandler);
        this.put("lambda", this.unsuportedHandler);
        this.put("compose", this.unsuportedHandler);
        this.put("ident", this.unsuportedHandler);
        this.put("domain", this.unsuportedHandler);
        this.put("codomain", this.unsuportedHandler);
        this.put("image", this.unsuportedHandler);
        this.put("domainofapplication", this.unsuportedHandler);
        this.put("piecewise", this.unsuportedHandler);
        this.put("piece", this.unsuportedHandler);
        this.put("otherwise", this.unsuportedHandler);
        this.put("quotient", this.unsuportedHandler);
        this.put("factorial", this.unsuportedHandler);
        this.putOperator("divide", this.ot.getDivide());
        this.putFunction("max", "max");
        this.putFunction("min", "min");
        this.put("minus", new MinusHandler());
        this.putOperator("plus", this.ot.getAdd());
        this.putOperator("power", this.ot.getPower());
        this.putOperator("rem", this.ot.getMod());
        this.putOperator("times", this.ot.getMultiply());
        this.put("root", new RootHandler());
        this.put("gcd", this.unsuportedHandler);
        this.putOperator("and", this.ot.getAnd());
        this.putOperator("or", this.ot.getOr());
        this.put("xor", this.unsuportedHandler);
        this.putOperator("not", this.ot.getNot());
        this.put("implies", this.unsuportedHandler);
        this.put("forall", this.unsuportedHandler);
        this.put("exists", this.unsuportedHandler);
        this.putFunction("abs", "abs");
        this.put("conjugate", this.unsuportedHandler);
        this.putFunction("arg", "arg");
        this.putFunction("real", "re");
        this.putFunction("imaginary", "im");
        this.put("lcm", this.unsuportedHandler);
        this.putFunction("floor", "floor");
        this.putFunction("ceiling", "ceil");
        this.putOperator("eq", this.ot.getEQ());
        this.putOperator("neq", this.ot.getNE());
        this.putOperator("gt", this.ot.getGT());
        this.putOperator("lt", this.ot.getLT());
        this.putOperator("geq", this.ot.getGE());
        this.putOperator("leq", this.ot.getLE());
        this.putOperator("equivalent", this.ot.getAssign());
        this.put("approx", this.unsuportedHandler);
        this.put("factorof", this.unsuportedHandler);
        this.put("int", this.unsuportedHandler);
        this.put("diff", this.unsuportedHandler);
        this.put("partialdiff", this.unsuportedHandler);
        this.put("lowlimit", this.unsuportedHandler);
        this.put("uplimit", this.unsuportedHandler);
        this.put("bvar", this.unsuportedHandler);
        this.putSpecialNode("degree", 1);
        this.putSpecialNode("logbase", 1);
        this.put("divergence", this.unsuportedHandler);
        this.put("grad", this.unsuportedHandler);
        this.put("curl", this.unsuportedHandler);
        this.put("laplacian", this.unsuportedHandler);
        this.put("set", this.matrixHandler);
        this.put("list", this.matrixHandler);
        this.put("union", this.unsuportedHandler);
        this.put("intersect", this.unsuportedHandler);
        this.put("in", this.unsuportedHandler);
        this.put("notin", this.unsuportedHandler);
        this.put("subset", this.unsuportedHandler);
        this.put("prsubset", this.unsuportedHandler);
        this.put("notsubset", this.unsuportedHandler);
        this.put("notprsubset", this.unsuportedHandler);
        this.put("setdiff", this.unsuportedHandler);
        this.put("card", this.unsuportedHandler);
        this.put("cartesianproduct", this.unsuportedHandler);
        this.putFunction("sum", "sum");
        this.put("product", this.unsuportedHandler);
        this.put("limit", this.unsuportedHandler);
        this.put("tendsto", this.unsuportedHandler);
        this.putFunction("exp", "exp");
        this.putFunction("ln", "ln");
        this.put("log", new LogHandler("log", "lg"));
        this.putFunction("sin", "sin");
        this.putFunction("cos", "cos");
        this.putFunction("tan", "tan");
        this.put("sec", this.unsuportedHandler);
        this.put("csc", this.unsuportedHandler);
        this.put("cot", this.unsuportedHandler);
        this.putFunction("sinh", "sinh");
        this.putFunction("cosh", "cosh");
        this.putFunction("tanh", "tanh");
        this.put("sech", this.unsuportedHandler);
        this.put("csch", this.unsuportedHandler);
        this.put("coth", this.unsuportedHandler);
        this.putFunction("arcsin", "asin");
        this.putFunction("arccos", "acos");
        this.putFunction("arctan", "atan");
        this.putFunction("arccosh", "acosh");
        this.put("arccot", this.unsuportedHandler);
        this.put("arccoth", this.unsuportedHandler);
        this.put("arccsc", this.unsuportedHandler);
        this.put("arccsch", this.unsuportedHandler);
        this.put("arcsec", this.unsuportedHandler);
        this.put("arcsech", this.unsuportedHandler);
        this.putFunction("arcsinh", "asinh");
        this.putFunction("arctanh", "atanh");
        this.putFunction("mean", "avg");
        this.put("sdev", this.unsuportedHandler);
        this.put("variance", this.unsuportedHandler);
        this.put("median", this.unsuportedHandler);
        this.put("mode", this.unsuportedHandler);
        this.put("moment", this.unsuportedHandler);
        this.put("momentabout", this.unsuportedHandler);
        this.put("vector", this.matrixHandler);
        this.put("matrix", this.matrixHandler);
        this.put("matrixrow", this.matrixHandler);
        this.put("determinant", this.unsuportedHandler);
        this.put("transpose", this.unsuportedHandler);
        this.put("selector", new SelectorHandler());
        this.putOperator("vectorproduct", this.ot.getCross());
        this.putOperator("scalarproduct", this.ot.getDot());
        this.put("outerproduct", this.unsuportedHandler);
        this.put("annotation", this.annotationHandler);
        this.put("semantics", this.semanticHandler);
        this.put("annotation-xml", this.annotationHandler);
        this.put("integers", this.unsuportedHandler);
        this.put("reals", this.unsuportedHandler);
        this.put("rationals", this.unsuportedHandler);
        this.put("naturalnumbers", this.unsuportedHandler);
        this.put("complexes", this.unsuportedHandler);
        this.put("primes", this.unsuportedHandler);
        this.putConstantElement("exponentiale", "e");
        this.putConstantElement("imaginaryi", "i");
        this.put("notanumber", new NumericConstantHandler(jep, Double.NaN));
        this.putConstantElement("true", "true");
        this.putConstantElement("false", "false");
        this.put("emptyset", this.unsuportedHandler);
        this.putConstantElement("pi", "pi");
        this.put("eulergamma", this.unsuportedHandler);
        this.put("infinity", new NumericConstantHandler(jep, Double.POSITIVE_INFINITY));
        this.putEntity("ExponentialE", "\u2147", "e");
        this.putEntity("ImaginaryI", "\u2148", "i");
        this.putEntity("pi", "\u03c0", "pi");
    }

    public Node parseSingle(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        SAXParser sAXParser = this.spf.newSAXParser();
        this.mdh.setUnknownHandler(null);
        sAXParser.parse(inputSource, (DefaultHandler)this.mdh);
        List<Node> list = this.mathElementHandler.getResults();
        if (list.size() == 0) {
            throw new SAXException("No math tag found");
        }
        if (list.size() > 1) {
            throw new SAXException("More then one expression found");
        }
        return list.get(0);
    }

    public Node parseSingle(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        Reader reader2 = reader;
        if (this.preprendMathMLEntities) {
            reader2 = new ConcatReader(new StringReader(this.mathMLEntitiesString), reader);
        }
        return this.parseSingle(new InputSource(reader2));
    }

    public Node parseSingle(String string) throws ParserConfigurationException, SAXException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.parseSingle(stringReader);
    }

    public Node parseFragment(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        SAXParser sAXParser = this.spf.newSAXParser();
        this.mdh.setUnknownHandler(null);
        sAXParser.parse(inputSource, (DefaultHandler)this.mdh);
        List<Object> list = this.mdh.getResults();
        if (list.size() == 0) {
            throw new SAXException("Empty results");
        }
        if (list.size() > 1) {
            throw new SAXException("More then one expression found");
        }
        Object object = list.get(0);
        if (!(object instanceof Node)) {
            throw new SAXException("Result should be of type Node");
        }
        return (Node)list.get(0);
    }

    public Node parseFragment(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        Reader reader2 = reader;
        if (this.preprendMathMLEntities) {
            reader2 = new ConcatReader(new StringReader(this.mathMLEntitiesString), reader);
        }
        return this.parseFragment(new InputSource(reader2));
    }

    public List<Node> parseAllMath(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        this.mdh.setUnknownHandler(NullHandler.getInstance());
        SAXParser sAXParser = this.spf.newSAXParser();
        sAXParser.parse(inputSource, (DefaultHandler)this.mdh);
        return this.mathElementHandler.getResults();
    }

    public List<Node> parseAllMath(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        Reader reader2 = reader;
        if (this.preprendMathMLEntities) {
            reader2 = new ConcatReader(new StringReader(this.mathMLEntitiesString), reader);
        }
        return this.parseAllMath(new InputSource(reader2));
    }

    public List<Node> parseAllMath(String string) throws ParserConfigurationException, SAXException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.parseAllMath(stringReader);
    }

    public Object parseAll(InputSource inputSource, TagHandler tagHandler) throws ParserConfigurationException, SAXException, IOException {
        this.mdh.setUnknownHandler(tagHandler);
        SAXParser sAXParser = this.spf.newSAXParser();
        sAXParser.parse(inputSource, (DefaultHandler)this.mdh);
        List<Object> list = this.mdh.getResults();
        if (list.size() == 1) {
            Object object = list.get(0);
            return object;
        }
        throw new SAXException("Document should have exactly one root node");
    }

    public Object parseAll(Reader reader, TagHandler tagHandler) throws ParserConfigurationException, SAXException, IOException {
        Reader reader2 = reader;
        if (this.preprendMathMLEntities) {
            reader2 = new ConcatReader(new StringReader(this.mathMLEntitiesString), reader);
        }
        return this.parseAll(new InputSource(reader2), tagHandler);
    }

    public Object parseAll(Reader reader, Behaviour behaviour) throws ParserConfigurationException, SAXException, IOException {
        SimpleArrayHandler simpleArrayHandler = SimpleArrayHandler.getInstance();
        Reader reader2 = reader;
        if (this.preprendMathMLEntities) {
            reader2 = new ConcatReader(new StringReader(this.mathMLEntitiesString), reader);
        }
        return this.parseAll(new InputSource(reader2), (TagHandler)simpleArrayHandler);
    }

    public TagHandler put(String string, TagHandler tagHandler) {
        return this.mdh.put(string, tagHandler);
    }

    public TagHandler putOperator(String string, Operator operator) {
        TagHandler tagHandler = this.put(string, this.operatorHandler);
        this.operatorHandler.put(string, operator);
        return tagHandler;
    }

    public TagHandler putFunction(String string, String string2) {
        TagHandler tagHandler = this.put(string, this.standardFunctionHandler);
        this.standardFunctionHandler.put(string, string2);
        return tagHandler;
    }

    public TagHandler putConstantElement(String string, String string2) {
        TagHandler tagHandler = this.put(string, this.constantHandler);
        this.constantHandler.putConstantElement(string, string2);
        return tagHandler;
    }

    public TagHandler putSpecialNode(String string, int n) {
        TagHandler tagHandler = this.put(string, this.specialNodeHandler);
        this.specialNodeHandler.put(string, n);
        return tagHandler;
    }

    public TagHandler remove(Object object) {
        TagHandler tagHandler = this.mdh.get(object);
        if (tagHandler == this.standardFunctionHandler) {
            this.standardFunctionHandler.remove(object);
        }
        if (tagHandler == this.operatorHandler) {
            this.operatorHandler.remove(object);
        }
        if (tagHandler == this.constantHandler) {
            this.constantHandler.removeConstantElement(object);
        }
        if (tagHandler == this.specialNodeHandler) {
            this.specialNodeHandler.remove(object);
        }
        return this.mdh.remove(object);
    }

    public String getMathMLEntitiesString() {
        return this.mathMLEntitiesString;
    }

    public boolean isPreprendMathMLEntities() {
        return this.preprendMathMLEntities;
    }

    public void setPreprendMathMLEntities(boolean bl) {
        this.preprendMathMLEntities = bl;
    }

    public TagHandler putEntity(String string, String string2, String string3) {
        this.mathMLEntities.put(string, "<!ENTITY " + string + " \"" + string2 + "\">");
        StringBuilder stringBuilder = new StringBuilder(MathMLEntitiesStart);
        for (String string4 : this.mathMLEntities.values()) {
            stringBuilder.append(string4);
        }
        stringBuilder.append(MathMLEntitiesEnd);
        this.mathMLEntitiesString = stringBuilder.toString();
        this.constantHandler.putEntity(string2, string3);
        return this.constantHandler;
    }

    public TagHandler removeEntity(Object object) {
        String string = this.mathMLEntities.get(object);
        this.constantHandler.removeEntity(string);
        this.mathMLEntities.remove(object);
        return this.constantHandler;
    }

    public SAXParserFactory getSAXParserFactory() {
        return this.spf;
    }

    public void setSAXParserFactory(SAXParserFactory sAXParserFactory) {
        this.spf = sAXParserFactory;
    }

    public static enum Behaviour {
        RETURNNULL,
        RETURNKNOWCHILDREN,
        RETURNALLCHILDREN;

    }
}

