/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.parser;

import com.singularsys.extensions.mathml.parser.AbstractHandler;
import com.singularsys.extensions.mathml.parser.SpecialNode;
import com.singularsys.extensions.mathml.parser.StackFrame;
import com.singularsys.jep.Jep;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class ConstantHandler
extends AbstractHandler {
    public static final boolean DEBUG = false;
    Map<String, String> entities = new HashMap<String, String>();
    Map<String, ConstantTypeHandler> typeHandlers = new HashMap<String, ConstantTypeHandler>();
    Map<String, String> constantTags = new HashMap<String, String>();

    public ConstantHandler(Jep jep) {
        super(jep);
        this.typeHandlers.put("real", new RealHandler());
        this.typeHandlers.put("rational", new RationalHandler());
        this.typeHandlers.put("integer", new IntegerHandler());
        this.typeHandlers.put("complex-cartesian", new ComplexHandler());
        this.typeHandlers.put("complex-polar", new ComplexPolarHandler());
        this.typeHandlers.put("constant", new KnownConstantHandler());
        this.typeHandlers.put("e-notation", new ENotationHandler());
    }

    @Override
    public Object handle(StackFrame stackFrame, Locator locator) throws SAXParseException {
        Object object;
        int n;
        if (this.constantTags.containsKey(stackFrame.getName())) {
            String string = this.constantTags.get(stackFrame.getName());
            try {
                return this.nf.buildVariableNode(string);
            }
            catch (ParseException parseException) {
                throw new SAXParseException(parseException.getLocalizedMessage(), locator, parseException);
            }
        }
        String string = stackFrame.getAttributeValue("base");
        int n2 = 10;
        if (string != null) {
            n2 = Integer.parseInt(string);
        }
        if ((n = stackFrame.getNumChildren()) % 2 == 0) {
            throw new SAXParseException("Element <cn> must have an odd number of children", locator);
        }
        int n3 = (n + 1) / 2;
        Object[] objectArray = new Object[n3];
        for (int i = 0; i < n; ++i) {
            object = null;
            try {
                object = this.processChild(stackFrame.getChild(i), n2, locator);
            }
            catch (ParseException parseException) {
                throw new SAXParseException(parseException.getMessage(), locator, parseException);
            }
            if (i % 2 == 0) {
                if (object == null) {
                    throw new SAXParseException("Child " + i + " of <cn> must be numeric", locator);
                }
                objectArray[i / 2] = object;
                continue;
            }
            if (object == null) continue;
            throw new SAXParseException("Child " + i + " of <cn> must be <sep/>", locator);
        }
        String string2 = stackFrame.getAttributeValue("type");
        if (string2 == null) {
            string2 = "real";
        }
        if ((object = this.typeHandlers.get(string2)) == null) {
            throw new SAXParseException("Element <cn> no handeler for type=\"" + string2 + "\"", locator);
        }
        try {
            return object.handle(this, objectArray, stackFrame, locator);
        }
        catch (ParseException parseException) {
            throw new SAXParseException(parseException.getMessage(), locator, parseException);
        }
    }

    Object processChild(Object object, int n, Locator locator) throws ParseException, SAXParseException {
        if (object instanceof String) {
            String string = (String)object;
            if (this.entities.containsKey(string)) {
                String string2 = this.entities.get(string);
                return string2;
            }
            if (n != 10) {
                long l = Long.valueOf(string, n);
                return this.jep.getNumberFactory().createNumber(l);
            }
            Object object2 = this.jep.getNumberFactory().createNumber(string);
            return object2;
        }
        if (object instanceof SpecialNode && ((SpecialNode)object).getName().equals("sep")) {
            return null;
        }
        throw new SAXParseException("Element <cn> can only have numbers and seperators as children", locator);
    }

    public String putEntity(String string, String string2) {
        return this.entities.put(string, string2);
    }

    public String putConstantElement(String string, String string2) {
        return this.constantTags.put(string, string2);
    }

    public String removeConstantElement(Object object) {
        return this.constantTags.remove(object);
    }

    public String removeEntity(Object object) {
        return this.entities.remove(object);
    }

    public static class KnownConstantHandler
    implements ConstantTypeHandler {
        @Override
        public Node handle(ConstantHandler constantHandler, Object[] objectArray, StackFrame stackFrame, Locator locator) throws SAXParseException, ParseException {
            if (objectArray.length != 1) {
                throw new SAXParseException("Element <cn type=\"constant\"> must have 1 child", locator);
            }
            if (!(objectArray[0] instanceof String)) {
                throw new SAXParseException("Element <cn type=\"constant\"> child must be a known constant", locator);
            }
            ASTVarNode aSTVarNode = constantHandler.getNf().buildVariableNode((String)objectArray[0]);
            return aSTVarNode;
        }
    }

    public static class ComplexPolarHandler
    implements ConstantTypeHandler {
        @Override
        public Node handle(ConstantHandler constantHandler, Object[] objectArray, StackFrame stackFrame, Locator locator) throws SAXParseException, ParseException {
            if (objectArray.length != 2) {
                throw new SAXParseException("Element <cn type=\"complex-polar\"> must have 3 children", locator);
            }
            if (!(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) {
                throw new SAXParseException("Argumnets of <cn type=\"complex-polar\"> must have Numbers", locator);
            }
            Number number = (Number)objectArray[0];
            Number number2 = (Number)objectArray[1];
            Complex complex = Complex.polarValueOf(number, number2);
            ASTConstant aSTConstant = constantHandler.getNf().buildConstantNode(complex);
            return aSTConstant;
        }
    }

    public static class ComplexHandler
    implements ConstantTypeHandler {
        @Override
        public Node handle(ConstantHandler constantHandler, Object[] objectArray, StackFrame stackFrame, Locator locator) throws SAXParseException, ParseException {
            if (objectArray.length != 2) {
                throw new SAXParseException("Element <cn type=\"complex-cartesian\"> must have 3 children", locator);
            }
            if (!(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) {
                throw new SAXParseException("Argumnets of <cn type=\"complex-cartesian\"> must have Numbers", locator);
            }
            double d = ((Number)objectArray[0]).doubleValue();
            double d2 = ((Number)objectArray[1]).doubleValue();
            Complex complex = new Complex(d, d2);
            ASTConstant aSTConstant = constantHandler.getNf().buildConstantNode(complex);
            return aSTConstant;
        }
    }

    public static class ENotationHandler
    implements ConstantTypeHandler {
        @Override
        public Node handle(ConstantHandler constantHandler, Object[] objectArray, StackFrame stackFrame, Locator locator) throws SAXParseException, ParseException {
            if (objectArray.length != 2) {
                throw new SAXParseException("Element <cn type=\"e-notation\"> must have 2 children", locator);
            }
            if (!(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) {
                throw new SAXParseException("Element <cn type=\"e-notation\"> both arguments shouble be numbers", locator);
            }
            String string = (String)stackFrame.getChild(0);
            Object object = stackFrame.getChild(2);
            double d = Double.parseDouble(string + "E" + object);
            ASTConstant aSTConstant = constantHandler.getNf().buildConstantNode(d);
            return aSTConstant;
        }
    }

    public static class RationalHandler
    implements ConstantTypeHandler {
        @Override
        public Node handle(ConstantHandler constantHandler, Object[] objectArray, StackFrame stackFrame, Locator locator) throws SAXParseException, ParseException {
            if (objectArray.length != 2) {
                throw new SAXParseException("Element <cn type=\"rational\"> must have 3 children", locator);
            }
            ASTConstant aSTConstant = constantHandler.getNf().buildConstantNode(objectArray[0]);
            ASTConstant aSTConstant2 = constantHandler.getNf().buildConstantNode(objectArray[1]);
            ASTOpNode aSTOpNode = constantHandler.getNf().buildOperatorNode(constantHandler.getOt().getDivide(), aSTConstant, aSTConstant2);
            return aSTOpNode;
        }
    }

    public static class IntegerHandler
    implements ConstantTypeHandler {
        @Override
        public Node handle(ConstantHandler constantHandler, Object[] objectArray, StackFrame stackFrame, Locator locator) throws SAXParseException, ParseException {
            if (objectArray.length != 1) {
                throw new SAXParseException("Element <cn type=\"integer\"> must have 1 child", locator);
            }
            return constantHandler.getNf().buildConstantNode(objectArray[0]);
        }
    }

    public static class RealHandler
    implements ConstantTypeHandler {
        @Override
        public Node handle(ConstantHandler constantHandler, Object[] objectArray, StackFrame stackFrame, Locator locator) throws SAXParseException, ParseException {
            if (objectArray.length != 1) {
                throw new SAXParseException("Element <cn type=\"real\"> must have 1 child", locator);
            }
            return constantHandler.getNf().buildConstantNode(objectArray[0]);
        }
    }

    public static interface ConstantTypeHandler {
        public Node handle(ConstantHandler var1, Object[] var2, StackFrame var3, Locator var4) throws SAXParseException, ParseException;
    }
}

