/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix;

import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixFieldI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;

public abstract class AbstractMatrixField
implements MatrixFieldI {
    private static final long serialVersionUID = 330L;
    protected MatrixFactoryI mf;
    final boolean skipElements;

    public AbstractMatrixField(MatrixFactoryI matrixFactoryI) {
        this.mf = matrixFactoryI;
        this.skipElements = false;
    }

    public AbstractMatrixField(MatrixFactoryI matrixFactoryI, boolean bl) {
        this.mf = matrixFactoryI;
        this.skipElements = bl;
    }

    protected abstract Object addEle(Object var1, Object var2) throws EvaluationException;

    protected abstract VectorI addVV(VectorI var1, VectorI var2) throws EvaluationException;

    protected abstract MatrixI addMM(MatrixI var1, MatrixI var2) throws EvaluationException;

    @Override
    public Object add(Object object, Object object2) throws EvaluationException {
        if (object instanceof VectorI && object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            VectorI vectorI2 = (VectorI)object2;
            if (vectorI.getNEles() != vectorI2.getNEles()) {
                throw new EvaluationException("Vector sizes do not match " + vectorI + " " + vectorI2);
            }
            return this.addVV(vectorI, vectorI2);
        }
        if (object instanceof MatrixI && object2 instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            MatrixI matrixI2 = (MatrixI)object2;
            if (matrixI.getNRows() != matrixI2.getNRows() || matrixI.getNCols() != matrixI2.getNCols()) {
                throw new EvaluationException("Matrix sizes do not match " + matrixI + " " + matrixI2);
            }
            return this.addMM(matrixI, matrixI2);
        }
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.addEle(object3, object4);
    }

    protected abstract Object subEle(Object var1, Object var2) throws EvaluationException;

    protected abstract VectorI subVV(VectorI var1, VectorI var2) throws EvaluationException;

    protected abstract MatrixI subMM(MatrixI var1, MatrixI var2) throws EvaluationException;

    @Override
    public Object sub(Object object, Object object2) throws EvaluationException {
        if (object instanceof MatrixI && object2 instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            MatrixI matrixI2 = (MatrixI)object2;
            if (matrixI.getNRows() != matrixI2.getNRows() || matrixI.getNCols() != matrixI2.getNCols()) {
                throw new EvaluationException("Matrix sizes do not match " + matrixI + " " + matrixI2);
            }
            return this.subMM(matrixI, matrixI2);
        }
        if (object instanceof VectorI && object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            VectorI vectorI2 = (VectorI)object2;
            if (vectorI.getNEles() != vectorI2.getNEles()) {
                throw new EvaluationException("Vector sizes do not match " + vectorI + " " + vectorI2);
            }
            return this.subVV(vectorI, vectorI2);
        }
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.subEle(object3, object4);
    }

    protected abstract Object negEle(Object var1) throws EvaluationException;

    protected abstract VectorI negV(VectorI var1) throws EvaluationException;

    protected abstract MatrixI negM(MatrixI var1) throws EvaluationException;

    @Override
    public Object neg(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            return this.negM(matrixI);
        }
        if (object instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            return this.negV(vectorI);
        }
        if (this.skipElements) {
            return null;
        }
        Object object2 = this.mf.elementValue(object);
        if (object2 == null) {
            return null;
        }
        return this.negEle(object2);
    }

    protected abstract Object mulEle(Object var1, Object var2) throws EvaluationException;

    protected abstract VectorI mulVO(VectorI var1, Object var2) throws EvaluationException;

    protected abstract MatrixI mulMO(MatrixI var1, Object var2) throws EvaluationException;

    protected abstract MatrixI mulVV(VectorI var1, VectorI var2) throws EvaluationException;

    protected abstract VectorI mulVM(VectorI var1, MatrixI var2) throws EvaluationException;

    protected abstract VectorI mulMV(MatrixI var1, VectorI var2) throws EvaluationException;

    protected abstract MatrixI mulMM(MatrixI var1, MatrixI var2) throws EvaluationException;

    @Override
    public Object mul(Object object, Object object2) throws EvaluationException {
        if (object instanceof MatrixI && object2 instanceof VectorI) {
            MatrixI matrixI = (MatrixI)object;
            VectorI vectorI = (VectorI)object2;
            if (matrixI.getNCols() != vectorI.getNEles()) {
                throw new EvaluationException("Matrix *, sizes do not match " + matrixI + " " + vectorI);
            }
            return this.mulMV(matrixI, vectorI);
        }
        if (object instanceof VectorI && object2 instanceof MatrixI) {
            VectorI vectorI = (VectorI)object;
            MatrixI matrixI = (MatrixI)object2;
            if (vectorI.getNEles() != matrixI.getNRows()) {
                throw new EvaluationException("Matrix *, sizes do not match " + vectorI + " " + matrixI);
            }
            return this.mulVM(vectorI, matrixI);
        }
        if (object instanceof MatrixI && object2 instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            MatrixI matrixI2 = (MatrixI)object2;
            if (matrixI.getNCols() != matrixI2.getNRows()) {
                throw new EvaluationException("Matrix *, sizes do not match " + matrixI + " " + matrixI2);
            }
            return this.mulMM(matrixI, matrixI2);
        }
        if (object instanceof VectorI && object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            VectorI vectorI2 = (VectorI)object2;
            return this.mulVV(vectorI, vectorI2);
        }
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            return this.mulMO(matrixI, object2);
        }
        if (object2 instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object2;
            return this.mulMO(matrixI, object);
        }
        if (object instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            return this.mulVO(vectorI, object2);
        }
        if (object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object2;
            return this.mulVO(vectorI, object);
        }
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.mulEle(object3, object4);
    }

    protected abstract Object divEle(Object var1, Object var2) throws EvaluationException;

    protected abstract VectorI divVO(VectorI var1, Object var2) throws EvaluationException;

    protected abstract MatrixI divMO(MatrixI var1, Object var2) throws EvaluationException;

    @Override
    public Object div(Object object, Object object2) throws EvaluationException {
        Object object3 = this.mf.elementValue(object2);
        if (object3 == null) {
            return null;
        }
        if (object instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            return this.divVO(vectorI, object2);
        }
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            return this.divMO(matrixI, object2);
        }
        if (this.skipElements) {
            return null;
        }
        Object object4 = this.mf.elementValue(object);
        if (object4 == null) {
            return null;
        }
        return this.divEle(object4, object3);
    }

    protected abstract Object modEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Object mod(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.modEle(object3, object4);
    }

    protected abstract Object powEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Object pow(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.powEle(object3, object4);
    }

    protected abstract Boolean eqEle(Object var1, Object var2) throws EvaluationException;

    protected abstract Boolean eqVV(VectorI var1, VectorI var2) throws EvaluationException;

    protected abstract Boolean eqMM(MatrixI var1, MatrixI var2) throws EvaluationException;

    @Override
    public Boolean eq(Object object, Object object2) throws EvaluationException {
        Object object3;
        Object object4;
        Boolean bl;
        if (object instanceof MatrixI && object2 instanceof MatrixI && (bl = this.eqMM((MatrixI)(object4 = (MatrixI)object), (MatrixI)(object3 = (MatrixI)object2))) != null) {
            return bl;
        }
        if (object instanceof VectorI && object2 instanceof VectorI) {
            object4 = (VectorI)object;
            object3 = (VectorI)object2;
            return this.eqVV((VectorI)object4, (VectorI)object3);
        }
        if (this.skipElements) {
            return null;
        }
        object4 = this.mf.elementValue(object);
        object3 = this.mf.elementValue(object2);
        if (object4 == null || object3 == null) {
            return null;
        }
        return this.eqEle(object4, object3);
    }

    protected abstract Boolean neEle(Object var1, Object var2) throws EvaluationException;

    protected abstract Boolean neVV(VectorI var1, VectorI var2) throws EvaluationException;

    protected abstract Boolean neMM(MatrixI var1, MatrixI var2) throws EvaluationException;

    @Override
    public Boolean ne(Object object, Object object2) throws EvaluationException {
        if (object instanceof MatrixI && object2 instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            MatrixI matrixI2 = (MatrixI)object2;
            Boolean bl = this.neMM(matrixI, matrixI2);
            if (bl == null) {
                return null;
            }
            return bl;
        }
        if (object instanceof VectorI && object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            VectorI vectorI2 = (VectorI)object2;
            Boolean bl = this.neVV(vectorI, vectorI2);
            if (bl == null) {
                return null;
            }
            return bl;
        }
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        Boolean bl = this.neEle(object, object2);
        return bl;
    }

    protected abstract Boolean andEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Boolean and(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.andEle(object3, object4);
    }

    protected abstract Boolean orEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Boolean or(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.orEle(object3, object4);
    }

    protected abstract Boolean notEle(Object var1) throws EvaluationException;

    @Override
    public Boolean not(Object object) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object2 = this.mf.elementValue(object);
        if (object2 == null) {
            return null;
        }
        return this.notEle(object2);
    }

    protected abstract Boolean gtEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Boolean gt(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.gtEle(object3, object4);
    }

    protected abstract Boolean geEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Boolean ge(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.geEle(object3, object4);
    }

    protected abstract Boolean ltEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Boolean lt(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.ltEle(object3, object4);
    }

    protected abstract Boolean leEle(Object var1, Object var2) throws EvaluationException;

    @Override
    public Boolean le(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        Object object3 = this.mf.elementValue(object);
        Object object4 = this.mf.elementValue(object2);
        if (object3 == null || object4 == null) {
            return null;
        }
        return this.leEle(object3, object4);
    }

    @Override
    public Object trans(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            return this.transM(matrixI);
        }
        return null;
    }

    protected Object transM(MatrixI matrixI) throws EvaluationException {
        Object[][] objectArray = new Object[matrixI.getNCols()][matrixI.getNRows()];
        int n = matrixI.getNRows();
        for (int i = 0; i < n; ++i) {
            int n2 = matrixI.getNCols();
            for (int j = 0; j < n2; ++j) {
                objectArray[j][i] = matrixI.getEle(i, j);
            }
        }
        return this.mf.newMatrix(objectArray);
    }

    @Override
    public Object dot(Object object, Object object2) throws EvaluationException {
        if (object instanceof VectorI && object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            VectorI vectorI2 = (VectorI)object2;
            if (vectorI.getNEles() != vectorI2.getNEles()) {
                throw new EvaluationException("Vector sizes do not match " + vectorI + " " + vectorI2);
            }
            return this.dotVV(vectorI, vectorI2);
        }
        return null;
    }

    protected Object dotVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        Object object = this.mulEle(vectorI.getEle(0), vectorI2.getEle(0));
        for (int i = 1; i < vectorI.getNEles(); ++i) {
            object = this.addEle(object, this.mulEle(vectorI.getEle(i), vectorI2.getEle(i)));
        }
        return object;
    }

    @Override
    public Object cross(Object object, Object object2) throws EvaluationException {
        if (object instanceof VectorI && object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            VectorI vectorI2 = (VectorI)object2;
            if (vectorI.getNEles() != vectorI2.getNEles()) {
                throw new EvaluationException("Vector sizes do not match " + vectorI + " " + vectorI2);
            }
            if (vectorI.getNEles() != 3) {
                throw new EvaluationException("Vectors must be of length 3, they are " + vectorI + ", " + vectorI2);
            }
            return this.crossVV(vectorI, vectorI2);
        }
        return null;
    }

    protected Object crossVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        if (vectorI.getNEles() == 3) {
            Object[] objectArray = new Object[]{this.subEle(this.mulEle(vectorI.getEle(1), vectorI2.getEle(2)), this.mulEle(vectorI2.getEle(1), vectorI.getEle(2))), this.subEle(this.mulEle(vectorI.getEle(2), vectorI2.getEle(0)), this.mulEle(vectorI2.getEle(2), vectorI.getEle(0))), this.subEle(this.mulEle(vectorI.getEle(0), vectorI2.getEle(1)), this.mulEle(vectorI2.getEle(0), vectorI.getEle(1)))};
            return this.mf.newVector(objectArray);
        }
        return null;
    }

    public Object traceM(MatrixI matrixI) throws EvaluationException {
        int n;
        int n2 = matrixI.getNRows();
        int n3 = n2 < (n = matrixI.getNCols()) ? n2 : n;
        Object object = matrixI.getEle(0, 0);
        for (int i = 1; i < n3; ++i) {
            object = this.addEle(object, matrixI.getEle(i, i));
        }
        return object;
    }

    @Override
    public Object trace(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            return this.traceM(matrixI);
        }
        return null;
    }

    @Override
    public Object det(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            if (matrixI.getNRows() != matrixI.getNCols()) {
                throw new EvaluationException("det: must be a square matrix " + matrixI);
            }
            return this.detM(matrixI);
        }
        return null;
    }

    protected Object detM(MatrixI matrixI) throws EvaluationException {
        if (matrixI.getNRows() == 2) {
            Object object = this.subEle(this.mulEle(matrixI.getEle(0, 0), matrixI.getEle(1, 1)), this.mulEle(matrixI.getEle(0, 1), matrixI.getEle(1, 0)));
            return object;
        }
        Object object = this.getZero();
        for (int i = 0; i < matrixI.getNCols(); ++i) {
            MatrixI matrixI2 = this.minor(matrixI, 0, i);
            object = i % 2 == 0 ? this.addEle(object, this.mulEle(matrixI.getEle(0, i), this.detM(matrixI2))) : this.subEle(object, this.mulEle(matrixI.getEle(0, i), this.detM(matrixI2)));
        }
        return object;
    }

    protected MatrixI minor(MatrixI matrixI, int n, int n2) throws EvaluationException {
        int n3;
        int n4;
        Object[][] objectArray = new Object[matrixI.getNRows() - 1][matrixI.getNCols() - 1];
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                objectArray[n4][n3] = matrixI.getEle(n4, n3);
            }
            for (n3 = n2 + 1; n3 < matrixI.getNCols(); ++n3) {
                objectArray[n4][n3 - 1] = matrixI.getEle(n4, n3);
            }
        }
        for (n4 = n + 1; n4 < matrixI.getNRows(); ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                objectArray[n4 - 1][n3] = matrixI.getEle(n4, n3);
            }
            for (n3 = n2 + 1; n3 < matrixI.getNCols(); ++n3) {
                objectArray[n4 - 1][n3 - 1] = matrixI.getEle(n4, n3);
            }
        }
        return this.mf.newMatrix(objectArray);
    }

    protected void swapRows(MatrixI matrixI, int n, int n2) throws EvaluationException {
        int n3 = matrixI.getNCols();
        for (int i = 0; i < n3; ++i) {
            Object object = matrixI.getEle(n, i);
            Object object2 = matrixI.getEle(n2, i);
            matrixI.setEle(n, i, object2);
            matrixI.setEle(n2, i, object);
        }
    }

    protected void mulRow(MatrixI matrixI, int n, Object object) throws EvaluationException {
        int n2 = matrixI.getNCols();
        for (int i = 0; i < n2; ++i) {
            matrixI.setEle(n, i, this.mulEle(matrixI.getEle(n, i), object));
        }
    }

    protected void subtractMul(MatrixI matrixI, int n, int n2, Object object) throws EvaluationException {
        int n3 = matrixI.getNCols();
        for (int i = 0; i < n3; ++i) {
            matrixI.setEle(n, i, this.subEle(matrixI.getEle(n, i), this.mulEle(matrixI.getEle(n2, i), object)));
        }
    }

    protected MatrixI invM(MatrixI matrixI) throws EvaluationException {
        Object object = this.detM(matrixI);
        if (object == null) {
            throw new EvaluationException("Could not calculate the determinant of " + matrixI);
        }
        if (this.eqEle(object, this.getZero()).booleanValue()) {
            throw new EvaluationException("Cannot invert matrix with zero determinant " + matrixI);
        }
        int n = matrixI.getNRows();
        if (n == 2) {
            MatrixI matrixI2 = this.mf.identity(2);
            matrixI2.setEle(0, 0, matrixI.getEle(1, 1));
            matrixI2.setEle(0, 1, this.negEle(matrixI.getEle(0, 1)));
            matrixI2.setEle(1, 0, this.negEle(matrixI.getEle(1, 0)));
            matrixI2.setEle(1, 1, matrixI.getEle(0, 0));
            MatrixI matrixI3 = this.divMO(matrixI2, object);
            return matrixI3;
        }
        if (n == 3) {
            Object object2 = matrixI.getEle(0, 0);
            Object object3 = matrixI.getEle(0, 1);
            Object object4 = matrixI.getEle(0, 2);
            Object object5 = matrixI.getEle(1, 0);
            Object object6 = matrixI.getEle(1, 1);
            Object object7 = matrixI.getEle(1, 2);
            Object object8 = matrixI.getEle(2, 0);
            Object object9 = matrixI.getEle(2, 1);
            Object object10 = matrixI.getEle(2, 2);
            Object object11 = this.subEle(this.mulEle(object6, object10), this.mulEle(object7, object9));
            Object object12 = this.subEle(this.mulEle(object7, object8), this.mulEle(object5, object10));
            Object object13 = this.subEle(this.mulEle(object5, object9), this.mulEle(object6, object8));
            Object object14 = this.subEle(this.mulEle(object4, object9), this.mulEle(object3, object10));
            Object object15 = this.subEle(this.mulEle(object2, object10), this.mulEle(object4, object8));
            Object object16 = this.subEle(this.mulEle(object3, object8), this.mulEle(object2, object9));
            Object object17 = this.subEle(this.mulEle(object3, object7), this.mulEle(object4, object6));
            Object object18 = this.subEle(this.mulEle(object4, object5), this.mulEle(object2, object7));
            Object object19 = this.subEle(this.mulEle(object2, object6), this.mulEle(object3, object5));
            MatrixI matrixI4 = this.mf.identity(3);
            matrixI4.setEle(0, 0, object11);
            matrixI4.setEle(0, 1, object14);
            matrixI4.setEle(0, 2, object17);
            matrixI4.setEle(1, 0, object12);
            matrixI4.setEle(1, 1, object15);
            matrixI4.setEle(1, 2, object18);
            matrixI4.setEle(2, 0, object13);
            matrixI4.setEle(2, 1, object16);
            matrixI4.setEle(2, 2, object19);
            MatrixI matrixI5 = this.divMO(matrixI4, object);
            return matrixI5;
        }
        MatrixI matrixI6 = this.mf.newMatrix(matrixI.toArray(new Object[n][n]));
        MatrixI matrixI7 = this.mf.identity(n);
        return this.gaussJordan(n, matrixI6, matrixI7);
    }

    MatrixI gaussJordan(int n, MatrixI matrixI, MatrixI matrixI2) throws EvaluationException {
        for (int i = 0; i < n; ++i) {
            Object object = matrixI.getEle(i, i);
            Object object2 = this.mulEle(object, object);
            int n2 = i;
            for (int j = i + 1; j < n; ++j) {
                object = matrixI.getEle(j, i);
                Object object3 = this.mulEle(object, object);
                if (!this.gtEle(object3, object2).booleanValue()) continue;
                object2 = object3;
                n2 = j;
            }
            if (n2 != i) {
                this.swapRows(matrixI, i, n2);
                this.swapRows(matrixI2, i, n2);
            }
            object = matrixI.getEle(i, i);
            Object object4 = this.divEle(this.getOne(), object);
            this.mulRow(matrixI, i, object4);
            this.mulRow(matrixI2, i, object4);
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                object4 = matrixI.getEle(j, i);
                this.subtractMul(matrixI, j, i, object4);
                this.subtractMul(matrixI2, j, i, object4);
            }
        }
        return matrixI2;
    }

    @Override
    public Object inv(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            return this.invM(matrixI);
        }
        return null;
    }

    protected MatrixI solveMM(MatrixI matrixI, MatrixI matrixI2) throws EvaluationException {
        MatrixI matrixI3 = this.mf.newMatrix(matrixI.toArray(new Object[matrixI.getNRows()][matrixI.getNCols()]));
        MatrixI matrixI4 = this.mf.newMatrix(matrixI2.toArray(new Object[matrixI2.getNRows()][matrixI2.getNCols()]));
        return this.gaussJordan(matrixI.getNRows(), matrixI3, matrixI4);
    }

    protected VectorI solveMV(MatrixI matrixI, VectorI vectorI) throws EvaluationException {
        MatrixI matrixI2 = this.mf.newMatrix(matrixI.toArray(new Object[matrixI.getNRows()][matrixI.getNCols()]));
        Object[][] objectArray = new Object[vectorI.getNEles()][1];
        for (int i = 0; i < vectorI.getNEles(); ++i) {
            objectArray[i][0] = vectorI.getEle(i);
        }
        MatrixI matrixI3 = this.mf.newMatrix(objectArray);
        MatrixI matrixI4 = this.gaussJordan(matrixI.getNRows(), matrixI2, matrixI3);
        Object[] objectArray2 = new Object[vectorI.getNEles()];
        for (int i = 0; i < vectorI.getNEles(); ++i) {
            objectArray2[i] = matrixI4.getEle(i, 0);
        }
        return this.mf.newVector(objectArray2);
    }

    @Override
    public Object solve(Object object, Object object2) throws EvaluationException {
        if (!(object instanceof MatrixI)) {
            throw new EvaluationException("Can only solve equations when lhs is a square matrix" + object);
        }
        MatrixI matrixI = (MatrixI)object;
        int n = matrixI.getNRows();
        if (n != matrixI.getNCols()) {
            throw new EvaluationException("Can only solve equations when lhs is a square matrix" + object);
        }
        if (object2 instanceof MatrixI) {
            MatrixI matrixI2 = (MatrixI)object2;
            if (n != matrixI2.getNRows()) {
                throw new EvaluationException("Can only solve equations when number of rows on left and right match" + object + " " + object2);
            }
            return this.solveMM(matrixI, matrixI2);
        }
        if (object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object2;
            if (n != vectorI.getNEles()) {
                throw new EvaluationException("Can only solve equations when number of rows on left and right match" + object + " " + object2);
            }
            return this.solveMV(matrixI, vectorI);
        }
        return null;
    }
}

