/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix;

import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFunctionI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.Ele;
import com.singularsys.jep.functions.LValueI;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.reals.RealNaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class DimensionVisitor
implements ParserVisitor,
JepComponent {
    private static final long serialVersionUID = 350L;
    List<String> warnings = new ArrayList<String>();
    public static final Node.HookKey DIM_KEY = new Node.HookKey(){

        public String toString() {
            return "DIM_KEY";
        }
    };
    Jep jep;
    OperatorTableI ot;

    public DimensionVisitor() {
    }

    public DimensionVisitor(Jep jep) {
        this.jep = jep;
        this.ot = this.jep.getOperatorTable();
    }

    public static final Dimensions getDimByValue(Object object) {
        if (object instanceof MatrixI) {
            return Dimensions.valueOf(((MatrixI)object).getNRows(), ((MatrixI)object).getNCols());
        }
        if (object instanceof VectorI) {
            int n = ((VectorI)object).getNEles();
            return Dimensions.valueOf(n);
        }
        if (object instanceof Number || object instanceof Boolean) {
            return Dimensions.ONE;
        }
        if (object instanceof Vector) {
            int n = ((Vector)object).size();
            Object e = ((Vector)object).get(0);
            if (e instanceof Vector) {
                int n2 = ((Vector)e).size();
                return Dimensions.valueOf(n, n2);
            }
            return Dimensions.valueOf(n);
        }
        return Dimensions.ONE;
    }

    public Dimensions visit(Node node) throws ParseException {
        Dimensions dimensions;
        try {
            dimensions = (Dimensions)node.jjtAccept(this, null);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        return dimensions;
    }

    @Override
    public Dimensions visit(ASTConstant aSTConstant, Object object) throws ParseException {
        Dimensions dimensions = DimensionVisitor.getDimByValue(aSTConstant.getValue());
        aSTConstant.setHook(DIM_KEY, dimensions);
        return dimensions;
    }

    @Override
    public Dimensions visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        Variable variable = aSTVarNode.getVar();
        Dimensions dimensions = (Dimensions)variable.getHook(DIM_KEY);
        if (variable.hasValidValue()) {
            Object object2 = variable.getValue();
            Dimensions dimensions2 = DimensionVisitor.getDimByValue(object2);
            if (dimensions == null) {
                variable.setHook(DIM_KEY, dimensions2);
                aSTVarNode.setHook(DIM_KEY, dimensions2);
                return dimensions2;
            }
            if (dimensions.equalsDim(dimensions2)) {
                variable.setHook(DIM_KEY, dimensions2);
                aSTVarNode.setHook(DIM_KEY, dimensions2);
                return dimensions2;
            }
            System.out.println("DimensionVisitor: variable dimensions differ " + dimensions + " " + dimensions2);
            variable.setHook(DIM_KEY, dimensions2);
            aSTVarNode.setHook(DIM_KEY, dimensions2);
            return dimensions2;
        }
        if (dimensions == null) {
            if (this.jep.getAllowUndeclared()) {
                dimensions = Dimensions.ONE;
            } else {
                throw new ParseException("DimensionVisitor: unknown dimension for variable " + variable.toString());
            }
        }
        variable.setHook(DIM_KEY, dimensions);
        aSTVarNode.setHook(DIM_KEY, dimensions);
        return dimensions;
    }

    protected Dimensions visitAssign(ASTOpNode aSTOpNode, Object object) throws ParseException {
        Dimensions dimensions;
        try {
            dimensions = (Dimensions)aSTOpNode.jjtGetChild(1).jjtAccept(this, object);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        Node node = aSTOpNode.jjtGetChild(0);
        Variable variable = node.getVar();
        if (variable == null) {
            if (node.getPFMC() instanceof LValueI) {
                if (node.getPFMC() instanceof Ele) {
                    variable = node.jjtGetChild(0).getVar();
                    Dimensions dimensions2 = (Dimensions)variable.getHook(DIM_KEY);
                    if (dimensions2 == null) {
                        throw new ParseException(MessageFormat.format("Assign: LHS Variable {0} should have its dimesions set", variable.toString()));
                    }
                    int n = node.jjtGetNumChildren();
                    int n2 = n - 1;
                    Dimensions[] dimensionsArray = new Dimensions[n];
                    for (int i = 0; i < n; ++i) {
                        dimensionsArray[i] = this.visit(node.jjtGetChild(i));
                        if (i <= 0 || dimensionsArray[i].is0D()) continue;
                        throw new ParseException(MessageFormat.format("Assign: indices of LValueI {0}[] should be 1, found {1}.", variable.toString(), dimensionsArray[i]));
                    }
                    if (dimensions2.is1D()) {
                        if (n2 != 1) {
                            throw new ParseException(MessageFormat.format("Assign: only one index allowed lhs variable {0} with dimension {1}, found {2}", variable.toString(), dimensions2, n2));
                        }
                        if (!dimensions.is0D()) {
                            throw new ParseException(MessageFormat.format("Assign: rhs of LValue assignment should be 1D, found {0}", dimensions));
                        }
                    } else if (dimensions2.is2D()) {
                        if (n2 == 1) {
                            if (!dimensions.is1D() && dimensions.getFirstDim() != dimensions2.getLastDim()) {
                                throw new ParseException(MessageFormat.format("Assign: dimensions of rhs {0} don't match dimensions of variable {1} ({2}) whih one index", dimensions, variable.toString(), dimensions2));
                            }
                        } else if (n2 == 2 && !dimensions.is0D()) {
                            throw new ParseException(MessageFormat.format("Assign: rhs of LValue assignment should be 1D, found {0}", dimensions));
                        }
                    } else {
                        throw new ParseException(MessageFormat.format("Assign: lhs variable {0} with dimension {1} should be 1D or 2D", variable.toString(), dimensions2));
                    }
                    aSTOpNode.setHook(DIM_KEY, dimensions);
                    node.setHook(DIM_KEY, dimensions);
                    return dimensions;
                }
                throw new ParseException(MessageFormat.format("Unknown LValueI {0} in assignment", node.toString()));
            }
            throw new ParseException(MessageFormat.format(JepMessages.getString("functions.AssignmentShouldHaveAnLValue"), node.getName(), node.toString()));
        }
        Dimensions dimensions3 = (Dimensions)variable.getHook(DIM_KEY);
        aSTOpNode.setHook(DIM_KEY, dimensions);
        node.setHook(DIM_KEY, dimensions);
        if (dimensions3 == null) {
            variable.setHook(DIM_KEY, dimensions);
        } else if (!dimensions3.equalsDim(dimensions)) {
            this.warnings.add("Warning variable dimensions changes for " + variable.getName() + " from " + dimensions3 + " to " + dimensions);
            variable.setHook(DIM_KEY, dimensions);
            variable.setValidValue(false);
        }
        return dimensions;
    }

    @Override
    public Dimensions visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        int n = aSTFunNode.jjtGetNumChildren();
        Dimensions[] dimensionsArray = new Dimensions[n];
        for (int i = 0; i < dimensionsArray.length; ++i) {
            try {
                dimensionsArray[i] = (Dimensions)aSTFunNode.jjtGetChild(i).jjtAccept(this, object);
                continue;
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (JepException jepException) {
                throw new ParseException(jepException);
            }
        }
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI instanceof MatrixFunctionI) {
            Dimensions dimensions = ((MatrixFunctionI)((Object)postfixMathCommandI)).calcDims(dimensionsArray);
            if (dimensions == null) {
                boolean bl = true;
                Stack<Object> stack = new Stack<Object>();
                for (int i = n - 1; i >= 0; --i) {
                    Node node = aSTFunNode.jjtGetChild(i);
                    if (!(node instanceof ASTConstant)) {
                        bl = false;
                        break;
                    }
                    stack.push(node.getValue());
                }
                if (bl) {
                    postfixMathCommandI.setCurNumberOfParameters(n);
                    try {
                        postfixMathCommandI.run(stack);
                        Object object2 = stack.pop();
                        dimensions = DimensionVisitor.getDimByValue(object2);
                    }
                    catch (EvaluationException evaluationException) {
                        throw new ParseException(evaluationException);
                    }
                } else {
                    throw new ParseException("Cannot calculate dimensions for function/operator " + aSTFunNode.getName());
                }
            }
            aSTFunNode.setHook(DIM_KEY, dimensions);
            return dimensions;
        }
        for (int i = 0; i < dimensionsArray.length; ++i) {
            if (dimensionsArray[i].is0D()) continue;
            throw new ParseException("RpEval: Sorry only functions with scalar arguments are supported");
        }
        aSTFunNode.setHook(DIM_KEY, Dimensions.ONE);
        return Dimensions.ONE;
    }

    @Override
    public Dimensions visit(ASTOpNode aSTOpNode, Object object) throws ParseException {
        Dimensions dimensions;
        if (aSTOpNode.getOperator() == this.ot.getAssign()) {
            return this.visitAssign(aSTOpNode, object);
        }
        int n = aSTOpNode.jjtGetNumChildren();
        Operator operator = aSTOpNode.getOperator();
        Dimensions[] dimensionsArray = new Dimensions[n];
        for (int i = 0; i < n; ++i) {
            try {
                dimensionsArray[i] = (Dimensions)aSTOpNode.jjtGetChild(i).jjtAccept(this, object);
                continue;
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (JepException jepException) {
                throw new ParseException(jepException);
            }
        }
        PostfixMathCommandI postfixMathCommandI = aSTOpNode.getPFMC();
        if (postfixMathCommandI instanceof MatrixFunctionI) {
            Dimensions dimensions2 = ((MatrixFunctionI)((Object)postfixMathCommandI)).calcDims(dimensionsArray);
            aSTOpNode.setHook(DIM_KEY, dimensions2);
            return dimensions2;
        }
        if (operator.isBinary() && n != 2) {
            throw new ParseException("DimensionVisitor: binary operator must have two children, but it has " + n);
        }
        if (operator.isUnary() && n != 1) {
            throw new ParseException("DimensionVisitor: unary operator must have one child, but it has " + n);
        }
        if (postfixMathCommandI instanceof RealUnaryFunction) {
            if (!dimensionsArray[0].is0D()) {
                throw new ParseException("DimensionVisitor: real unary functions can only accept scaler arguments, but found " + dimensionsArray[0]);
            }
            aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
            return Dimensions.ONE;
        }
        if (postfixMathCommandI instanceof RealBinaryFunction) {
            if (!dimensionsArray[0].is0D() || !dimensionsArray[1].is0D()) {
                throw new ParseException("DimensionVisitor: real binary functions can only accept scaler arguments, but found " + dimensionsArray[0] + " and " + dimensionsArray[1]);
            }
            aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
            return Dimensions.ONE;
        }
        if (postfixMathCommandI instanceof RealNaryFunction) {
            for (int i = 0; i < dimensionsArray.length; ++i) {
                if (dimensionsArray[i].is0D()) continue;
                throw new ParseException("DimensionVisitor: real nary functions can only accept scaler arguments, but found " + dimensionsArray[i]);
            }
            aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
            return Dimensions.ONE;
        }
        if (n == 1) {
            dimensions = dimensionsArray[0];
            if (operator == this.ot.getUPlus()) {
                aSTOpNode.setHook(DIM_KEY, dimensions);
                return dimensions;
            }
            if (operator == this.ot.getNot()) {
                if (!dimensions.is0D()) {
                    throw new ParseException("Dimension of operand for 'not' operator must be one");
                }
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
        }
        if (n == 2) {
            dimensions = dimensionsArray[0];
            Dimensions dimensions3 = dimensionsArray[1];
            if (operator == this.ot.getEQ()) {
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
            if (operator == this.ot.getNE()) {
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
            if (operator == this.ot.getLT()) {
                if (!dimensions.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for < operator must both be one");
                }
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
            if (operator == this.ot.getGT()) {
                if (!dimensions.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for > operator must both be one");
                }
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
            if (operator == this.ot.getLE()) {
                if (!dimensions.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for <= operator must both be one");
                }
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
            if (operator == this.ot.getGE()) {
                if (!dimensions.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for >= operator must both be one");
                }
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
            if (operator == this.ot.getAnd()) {
                if (!dimensions.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for && operator must both be one");
                }
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
            if (operator == this.ot.getOr()) {
                if (!dimensions.is0D() || !dimensions3.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                aSTOpNode.setHook(DIM_KEY, Dimensions.ONE);
                return Dimensions.ONE;
            }
        }
        if (operator == this.ot.getList()) {
            dimensions = Dimensions.valueOf(dimensionsArray.length, dimensionsArray[0]);
            aSTOpNode.setHook(DIM_KEY, dimensions);
            return dimensions;
        }
        throw new ParseException("RpeEval: Sorry unsupported operator/function: " + aSTOpNode.getName());
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public void init(Jep jep) {
        this.jep = jep;
        this.ot = this.jep.getOperatorTable();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

