/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.doublemat;

import com.singularsys.extensions.field.implementations.PowerImplementations;
import com.singularsys.extensions.matrix.AbstractMatrixField;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.extensions.matrix.doublemat.DoubleMatrix;
import com.singularsys.extensions.matrix.doublemat.DoubleVector;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;

public class DoubleMatrixField
extends AbstractMatrixField {
    private static final long serialVersionUID = 330L;

    public DoubleMatrixField(MatrixFactoryI matrixFactoryI) {
        super(matrixFactoryI);
    }

    @Override
    protected MatrixI addMM(MatrixI matrixI, MatrixI matrixI2) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        DoubleMatrix doubleMatrix2 = (DoubleMatrix)matrixI2;
        double[][] dArray = new double[doubleMatrix.nrows][doubleMatrix.ncols];
        for (int i = 0; i < doubleMatrix.nrows; ++i) {
            for (int j = 0; j < doubleMatrix.ncols; ++j) {
                dArray[i][j] = doubleMatrix.data[i][j] + doubleMatrix2.data[i][j];
            }
        }
        DoubleMatrix doubleMatrix3 = new DoubleMatrix(dArray);
        return doubleMatrix3;
    }

    @Override
    protected MatrixI subMM(MatrixI matrixI, MatrixI matrixI2) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        DoubleMatrix doubleMatrix2 = (DoubleMatrix)matrixI2;
        double[][] dArray = new double[doubleMatrix.nrows][doubleMatrix.ncols];
        for (int i = 0; i < doubleMatrix.nrows; ++i) {
            for (int j = 0; j < doubleMatrix.ncols; ++j) {
                dArray[i][j] = doubleMatrix.data[i][j] - doubleMatrix2.data[i][j];
            }
        }
        DoubleMatrix doubleMatrix3 = new DoubleMatrix(dArray);
        return doubleMatrix3;
    }

    @Override
    protected MatrixI negM(MatrixI matrixI) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        double[][] dArray = new double[doubleMatrix.nrows][doubleMatrix.ncols];
        for (int i = 0; i < doubleMatrix.nrows; ++i) {
            for (int j = 0; j < doubleMatrix.ncols; ++j) {
                dArray[i][j] = -doubleMatrix.data[i][j];
            }
        }
        DoubleMatrix doubleMatrix2 = new DoubleMatrix(dArray);
        return doubleMatrix2;
    }

    @Override
    protected DoubleMatrix mulMO(MatrixI matrixI, Object object) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        double d = ((Number)object).doubleValue();
        double[][] dArray = new double[doubleMatrix.nrows][doubleMatrix.ncols];
        for (int i = 0; i < doubleMatrix.nrows; ++i) {
            for (int j = 0; j < doubleMatrix.ncols; ++j) {
                dArray[i][j] = doubleMatrix.data[i][j] * d;
            }
        }
        DoubleMatrix doubleMatrix2 = new DoubleMatrix(dArray);
        return doubleMatrix2;
    }

    @Override
    protected DoubleMatrix mulMM(MatrixI matrixI, MatrixI matrixI2) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        DoubleMatrix doubleMatrix2 = (DoubleMatrix)matrixI2;
        double[][] dArray = new double[doubleMatrix.nrows][doubleMatrix2.ncols];
        for (int i = 0; i < doubleMatrix.nrows; ++i) {
            for (int j = 0; j < doubleMatrix2.ncols; ++j) {
                double d = 0.0;
                for (int k = 0; k < doubleMatrix.ncols; ++k) {
                    d += doubleMatrix.data[i][k] * doubleMatrix2.data[k][j];
                }
                dArray[i][j] = d;
            }
        }
        DoubleMatrix doubleMatrix3 = new DoubleMatrix(dArray);
        return doubleMatrix3;
    }

    @Override
    protected DoubleVector mulVM(VectorI vectorI, MatrixI matrixI) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        double[] dArray = new double[doubleMatrix.ncols];
        for (int i = 0; i < doubleMatrix.ncols; ++i) {
            double d = 0.0;
            for (int j = 0; j < doubleMatrix.nrows; ++j) {
                d += doubleVector.data[j] * doubleMatrix.data[j][i];
            }
            dArray[i] = d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected DoubleVector mulMV(MatrixI matrixI, VectorI vectorI) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double[] dArray = new double[doubleMatrix.nrows];
        for (int i = 0; i < doubleMatrix.nrows; ++i) {
            double d = 0.0;
            for (int j = 0; j < doubleMatrix.ncols; ++j) {
                d += doubleMatrix.data[i][j] * doubleVector.data[j];
            }
            dArray[i] = d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected DoubleMatrix divMO(MatrixI matrixI, Object object) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        double d = ((Number)object).doubleValue();
        double[][] dArray = new double[doubleMatrix.nrows][doubleMatrix.ncols];
        for (int i = 0; i < doubleMatrix.nrows; ++i) {
            for (int j = 0; j < doubleMatrix.ncols; ++j) {
                dArray[i][j] = doubleMatrix.data[i][j] / d;
            }
        }
        DoubleMatrix doubleMatrix2 = new DoubleMatrix(dArray);
        return doubleMatrix2;
    }

    @Override
    protected Object detM(MatrixI matrixI) throws EvaluationException {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        if (doubleMatrix.nrows == 2) {
            double d = doubleMatrix.data[0][0] * doubleMatrix.data[1][1] - doubleMatrix.data[0][1] * doubleMatrix.data[1][0];
            return d;
        }
        if (doubleMatrix.nrows == 3) {
            double d = doubleMatrix.data[0][0] * (doubleMatrix.data[1][1] * doubleMatrix.data[2][2] - doubleMatrix.data[2][1] * doubleMatrix.data[1][2]);
            d -= doubleMatrix.data[0][1] * (doubleMatrix.data[1][0] * doubleMatrix.data[2][2] - doubleMatrix.data[2][0] * doubleMatrix.data[1][2]);
            return d += doubleMatrix.data[0][2] * (doubleMatrix.data[1][0] * doubleMatrix.data[2][1] - doubleMatrix.data[2][0] * doubleMatrix.data[1][1]);
        }
        double d = 0.0;
        for (int i = 0; i < doubleMatrix.ncols; ++i) {
            DoubleMatrix doubleMatrix2 = (DoubleMatrix)this.minor(doubleMatrix, 0, i);
            if (i % 2 == 0) {
                d += doubleMatrix.data[0][i] * (Double)this.detM(doubleMatrix2);
                continue;
            }
            d -= doubleMatrix.data[0][i] * (Double)this.detM(doubleMatrix2);
        }
        return d;
    }

    @Override
    protected Object transM(MatrixI matrixI) {
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        double[][] dArray = new double[matrixI.getNCols()][matrixI.getNRows()];
        for (int i = 0; i < matrixI.getNRows(); ++i) {
            for (int j = 0; j < matrixI.getNCols(); ++j) {
                dArray[j][i] = doubleMatrix.data[i][j];
            }
        }
        return new DoubleMatrix(dArray);
    }

    @Override
    protected VectorI addVV(VectorI vectorI, VectorI vectorI2) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] + doubleVector2.data[i];
        }
        DoubleVector doubleVector3 = new DoubleVector(dArray);
        return doubleVector3;
    }

    @Override
    protected VectorI subVV(VectorI vectorI, VectorI vectorI2) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] - doubleVector2.data[i];
        }
        DoubleVector doubleVector3 = new DoubleVector(dArray);
        return doubleVector3;
    }

    @Override
    protected VectorI negV(VectorI vectorI) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = -doubleVector.data[i];
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected VectorI mulVO(VectorI vectorI, Object object) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double d = ((Number)object).doubleValue();
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] * d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected VectorI divVO(VectorI vectorI, Object object) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double d = ((Number)object).doubleValue();
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] / d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected Object addEle(Object object, Object object2) {
        return (Double)object + (Double)object2;
    }

    @Override
    protected Object mulEle(Object object, Object object2) {
        return (Double)object * (Double)object2;
    }

    @Override
    protected Object subEle(Object object, Object object2) {
        return (Double)object - (Double)object2;
    }

    @Override
    protected Object dotVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double d = 0.0;
        for (int i = 0; i < doubleVector.nrows; ++i) {
            d += doubleVector.data[i] * doubleVector2.data[i];
        }
        return d;
    }

    @Override
    protected MatrixI mulVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double[][] dArray = new double[doubleVector.nrows][doubleVector2.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            for (int j = 0; j < doubleVector2.nrows; ++j) {
                dArray[i][j] = doubleVector.data[i] * doubleVector2.data[j];
            }
        }
        return new DoubleMatrix(dArray);
    }

    @Override
    protected Object crossVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        if (doubleVector.nrows == 3) {
            double[] dArray = new double[]{doubleVector.data[1] * doubleVector2.data[2] - doubleVector.data[2] * doubleVector2.data[1], doubleVector.data[2] * doubleVector2.data[0] - doubleVector.data[0] * doubleVector2.data[2], doubleVector.data[0] * doubleVector2.data[1] - doubleVector.data[1] * doubleVector2.data[0]};
            DoubleVector doubleVector3 = new DoubleVector(dArray);
            return doubleVector3;
        }
        throw new EvaluationException("Wrong dimensions for cross product " + doubleVector.getNEles());
    }

    @Override
    protected Boolean eqVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        if (vectorI.getNEles() != vectorI2.getNEles()) {
            return Boolean.FALSE;
        }
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        for (int i = doubleVector.getNEles() - 1; i >= 0; --i) {
            if (doubleVector.data[i] == doubleVector2.data[i]) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean neVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        if (vectorI.getNEles() != vectorI2.getNEles()) {
            return Boolean.TRUE;
        }
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        for (int i = doubleVector.getNEles() - 1; i >= 0; --i) {
            if (doubleVector.data[i] == doubleVector2.data[i]) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean eqMM(MatrixI matrixI, MatrixI matrixI2) throws EvaluationException {
        if (matrixI.getNRows() != matrixI2.getNRows()) {
            return Boolean.FALSE;
        }
        if (matrixI.getNCols() != matrixI2.getNCols()) {
            return Boolean.FALSE;
        }
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        DoubleMatrix doubleMatrix2 = (DoubleMatrix)matrixI2;
        for (int i = doubleMatrix.getNRows() - 1; i >= 0; --i) {
            for (int j = doubleMatrix.getNCols() - 1; j >= 0; --j) {
                if (doubleMatrix.data[i][j] == doubleMatrix2.data[i][j]) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean neMM(MatrixI matrixI, MatrixI matrixI2) throws EvaluationException {
        if (matrixI.getNRows() != matrixI2.getNRows()) {
            return Boolean.TRUE;
        }
        if (matrixI.getNCols() != matrixI2.getNCols()) {
            return Boolean.TRUE;
        }
        DoubleMatrix doubleMatrix = (DoubleMatrix)matrixI;
        DoubleMatrix doubleMatrix2 = (DoubleMatrix)matrixI2;
        for (int i = doubleMatrix.getNRows() - 1; i >= 0; --i) {
            for (int j = doubleMatrix.getNCols() - 1; j >= 0; --j) {
                if (doubleMatrix.data[i][j] == doubleMatrix2.data[i][j]) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public Object trace(Object object) throws EvaluationException {
        DoubleMatrix doubleMatrix = (DoubleMatrix)object;
        int n = doubleMatrix.nrows < doubleMatrix.ncols ? doubleMatrix.nrows : doubleMatrix.ncols;
        double d = doubleMatrix.data[0][0];
        for (int i = 1; i < n; ++i) {
            d += doubleMatrix.data[i][i];
        }
        return d;
    }

    @Override
    protected Object negEle(Object object) throws EvaluationException {
        return -((Double)object).doubleValue();
    }

    @Override
    protected Object divEle(Object object, Object object2) throws EvaluationException {
        return (Double)object / (Double)object2;
    }

    @Override
    protected Object modEle(Object object, Object object2) throws EvaluationException {
        return (Double)object % (Double)object2;
    }

    @Override
    protected Object powEle(Object object, Object object2) throws EvaluationException {
        return PowerImplementations.power((double)((Double)object), (Double)object2);
    }

    @Override
    protected Boolean eqEle(Object object, Object object2) throws EvaluationException {
        return ((Double)object).doubleValue() == ((Double)object2).doubleValue();
    }

    @Override
    protected Boolean neEle(Object object, Object object2) throws EvaluationException {
        return ((Double)object).doubleValue() != ((Double)object2).doubleValue();
    }

    @Override
    protected Boolean leEle(Object object, Object object2) throws EvaluationException {
        return (Double)object <= (Double)object2;
    }

    @Override
    protected Boolean ltEle(Object object, Object object2) throws EvaluationException {
        return (Double)object < (Double)object2;
    }

    @Override
    protected Boolean geEle(Object object, Object object2) throws EvaluationException {
        return (Double)object >= (Double)object2;
    }

    @Override
    protected Boolean gtEle(Object object, Object object2) throws EvaluationException {
        return (Double)object > (Double)object2;
    }

    @Override
    protected Boolean andEle(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    protected Boolean orEle(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    protected Boolean notEle(Object object) throws EvaluationException {
        return null;
    }

    @Override
    public Object getOne() {
        return 1.0;
    }

    @Override
    public Object getZero() {
        return 0.0;
    }

    @Override
    public Integer convertToInt(Object object) throws EvaluationException {
        Double d;
        int n;
        if (object instanceof Double && (double)(n = (d = (Double)object).intValue()) == d) {
            return n;
        }
        return null;
    }

    @Override
    public Object convertFromInt(Integer n) throws EvaluationException {
        return n.doubleValue();
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

