/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.functions;

import com.singularsys.extensions.field.implementations.IntegerConvertor;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixFunctionI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.NaryFunction;

public class MatrixId
extends NaryFunction
implements MatrixFunctionI {
    private static final long serialVersionUID = 340L;
    MatrixFactoryI mfact;
    IntegerConvertor conv;

    public MatrixId(MatrixFactoryI matrixFactoryI, IntegerConvertor integerConvertor) {
        this.mfact = matrixFactoryI;
        this.conv = integerConvertor;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n == 1 || n == 2;
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        if (objectArray.length == 1) {
            Integer n = this.conv.convertToInt(objectArray[0]);
            if (n == null) {
                n = this.asStrictInt(0, objectArray[0]);
            }
            return this.mfact.identity(n);
        }
        if (objectArray.length == 2) {
            Integer n;
            Integer n2 = this.conv.convertToInt(objectArray[0]);
            if (n2 == null) {
                n2 = this.asStrictInt(0, objectArray[0]);
            }
            if ((n = this.conv.convertToInt(objectArray[1])) == null) {
                n = this.asStrictInt(1, objectArray[1]);
            }
            return this.mfact.identity(n2, n);
        }
        throw new EvaluationException("Identity Matrix too many arguments " + objectArray);
    }

    @Override
    public Dimensions calcDims(Dimensions ... dimensionsArray) {
        return null;
    }
}

