/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.functions;

import com.singularsys.extensions.ExtMessages;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFieldI;
import com.singularsys.extensions.matrix.MatrixFunctionI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.UnaryFunction;
import java.text.MessageFormat;

public class MatrixTrace
extends UnaryFunction
implements MatrixFunctionI {
    private static final long serialVersionUID = 340L;
    MatrixFieldI mfield;

    public MatrixTrace(MatrixFieldI matrixFieldI) {
        this.mfield = matrixFieldI;
    }

    public Object trace(Object object) throws EvaluationException {
        Object object2 = this.mfield.trace(object);
        if (object2 != null) {
            return object2;
        }
        throw new EvaluationException("Could not calculate the trace of " + object);
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.trace(object);
    }

    @Override
    public Dimensions calcDims(Dimensions ... dimensionsArray) throws ParseException {
        if (dimensionsArray.length != 1) {
            throw new ParseException(MessageFormat.format(JepMessages.getString("FunctionRequiresNArgumentsFoundN"), this.getName(), 1, dimensionsArray.length));
        }
        Dimensions dimensions = dimensionsArray[0];
        if (!dimensions.is2D() || dimensions.getFirstDim() != dimensions.getLastDim()) {
            throw new ParseException(MessageFormat.format(ExtMessages.getString("BadDimensions"), this.getName(), dimensionsArray[0]));
        }
        return Dimensions.ONE;
    }
}

