/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.field.implementations.IntegerConvertor;
import com.singularsys.extensions.polynomials.AbstractPNode;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.POperator;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.Node;
import java.util.Map;

public class PConstant
extends AbstractPNode {
    Object value;

    public PConstant(PolynomialCreator polynomialCreator, Object object) {
        super(polynomialCreator);
        this.value = object;
    }

    @Override
    public PNodeI negate() throws ParseException {
        return new PConstant(this.pc, this.pc.neg(this.value));
    }

    @Override
    public PNodeI add(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            return pNodeI;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.add(this.value, ((PConstant)pNodeI).value));
        }
        return super.add(pNodeI);
    }

    @Override
    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            return pNodeI.negate();
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.sub(this.value, ((PConstant)pNodeI).value));
        }
        return super.sub(pNodeI);
    }

    @Override
    public PNodeI mul(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            return this.pc.zeroConstant;
        }
        if (this.isOne()) {
            return pNodeI;
        }
        if (pNodeI.isZero()) {
            return this.pc.zeroConstant;
        }
        if (pNodeI.isOne()) {
            return this;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.mul(this.value, ((PConstant)pNodeI).value));
        }
        return super.mul(pNodeI);
    }

    @Override
    public PNodeI div(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            if (pNodeI.isZero()) {
                if (this.pc.tu.hasNaN()) {
                    return this.pc.nanConstant;
                }
                return new POperator(this.pc, this.pc.ot.getDivide(), new PNodeI[]{this, pNodeI});
            }
            return this.pc.zeroConstant;
        }
        if (pNodeI.isZero()) {
            if (this.pc.tu.hasInfinity()) {
                return this.pc.infConstant;
            }
            return new POperator(this.pc, this.pc.ot.getDivide(), new PNodeI[]{this, pNodeI});
        }
        if (pNodeI.isOne()) {
            return this;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.div(this.value, ((PConstant)pNodeI).value));
        }
        return super.div(pNodeI);
    }

    @Override
    public PNodeI invert() throws ParseException {
        return new PConstant(this.pc, this.pc.div(this.pc.tu.getOne(), this.value));
    }

    @Override
    public PNodeI pow(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            if (pNodeI.isZero()) {
                if (this.pc.tu.hasNaN()) {
                    return this.pc.nanConstant;
                }
                return new POperator(this.pc, this.pc.ot.getPower(), new PNodeI[]{this, pNodeI});
            }
            return this.pc.zeroConstant;
        }
        if (this.isOne()) {
            return this.pc.oneConstant;
        }
        if (pNodeI.isZero()) {
            return this.pc.oneConstant;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.pow(this.value, ((PConstant)pNodeI).value));
        }
        return super.pow(pNodeI);
    }

    @Override
    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isOne()) {
            return "1";
        }
        if (this.isInfinity()) {
            return "inf";
        }
        if (this.isNan()) {
            return "NaN";
        }
        if (this.isInteger()) {
            return String.valueOf(this.intValue());
        }
        return this.value.toString();
    }

    @Override
    public boolean isZero() {
        return this.pc.tu.isZeroVal(this.value);
    }

    @Override
    public boolean isOne() {
        return this.pc.tu.isOneVal(this.value);
    }

    public boolean isMinusOne() {
        return this.pc.tu.isMinusOneVal(this.value);
    }

    public boolean isInfinity() {
        return this.pc.tu.isInfinityVal(this.value);
    }

    public boolean isNan() {
        return this.pc.tu.isNaNVal(this.value);
    }

    public boolean isPositive() {
        return this.pc.tu.isPositiveVal(this.value);
    }

    public boolean isNegative() {
        return this.pc.tu.isNegativeVal(this.value);
    }

    public boolean isInteger() {
        return this.pc.tu.isIntegerVal(this.value);
    }

    public int intValue() {
        try {
            Integer n;
            if (this.pc.field instanceof IntegerConvertor && (n = ((IntegerConvertor)((Object)this.pc.field)).convertToInt(this.value)) != null) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Node toNode() throws ParseException {
        return this.pc.getNodeFactory().buildConstantNode(this.value);
    }

    @Override
    public Node toCompactNode() throws ParseException {
        return this.toNode();
    }

    public int compareToPConstant(PConstant pConstant) {
        return ((Comparable)this.value).compareTo(pConstant.value);
    }

    @Override
    public boolean equalsPNode(PNodeI pNodeI) {
        if (pNodeI instanceof PConstant) {
            return this.value.equals(((PConstant)pNodeI).value);
        }
        return false;
    }

    @Override
    public PNodeI expand() {
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void convertToPolyArray(String string, Map<Integer, PNodeI> map) throws ParseException {
        super.addToMap(map, 0, this);
    }
}

