/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.AbstractPNode;
import com.singularsys.extensions.polynomials.Monomial;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.Polynomial;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.Node;
import java.util.Map;

public class PVariable
extends AbstractPNode {
    Variable variable;

    public PVariable(PolynomialCreator polynomialCreator, Variable variable) {
        super(polynomialCreator);
        this.variable = variable;
    }

    @Override
    public boolean equalsPNode(PNodeI pNodeI) {
        return pNodeI instanceof PVariable && this.variable.equals(((PVariable)pNodeI).variable);
    }

    @Override
    public PNodeI add(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PVariable && this.variable.equals(((PVariable)pNodeI).variable)) {
            return Monomial.valueOf(this.pc, this.pc.twoConstant, this);
        }
        return super.add(pNodeI);
    }

    @Override
    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PVariable && this.variable.equals(((PVariable)pNodeI).variable)) {
            return this.pc.zeroConstant;
        }
        return super.sub(pNodeI);
    }

    @Override
    public int compareTo(PVariable pVariable) {
        int n = this.variable.getName().compareTo(pVariable.variable.getName());
        return n < 0 ? -1 : (n == 0 ? 0 : 1);
    }

    @Override
    public String toString() {
        return this.variable.getName();
    }

    @Override
    public Node toNode() throws ParseException {
        return this.pc.getNodeFactory().buildVariableNode(this.variable);
    }

    @Override
    public Node toCompactNode() throws ParseException {
        return this.toNode();
    }

    @Override
    public PNodeI expand() {
        return this;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public String getName() {
        return this.variable.getName();
    }

    @Override
    public void convertToPolyArray(String string, Map<Integer, PNodeI> map) throws ParseException {
        if (string.equals(this.getName())) {
            super.addToMap(map, 1, this.pc.oneConstant);
        } else {
            super.addToMap(map, 0, this);
        }
    }

    @Override
    public PNodeI negate() throws ParseException {
        return Monomial.valueOf(this.pc, this.pc.minusOneConstant, this);
    }

    public boolean equalsIgnoreConstant(PNodeI pNodeI) {
        if (pNodeI instanceof PVariable) {
            return this.equalsPNode(pNodeI);
        }
        if (pNodeI instanceof Monomial) {
            Monomial monomial = (Monomial)pNodeI;
            if (monomial.vars.length != 1) {
                return false;
            }
            if (!this.equalsPNode(monomial.vars[0])) {
                return false;
            }
            return monomial.powers[0].equalsPNode(this.pc.oneConstant);
        }
        if (pNodeI instanceof Polynomial) {
            Polynomial polynomial = (Polynomial)pNodeI;
            if (polynomial.terms.length != 1) {
                return false;
            }
            return this.equalsIgnoreConstant(polynomial.terms[0]);
        }
        return false;
    }
}

