/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.statistical.ArgumentExpander;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;

public class ElementMinMax
extends PostfixMathCommand
implements JepComponent {
    private static final long serialVersionUID = 330L;
    FieldI field;
    Type type;

    public ElementMinMax(Type type, FieldI fieldI) {
        super(-1);
        this.type = type;
        this.field = fieldI;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n > 0;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        int n = this.curNumberOfParameters;
        switch (this.type) {
            case MIN: {
                MinProcessor minProcessor = new MinProcessor();
                minProcessor.doStack(stack, n);
                if (minProcessor.min == null) {
                    throw new EvaluationException(this.name + ": zero length array");
                }
                stack.push(minProcessor.min);
                break;
            }
            case MAX: {
                MaxProcessor maxProcessor = new MaxProcessor();
                maxProcessor.doStack(stack, n);
                if (maxProcessor.max == null) {
                    throw new EvaluationException(this.name + ": zero length array");
                }
                stack.push(maxProcessor.max);
            }
        }
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new ElementMinMax(this.type, this.field);
    }

    class MaxProcessor
    extends ArgumentExpander {
        Object max;
        int neles;

        @Override
        protected void doSingleArg(Object object) throws EvaluationException {
            ++this.neles;
            if (this.max == null) {
                this.max = object;
            } else {
                Boolean bl = ElementMinMax.this.field.gt(object, this.max);
                if (bl == null) {
                    throw new EvaluationException(ElementMinMax.this.name + ": could not compare " + object);
                }
                if (bl.booleanValue()) {
                    this.max = object;
                }
            }
        }
    }

    class MinProcessor
    extends ArgumentExpander {
        Object min;
        int neles;

        @Override
        protected void doSingleArg(Object object) throws EvaluationException {
            ++this.neles;
            if (this.min == null) {
                this.min = object;
            } else {
                Boolean bl = ElementMinMax.this.field.lt(object, this.min);
                if (bl == null) {
                    throw new EvaluationException(ElementMinMax.this.name + ": could not compare " + object);
                }
                if (bl.booleanValue()) {
                    this.min = object;
                }
            }
        }
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

