/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class NodeFactory
implements JepComponent {
    private static final long serialVersionUID = 300L;
    protected transient Evaluator ev;
    protected transient VariableTable vt;
    protected transient Jep j;

    @Override
    public void init(Jep jep) {
        this.j = jep;
        this.ev = this.j.getEvaluator();
        this.vt = this.j.getVariableTable();
    }

    public void copyChildren(Node node, Node ... nodeArray) {
        int n = nodeArray.length;
        node.jjtOpen();
        for (int i = 0; i < n; ++i) {
            nodeArray[i].jjtSetParent(node);
            node.jjtAddChild(nodeArray[i], i);
        }
        node.jjtClose();
    }

    public ASTConstant buildConstantNode(Object object) throws ParseException {
        ASTConstant aSTConstant = new ASTConstant(5);
        aSTConstant.setValue(object);
        return aSTConstant;
    }

    public ASTConstant buildConstantNode(ASTConstant aSTConstant) throws ParseException {
        return this.buildConstantNode(aSTConstant.getValue());
    }

    public ASTConstant buildConstantNode(PostfixMathCommandI postfixMathCommandI, Node ... nodeArray) throws ParseException {
        Object object;
        ASTFunNode aSTFunNode = this.buildFunctionNode("tmpfun", postfixMathCommandI, nodeArray);
        try {
            object = this.ev.eval(aSTFunNode);
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
        return this.buildConstantNode(object);
    }

    public ASTConstant buildConstantNode(Operator operator, Node ... nodeArray) throws ParseException {
        return this.buildConstantNode(operator.getPFMC(), nodeArray);
    }

    public ASTVarNode buildVariableNode(ASTVarNode aSTVarNode) throws ParseException {
        return this.buildVariableNode(aSTVarNode.getVar());
    }

    public ASTVarNode buildVariableNode(Variable variable) throws ParseException {
        ASTVarNode aSTVarNode = new ASTVarNode(3);
        aSTVarNode.setVar(variable);
        return aSTVarNode;
    }

    public ASTVarNode buildVariableNode(String string) throws ParseException {
        ASTVarNode aSTVarNode = new ASTVarNode(3);
        Variable variable = this.vt.addVariable(string);
        aSTVarNode.setVar(variable);
        return this.buildVariableNode(variable);
    }

    public ASTVarNode buildVariableNodeCheckUndeclared(String string) throws ParseException {
        if (this.j.getAllowUndeclared() || this.vt.getVariable(string) != null) {
            return this.buildVariableNode(string);
        }
        throw new ParseException(MessageFormat.format(JepMessages.getString("NodeFactory.VariableUndefined"), string));
    }

    public ASTOpNode buildOperatorNode(Operator operator, Node ... nodeArray) throws ParseException {
        ASTOpNode aSTOpNode = new ASTOpNode(2);
        aSTOpNode.setOperator(operator);
        this.copyChildren(aSTOpNode, nodeArray);
        return aSTOpNode;
    }

    public ASTOpNode buildUnfinishedOperatorNode(Operator operator) {
        ASTOpNode aSTOpNode = new ASTOpNode(2);
        aSTOpNode.setOperator(operator);
        return aSTOpNode;
    }

    public ASTFunNode buildFunctionNode(String string, PostfixMathCommandI postfixMathCommandI, Node ... nodeArray) throws ParseException {
        if (!postfixMathCommandI.checkNumberOfParameters(nodeArray.length)) {
            throw new ParseException(MessageFormat.format(JepMessages.getString("functions.IncorrectNumberOfArguments"), string, nodeArray.length));
        }
        ASTFunNode aSTFunNode = new ASTFunNode(4);
        aSTFunNode.setFunction(string, postfixMathCommandI);
        this.copyChildren(aSTFunNode, nodeArray);
        return aSTFunNode;
    }

    public ASTFunNode buildFunctionNode(ASTFunNode aSTFunNode, Node ... nodeArray) throws ParseException {
        return this.buildFunctionNode(aSTFunNode.getName(), aSTFunNode.getPFMC(), nodeArray);
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new NodeFactory();
    }
}

