/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.JepMessages;
import com.singularsys.jep.parser.Node;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class Variable
extends Observable
implements Serializable {
    private static final long serialVersionUID = 300L;
    protected String name;
    private Object value;
    private boolean isConstant = false;
    private boolean validValue = false;
    protected Node.HookKey[] keys;
    protected Object[] keyVals;

    protected Variable(String string) {
        this.name = string;
        this.value = null;
        this.validValue = false;
    }

    protected Variable(String string, Object object) {
        this.name = string;
        this.value = object;
        this.validValue = object != null;
    }

    protected Variable(Variable variable) {
        this(variable.getName(), variable.getValue());
        this.setIsConstant(variable.isConstant());
    }

    public String getName() {
        return this.name;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public void setIsConstant(boolean bl) {
        this.isConstant = bl;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasValidValue() {
        return this.validValue;
    }

    public void setValidValue(boolean bl) {
        if (!this.isConstant()) {
            this.validValue = bl;
        }
    }

    public boolean setValue(Object object) {
        if (!this.setValueRaw(object)) {
            return false;
        }
        this.setChanged();
        this.notifyObservers(object);
        return true;
    }

    public final boolean setValue(Object object, Observer observer) {
        if (!this.setValueRaw(object)) {
            return false;
        }
        this.setChanged();
        this.notifyObservers(observer);
        return true;
    }

    protected boolean setValueRaw(Object object) {
        if (this.isConstant) {
            return false;
        }
        this.validValue = true;
        this.value = object;
        return true;
    }

    private int getHookIndex(Node.HookKey hookKey) {
        if (this.keys == null) {
            return -1;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != hookKey) continue;
            return i;
        }
        return -1;
    }

    public Object getHook(Node.HookKey hookKey) {
        int n = this.getHookIndex(hookKey);
        if (n < 0) {
            return null;
        }
        return this.keyVals[n];
    }

    public Object setHook(Node.HookKey hookKey, Object object) {
        if (this.keys == null) {
            this.keys = new Node.HookKey[1];
            this.keyVals = new Object[1];
            this.keys[0] = hookKey;
            this.keyVals[0] = object;
            return null;
        }
        int n = this.getHookIndex(hookKey);
        if (n >= 0) {
            Object object2 = this.keyVals[n];
            this.keyVals[n] = object;
            return object2;
        }
        Node.HookKey[] hookKeyArray = this.keys;
        Object[] objectArray = this.keyVals;
        int n2 = hookKeyArray.length;
        this.keys = new Node.HookKey[n2 + 1];
        this.keyVals = new Object[n2 + 1];
        System.arraycopy(hookKeyArray, 0, this.keys, 0, n2);
        System.arraycopy(objectArray, 0, this.keyVals, 0, n2);
        this.keys[n2] = hookKey;
        this.keyVals[n2] = object;
        return null;
    }

    public Collection<Node.HookKey> hookKeys() {
        return Arrays.asList(this.keys);
    }

    public Object removeHook(Node.HookKey hookKey) {
        if (this.keys == null) {
            return null;
        }
        int n = this.getHookIndex(hookKey);
        if (n < 0) {
            return null;
        }
        Object object = this.keyVals[n];
        Node.HookKey[] hookKeyArray = this.keys;
        Object[] objectArray = this.keyVals;
        int n2 = hookKeyArray.length;
        if (n2 == 1) {
            this.keys = null;
            this.keyVals = null;
            return object;
        }
        this.keys = new Node.HookKey[n2 - 1];
        this.keyVals = new Object[n2 - 1];
        System.arraycopy(hookKeyArray, 0, this.keys, 0, n);
        System.arraycopy(objectArray, 0, this.keyVals, 0, n);
        System.arraycopy(hookKeyArray, n + 1, this.keys, n, n2 - n - 1);
        System.arraycopy(objectArray, n + 1, this.keyVals, n, n2 - n - 1);
        return object;
    }

    public String toString() {
        if (!this.validValue || this.value == null) {
            return MessageFormat.format(JepMessages.getString("Variable.ToStringNullValue"), this.name);
        }
        if (this.isConstant) {
            return MessageFormat.format(JepMessages.getString("Variable.ToStringConstant"), this.name, this.value.toString());
        }
        return MessageFormat.format(JepMessages.getString("Variable.ToString"), this.name, this.value.toString());
    }
}

