/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal;

import com.singularsys.jep.OperatorTable2;
import com.singularsys.jep.bigdecimal.functions.BigDecAdd;
import com.singularsys.jep.bigdecimal.functions.BigDecDiv;
import com.singularsys.jep.bigdecimal.functions.BigDecMod;
import com.singularsys.jep.bigdecimal.functions.BigDecMul;
import com.singularsys.jep.bigdecimal.functions.BigDecNegate;
import com.singularsys.jep.bigdecimal.functions.BigDecPow;
import com.singularsys.jep.bigdecimal.functions.BigDecRelational;
import com.singularsys.jep.bigdecimal.functions.BigDecSub;
import com.singularsys.jep.functions.LazyLogical;
import com.singularsys.jep.functions.Not;
import com.singularsys.jep.standard.StandardOperatorTable2;
import java.math.MathContext;

public class BigDecOperatorTable
extends StandardOperatorTable2 {
    private static final long serialVersionUID = 300L;
    MathContext mc;
    BigDecAdd BD_ADD;
    BigDecSub BD_SUB;
    BigDecNegate BD_NEG;
    BigDecMul BD_MUL;
    BigDecDiv BD_DIV;
    BigDecMod BD_MOD;
    BigDecPow BD_POW;

    public BigDecOperatorTable(MathContext mathContext) {
        this.mc = mathContext;
        this.setBDPfmcs();
        this.setMathContext(mathContext);
    }

    public BigDecOperatorTable(OperatorTable2 operatorTable2, MathContext mathContext) {
        super(operatorTable2);
        this.mc = mathContext;
        this.setBDPfmcs();
        this.setMathContext(mathContext);
    }

    public BigDecOperatorTable(MathContext mathContext, boolean bl) {
        this(mathContext);
        this.setAllowStrings(bl);
    }

    @Override
    protected void setBasicPfmcs() {
    }

    protected void setBDPfmcs() {
        this.BD_ADD = new BigDecAdd(this.mc);
        this.BD_SUB = new BigDecSub(this.mc);
        this.BD_NEG = new BigDecNegate(this.mc);
        this.BD_MUL = new BigDecMul(this.mc);
        this.BD_DIV = new BigDecDiv(this.mc);
        this.BD_MOD = new BigDecMod(this.mc);
        this.BD_POW = new BigDecPow(this.mc);
        this.getOperator(OperatorTable2.BasicOperators.GT).setPFMC(new BigDecRelational(1));
        this.getOperator(OperatorTable2.BasicOperators.LT).setPFMC(new BigDecRelational(0));
        this.getOperator(OperatorTable2.BasicOperators.EQ).setPFMC(new BigDecRelational(5));
        this.getOperator(OperatorTable2.BasicOperators.LE).setPFMC(new BigDecRelational(2));
        this.getOperator(OperatorTable2.BasicOperators.GE).setPFMC(new BigDecRelational(3));
        this.getOperator(OperatorTable2.BasicOperators.NE).setPFMC(new BigDecRelational(4));
        this.getOperator(OperatorTable2.BasicOperators.AND).setPFMC(new LazyLogical(0));
        this.getOperator(OperatorTable2.BasicOperators.OR).setPFMC(new LazyLogical(1));
        this.getOperator(OperatorTable2.BasicOperators.NOT).setPFMC(new Not());
        this.getOperator(OperatorTable2.BasicOperators.ADD).setPFMC(this.BD_ADD);
        this.getOperator(OperatorTable2.BasicOperators.SUB).setPFMC(this.BD_SUB);
        this.getOperator(OperatorTable2.BasicOperators.NEG).setPFMC(this.BD_NEG);
        this.getOperator(OperatorTable2.BasicOperators.MUL).setPFMC(this.BD_MUL);
        this.getOperator(OperatorTable2.BasicOperators.DIV).setPFMC(this.BD_DIV);
        this.getOperator(OperatorTable2.BasicOperators.MOD).setPFMC(this.BD_MOD);
        this.getOperator(OperatorTable2.BasicOperators.POW).setPFMC(this.BD_POW);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
        this.BD_ADD.setMathContext(mathContext);
        this.BD_SUB.setMathContext(mathContext);
        this.BD_MUL.setMathContext(mathContext);
        this.BD_DIV.setMathContext(mathContext);
        this.BD_MOD.setMathContext(mathContext);
        this.BD_POW.setMathContext(mathContext);
        this.BD_NEG.setMathContext(mathContext);
    }

    public void setAllowStrings(boolean bl) {
        ((BigDecRelational)this.getOperator(OperatorTable2.BasicOperators.EQ).getPFMC()).setAllowStrings(bl);
        ((BigDecRelational)this.getOperator(OperatorTable2.BasicOperators.NE).getPFMC()).setAllowStrings(bl);
        ((BigDecRelational)this.getOperator(OperatorTable2.BasicOperators.LE).getPFMC()).setAllowStrings(bl);
        ((BigDecRelational)this.getOperator(OperatorTable2.BasicOperators.LT).getPFMC()).setAllowStrings(bl);
        ((BigDecRelational)this.getOperator(OperatorTable2.BasicOperators.GE).getPFMC()).setAllowStrings(bl);
        ((BigDecRelational)this.getOperator(OperatorTable2.BasicOperators.GT).getPFMC()).setAllowStrings(bl);
        this.BD_ADD.setAllowStrings(bl);
    }
}

