/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.Comparative;
import com.singularsys.jep.functions.IllegalParameterException;
import java.math.BigDecimal;

public class BigDecRelational
extends Comparative {
    private static final long serialVersionUID = 340L;
    protected int id;
    private boolean allowStrings = false;

    public BigDecRelational(int n) {
        super(n);
        this.id = n;
        this.numberOfParameters = 2;
    }

    @Override
    public boolean compare(Object object, Object object2) throws EvaluationException {
        if (object instanceof BigDecimal) {
            if (object2 instanceof BigDecimal) {
                boolean bl = false;
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                switch (this.id) {
                    case 0: {
                        bl = bigDecimal.compareTo(bigDecimal2) < 0;
                        break;
                    }
                    case 1: {
                        bl = bigDecimal.compareTo(bigDecimal2) > 0;
                        break;
                    }
                    case 2: {
                        bl = bigDecimal.compareTo(bigDecimal2) <= 0;
                        break;
                    }
                    case 3: {
                        bl = bigDecimal.compareTo(bigDecimal2) >= 0;
                        break;
                    }
                    case 4: {
                        bl = bigDecimal.compareTo(bigDecimal2) != 0;
                        break;
                    }
                    case 5: {
                        bl = bigDecimal.compareTo(bigDecimal2) == 0;
                    }
                }
                return bl;
            }
            if (object2 instanceof Double) {
                return this.compare(object, BigDecimal.valueOf((Double)object2));
            }
            if (object2 instanceof Integer) {
                return this.compare(object, BigDecimal.valueOf(((Integer)object2).intValue()));
            }
            if (object2 instanceof Float) {
                return this.compare(object, BigDecimal.valueOf(((Float)object2).floatValue()));
            }
            if (object2 instanceof Short) {
                return this.compare(object, BigDecimal.valueOf(((Short)object2).shortValue()));
            }
            if (object2 instanceof Long) {
                return this.compare(object, BigDecimal.valueOf((Long)object2));
            }
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, BigDecimal.class, object2);
        }
        if (this.allowStrings && object instanceof String) {
            if (object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                boolean bl = false;
                switch (this.id) {
                    case 0: {
                        bl = string.compareTo(string2) < 0;
                        break;
                    }
                    case 1: {
                        bl = string.compareTo(string2) > 0;
                        break;
                    }
                    case 2: {
                        bl = string.compareTo(string2) <= 0;
                        break;
                    }
                    case 3: {
                        bl = string.compareTo(string2) >= 0;
                        break;
                    }
                    case 4: {
                        bl = string.compareTo(string2) != 0;
                        break;
                    }
                    case 5: {
                        bl = string.compareTo(string2) == 0;
                    }
                }
                return bl;
            }
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, String.class, object2);
        }
        if (object instanceof Boolean) {
            if (object2 instanceof Boolean) {
                Boolean bl = (Boolean)object;
                Boolean bl2 = (Boolean)object2;
                boolean bl3 = false;
                switch (this.id) {
                    case 0: {
                        bl3 = bl.compareTo(bl2) < 0;
                        break;
                    }
                    case 1: {
                        bl3 = bl.compareTo(bl2) > 0;
                        break;
                    }
                    case 2: {
                        bl3 = bl.compareTo(bl2) <= 0;
                        break;
                    }
                    case 3: {
                        bl3 = bl.compareTo(bl2) >= 0;
                        break;
                    }
                    case 4: {
                        bl3 = bl.compareTo(bl2) != 0;
                        break;
                    }
                    case 5: {
                        bl3 = bl.compareTo(bl2) == 0;
                    }
                }
                return bl3;
            }
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, BigDecimal.class, object2);
        }
        if (object instanceof Double) {
            return this.compare(BigDecimal.valueOf((Double)object), object2);
        }
        if (object instanceof Integer) {
            return this.compare(BigDecimal.valueOf(((Integer)object).intValue()), object2);
        }
        if (object instanceof Float) {
            return this.compare(BigDecimal.valueOf(((Float)object).floatValue()), object2);
        }
        if (object instanceof Short) {
            return this.compare(BigDecimal.valueOf(((Short)object).shortValue()), object2);
        }
        if (object instanceof Long) {
            return this.compare(BigDecimal.valueOf((Long)object), object2);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        boolean bl = this.compare(object, object2);
        return bl;
    }

    public boolean getAllowStrings() {
        return this.allowStrings;
    }

    public void setAllowStrings(boolean bl) {
        this.allowStrings = bl;
    }
}

