/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.Round;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecRound
extends Round {
    private static final long serialVersionUID = 350L;
    RoundingMode mode;

    public BigDecRound() {
    }

    public BigDecRound(RoundingMode roundingMode) {
        this.mode = roundingMode;
    }

    @Override
    public Object round(Object object) throws EvaluationException {
        if (object instanceof BigDecimal) {
            if (this.mode != null) {
                return ((BigDecimal)object).setScale(0, this.mode);
            }
            if (((BigDecimal)object).signum() >= 0) {
                return ((BigDecimal)object).setScale(0, RoundingMode.HALF_UP);
            }
            return ((BigDecimal)object).setScale(0, RoundingMode.HALF_DOWN);
        }
        if (object instanceof Double) {
            return this.round(BigDecimal.valueOf((Double)object));
        }
        if (object instanceof Integer) {
            return this.round(BigDecimal.valueOf(((Integer)object).intValue()));
        }
        if (object instanceof Float) {
            return this.round(BigDecimal.valueOf(((Float)object).floatValue()));
        }
        if (object instanceof Short) {
            return this.round(BigDecimal.valueOf(((Short)object).shortValue()));
        }
        if (object instanceof Long) {
            return this.round(BigDecimal.valueOf((Long)object));
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }

    @Override
    public Object round(Object object, Object object2) throws EvaluationException {
        if (object instanceof BigDecimal) {
            if (!(object2 instanceof Number)) {
                throw new IllegalParameterException((PostfixMathCommandI)this, 1, Number.class, object2);
            }
            int n = ((Number)object2).intValue();
            if (this.mode != null) {
                return ((BigDecimal)object).setScale(n, this.mode);
            }
            if (((BigDecimal)object).signum() >= 0) {
                return ((BigDecimal)object).setScale(n, RoundingMode.HALF_UP);
            }
            return ((BigDecimal)object).setScale(n, RoundingMode.HALF_DOWN);
        }
        if (object instanceof Double) {
            return this.round(BigDecimal.valueOf((Double)object), object2);
        }
        if (object instanceof Integer) {
            return this.round(BigDecimal.valueOf(((Integer)object).intValue()), object2);
        }
        if (object instanceof Float) {
            return this.round(BigDecimal.valueOf(((Float)object).floatValue()), object2);
        }
        if (object instanceof Short) {
            return this.round(BigDecimal.valueOf(((Short)object).shortValue()), object2);
        }
        if (object instanceof Long) {
            return this.round(BigDecimal.valueOf((Long)object), object2);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }
}

