/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.bigdecimal.functions.BigDecRelational;
import java.math.BigDecimal;

public class BigDecTieBreakComparative
extends BigDecRelational {
    private static final long serialVersionUID = 350L;

    public BigDecTieBreakComparative(int n) {
        super(n);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Only LT and GT supported");
        }
    }

    @Override
    public boolean compare(Object object, Object object2) throws EvaluationException {
        if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            BigDecimal bigDecimal2 = (BigDecimal)object2;
            int n = bigDecimal.compareTo(bigDecimal2);
            if (n != 0) {
                boolean bl = false;
                switch (this.id) {
                    case 0: {
                        bl = n < 0;
                        break;
                    }
                    case 1: {
                        bl = n > 0;
                    }
                }
                return bl;
            }
            if (bigDecimal.equals(bigDecimal2)) {
                return false;
            }
            return bigDecimal.precision() < bigDecimal2.precision();
        }
        return super.compare(object, object2);
    }
}

