/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class ArcSine
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;
    private final boolean strict;

    public ArcSine() {
        this.strict = true;
    }

    public ArcSine(boolean bl) {
        this.strict = bl;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.asin(object);
    }

    public Object asin(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (Math.abs(d) <= 1.0) {
                return Math.asin(d);
            }
            if (Double.isNaN(d)) {
                return NaN;
            }
            if (this.strict) {
                return NaN;
            }
            Complex complex = new Complex(d);
            return complex.asin();
        }
        if (object instanceof Complex) {
            return ((Complex)object).asin();
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.asin(d);
    }
}

