/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class ArcTanH
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 330L;
    private final boolean strict;

    public ArcTanH() {
        this.strict = false;
    }

    public ArcTanH(boolean bl) {
        this.strict = bl;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.atanh(object);
    }

    public Object atanh(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d > -1.0 && d < 1.0) {
                double d2 = Math.log((1.0 + d) / (1.0 - d)) / 2.0;
                return d2;
            }
            if (Double.isNaN(d)) {
                return NaN;
            }
            if (this.strict) {
                return NaN;
            }
            Complex complex = new Complex(d, 0.0);
            return complex.atanh();
        }
        if (object instanceof Complex) {
            return ((Complex)object).atanh();
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        if (d > -1.0 && d < 1.0) {
            return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
        }
        return Double.NaN;
    }
}

