/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.SubstitutionVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Stack;

public class MacroFunction
extends PostfixMathCommand
implements JepComponent {
    private static final long serialVersionUID = 300L;
    private final int nParam;
    private final String[] varNames;
    private final String expression;
    protected transient Node topNode;
    private transient Evaluator ev;
    private transient Variable[] vars;

    public MacroFunction(Jep jep, String string, String[] stringArray, String string2) {
        this(string, stringArray, string2);
        this.init(jep);
    }

    public MacroFunction(Jep jep, String string, String string2, String string3) {
        this.numberOfParameters = 1;
        this.name = string;
        this.varNames = new String[]{string2};
        this.expression = string3;
        this.nParam = 1;
        this.vars = new Variable[this.nParam];
        this.init(jep);
    }

    public MacroFunction(String string, String[] stringArray, String string2) {
        this.numberOfParameters = this.nParam = stringArray.length;
        this.name = string;
        this.varNames = (String[])stringArray.clone();
        this.expression = string2;
        this.vars = new Variable[this.nParam];
    }

    @Override
    public void init(Jep jep) {
        this.ev = (Evaluator)jep.getEvaluator().getLightWeightInstance();
        this.ev.init(jep);
        String string = this.expression;
        String[] stringArray = new String[this.varNames.length];
        for (int i = 0; i < this.nParam; ++i) {
            stringArray[i] = this.name + "::" + this.varNames[i];
            this.vars[i] = jep.addVariable(stringArray[i]);
        }
        try {
            Node node = jep.parse(string);
            SubstitutionVisitor substitutionVisitor = new SubstitutionVisitor(jep);
            this.topNode = substitutionVisitor.substitute(node, this.varNames, stringArray);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        if (this.topNode == null) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("misc.MacroFunction.InitMethodMustBeCalledBeforeEvaluation"), this.getName()));
        }
        for (int i = this.nParam - 1; i >= 0; --i) {
            this.vars[i].setValue(stack.pop());
        }
        Object object = this.ev.eval(this.topNode);
        stack.push(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.vars = new Variable[this.nParam];
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public String[] getParameterNames() {
        return (String[])this.varNames.clone();
    }

    public Variable[] getVars() {
        return this.vars;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append("(");
        for (int i = 0; i < this.nParam; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.varNames[i]);
        }
        stringBuilder.append("):=");
        stringBuilder.append(this.expression);
        return stringBuilder.toString();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

