/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class SwitchDefault
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 330L;
    protected NullBehaviour nullBehaviour = NullBehaviour.ERROR;

    public SwitchDefault() {
        super(-1);
    }

    public SwitchDefault(NullBehaviour nullBehaviour) {
        super(-1);
        this.nullBehaviour = nullBehaviour;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n > 2;
    }

    public NullBehaviour getNullBehaviour() {
        return this.nullBehaviour;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        Object object;
        Object object2 = evaluator.eval(node.jjtGetChild(0));
        if (object2 == null && this.nullBehaviour == NullBehaviour.RETURN_NULL) {
            return null;
        }
        int n = node.jjtGetNumChildren();
        int n2 = this.asStrictInt(0, object2);
        if (n2 >= n - 1) {
            object = evaluator.eval(node.jjtGetChild(n - 1));
        } else if (n2 > 0) {
            object = evaluator.eval(node.jjtGetChild(n2));
        } else {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IndexOutOfRangeMax"), this.getName(), n2, node.jjtGetNumChildren() - 1));
        }
        return object;
    }

    public static enum NullBehaviour {
        ERROR,
        RETURN_NULL;

    }
}

